# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetRepositoryResult',
    'AwaitableGetRepositoryResult',
    'get_repository',
    'get_repository_output',
]

@pulumi.output_type
class GetRepositoryResult:
    def __init__(__self__, git_remote_settings=None, name=None, npmrc_environment_variables_secret_version=None, workspace_compilation_overrides=None):
        if git_remote_settings and not isinstance(git_remote_settings, dict):
            raise TypeError("Expected argument 'git_remote_settings' to be a dict")
        pulumi.set(__self__, "git_remote_settings", git_remote_settings)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if npmrc_environment_variables_secret_version and not isinstance(npmrc_environment_variables_secret_version, str):
            raise TypeError("Expected argument 'npmrc_environment_variables_secret_version' to be a str")
        pulumi.set(__self__, "npmrc_environment_variables_secret_version", npmrc_environment_variables_secret_version)
        if workspace_compilation_overrides and not isinstance(workspace_compilation_overrides, dict):
            raise TypeError("Expected argument 'workspace_compilation_overrides' to be a dict")
        pulumi.set(__self__, "workspace_compilation_overrides", workspace_compilation_overrides)

    @property
    @pulumi.getter(name="gitRemoteSettings")
    def git_remote_settings(self) -> 'outputs.GitRemoteSettingsResponse':
        """
        Optional. If set, configures this repository to be linked to a Git remote.
        """
        return pulumi.get(self, "git_remote_settings")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The repository's name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="npmrcEnvironmentVariablesSecretVersion")
    def npmrc_environment_variables_secret_version(self) -> str:
        """
        Optional. The name of the Secret Manager secret version to be used to interpolate variables into the .npmrc file for package installation operations. Must be in the format `projects/*/secrets/*/versions/*`. The file itself must be in a JSON format.
        """
        return pulumi.get(self, "npmrc_environment_variables_secret_version")

    @property
    @pulumi.getter(name="workspaceCompilationOverrides")
    def workspace_compilation_overrides(self) -> 'outputs.WorkspaceCompilationOverridesResponse':
        """
        Optional. If set, fields of `workspace_compilation_overrides` override the default compilation settings that are specified in dataform.json when creating workspace-scoped compilation results. See documentation for `WorkspaceCompilationOverrides` for more information.
        """
        return pulumi.get(self, "workspace_compilation_overrides")


class AwaitableGetRepositoryResult(GetRepositoryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRepositoryResult(
            git_remote_settings=self.git_remote_settings,
            name=self.name,
            npmrc_environment_variables_secret_version=self.npmrc_environment_variables_secret_version,
            workspace_compilation_overrides=self.workspace_compilation_overrides)


def get_repository(location: Optional[str] = None,
                   project: Optional[str] = None,
                   repository_id: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRepositoryResult:
    """
    Fetches a single Repository.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['project'] = project
    __args__['repositoryId'] = repository_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:dataform/v1beta1:getRepository', __args__, opts=opts, typ=GetRepositoryResult).value

    return AwaitableGetRepositoryResult(
        git_remote_settings=__ret__.git_remote_settings,
        name=__ret__.name,
        npmrc_environment_variables_secret_version=__ret__.npmrc_environment_variables_secret_version,
        workspace_compilation_overrides=__ret__.workspace_compilation_overrides)


@_utilities.lift_output_func(get_repository)
def get_repository_output(location: Optional[pulumi.Input[str]] = None,
                          project: Optional[pulumi.Input[Optional[str]]] = None,
                          repository_id: Optional[pulumi.Input[str]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRepositoryResult]:
    """
    Fetches a single Repository.
    """
    ...
