# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CompilationResultArgs', 'CompilationResult']

@pulumi.input_type
class CompilationResultArgs:
    def __init__(__self__, *,
                 repository_id: pulumi.Input[str],
                 code_compilation_config: Optional[pulumi.Input['CodeCompilationConfigArgs']] = None,
                 git_commitish: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 release_config: Optional[pulumi.Input[str]] = None,
                 workspace: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CompilationResult resource.
        :param pulumi.Input['CodeCompilationConfigArgs'] code_compilation_config: Immutable. If set, fields of `code_compilation_config` override the default compilation settings that are specified in dataform.json.
        :param pulumi.Input[str] git_commitish: Immutable. Git commit/tag/branch name at which the repository should be compiled. Must exist in the remote repository. Examples: - a commit SHA: `12ade345` - a tag: `tag1` - a branch name: `branch1`
        :param pulumi.Input[str] release_config: Immutable. The name of the release config to compile. The release config's 'current_compilation_result' field will be updated to this compilation result. Must be in the format `projects/*/locations/*/repositories/*/releaseConfigs/*`.
        :param pulumi.Input[str] workspace: Immutable. The name of the workspace to compile. Must be in the format `projects/*/locations/*/repositories/*/workspaces/*`.
        """
        pulumi.set(__self__, "repository_id", repository_id)
        if code_compilation_config is not None:
            pulumi.set(__self__, "code_compilation_config", code_compilation_config)
        if git_commitish is not None:
            pulumi.set(__self__, "git_commitish", git_commitish)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if release_config is not None:
            pulumi.set(__self__, "release_config", release_config)
        if workspace is not None:
            pulumi.set(__self__, "workspace", workspace)

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "repository_id")

    @repository_id.setter
    def repository_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "repository_id", value)

    @property
    @pulumi.getter(name="codeCompilationConfig")
    def code_compilation_config(self) -> Optional[pulumi.Input['CodeCompilationConfigArgs']]:
        """
        Immutable. If set, fields of `code_compilation_config` override the default compilation settings that are specified in dataform.json.
        """
        return pulumi.get(self, "code_compilation_config")

    @code_compilation_config.setter
    def code_compilation_config(self, value: Optional[pulumi.Input['CodeCompilationConfigArgs']]):
        pulumi.set(self, "code_compilation_config", value)

    @property
    @pulumi.getter(name="gitCommitish")
    def git_commitish(self) -> Optional[pulumi.Input[str]]:
        """
        Immutable. Git commit/tag/branch name at which the repository should be compiled. Must exist in the remote repository. Examples: - a commit SHA: `12ade345` - a tag: `tag1` - a branch name: `branch1`
        """
        return pulumi.get(self, "git_commitish")

    @git_commitish.setter
    def git_commitish(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "git_commitish", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="releaseConfig")
    def release_config(self) -> Optional[pulumi.Input[str]]:
        """
        Immutable. The name of the release config to compile. The release config's 'current_compilation_result' field will be updated to this compilation result. Must be in the format `projects/*/locations/*/repositories/*/releaseConfigs/*`.
        """
        return pulumi.get(self, "release_config")

    @release_config.setter
    def release_config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "release_config", value)

    @property
    @pulumi.getter
    def workspace(self) -> Optional[pulumi.Input[str]]:
        """
        Immutable. The name of the workspace to compile. Must be in the format `projects/*/locations/*/repositories/*/workspaces/*`.
        """
        return pulumi.get(self, "workspace")

    @workspace.setter
    def workspace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workspace", value)


class CompilationResult(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 code_compilation_config: Optional[pulumi.Input[pulumi.InputType['CodeCompilationConfigArgs']]] = None,
                 git_commitish: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 release_config: Optional[pulumi.Input[str]] = None,
                 repository_id: Optional[pulumi.Input[str]] = None,
                 workspace: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates a new CompilationResult in a given project and location.
        Auto-naming is currently not supported for this resource.
        Note - this resource's API doesn't support deletion. When deleted, the resource will persist
        on Google Cloud even though it will be deleted from Pulumi state.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['CodeCompilationConfigArgs']] code_compilation_config: Immutable. If set, fields of `code_compilation_config` override the default compilation settings that are specified in dataform.json.
        :param pulumi.Input[str] git_commitish: Immutable. Git commit/tag/branch name at which the repository should be compiled. Must exist in the remote repository. Examples: - a commit SHA: `12ade345` - a tag: `tag1` - a branch name: `branch1`
        :param pulumi.Input[str] release_config: Immutable. The name of the release config to compile. The release config's 'current_compilation_result' field will be updated to this compilation result. Must be in the format `projects/*/locations/*/repositories/*/releaseConfigs/*`.
        :param pulumi.Input[str] workspace: Immutable. The name of the workspace to compile. Must be in the format `projects/*/locations/*/repositories/*/workspaces/*`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CompilationResultArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new CompilationResult in a given project and location.
        Auto-naming is currently not supported for this resource.
        Note - this resource's API doesn't support deletion. When deleted, the resource will persist
        on Google Cloud even though it will be deleted from Pulumi state.

        :param str resource_name: The name of the resource.
        :param CompilationResultArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CompilationResultArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 code_compilation_config: Optional[pulumi.Input[pulumi.InputType['CodeCompilationConfigArgs']]] = None,
                 git_commitish: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 release_config: Optional[pulumi.Input[str]] = None,
                 repository_id: Optional[pulumi.Input[str]] = None,
                 workspace: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CompilationResultArgs.__new__(CompilationResultArgs)

            __props__.__dict__["code_compilation_config"] = code_compilation_config
            __props__.__dict__["git_commitish"] = git_commitish
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["release_config"] = release_config
            if repository_id is None and not opts.urn:
                raise TypeError("Missing required property 'repository_id'")
            __props__.__dict__["repository_id"] = repository_id
            __props__.__dict__["workspace"] = workspace
            __props__.__dict__["compilation_errors"] = None
            __props__.__dict__["dataform_core_version"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["resolved_git_commit_sha"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["location", "project", "repository_id"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(CompilationResult, __self__).__init__(
            'google-native:dataform/v1beta1:CompilationResult',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'CompilationResult':
        """
        Get an existing CompilationResult resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = CompilationResultArgs.__new__(CompilationResultArgs)

        __props__.__dict__["code_compilation_config"] = None
        __props__.__dict__["compilation_errors"] = None
        __props__.__dict__["dataform_core_version"] = None
        __props__.__dict__["git_commitish"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["release_config"] = None
        __props__.__dict__["repository_id"] = None
        __props__.__dict__["resolved_git_commit_sha"] = None
        __props__.__dict__["workspace"] = None
        return CompilationResult(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="codeCompilationConfig")
    def code_compilation_config(self) -> pulumi.Output['outputs.CodeCompilationConfigResponse']:
        """
        Immutable. If set, fields of `code_compilation_config` override the default compilation settings that are specified in dataform.json.
        """
        return pulumi.get(self, "code_compilation_config")

    @property
    @pulumi.getter(name="compilationErrors")
    def compilation_errors(self) -> pulumi.Output[Sequence['outputs.CompilationErrorResponse']]:
        """
        Errors encountered during project compilation.
        """
        return pulumi.get(self, "compilation_errors")

    @property
    @pulumi.getter(name="dataformCoreVersion")
    def dataform_core_version(self) -> pulumi.Output[str]:
        """
        The version of `@dataform/core` that was used for compilation.
        """
        return pulumi.get(self, "dataform_core_version")

    @property
    @pulumi.getter(name="gitCommitish")
    def git_commitish(self) -> pulumi.Output[str]:
        """
        Immutable. Git commit/tag/branch name at which the repository should be compiled. Must exist in the remote repository. Examples: - a commit SHA: `12ade345` - a tag: `tag1` - a branch name: `branch1`
        """
        return pulumi.get(self, "git_commitish")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The compilation result's name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="releaseConfig")
    def release_config(self) -> pulumi.Output[str]:
        """
        Immutable. The name of the release config to compile. The release config's 'current_compilation_result' field will be updated to this compilation result. Must be in the format `projects/*/locations/*/repositories/*/releaseConfigs/*`.
        """
        return pulumi.get(self, "release_config")

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "repository_id")

    @property
    @pulumi.getter(name="resolvedGitCommitSha")
    def resolved_git_commit_sha(self) -> pulumi.Output[str]:
        """
        The fully resolved Git commit SHA of the code that was compiled. Not set for compilation results whose source is a workspace.
        """
        return pulumi.get(self, "resolved_git_commit_sha")

    @property
    @pulumi.getter
    def workspace(self) -> pulumi.Output[str]:
        """
        Immutable. The name of the workspace to compile. Must be in the format `projects/*/locations/*/repositories/*/workspaces/*`.
        """
        return pulumi.get(self, "workspace")

