# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'CodeCompilationConfigArgs',
    'GitRemoteSettingsArgs',
    'InvocationConfigArgs',
    'TargetArgs',
    'WorkspaceCompilationOverridesArgs',
]

@pulumi.input_type
class CodeCompilationConfigArgs:
    def __init__(__self__, *,
                 assertion_schema: Optional[pulumi.Input[str]] = None,
                 database_suffix: Optional[pulumi.Input[str]] = None,
                 default_database: Optional[pulumi.Input[str]] = None,
                 default_location: Optional[pulumi.Input[str]] = None,
                 default_schema: Optional[pulumi.Input[str]] = None,
                 schema_suffix: Optional[pulumi.Input[str]] = None,
                 table_prefix: Optional[pulumi.Input[str]] = None,
                 vars: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Configures various aspects of Dataform code compilation.
        :param pulumi.Input[str] assertion_schema: Optional. The default schema (BigQuery dataset ID) for assertions.
        :param pulumi.Input[str] database_suffix: Optional. The suffix that should be appended to all database (Google Cloud project ID) names.
        :param pulumi.Input[str] default_database: Optional. The default database (Google Cloud project ID).
        :param pulumi.Input[str] default_location: Optional. The default BigQuery location to use. Defaults to "US". See the BigQuery docs for a full list of locations: https://cloud.google.com/bigquery/docs/locations.
        :param pulumi.Input[str] default_schema: Optional. The default schema (BigQuery dataset ID).
        :param pulumi.Input[str] schema_suffix: Optional. The suffix that should be appended to all schema (BigQuery dataset ID) names.
        :param pulumi.Input[str] table_prefix: Optional. The prefix that should be prepended to all table names.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] vars: Optional. User-defined variables that are made available to project code during compilation.
        """
        if assertion_schema is not None:
            pulumi.set(__self__, "assertion_schema", assertion_schema)
        if database_suffix is not None:
            pulumi.set(__self__, "database_suffix", database_suffix)
        if default_database is not None:
            pulumi.set(__self__, "default_database", default_database)
        if default_location is not None:
            pulumi.set(__self__, "default_location", default_location)
        if default_schema is not None:
            pulumi.set(__self__, "default_schema", default_schema)
        if schema_suffix is not None:
            pulumi.set(__self__, "schema_suffix", schema_suffix)
        if table_prefix is not None:
            pulumi.set(__self__, "table_prefix", table_prefix)
        if vars is not None:
            pulumi.set(__self__, "vars", vars)

    @property
    @pulumi.getter(name="assertionSchema")
    def assertion_schema(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The default schema (BigQuery dataset ID) for assertions.
        """
        return pulumi.get(self, "assertion_schema")

    @assertion_schema.setter
    def assertion_schema(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "assertion_schema", value)

    @property
    @pulumi.getter(name="databaseSuffix")
    def database_suffix(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The suffix that should be appended to all database (Google Cloud project ID) names.
        """
        return pulumi.get(self, "database_suffix")

    @database_suffix.setter
    def database_suffix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_suffix", value)

    @property
    @pulumi.getter(name="defaultDatabase")
    def default_database(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The default database (Google Cloud project ID).
        """
        return pulumi.get(self, "default_database")

    @default_database.setter
    def default_database(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_database", value)

    @property
    @pulumi.getter(name="defaultLocation")
    def default_location(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The default BigQuery location to use. Defaults to "US". See the BigQuery docs for a full list of locations: https://cloud.google.com/bigquery/docs/locations.
        """
        return pulumi.get(self, "default_location")

    @default_location.setter
    def default_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_location", value)

    @property
    @pulumi.getter(name="defaultSchema")
    def default_schema(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The default schema (BigQuery dataset ID).
        """
        return pulumi.get(self, "default_schema")

    @default_schema.setter
    def default_schema(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_schema", value)

    @property
    @pulumi.getter(name="schemaSuffix")
    def schema_suffix(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The suffix that should be appended to all schema (BigQuery dataset ID) names.
        """
        return pulumi.get(self, "schema_suffix")

    @schema_suffix.setter
    def schema_suffix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema_suffix", value)

    @property
    @pulumi.getter(name="tablePrefix")
    def table_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The prefix that should be prepended to all table names.
        """
        return pulumi.get(self, "table_prefix")

    @table_prefix.setter
    def table_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table_prefix", value)

    @property
    @pulumi.getter
    def vars(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. User-defined variables that are made available to project code during compilation.
        """
        return pulumi.get(self, "vars")

    @vars.setter
    def vars(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "vars", value)


@pulumi.input_type
class GitRemoteSettingsArgs:
    def __init__(__self__, *,
                 authentication_token_secret_version: pulumi.Input[str],
                 default_branch: pulumi.Input[str],
                 url: pulumi.Input[str]):
        """
        Controls Git remote configuration for a repository.
        :param pulumi.Input[str] authentication_token_secret_version: The name of the Secret Manager secret version to use as an authentication token for Git operations. Must be in the format `projects/*/secrets/*/versions/*`.
        :param pulumi.Input[str] default_branch: The Git remote's default branch name.
        :param pulumi.Input[str] url: The Git remote's URL.
        """
        pulumi.set(__self__, "authentication_token_secret_version", authentication_token_secret_version)
        pulumi.set(__self__, "default_branch", default_branch)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="authenticationTokenSecretVersion")
    def authentication_token_secret_version(self) -> pulumi.Input[str]:
        """
        The name of the Secret Manager secret version to use as an authentication token for Git operations. Must be in the format `projects/*/secrets/*/versions/*`.
        """
        return pulumi.get(self, "authentication_token_secret_version")

    @authentication_token_secret_version.setter
    def authentication_token_secret_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "authentication_token_secret_version", value)

    @property
    @pulumi.getter(name="defaultBranch")
    def default_branch(self) -> pulumi.Input[str]:
        """
        The Git remote's default branch name.
        """
        return pulumi.get(self, "default_branch")

    @default_branch.setter
    def default_branch(self, value: pulumi.Input[str]):
        pulumi.set(self, "default_branch", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        The Git remote's URL.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class InvocationConfigArgs:
    def __init__(__self__, *,
                 fully_refresh_incremental_tables_enabled: Optional[pulumi.Input[bool]] = None,
                 included_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 included_targets: Optional[pulumi.Input[Sequence[pulumi.Input['TargetArgs']]]] = None,
                 transitive_dependencies_included: Optional[pulumi.Input[bool]] = None,
                 transitive_dependents_included: Optional[pulumi.Input[bool]] = None):
        """
        Includes various configuration options for a workflow invocation. If both `included_targets` and `included_tags` are unset, all actions will be included.
        :param pulumi.Input[bool] fully_refresh_incremental_tables_enabled: Optional. When set to true, any incremental tables will be fully refreshed.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] included_tags: Optional. The set of tags to include.
        :param pulumi.Input[Sequence[pulumi.Input['TargetArgs']]] included_targets: Optional. The set of action identifiers to include.
        :param pulumi.Input[bool] transitive_dependencies_included: Optional. When set to true, transitive dependencies of included actions will be executed.
        :param pulumi.Input[bool] transitive_dependents_included: Optional. When set to true, transitive dependents of included actions will be executed.
        """
        if fully_refresh_incremental_tables_enabled is not None:
            pulumi.set(__self__, "fully_refresh_incremental_tables_enabled", fully_refresh_incremental_tables_enabled)
        if included_tags is not None:
            pulumi.set(__self__, "included_tags", included_tags)
        if included_targets is not None:
            pulumi.set(__self__, "included_targets", included_targets)
        if transitive_dependencies_included is not None:
            pulumi.set(__self__, "transitive_dependencies_included", transitive_dependencies_included)
        if transitive_dependents_included is not None:
            pulumi.set(__self__, "transitive_dependents_included", transitive_dependents_included)

    @property
    @pulumi.getter(name="fullyRefreshIncrementalTablesEnabled")
    def fully_refresh_incremental_tables_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. When set to true, any incremental tables will be fully refreshed.
        """
        return pulumi.get(self, "fully_refresh_incremental_tables_enabled")

    @fully_refresh_incremental_tables_enabled.setter
    def fully_refresh_incremental_tables_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "fully_refresh_incremental_tables_enabled", value)

    @property
    @pulumi.getter(name="includedTags")
    def included_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. The set of tags to include.
        """
        return pulumi.get(self, "included_tags")

    @included_tags.setter
    def included_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "included_tags", value)

    @property
    @pulumi.getter(name="includedTargets")
    def included_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TargetArgs']]]]:
        """
        Optional. The set of action identifiers to include.
        """
        return pulumi.get(self, "included_targets")

    @included_targets.setter
    def included_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TargetArgs']]]]):
        pulumi.set(self, "included_targets", value)

    @property
    @pulumi.getter(name="transitiveDependenciesIncluded")
    def transitive_dependencies_included(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. When set to true, transitive dependencies of included actions will be executed.
        """
        return pulumi.get(self, "transitive_dependencies_included")

    @transitive_dependencies_included.setter
    def transitive_dependencies_included(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "transitive_dependencies_included", value)

    @property
    @pulumi.getter(name="transitiveDependentsIncluded")
    def transitive_dependents_included(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. When set to true, transitive dependents of included actions will be executed.
        """
        return pulumi.get(self, "transitive_dependents_included")

    @transitive_dependents_included.setter
    def transitive_dependents_included(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "transitive_dependents_included", value)


@pulumi.input_type
class TargetArgs:
    def __init__(__self__, *,
                 database: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 schema: Optional[pulumi.Input[str]] = None):
        """
        Represents an action identifier. If the action writes output, the output will be written to the referenced database object.
        :param pulumi.Input[str] database: The action's database (Google Cloud project ID) .
        :param pulumi.Input[str] name: The action's name, within `database` and `schema`.
        :param pulumi.Input[str] schema: The action's schema (BigQuery dataset ID), within `database`.
        """
        if database is not None:
            pulumi.set(__self__, "database", database)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input[str]]:
        """
        The action's database (Google Cloud project ID) .
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The action's name, within `database` and `schema`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[str]]:
        """
        The action's schema (BigQuery dataset ID), within `database`.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema", value)


@pulumi.input_type
class WorkspaceCompilationOverridesArgs:
    def __init__(__self__, *,
                 default_database: Optional[pulumi.Input[str]] = None,
                 schema_suffix: Optional[pulumi.Input[str]] = None,
                 table_prefix: Optional[pulumi.Input[str]] = None):
        """
        Configures workspace compilation overrides for a repository. Primarily used by the UI (`console.cloud.google.com`). `schema_suffix` and `table_prefix` can have a special expression - `${workspaceName}`, which refers to the workspace name from which the compilation results will be created. API callers are expected to resolve the expression in these overrides and provide them explicitly in `code_compilation_config` (https://cloud.google.com/dataform/reference/rest/v1beta1/projects.locations.repositories.compilationResults#codecompilationconfig) when creating workspace-scoped compilation results.
        :param pulumi.Input[str] default_database: Optional. The default database (Google Cloud project ID).
        :param pulumi.Input[str] schema_suffix: Optional. The suffix that should be appended to all schema (BigQuery dataset ID) names.
        :param pulumi.Input[str] table_prefix: Optional. The prefix that should be prepended to all table names.
        """
        if default_database is not None:
            pulumi.set(__self__, "default_database", default_database)
        if schema_suffix is not None:
            pulumi.set(__self__, "schema_suffix", schema_suffix)
        if table_prefix is not None:
            pulumi.set(__self__, "table_prefix", table_prefix)

    @property
    @pulumi.getter(name="defaultDatabase")
    def default_database(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The default database (Google Cloud project ID).
        """
        return pulumi.get(self, "default_database")

    @default_database.setter
    def default_database(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_database", value)

    @property
    @pulumi.getter(name="schemaSuffix")
    def schema_suffix(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The suffix that should be appended to all schema (BigQuery dataset ID) names.
        """
        return pulumi.get(self, "schema_suffix")

    @schema_suffix.setter
    def schema_suffix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema_suffix", value)

    @property
    @pulumi.getter(name="tablePrefix")
    def table_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The prefix that should be prepended to all table names.
        """
        return pulumi.get(self, "table_prefix")

    @table_prefix.setter
    def table_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table_prefix", value)


