# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GoogleCloudContentwarehouseV1AccessControlActionResponse',
    'GoogleCloudContentwarehouseV1ActionResponse',
    'GoogleCloudContentwarehouseV1AddToFolderActionResponse',
    'GoogleCloudContentwarehouseV1DataUpdateActionResponse',
    'GoogleCloudContentwarehouseV1DataValidationActionResponse',
    'GoogleCloudContentwarehouseV1DateTimeArrayResponse',
    'GoogleCloudContentwarehouseV1DateTimeTypeOptionsResponse',
    'GoogleCloudContentwarehouseV1DeleteDocumentActionResponse',
    'GoogleCloudContentwarehouseV1EnumArrayResponse',
    'GoogleCloudContentwarehouseV1EnumTypeOptionsResponse',
    'GoogleCloudContentwarehouseV1FloatArrayResponse',
    'GoogleCloudContentwarehouseV1FloatTypeOptionsResponse',
    'GoogleCloudContentwarehouseV1IntegerArrayResponse',
    'GoogleCloudContentwarehouseV1IntegerTypeOptionsResponse',
    'GoogleCloudContentwarehouseV1MapPropertyResponse',
    'GoogleCloudContentwarehouseV1MapTypeOptionsResponse',
    'GoogleCloudContentwarehouseV1PropertyArrayResponse',
    'GoogleCloudContentwarehouseV1PropertyDefinitionResponse',
    'GoogleCloudContentwarehouseV1PropertyDefinitionSchemaSourceResponse',
    'GoogleCloudContentwarehouseV1PropertyResponse',
    'GoogleCloudContentwarehouseV1PropertyTypeOptionsResponse',
    'GoogleCloudContentwarehouseV1PublishActionResponse',
    'GoogleCloudContentwarehouseV1RemoveFromFolderActionResponse',
    'GoogleCloudContentwarehouseV1RuleResponse',
    'GoogleCloudContentwarehouseV1SynonymSetSynonymResponse',
    'GoogleCloudContentwarehouseV1TextArrayResponse',
    'GoogleCloudContentwarehouseV1TextTypeOptionsResponse',
    'GoogleCloudContentwarehouseV1TimestampArrayResponse',
    'GoogleCloudContentwarehouseV1TimestampTypeOptionsResponse',
    'GoogleCloudContentwarehouseV1TimestampValueResponse',
    'GoogleCloudDocumentaiV1BarcodeResponse',
    'GoogleCloudDocumentaiV1BoundingPolyResponse',
    'GoogleCloudDocumentaiV1DocumentEntityNormalizedValueResponse',
    'GoogleCloudDocumentaiV1DocumentEntityRelationResponse',
    'GoogleCloudDocumentaiV1DocumentEntityResponse',
    'GoogleCloudDocumentaiV1DocumentPageAnchorPageRefResponse',
    'GoogleCloudDocumentaiV1DocumentPageAnchorResponse',
    'GoogleCloudDocumentaiV1DocumentPageBlockResponse',
    'GoogleCloudDocumentaiV1DocumentPageDetectedBarcodeResponse',
    'GoogleCloudDocumentaiV1DocumentPageDetectedLanguageResponse',
    'GoogleCloudDocumentaiV1DocumentPageDimensionResponse',
    'GoogleCloudDocumentaiV1DocumentPageFormFieldResponse',
    'GoogleCloudDocumentaiV1DocumentPageImageQualityScoresDetectedDefectResponse',
    'GoogleCloudDocumentaiV1DocumentPageImageQualityScoresResponse',
    'GoogleCloudDocumentaiV1DocumentPageImageResponse',
    'GoogleCloudDocumentaiV1DocumentPageLayoutResponse',
    'GoogleCloudDocumentaiV1DocumentPageLineResponse',
    'GoogleCloudDocumentaiV1DocumentPageMatrixResponse',
    'GoogleCloudDocumentaiV1DocumentPageParagraphResponse',
    'GoogleCloudDocumentaiV1DocumentPageResponse',
    'GoogleCloudDocumentaiV1DocumentPageSymbolResponse',
    'GoogleCloudDocumentaiV1DocumentPageTableResponse',
    'GoogleCloudDocumentaiV1DocumentPageTableTableCellResponse',
    'GoogleCloudDocumentaiV1DocumentPageTableTableRowResponse',
    'GoogleCloudDocumentaiV1DocumentPageTokenDetectedBreakResponse',
    'GoogleCloudDocumentaiV1DocumentPageTokenResponse',
    'GoogleCloudDocumentaiV1DocumentPageVisualElementResponse',
    'GoogleCloudDocumentaiV1DocumentProvenanceParentResponse',
    'GoogleCloudDocumentaiV1DocumentProvenanceResponse',
    'GoogleCloudDocumentaiV1DocumentResponse',
    'GoogleCloudDocumentaiV1DocumentRevisionHumanReviewResponse',
    'GoogleCloudDocumentaiV1DocumentRevisionResponse',
    'GoogleCloudDocumentaiV1DocumentShardInfoResponse',
    'GoogleCloudDocumentaiV1DocumentStyleFontSizeResponse',
    'GoogleCloudDocumentaiV1DocumentStyleResponse',
    'GoogleCloudDocumentaiV1DocumentTextAnchorResponse',
    'GoogleCloudDocumentaiV1DocumentTextAnchorTextSegmentResponse',
    'GoogleCloudDocumentaiV1DocumentTextChangeResponse',
    'GoogleCloudDocumentaiV1NormalizedVertexResponse',
    'GoogleCloudDocumentaiV1VertexResponse',
    'GoogleIamV1AuditConfigResponse',
    'GoogleIamV1AuditLogConfigResponse',
    'GoogleIamV1BindingResponse',
    'GoogleIamV1PolicyResponse',
    'GoogleRpcStatusResponse',
    'GoogleTypeColorResponse',
    'GoogleTypeDateResponse',
    'GoogleTypeDateTimeResponse',
    'GoogleTypeExprResponse',
    'GoogleTypeMoneyResponse',
    'GoogleTypePostalAddressResponse',
    'GoogleTypeTimeZoneResponse',
]

@pulumi.output_type
class GoogleCloudContentwarehouseV1AccessControlActionResponse(dict):
    """
    Represents the action responsible for access control list management operations.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operationType":
            suggest = "operation_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudContentwarehouseV1AccessControlActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudContentwarehouseV1AccessControlActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudContentwarehouseV1AccessControlActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operation_type: str,
                 policy: 'outputs.GoogleIamV1PolicyResponse'):
        """
        Represents the action responsible for access control list management operations.
        :param str operation_type: Identifies the type of operation.
        :param 'GoogleIamV1PolicyResponse' policy: Represents the new policy from which bindings are added, removed or replaced based on the type of the operation. the policy is limited to a few 10s of KB.
        """
        pulumi.set(__self__, "operation_type", operation_type)
        pulumi.set(__self__, "policy", policy)

    @property
    @pulumi.getter(name="operationType")
    def operation_type(self) -> str:
        """
        Identifies the type of operation.
        """
        return pulumi.get(self, "operation_type")

    @property
    @pulumi.getter
    def policy(self) -> 'outputs.GoogleIamV1PolicyResponse':
        """
        Represents the new policy from which bindings are added, removed or replaced based on the type of the operation. the policy is limited to a few 10s of KB.
        """
        return pulumi.get(self, "policy")


@pulumi.output_type
class GoogleCloudContentwarehouseV1ActionResponse(dict):
    """
    Represents the action triggered by Rule Engine when the rule is true.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessControl":
            suggest = "access_control"
        elif key == "actionId":
            suggest = "action_id"
        elif key == "addToFolder":
            suggest = "add_to_folder"
        elif key == "dataUpdate":
            suggest = "data_update"
        elif key == "dataValidation":
            suggest = "data_validation"
        elif key == "deleteDocumentAction":
            suggest = "delete_document_action"
        elif key == "publishToPubSub":
            suggest = "publish_to_pub_sub"
        elif key == "removeFromFolderAction":
            suggest = "remove_from_folder_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudContentwarehouseV1ActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudContentwarehouseV1ActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudContentwarehouseV1ActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_control: 'outputs.GoogleCloudContentwarehouseV1AccessControlActionResponse',
                 action_id: str,
                 add_to_folder: 'outputs.GoogleCloudContentwarehouseV1AddToFolderActionResponse',
                 data_update: 'outputs.GoogleCloudContentwarehouseV1DataUpdateActionResponse',
                 data_validation: 'outputs.GoogleCloudContentwarehouseV1DataValidationActionResponse',
                 delete_document_action: 'outputs.GoogleCloudContentwarehouseV1DeleteDocumentActionResponse',
                 publish_to_pub_sub: 'outputs.GoogleCloudContentwarehouseV1PublishActionResponse',
                 remove_from_folder_action: 'outputs.GoogleCloudContentwarehouseV1RemoveFromFolderActionResponse'):
        """
        Represents the action triggered by Rule Engine when the rule is true.
        :param 'GoogleCloudContentwarehouseV1AccessControlActionResponse' access_control: Action triggering access control operations.
        :param str action_id: ID of the action. Managed internally.
        :param 'GoogleCloudContentwarehouseV1AddToFolderActionResponse' add_to_folder: Action triggering create document link operation.
        :param 'GoogleCloudContentwarehouseV1DataUpdateActionResponse' data_update: Action triggering data update operations.
        :param 'GoogleCloudContentwarehouseV1DataValidationActionResponse' data_validation: Action triggering data validation operations.
        :param 'GoogleCloudContentwarehouseV1DeleteDocumentActionResponse' delete_document_action: Action deleting the document.
        :param 'GoogleCloudContentwarehouseV1PublishActionResponse' publish_to_pub_sub: Action publish to Pub/Sub operation.
        :param 'GoogleCloudContentwarehouseV1RemoveFromFolderActionResponse' remove_from_folder_action: Action removing a document from a folder.
        """
        pulumi.set(__self__, "access_control", access_control)
        pulumi.set(__self__, "action_id", action_id)
        pulumi.set(__self__, "add_to_folder", add_to_folder)
        pulumi.set(__self__, "data_update", data_update)
        pulumi.set(__self__, "data_validation", data_validation)
        pulumi.set(__self__, "delete_document_action", delete_document_action)
        pulumi.set(__self__, "publish_to_pub_sub", publish_to_pub_sub)
        pulumi.set(__self__, "remove_from_folder_action", remove_from_folder_action)

    @property
    @pulumi.getter(name="accessControl")
    def access_control(self) -> 'outputs.GoogleCloudContentwarehouseV1AccessControlActionResponse':
        """
        Action triggering access control operations.
        """
        return pulumi.get(self, "access_control")

    @property
    @pulumi.getter(name="actionId")
    def action_id(self) -> str:
        """
        ID of the action. Managed internally.
        """
        return pulumi.get(self, "action_id")

    @property
    @pulumi.getter(name="addToFolder")
    def add_to_folder(self) -> 'outputs.GoogleCloudContentwarehouseV1AddToFolderActionResponse':
        """
        Action triggering create document link operation.
        """
        return pulumi.get(self, "add_to_folder")

    @property
    @pulumi.getter(name="dataUpdate")
    def data_update(self) -> 'outputs.GoogleCloudContentwarehouseV1DataUpdateActionResponse':
        """
        Action triggering data update operations.
        """
        return pulumi.get(self, "data_update")

    @property
    @pulumi.getter(name="dataValidation")
    def data_validation(self) -> 'outputs.GoogleCloudContentwarehouseV1DataValidationActionResponse':
        """
        Action triggering data validation operations.
        """
        return pulumi.get(self, "data_validation")

    @property
    @pulumi.getter(name="deleteDocumentAction")
    def delete_document_action(self) -> 'outputs.GoogleCloudContentwarehouseV1DeleteDocumentActionResponse':
        """
        Action deleting the document.
        """
        return pulumi.get(self, "delete_document_action")

    @property
    @pulumi.getter(name="publishToPubSub")
    def publish_to_pub_sub(self) -> 'outputs.GoogleCloudContentwarehouseV1PublishActionResponse':
        """
        Action publish to Pub/Sub operation.
        """
        return pulumi.get(self, "publish_to_pub_sub")

    @property
    @pulumi.getter(name="removeFromFolderAction")
    def remove_from_folder_action(self) -> 'outputs.GoogleCloudContentwarehouseV1RemoveFromFolderActionResponse':
        """
        Action removing a document from a folder.
        """
        return pulumi.get(self, "remove_from_folder_action")


@pulumi.output_type
class GoogleCloudContentwarehouseV1AddToFolderActionResponse(dict):
    """
    Represents the action responsible for adding document under a folder.
    """
    def __init__(__self__, *,
                 folders: Sequence[str]):
        """
        Represents the action responsible for adding document under a folder.
        :param Sequence[str] folders: Names of the folder under which new document is to be added. Format: projects/{project_number}/locations/{location}/documents/{document_id}.
        """
        pulumi.set(__self__, "folders", folders)

    @property
    @pulumi.getter
    def folders(self) -> Sequence[str]:
        """
        Names of the folder under which new document is to be added. Format: projects/{project_number}/locations/{location}/documents/{document_id}.
        """
        return pulumi.get(self, "folders")


@pulumi.output_type
class GoogleCloudContentwarehouseV1DataUpdateActionResponse(dict):
    """
    Represents the action responsible for properties update operations.
    """
    def __init__(__self__, *,
                 entries: Mapping[str, str]):
        """
        Represents the action responsible for properties update operations.
        :param Mapping[str, str] entries: Map of (K, V) -> (valid name of the field, new value of the field) E.g., ("age", "60") entry triggers update of field age with a value of 60. If the field is not present then new entry is added. During update action execution, value strings will be casted to appropriate types.
        """
        pulumi.set(__self__, "entries", entries)

    @property
    @pulumi.getter
    def entries(self) -> Mapping[str, str]:
        """
        Map of (K, V) -> (valid name of the field, new value of the field) E.g., ("age", "60") entry triggers update of field age with a value of 60. If the field is not present then new entry is added. During update action execution, value strings will be casted to appropriate types.
        """
        return pulumi.get(self, "entries")


@pulumi.output_type
class GoogleCloudContentwarehouseV1DataValidationActionResponse(dict):
    """
    Represents the action responsible for data validation operations.
    """
    def __init__(__self__, *,
                 conditions: Mapping[str, str]):
        """
        Represents the action responsible for data validation operations.
        :param Mapping[str, str] conditions: Map of (K, V) -> (field, string condition to be evaluated on the field) E.g., ("age", "age > 18 && age < 60") entry triggers validation of field age with the given condition. Map entries will be ANDed during validation.
        """
        pulumi.set(__self__, "conditions", conditions)

    @property
    @pulumi.getter
    def conditions(self) -> Mapping[str, str]:
        """
        Map of (K, V) -> (field, string condition to be evaluated on the field) E.g., ("age", "age > 18 && age < 60") entry triggers validation of field age with the given condition. Map entries will be ANDed during validation.
        """
        return pulumi.get(self, "conditions")


@pulumi.output_type
class GoogleCloudContentwarehouseV1DateTimeArrayResponse(dict):
    """
    DateTime values.
    """
    def __init__(__self__, *,
                 values: Sequence['outputs.GoogleTypeDateTimeResponse']):
        """
        DateTime values.
        :param Sequence['GoogleTypeDateTimeResponse'] values: List of datetime values. Both OffsetDateTime and ZonedDateTime are supported.
        """
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def values(self) -> Sequence['outputs.GoogleTypeDateTimeResponse']:
        """
        List of datetime values. Both OffsetDateTime and ZonedDateTime are supported.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GoogleCloudContentwarehouseV1DateTimeTypeOptionsResponse(dict):
    """
    Configurations for a date time property.
    """
    def __init__(__self__):
        """
        Configurations for a date time property.
        """
        pass


@pulumi.output_type
class GoogleCloudContentwarehouseV1DeleteDocumentActionResponse(dict):
    """
    Represents the action responsible for deleting the document.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableHardDelete":
            suggest = "enable_hard_delete"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudContentwarehouseV1DeleteDocumentActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudContentwarehouseV1DeleteDocumentActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudContentwarehouseV1DeleteDocumentActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_hard_delete: bool):
        """
        Represents the action responsible for deleting the document.
        :param bool enable_hard_delete: Boolean field to select between hard vs soft delete options. Set 'true' for 'hard delete' and 'false' for 'soft delete'.
        """
        pulumi.set(__self__, "enable_hard_delete", enable_hard_delete)

    @property
    @pulumi.getter(name="enableHardDelete")
    def enable_hard_delete(self) -> bool:
        """
        Boolean field to select between hard vs soft delete options. Set 'true' for 'hard delete' and 'false' for 'soft delete'.
        """
        return pulumi.get(self, "enable_hard_delete")


@pulumi.output_type
class GoogleCloudContentwarehouseV1EnumArrayResponse(dict):
    """
    Enum values.
    """
    def __init__(__self__, *,
                 values: Sequence[str]):
        """
        Enum values.
        :param Sequence[str] values: List of enum values.
        """
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        List of enum values.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GoogleCloudContentwarehouseV1EnumTypeOptionsResponse(dict):
    """
    Configurations for an enum/categorical property.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "possibleValues":
            suggest = "possible_values"
        elif key == "validationCheckDisabled":
            suggest = "validation_check_disabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudContentwarehouseV1EnumTypeOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudContentwarehouseV1EnumTypeOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudContentwarehouseV1EnumTypeOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 possible_values: Sequence[str],
                 validation_check_disabled: bool):
        """
        Configurations for an enum/categorical property.
        :param Sequence[str] possible_values: List of possible enum values.
        :param bool validation_check_disabled: Make sure the Enum property value provided in the document is in the possile value list during document creation. The validation check runs by default.
        """
        pulumi.set(__self__, "possible_values", possible_values)
        pulumi.set(__self__, "validation_check_disabled", validation_check_disabled)

    @property
    @pulumi.getter(name="possibleValues")
    def possible_values(self) -> Sequence[str]:
        """
        List of possible enum values.
        """
        return pulumi.get(self, "possible_values")

    @property
    @pulumi.getter(name="validationCheckDisabled")
    def validation_check_disabled(self) -> bool:
        """
        Make sure the Enum property value provided in the document is in the possile value list during document creation. The validation check runs by default.
        """
        return pulumi.get(self, "validation_check_disabled")


@pulumi.output_type
class GoogleCloudContentwarehouseV1FloatArrayResponse(dict):
    """
    Float values.
    """
    def __init__(__self__, *,
                 values: Sequence[float]):
        """
        Float values.
        :param Sequence[float] values: List of float values.
        """
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def values(self) -> Sequence[float]:
        """
        List of float values.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GoogleCloudContentwarehouseV1FloatTypeOptionsResponse(dict):
    """
    Configurations for a float property.
    """
    def __init__(__self__):
        """
        Configurations for a float property.
        """
        pass


@pulumi.output_type
class GoogleCloudContentwarehouseV1IntegerArrayResponse(dict):
    """
    Integer values.
    """
    def __init__(__self__, *,
                 values: Sequence[int]):
        """
        Integer values.
        :param Sequence[int] values: List of integer values.
        """
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def values(self) -> Sequence[int]:
        """
        List of integer values.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GoogleCloudContentwarehouseV1IntegerTypeOptionsResponse(dict):
    """
    Configurations for an integer property.
    """
    def __init__(__self__):
        """
        Configurations for an integer property.
        """
        pass


@pulumi.output_type
class GoogleCloudContentwarehouseV1MapPropertyResponse(dict):
    """
    Map property value. Represents a structured entries of key value pairs, consisting of field names which map to dynamically typed values.
    """
    def __init__(__self__, *,
                 fields: Mapping[str, str]):
        """
        Map property value. Represents a structured entries of key value pairs, consisting of field names which map to dynamically typed values.
        :param Mapping[str, str] fields: Unordered map of dynamically typed values.
        """
        pulumi.set(__self__, "fields", fields)

    @property
    @pulumi.getter
    def fields(self) -> Mapping[str, str]:
        """
        Unordered map of dynamically typed values.
        """
        return pulumi.get(self, "fields")


@pulumi.output_type
class GoogleCloudContentwarehouseV1MapTypeOptionsResponse(dict):
    """
    Configurations for a Map property.
    """
    def __init__(__self__):
        """
        Configurations for a Map property.
        """
        pass


@pulumi.output_type
class GoogleCloudContentwarehouseV1PropertyArrayResponse(dict):
    """
    Property values.
    """
    def __init__(__self__, *,
                 properties: Sequence['outputs.GoogleCloudContentwarehouseV1PropertyResponse']):
        """
        Property values.
        :param Sequence['GoogleCloudContentwarehouseV1PropertyResponse'] properties: List of property values.
        """
        pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def properties(self) -> Sequence['outputs.GoogleCloudContentwarehouseV1PropertyResponse']:
        """
        List of property values.
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class GoogleCloudContentwarehouseV1PropertyDefinitionResponse(dict):
    """
    Defines the metadata for a schema property.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dateTimeTypeOptions":
            suggest = "date_time_type_options"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "enumTypeOptions":
            suggest = "enum_type_options"
        elif key == "floatTypeOptions":
            suggest = "float_type_options"
        elif key == "integerTypeOptions":
            suggest = "integer_type_options"
        elif key == "isFilterable":
            suggest = "is_filterable"
        elif key == "isMetadata":
            suggest = "is_metadata"
        elif key == "isRepeatable":
            suggest = "is_repeatable"
        elif key == "isRequired":
            suggest = "is_required"
        elif key == "isSearchable":
            suggest = "is_searchable"
        elif key == "mapTypeOptions":
            suggest = "map_type_options"
        elif key == "propertyTypeOptions":
            suggest = "property_type_options"
        elif key == "retrievalImportance":
            suggest = "retrieval_importance"
        elif key == "schemaSources":
            suggest = "schema_sources"
        elif key == "textTypeOptions":
            suggest = "text_type_options"
        elif key == "timestampTypeOptions":
            suggest = "timestamp_type_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudContentwarehouseV1PropertyDefinitionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudContentwarehouseV1PropertyDefinitionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudContentwarehouseV1PropertyDefinitionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 date_time_type_options: 'outputs.GoogleCloudContentwarehouseV1DateTimeTypeOptionsResponse',
                 display_name: str,
                 enum_type_options: 'outputs.GoogleCloudContentwarehouseV1EnumTypeOptionsResponse',
                 float_type_options: 'outputs.GoogleCloudContentwarehouseV1FloatTypeOptionsResponse',
                 integer_type_options: 'outputs.GoogleCloudContentwarehouseV1IntegerTypeOptionsResponse',
                 is_filterable: bool,
                 is_metadata: bool,
                 is_repeatable: bool,
                 is_required: bool,
                 is_searchable: bool,
                 map_type_options: 'outputs.GoogleCloudContentwarehouseV1MapTypeOptionsResponse',
                 name: str,
                 property_type_options: 'outputs.GoogleCloudContentwarehouseV1PropertyTypeOptionsResponse',
                 retrieval_importance: str,
                 schema_sources: Sequence['outputs.GoogleCloudContentwarehouseV1PropertyDefinitionSchemaSourceResponse'],
                 text_type_options: 'outputs.GoogleCloudContentwarehouseV1TextTypeOptionsResponse',
                 timestamp_type_options: 'outputs.GoogleCloudContentwarehouseV1TimestampTypeOptionsResponse'):
        """
        Defines the metadata for a schema property.
        :param 'GoogleCloudContentwarehouseV1DateTimeTypeOptionsResponse' date_time_type_options: Date time property. It is not supported by CMEK compliant deployment.
        :param str display_name: The display-name for the property, used for front-end.
        :param 'GoogleCloudContentwarehouseV1EnumTypeOptionsResponse' enum_type_options: Enum/categorical property.
        :param 'GoogleCloudContentwarehouseV1FloatTypeOptionsResponse' float_type_options: Float property.
        :param 'GoogleCloudContentwarehouseV1IntegerTypeOptionsResponse' integer_type_options: Integer property.
        :param bool is_filterable: Whether the property can be filtered. If this is a sub-property, all the parent properties must be marked filterable.
        :param bool is_metadata: Whether the property is user supplied metadata. This out-of-the box placeholder setting can be used to tag derived properties. Its value and interpretation logic should be implemented by API user.
        :param bool is_repeatable: Whether the property can have multiple values.
        :param bool is_required: Whether the property is mandatory. Default is 'false', i.e. populating property value can be skipped. If 'true' then user must populate the value for this property.
        :param bool is_searchable: Indicates that the property should be included in a global search.
        :param 'GoogleCloudContentwarehouseV1MapTypeOptionsResponse' map_type_options: Map property.
        :param str name: The name of the metadata property. Must be unique within a document schema and is case insensitive. Names must be non-blank, start with a letter, and can contain alphanumeric characters and: /, :, -, _, and .
        :param 'GoogleCloudContentwarehouseV1PropertyTypeOptionsResponse' property_type_options: Nested structured data property.
        :param str retrieval_importance: The retrieval importance of the property during search.
        :param Sequence['GoogleCloudContentwarehouseV1PropertyDefinitionSchemaSourceResponse'] schema_sources: The mapping information between this property to another schema source.
        :param 'GoogleCloudContentwarehouseV1TextTypeOptionsResponse' text_type_options: Text/string property.
        :param 'GoogleCloudContentwarehouseV1TimestampTypeOptionsResponse' timestamp_type_options: Timestamp property. It is not supported by CMEK compliant deployment.
        """
        pulumi.set(__self__, "date_time_type_options", date_time_type_options)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "enum_type_options", enum_type_options)
        pulumi.set(__self__, "float_type_options", float_type_options)
        pulumi.set(__self__, "integer_type_options", integer_type_options)
        pulumi.set(__self__, "is_filterable", is_filterable)
        pulumi.set(__self__, "is_metadata", is_metadata)
        pulumi.set(__self__, "is_repeatable", is_repeatable)
        pulumi.set(__self__, "is_required", is_required)
        pulumi.set(__self__, "is_searchable", is_searchable)
        pulumi.set(__self__, "map_type_options", map_type_options)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "property_type_options", property_type_options)
        pulumi.set(__self__, "retrieval_importance", retrieval_importance)
        pulumi.set(__self__, "schema_sources", schema_sources)
        pulumi.set(__self__, "text_type_options", text_type_options)
        pulumi.set(__self__, "timestamp_type_options", timestamp_type_options)

    @property
    @pulumi.getter(name="dateTimeTypeOptions")
    def date_time_type_options(self) -> 'outputs.GoogleCloudContentwarehouseV1DateTimeTypeOptionsResponse':
        """
        Date time property. It is not supported by CMEK compliant deployment.
        """
        return pulumi.get(self, "date_time_type_options")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display-name for the property, used for front-end.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="enumTypeOptions")
    def enum_type_options(self) -> 'outputs.GoogleCloudContentwarehouseV1EnumTypeOptionsResponse':
        """
        Enum/categorical property.
        """
        return pulumi.get(self, "enum_type_options")

    @property
    @pulumi.getter(name="floatTypeOptions")
    def float_type_options(self) -> 'outputs.GoogleCloudContentwarehouseV1FloatTypeOptionsResponse':
        """
        Float property.
        """
        return pulumi.get(self, "float_type_options")

    @property
    @pulumi.getter(name="integerTypeOptions")
    def integer_type_options(self) -> 'outputs.GoogleCloudContentwarehouseV1IntegerTypeOptionsResponse':
        """
        Integer property.
        """
        return pulumi.get(self, "integer_type_options")

    @property
    @pulumi.getter(name="isFilterable")
    def is_filterable(self) -> bool:
        """
        Whether the property can be filtered. If this is a sub-property, all the parent properties must be marked filterable.
        """
        return pulumi.get(self, "is_filterable")

    @property
    @pulumi.getter(name="isMetadata")
    def is_metadata(self) -> bool:
        """
        Whether the property is user supplied metadata. This out-of-the box placeholder setting can be used to tag derived properties. Its value and interpretation logic should be implemented by API user.
        """
        return pulumi.get(self, "is_metadata")

    @property
    @pulumi.getter(name="isRepeatable")
    def is_repeatable(self) -> bool:
        """
        Whether the property can have multiple values.
        """
        return pulumi.get(self, "is_repeatable")

    @property
    @pulumi.getter(name="isRequired")
    def is_required(self) -> bool:
        """
        Whether the property is mandatory. Default is 'false', i.e. populating property value can be skipped. If 'true' then user must populate the value for this property.
        """
        return pulumi.get(self, "is_required")

    @property
    @pulumi.getter(name="isSearchable")
    def is_searchable(self) -> bool:
        """
        Indicates that the property should be included in a global search.
        """
        return pulumi.get(self, "is_searchable")

    @property
    @pulumi.getter(name="mapTypeOptions")
    def map_type_options(self) -> 'outputs.GoogleCloudContentwarehouseV1MapTypeOptionsResponse':
        """
        Map property.
        """
        return pulumi.get(self, "map_type_options")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the metadata property. Must be unique within a document schema and is case insensitive. Names must be non-blank, start with a letter, and can contain alphanumeric characters and: /, :, -, _, and .
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="propertyTypeOptions")
    def property_type_options(self) -> 'outputs.GoogleCloudContentwarehouseV1PropertyTypeOptionsResponse':
        """
        Nested structured data property.
        """
        return pulumi.get(self, "property_type_options")

    @property
    @pulumi.getter(name="retrievalImportance")
    def retrieval_importance(self) -> str:
        """
        The retrieval importance of the property during search.
        """
        return pulumi.get(self, "retrieval_importance")

    @property
    @pulumi.getter(name="schemaSources")
    def schema_sources(self) -> Sequence['outputs.GoogleCloudContentwarehouseV1PropertyDefinitionSchemaSourceResponse']:
        """
        The mapping information between this property to another schema source.
        """
        return pulumi.get(self, "schema_sources")

    @property
    @pulumi.getter(name="textTypeOptions")
    def text_type_options(self) -> 'outputs.GoogleCloudContentwarehouseV1TextTypeOptionsResponse':
        """
        Text/string property.
        """
        return pulumi.get(self, "text_type_options")

    @property
    @pulumi.getter(name="timestampTypeOptions")
    def timestamp_type_options(self) -> 'outputs.GoogleCloudContentwarehouseV1TimestampTypeOptionsResponse':
        """
        Timestamp property. It is not supported by CMEK compliant deployment.
        """
        return pulumi.get(self, "timestamp_type_options")


@pulumi.output_type
class GoogleCloudContentwarehouseV1PropertyDefinitionSchemaSourceResponse(dict):
    """
    The schema source information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "processorType":
            suggest = "processor_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudContentwarehouseV1PropertyDefinitionSchemaSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudContentwarehouseV1PropertyDefinitionSchemaSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudContentwarehouseV1PropertyDefinitionSchemaSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 processor_type: str):
        """
        The schema source information.
        :param str name: The schema name in the source.
        :param str processor_type: The Doc AI processor type name.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "processor_type", processor_type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The schema name in the source.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="processorType")
    def processor_type(self) -> str:
        """
        The Doc AI processor type name.
        """
        return pulumi.get(self, "processor_type")


@pulumi.output_type
class GoogleCloudContentwarehouseV1PropertyResponse(dict):
    """
    Property of a document.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dateTimeValues":
            suggest = "date_time_values"
        elif key == "enumValues":
            suggest = "enum_values"
        elif key == "floatValues":
            suggest = "float_values"
        elif key == "integerValues":
            suggest = "integer_values"
        elif key == "mapProperty":
            suggest = "map_property"
        elif key == "propertyValues":
            suggest = "property_values"
        elif key == "textValues":
            suggest = "text_values"
        elif key == "timestampValues":
            suggest = "timestamp_values"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudContentwarehouseV1PropertyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudContentwarehouseV1PropertyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudContentwarehouseV1PropertyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 date_time_values: 'outputs.GoogleCloudContentwarehouseV1DateTimeArrayResponse',
                 enum_values: 'outputs.GoogleCloudContentwarehouseV1EnumArrayResponse',
                 float_values: 'outputs.GoogleCloudContentwarehouseV1FloatArrayResponse',
                 integer_values: 'outputs.GoogleCloudContentwarehouseV1IntegerArrayResponse',
                 map_property: 'outputs.GoogleCloudContentwarehouseV1MapPropertyResponse',
                 name: str,
                 property_values: 'outputs.GoogleCloudContentwarehouseV1PropertyArrayResponse',
                 text_values: 'outputs.GoogleCloudContentwarehouseV1TextArrayResponse',
                 timestamp_values: 'outputs.GoogleCloudContentwarehouseV1TimestampArrayResponse'):
        """
        Property of a document.
        :param 'GoogleCloudContentwarehouseV1DateTimeArrayResponse' date_time_values: Date time property values. It is not supported by CMEK compliant deployment.
        :param 'GoogleCloudContentwarehouseV1EnumArrayResponse' enum_values: Enum property values.
        :param 'GoogleCloudContentwarehouseV1FloatArrayResponse' float_values: Float property values.
        :param 'GoogleCloudContentwarehouseV1IntegerArrayResponse' integer_values: Integer property values.
        :param 'GoogleCloudContentwarehouseV1MapPropertyResponse' map_property: Map property values.
        :param str name: Must match the name of a PropertyDefinition in the DocumentSchema.
        :param 'GoogleCloudContentwarehouseV1PropertyArrayResponse' property_values: Nested structured data property values.
        :param 'GoogleCloudContentwarehouseV1TextArrayResponse' text_values: String/text property values.
        :param 'GoogleCloudContentwarehouseV1TimestampArrayResponse' timestamp_values: Timestamp property values. It is not supported by CMEK compliant deployment.
        """
        pulumi.set(__self__, "date_time_values", date_time_values)
        pulumi.set(__self__, "enum_values", enum_values)
        pulumi.set(__self__, "float_values", float_values)
        pulumi.set(__self__, "integer_values", integer_values)
        pulumi.set(__self__, "map_property", map_property)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "property_values", property_values)
        pulumi.set(__self__, "text_values", text_values)
        pulumi.set(__self__, "timestamp_values", timestamp_values)

    @property
    @pulumi.getter(name="dateTimeValues")
    def date_time_values(self) -> 'outputs.GoogleCloudContentwarehouseV1DateTimeArrayResponse':
        """
        Date time property values. It is not supported by CMEK compliant deployment.
        """
        return pulumi.get(self, "date_time_values")

    @property
    @pulumi.getter(name="enumValues")
    def enum_values(self) -> 'outputs.GoogleCloudContentwarehouseV1EnumArrayResponse':
        """
        Enum property values.
        """
        return pulumi.get(self, "enum_values")

    @property
    @pulumi.getter(name="floatValues")
    def float_values(self) -> 'outputs.GoogleCloudContentwarehouseV1FloatArrayResponse':
        """
        Float property values.
        """
        return pulumi.get(self, "float_values")

    @property
    @pulumi.getter(name="integerValues")
    def integer_values(self) -> 'outputs.GoogleCloudContentwarehouseV1IntegerArrayResponse':
        """
        Integer property values.
        """
        return pulumi.get(self, "integer_values")

    @property
    @pulumi.getter(name="mapProperty")
    def map_property(self) -> 'outputs.GoogleCloudContentwarehouseV1MapPropertyResponse':
        """
        Map property values.
        """
        return pulumi.get(self, "map_property")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Must match the name of a PropertyDefinition in the DocumentSchema.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="propertyValues")
    def property_values(self) -> 'outputs.GoogleCloudContentwarehouseV1PropertyArrayResponse':
        """
        Nested structured data property values.
        """
        return pulumi.get(self, "property_values")

    @property
    @pulumi.getter(name="textValues")
    def text_values(self) -> 'outputs.GoogleCloudContentwarehouseV1TextArrayResponse':
        """
        String/text property values.
        """
        return pulumi.get(self, "text_values")

    @property
    @pulumi.getter(name="timestampValues")
    def timestamp_values(self) -> 'outputs.GoogleCloudContentwarehouseV1TimestampArrayResponse':
        """
        Timestamp property values. It is not supported by CMEK compliant deployment.
        """
        return pulumi.get(self, "timestamp_values")


@pulumi.output_type
class GoogleCloudContentwarehouseV1PropertyTypeOptionsResponse(dict):
    """
    Configurations for a nested structured data property.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "propertyDefinitions":
            suggest = "property_definitions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudContentwarehouseV1PropertyTypeOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudContentwarehouseV1PropertyTypeOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudContentwarehouseV1PropertyTypeOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 property_definitions: Sequence['outputs.GoogleCloudContentwarehouseV1PropertyDefinitionResponse']):
        """
        Configurations for a nested structured data property.
        :param Sequence['GoogleCloudContentwarehouseV1PropertyDefinitionResponse'] property_definitions: List of property definitions.
        """
        pulumi.set(__self__, "property_definitions", property_definitions)

    @property
    @pulumi.getter(name="propertyDefinitions")
    def property_definitions(self) -> Sequence['outputs.GoogleCloudContentwarehouseV1PropertyDefinitionResponse']:
        """
        List of property definitions.
        """
        return pulumi.get(self, "property_definitions")


@pulumi.output_type
class GoogleCloudContentwarehouseV1PublishActionResponse(dict):
    """
    Represents the action responsible for publishing messages to a Pub/Sub topic.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "topicId":
            suggest = "topic_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudContentwarehouseV1PublishActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudContentwarehouseV1PublishActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudContentwarehouseV1PublishActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 messages: Sequence[str],
                 topic_id: str):
        """
        Represents the action responsible for publishing messages to a Pub/Sub topic.
        :param Sequence[str] messages: Messages to be published.
        :param str topic_id: The topic id in the Pub/Sub service for which messages will be published to.
        """
        pulumi.set(__self__, "messages", messages)
        pulumi.set(__self__, "topic_id", topic_id)

    @property
    @pulumi.getter
    def messages(self) -> Sequence[str]:
        """
        Messages to be published.
        """
        return pulumi.get(self, "messages")

    @property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> str:
        """
        The topic id in the Pub/Sub service for which messages will be published to.
        """
        return pulumi.get(self, "topic_id")


@pulumi.output_type
class GoogleCloudContentwarehouseV1RemoveFromFolderActionResponse(dict):
    """
    Represents the action responsible for remove a document from a specific folder.
    """
    def __init__(__self__, *,
                 condition: str,
                 folder: str):
        """
        Represents the action responsible for remove a document from a specific folder.
        :param str condition: Condition of the action to be executed.
        :param str folder: Name of the folder under which new document is to be added. Format: projects/{project_number}/locations/{location}/documents/{document_id}.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "folder", folder)

    @property
    @pulumi.getter
    def condition(self) -> str:
        """
        Condition of the action to be executed.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def folder(self) -> str:
        """
        Name of the folder under which new document is to be added. Format: projects/{project_number}/locations/{location}/documents/{document_id}.
        """
        return pulumi.get(self, "folder")


@pulumi.output_type
class GoogleCloudContentwarehouseV1RuleResponse(dict):
    """
    Represents the rule for a content warehouse trigger.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ruleId":
            suggest = "rule_id"
        elif key == "triggerType":
            suggest = "trigger_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudContentwarehouseV1RuleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudContentwarehouseV1RuleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudContentwarehouseV1RuleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 actions: Sequence['outputs.GoogleCloudContentwarehouseV1ActionResponse'],
                 condition: str,
                 description: str,
                 rule_id: str,
                 trigger_type: str):
        """
        Represents the rule for a content warehouse trigger.
        :param Sequence['GoogleCloudContentwarehouseV1ActionResponse'] actions: List of actions that are executed when the rule is satisfied.
        :param str condition: Represents the conditional expression to be evaluated. Expression should evaluate to a boolean result. When the condition is true actions are executed. Example: user_role = "hsbc_role_1" AND doc.salary > 20000
        :param str description: Short description of the rule and its context.
        :param str rule_id: ID of the rule. It has to be unique across all the examples. This is managed internally.
        :param str trigger_type: Identifies the trigger type for running the policy.
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "rule_id", rule_id)
        pulumi.set(__self__, "trigger_type", trigger_type)

    @property
    @pulumi.getter
    def actions(self) -> Sequence['outputs.GoogleCloudContentwarehouseV1ActionResponse']:
        """
        List of actions that are executed when the rule is satisfied.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter
    def condition(self) -> str:
        """
        Represents the conditional expression to be evaluated. Expression should evaluate to a boolean result. When the condition is true actions are executed. Example: user_role = "hsbc_role_1" AND doc.salary > 20000
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Short description of the rule and its context.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> str:
        """
        ID of the rule. It has to be unique across all the examples. This is managed internally.
        """
        return pulumi.get(self, "rule_id")

    @property
    @pulumi.getter(name="triggerType")
    def trigger_type(self) -> str:
        """
        Identifies the trigger type for running the policy.
        """
        return pulumi.get(self, "trigger_type")


@pulumi.output_type
class GoogleCloudContentwarehouseV1SynonymSetSynonymResponse(dict):
    """
    Represents a list of words given by the customer All these words are synonyms of each other.
    """
    def __init__(__self__, *,
                 words: Sequence[str]):
        """
        Represents a list of words given by the customer All these words are synonyms of each other.
        :param Sequence[str] words: For example: sale, invoice, bill, order
        """
        pulumi.set(__self__, "words", words)

    @property
    @pulumi.getter
    def words(self) -> Sequence[str]:
        """
        For example: sale, invoice, bill, order
        """
        return pulumi.get(self, "words")


@pulumi.output_type
class GoogleCloudContentwarehouseV1TextArrayResponse(dict):
    """
    String/text values.
    """
    def __init__(__self__, *,
                 values: Sequence[str]):
        """
        String/text values.
        :param Sequence[str] values: List of text values.
        """
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        List of text values.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GoogleCloudContentwarehouseV1TextTypeOptionsResponse(dict):
    """
    Configurations for a text property.
    """
    def __init__(__self__):
        """
        Configurations for a text property.
        """
        pass


@pulumi.output_type
class GoogleCloudContentwarehouseV1TimestampArrayResponse(dict):
    """
    Timestamp values.
    """
    def __init__(__self__, *,
                 values: Sequence['outputs.GoogleCloudContentwarehouseV1TimestampValueResponse']):
        """
        Timestamp values.
        :param Sequence['GoogleCloudContentwarehouseV1TimestampValueResponse'] values: List of timestamp values.
        """
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def values(self) -> Sequence['outputs.GoogleCloudContentwarehouseV1TimestampValueResponse']:
        """
        List of timestamp values.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GoogleCloudContentwarehouseV1TimestampTypeOptionsResponse(dict):
    """
    Configurations for a timestamp property.
    """
    def __init__(__self__):
        """
        Configurations for a timestamp property.
        """
        pass


@pulumi.output_type
class GoogleCloudContentwarehouseV1TimestampValueResponse(dict):
    """
    Timestamp value type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "textValue":
            suggest = "text_value"
        elif key == "timestampValue":
            suggest = "timestamp_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudContentwarehouseV1TimestampValueResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudContentwarehouseV1TimestampValueResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudContentwarehouseV1TimestampValueResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 text_value: str,
                 timestamp_value: str):
        """
        Timestamp value type.
        :param str text_value: The string must represent a valid instant in UTC and is parsed using java.time.format.DateTimeFormatter.ISO_INSTANT. e.g. "2013-09-29T18:46:19Z"
        :param str timestamp_value: Timestamp value
        """
        pulumi.set(__self__, "text_value", text_value)
        pulumi.set(__self__, "timestamp_value", timestamp_value)

    @property
    @pulumi.getter(name="textValue")
    def text_value(self) -> str:
        """
        The string must represent a valid instant in UTC and is parsed using java.time.format.DateTimeFormatter.ISO_INSTANT. e.g. "2013-09-29T18:46:19Z"
        """
        return pulumi.get(self, "text_value")

    @property
    @pulumi.getter(name="timestampValue")
    def timestamp_value(self) -> str:
        """
        Timestamp value
        """
        return pulumi.get(self, "timestamp_value")


@pulumi.output_type
class GoogleCloudDocumentaiV1BarcodeResponse(dict):
    """
    Encodes the detailed information of a barcode.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "rawValue":
            suggest = "raw_value"
        elif key == "valueFormat":
            suggest = "value_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDocumentaiV1BarcodeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDocumentaiV1BarcodeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDocumentaiV1BarcodeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 format: str,
                 raw_value: str,
                 value_format: str):
        """
        Encodes the detailed information of a barcode.
        :param str format: Format of a barcode. The supported formats are: - `CODE_128`: Code 128 type. - `CODE_39`: Code 39 type. - `CODE_93`: Code 93 type. - `CODABAR`: Codabar type. - `DATA_MATRIX`: 2D Data Matrix type. - `ITF`: ITF type. - `EAN_13`: EAN-13 type. - `EAN_8`: EAN-8 type. - `QR_CODE`: 2D QR code type. - `UPC_A`: UPC-A type. - `UPC_E`: UPC-E type. - `PDF417`: PDF417 type. - `AZTEC`: 2D Aztec code type. - `DATABAR`: GS1 DataBar code type.
        :param str raw_value: Raw value encoded in the barcode. For example: `'MEBKM:TITLE:Google;URL:https://www.google.com;;'`.
        :param str value_format: Value format describes the format of the value that a barcode encodes. The supported formats are: - `CONTACT_INFO`: Contact information. - `EMAIL`: Email address. - `ISBN`: ISBN identifier. - `PHONE`: Phone number. - `PRODUCT`: Product. - `SMS`: SMS message. - `TEXT`: Text string. - `URL`: URL address. - `WIFI`: Wifi information. - `GEO`: Geo-localization. - `CALENDAR_EVENT`: Calendar event. - `DRIVER_LICENSE`: Driver's license.
        """
        pulumi.set(__self__, "format", format)
        pulumi.set(__self__, "raw_value", raw_value)
        pulumi.set(__self__, "value_format", value_format)

    @property
    @pulumi.getter
    def format(self) -> str:
        """
        Format of a barcode. The supported formats are: - `CODE_128`: Code 128 type. - `CODE_39`: Code 39 type. - `CODE_93`: Code 93 type. - `CODABAR`: Codabar type. - `DATA_MATRIX`: 2D Data Matrix type. - `ITF`: ITF type. - `EAN_13`: EAN-13 type. - `EAN_8`: EAN-8 type. - `QR_CODE`: 2D QR code type. - `UPC_A`: UPC-A type. - `UPC_E`: UPC-E type. - `PDF417`: PDF417 type. - `AZTEC`: 2D Aztec code type. - `DATABAR`: GS1 DataBar code type.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="rawValue")
    def raw_value(self) -> str:
        """
        Raw value encoded in the barcode. For example: `'MEBKM:TITLE:Google;URL:https://www.google.com;;'`.
        """
        return pulumi.get(self, "raw_value")

    @property
    @pulumi.getter(name="valueFormat")
    def value_format(self) -> str:
        """
        Value format describes the format of the value that a barcode encodes. The supported formats are: - `CONTACT_INFO`: Contact information. - `EMAIL`: Email address. - `ISBN`: ISBN identifier. - `PHONE`: Phone number. - `PRODUCT`: Product. - `SMS`: SMS message. - `TEXT`: Text string. - `URL`: URL address. - `WIFI`: Wifi information. - `GEO`: Geo-localization. - `CALENDAR_EVENT`: Calendar event. - `DRIVER_LICENSE`: Driver's license.
        """
        return pulumi.get(self, "value_format")


@pulumi.output_type
class GoogleCloudDocumentaiV1BoundingPolyResponse(dict):
    """
    A bounding polygon for the detected image annotation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "normalizedVertices":
            suggest = "normalized_vertices"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDocumentaiV1BoundingPolyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDocumentaiV1BoundingPolyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDocumentaiV1BoundingPolyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 normalized_vertices: Sequence['outputs.GoogleCloudDocumentaiV1NormalizedVertexResponse'],
                 vertices: Sequence['outputs.GoogleCloudDocumentaiV1VertexResponse']):
        """
        A bounding polygon for the detected image annotation.
        :param Sequence['GoogleCloudDocumentaiV1NormalizedVertexResponse'] normalized_vertices: The bounding polygon normalized vertices.
        :param Sequence['GoogleCloudDocumentaiV1VertexResponse'] vertices: The bounding polygon vertices.
        """
        pulumi.set(__self__, "normalized_vertices", normalized_vertices)
        pulumi.set(__self__, "vertices", vertices)

    @property
    @pulumi.getter(name="normalizedVertices")
    def normalized_vertices(self) -> Sequence['outputs.GoogleCloudDocumentaiV1NormalizedVertexResponse']:
        """
        The bounding polygon normalized vertices.
        """
        return pulumi.get(self, "normalized_vertices")

    @property
    @pulumi.getter
    def vertices(self) -> Sequence['outputs.GoogleCloudDocumentaiV1VertexResponse']:
        """
        The bounding polygon vertices.
        """
        return pulumi.get(self, "vertices")


@pulumi.output_type
class GoogleCloudDocumentaiV1DocumentEntityNormalizedValueResponse(dict):
    """
    Parsed and normalized entity value.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressValue":
            suggest = "address_value"
        elif key == "booleanValue":
            suggest = "boolean_value"
        elif key == "dateValue":
            suggest = "date_value"
        elif key == "datetimeValue":
            suggest = "datetime_value"
        elif key == "floatValue":
            suggest = "float_value"
        elif key == "integerValue":
            suggest = "integer_value"
        elif key == "moneyValue":
            suggest = "money_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDocumentaiV1DocumentEntityNormalizedValueResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDocumentaiV1DocumentEntityNormalizedValueResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDocumentaiV1DocumentEntityNormalizedValueResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address_value: 'outputs.GoogleTypePostalAddressResponse',
                 boolean_value: bool,
                 date_value: 'outputs.GoogleTypeDateResponse',
                 datetime_value: 'outputs.GoogleTypeDateTimeResponse',
                 float_value: float,
                 integer_value: int,
                 money_value: 'outputs.GoogleTypeMoneyResponse',
                 text: str):
        """
        Parsed and normalized entity value.
        :param 'GoogleTypePostalAddressResponse' address_value: Postal address. See also: https://github.com/googleapis/googleapis/blob/master/google/type/postal_address.proto
        :param bool boolean_value: Boolean value. Can be used for entities with binary values, or for checkboxes.
        :param 'GoogleTypeDateResponse' date_value: Date value. Includes year, month, day. See also: https://github.com/googleapis/googleapis/blob/master/google/type/date.proto
        :param 'GoogleTypeDateTimeResponse' datetime_value: DateTime value. Includes date, time, and timezone. See also: https://github.com/googleapis/googleapis/blob/master/google/type/datetime.proto
        :param float float_value: Float value.
        :param int integer_value: Integer value.
        :param 'GoogleTypeMoneyResponse' money_value: Money value. See also: https://github.com/googleapis/googleapis/blob/master/google/type/money.proto
        :param str text: Optional. An optional field to store a normalized string. For some entity types, one of respective `structured_value` fields may also be populated. Also not all the types of `structured_value` will be normalized. For example, some processors may not generate `float` or `integer` normalized text by default. Below are sample formats mapped to structured values. - Money/Currency type (`money_value`) is in the ISO 4217 text format. - Date type (`date_value`) is in the ISO 8601 text format. - Datetime type (`datetime_value`) is in the ISO 8601 text format.
        """
        pulumi.set(__self__, "address_value", address_value)
        pulumi.set(__self__, "boolean_value", boolean_value)
        pulumi.set(__self__, "date_value", date_value)
        pulumi.set(__self__, "datetime_value", datetime_value)
        pulumi.set(__self__, "float_value", float_value)
        pulumi.set(__self__, "integer_value", integer_value)
        pulumi.set(__self__, "money_value", money_value)
        pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter(name="addressValue")
    def address_value(self) -> 'outputs.GoogleTypePostalAddressResponse':
        """
        Postal address. See also: https://github.com/googleapis/googleapis/blob/master/google/type/postal_address.proto
        """
        return pulumi.get(self, "address_value")

    @property
    @pulumi.getter(name="booleanValue")
    def boolean_value(self) -> bool:
        """
        Boolean value. Can be used for entities with binary values, or for checkboxes.
        """
        return pulumi.get(self, "boolean_value")

    @property
    @pulumi.getter(name="dateValue")
    def date_value(self) -> 'outputs.GoogleTypeDateResponse':
        """
        Date value. Includes year, month, day. See also: https://github.com/googleapis/googleapis/blob/master/google/type/date.proto
        """
        return pulumi.get(self, "date_value")

    @property
    @pulumi.getter(name="datetimeValue")
    def datetime_value(self) -> 'outputs.GoogleTypeDateTimeResponse':
        """
        DateTime value. Includes date, time, and timezone. See also: https://github.com/googleapis/googleapis/blob/master/google/type/datetime.proto
        """
        return pulumi.get(self, "datetime_value")

    @property
    @pulumi.getter(name="floatValue")
    def float_value(self) -> float:
        """
        Float value.
        """
        return pulumi.get(self, "float_value")

    @property
    @pulumi.getter(name="integerValue")
    def integer_value(self) -> int:
        """
        Integer value.
        """
        return pulumi.get(self, "integer_value")

    @property
    @pulumi.getter(name="moneyValue")
    def money_value(self) -> 'outputs.GoogleTypeMoneyResponse':
        """
        Money value. See also: https://github.com/googleapis/googleapis/blob/master/google/type/money.proto
        """
        return pulumi.get(self, "money_value")

    @property
    @pulumi.getter
    def text(self) -> str:
        """
        Optional. An optional field to store a normalized string. For some entity types, one of respective `structured_value` fields may also be populated. Also not all the types of `structured_value` will be normalized. For example, some processors may not generate `float` or `integer` normalized text by default. Below are sample formats mapped to structured values. - Money/Currency type (`money_value`) is in the ISO 4217 text format. - Date type (`date_value`) is in the ISO 8601 text format. - Datetime type (`datetime_value`) is in the ISO 8601 text format.
        """
        return pulumi.get(self, "text")


@pulumi.output_type
class GoogleCloudDocumentaiV1DocumentEntityRelationResponse(dict):
    """
    Relationship between Entities.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectId":
            suggest = "object_id"
        elif key == "subjectId":
            suggest = "subject_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDocumentaiV1DocumentEntityRelationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDocumentaiV1DocumentEntityRelationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDocumentaiV1DocumentEntityRelationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_id: str,
                 relation: str,
                 subject_id: str):
        """
        Relationship between Entities.
        :param str object_id: Object entity id.
        :param str relation: Relationship description.
        :param str subject_id: Subject entity id.
        """
        pulumi.set(__self__, "object_id", object_id)
        pulumi.set(__self__, "relation", relation)
        pulumi.set(__self__, "subject_id", subject_id)

    @property
    @pulumi.getter(name="objectId")
    def object_id(self) -> str:
        """
        Object entity id.
        """
        return pulumi.get(self, "object_id")

    @property
    @pulumi.getter
    def relation(self) -> str:
        """
        Relationship description.
        """
        return pulumi.get(self, "relation")

    @property
    @pulumi.getter(name="subjectId")
    def subject_id(self) -> str:
        """
        Subject entity id.
        """
        return pulumi.get(self, "subject_id")


@pulumi.output_type
class GoogleCloudDocumentaiV1DocumentEntityResponse(dict):
    """
    An entity that could be a phrase in the text or a property that belongs to the document. It is a known entity type, such as a person, an organization, or location.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mentionId":
            suggest = "mention_id"
        elif key == "mentionText":
            suggest = "mention_text"
        elif key == "normalizedValue":
            suggest = "normalized_value"
        elif key == "pageAnchor":
            suggest = "page_anchor"
        elif key == "textAnchor":
            suggest = "text_anchor"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDocumentaiV1DocumentEntityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDocumentaiV1DocumentEntityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDocumentaiV1DocumentEntityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 confidence: float,
                 mention_id: str,
                 mention_text: str,
                 normalized_value: 'outputs.GoogleCloudDocumentaiV1DocumentEntityNormalizedValueResponse',
                 page_anchor: 'outputs.GoogleCloudDocumentaiV1DocumentPageAnchorResponse',
                 properties: Sequence['outputs.GoogleCloudDocumentaiV1DocumentEntityResponse'],
                 provenance: 'outputs.GoogleCloudDocumentaiV1DocumentProvenanceResponse',
                 redacted: bool,
                 text_anchor: 'outputs.GoogleCloudDocumentaiV1DocumentTextAnchorResponse',
                 type: str):
        """
        An entity that could be a phrase in the text or a property that belongs to the document. It is a known entity type, such as a person, an organization, or location.
        :param float confidence: Optional. Confidence of detected Schema entity. Range `[0, 1]`.
        :param str mention_id: Optional. Deprecated. Use `id` field instead.
        :param str mention_text: Optional. Text value of the entity e.g. `1600 Amphitheatre Pkwy`.
        :param 'GoogleCloudDocumentaiV1DocumentEntityNormalizedValueResponse' normalized_value: Optional. Normalized entity value. Absent if the extracted value could not be converted or the type (e.g. address) is not supported for certain parsers. This field is also only populated for certain supported document types.
        :param 'GoogleCloudDocumentaiV1DocumentPageAnchorResponse' page_anchor: Optional. Represents the provenance of this entity wrt. the location on the page where it was found.
        :param Sequence['GoogleCloudDocumentaiV1DocumentEntityResponse'] properties: Optional. Entities can be nested to form a hierarchical data structure representing the content in the document.
        :param 'GoogleCloudDocumentaiV1DocumentProvenanceResponse' provenance: Optional. The history of this annotation.
        :param bool redacted: Optional. Whether the entity will be redacted for de-identification purposes.
        :param 'GoogleCloudDocumentaiV1DocumentTextAnchorResponse' text_anchor: Optional. Provenance of the entity. Text anchor indexing into the Document.text.
        :param str type: Entity type from a schema e.g. `Address`.
        """
        pulumi.set(__self__, "confidence", confidence)
        pulumi.set(__self__, "mention_id", mention_id)
        pulumi.set(__self__, "mention_text", mention_text)
        pulumi.set(__self__, "normalized_value", normalized_value)
        pulumi.set(__self__, "page_anchor", page_anchor)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "provenance", provenance)
        pulumi.set(__self__, "redacted", redacted)
        pulumi.set(__self__, "text_anchor", text_anchor)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def confidence(self) -> float:
        """
        Optional. Confidence of detected Schema entity. Range `[0, 1]`.
        """
        return pulumi.get(self, "confidence")

    @property
    @pulumi.getter(name="mentionId")
    def mention_id(self) -> str:
        """
        Optional. Deprecated. Use `id` field instead.
        """
        return pulumi.get(self, "mention_id")

    @property
    @pulumi.getter(name="mentionText")
    def mention_text(self) -> str:
        """
        Optional. Text value of the entity e.g. `1600 Amphitheatre Pkwy`.
        """
        return pulumi.get(self, "mention_text")

    @property
    @pulumi.getter(name="normalizedValue")
    def normalized_value(self) -> 'outputs.GoogleCloudDocumentaiV1DocumentEntityNormalizedValueResponse':
        """
        Optional. Normalized entity value. Absent if the extracted value could not be converted or the type (e.g. address) is not supported for certain parsers. This field is also only populated for certain supported document types.
        """
        return pulumi.get(self, "normalized_value")

    @property
    @pulumi.getter(name="pageAnchor")
    def page_anchor(self) -> 'outputs.GoogleCloudDocumentaiV1DocumentPageAnchorResponse':
        """
        Optional. Represents the provenance of this entity wrt. the location on the page where it was found.
        """
        return pulumi.get(self, "page_anchor")

    @property
    @pulumi.getter
    def properties(self) -> Sequence['outputs.GoogleCloudDocumentaiV1DocumentEntityResponse']:
        """
        Optional. Entities can be nested to form a hierarchical data structure representing the content in the document.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def provenance(self) -> 'outputs.GoogleCloudDocumentaiV1DocumentProvenanceResponse':
        """
        Optional. The history of this annotation.
        """
        return pulumi.get(self, "provenance")

    @property
    @pulumi.getter
    def redacted(self) -> bool:
        """
        Optional. Whether the entity will be redacted for de-identification purposes.
        """
        return pulumi.get(self, "redacted")

    @property
    @pulumi.getter(name="textAnchor")
    def text_anchor(self) -> 'outputs.GoogleCloudDocumentaiV1DocumentTextAnchorResponse':
        """
        Optional. Provenance of the entity. Text anchor indexing into the Document.text.
        """
        return pulumi.get(self, "text_anchor")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Entity type from a schema e.g. `Address`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GoogleCloudDocumentaiV1DocumentPageAnchorPageRefResponse(dict):
    """
    Represents a weak reference to a page element within a document.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "boundingPoly":
            suggest = "bounding_poly"
        elif key == "layoutId":
            suggest = "layout_id"
        elif key == "layoutType":
            suggest = "layout_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDocumentaiV1DocumentPageAnchorPageRefResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDocumentaiV1DocumentPageAnchorPageRefResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDocumentaiV1DocumentPageAnchorPageRefResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bounding_poly: 'outputs.GoogleCloudDocumentaiV1BoundingPolyResponse',
                 confidence: float,
                 layout_id: str,
                 layout_type: str,
                 page: str):
        """
        Represents a weak reference to a page element within a document.
        :param 'GoogleCloudDocumentaiV1BoundingPolyResponse' bounding_poly: Optional. Identifies the bounding polygon of a layout element on the page.
        :param float confidence: Optional. Confidence of detected page element, if applicable. Range `[0, 1]`.
        :param str layout_id: Optional. Deprecated. Use PageRef.bounding_poly instead.
        :param str layout_type: Optional. The type of the layout element that is being referenced if any.
        :param str page: Index into the Document.pages element, for example using `Document.pages` to locate the related page element. This field is skipped when its value is the default `0`. See https://developers.google.com/protocol-buffers/docs/proto3#json.
        """
        pulumi.set(__self__, "bounding_poly", bounding_poly)
        pulumi.set(__self__, "confidence", confidence)
        pulumi.set(__self__, "layout_id", layout_id)
        pulumi.set(__self__, "layout_type", layout_type)
        pulumi.set(__self__, "page", page)

    @property
    @pulumi.getter(name="boundingPoly")
    def bounding_poly(self) -> 'outputs.GoogleCloudDocumentaiV1BoundingPolyResponse':
        """
        Optional. Identifies the bounding polygon of a layout element on the page.
        """
        return pulumi.get(self, "bounding_poly")

    @property
    @pulumi.getter
    def confidence(self) -> float:
        """
        Optional. Confidence of detected page element, if applicable. Range `[0, 1]`.
        """
        return pulumi.get(self, "confidence")

    @property
    @pulumi.getter(name="layoutId")
    def layout_id(self) -> str:
        """
        Optional. Deprecated. Use PageRef.bounding_poly instead.
        """
        return pulumi.get(self, "layout_id")

    @property
    @pulumi.getter(name="layoutType")
    def layout_type(self) -> str:
        """
        Optional. The type of the layout element that is being referenced if any.
        """
        return pulumi.get(self, "layout_type")

    @property
    @pulumi.getter
    def page(self) -> str:
        """
        Index into the Document.pages element, for example using `Document.pages` to locate the related page element. This field is skipped when its value is the default `0`. See https://developers.google.com/protocol-buffers/docs/proto3#json.
        """
        return pulumi.get(self, "page")


@pulumi.output_type
class GoogleCloudDocumentaiV1DocumentPageAnchorResponse(dict):
    """
    Referencing the visual context of the entity in the Document.pages. Page anchors can be cross-page, consist of multiple bounding polygons and optionally reference specific layout element types.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pageRefs":
            suggest = "page_refs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDocumentaiV1DocumentPageAnchorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDocumentaiV1DocumentPageAnchorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDocumentaiV1DocumentPageAnchorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 page_refs: Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageAnchorPageRefResponse']):
        """
        Referencing the visual context of the entity in the Document.pages. Page anchors can be cross-page, consist of multiple bounding polygons and optionally reference specific layout element types.
        :param Sequence['GoogleCloudDocumentaiV1DocumentPageAnchorPageRefResponse'] page_refs: One or more references to visual page elements
        """
        pulumi.set(__self__, "page_refs", page_refs)

    @property
    @pulumi.getter(name="pageRefs")
    def page_refs(self) -> Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageAnchorPageRefResponse']:
        """
        One or more references to visual page elements
        """
        return pulumi.get(self, "page_refs")


@pulumi.output_type
class GoogleCloudDocumentaiV1DocumentPageBlockResponse(dict):
    """
    A block has a set of lines (collected into paragraphs) that have a common line-spacing and orientation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "detectedLanguages":
            suggest = "detected_languages"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDocumentaiV1DocumentPageBlockResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDocumentaiV1DocumentPageBlockResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDocumentaiV1DocumentPageBlockResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 detected_languages: Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageDetectedLanguageResponse'],
                 layout: 'outputs.GoogleCloudDocumentaiV1DocumentPageLayoutResponse',
                 provenance: 'outputs.GoogleCloudDocumentaiV1DocumentProvenanceResponse'):
        """
        A block has a set of lines (collected into paragraphs) that have a common line-spacing and orientation.
        :param Sequence['GoogleCloudDocumentaiV1DocumentPageDetectedLanguageResponse'] detected_languages: A list of detected languages together with confidence.
        :param 'GoogleCloudDocumentaiV1DocumentPageLayoutResponse' layout: Layout for Block.
        :param 'GoogleCloudDocumentaiV1DocumentProvenanceResponse' provenance: The history of this annotation.
        """
        pulumi.set(__self__, "detected_languages", detected_languages)
        pulumi.set(__self__, "layout", layout)
        pulumi.set(__self__, "provenance", provenance)

    @property
    @pulumi.getter(name="detectedLanguages")
    def detected_languages(self) -> Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageDetectedLanguageResponse']:
        """
        A list of detected languages together with confidence.
        """
        return pulumi.get(self, "detected_languages")

    @property
    @pulumi.getter
    def layout(self) -> 'outputs.GoogleCloudDocumentaiV1DocumentPageLayoutResponse':
        """
        Layout for Block.
        """
        return pulumi.get(self, "layout")

    @property
    @pulumi.getter
    def provenance(self) -> 'outputs.GoogleCloudDocumentaiV1DocumentProvenanceResponse':
        """
        The history of this annotation.
        """
        return pulumi.get(self, "provenance")


@pulumi.output_type
class GoogleCloudDocumentaiV1DocumentPageDetectedBarcodeResponse(dict):
    """
    A detected barcode.
    """
    def __init__(__self__, *,
                 barcode: 'outputs.GoogleCloudDocumentaiV1BarcodeResponse',
                 layout: 'outputs.GoogleCloudDocumentaiV1DocumentPageLayoutResponse'):
        """
        A detected barcode.
        :param 'GoogleCloudDocumentaiV1BarcodeResponse' barcode: Detailed barcode information of the DetectedBarcode.
        :param 'GoogleCloudDocumentaiV1DocumentPageLayoutResponse' layout: Layout for DetectedBarcode.
        """
        pulumi.set(__self__, "barcode", barcode)
        pulumi.set(__self__, "layout", layout)

    @property
    @pulumi.getter
    def barcode(self) -> 'outputs.GoogleCloudDocumentaiV1BarcodeResponse':
        """
        Detailed barcode information of the DetectedBarcode.
        """
        return pulumi.get(self, "barcode")

    @property
    @pulumi.getter
    def layout(self) -> 'outputs.GoogleCloudDocumentaiV1DocumentPageLayoutResponse':
        """
        Layout for DetectedBarcode.
        """
        return pulumi.get(self, "layout")


@pulumi.output_type
class GoogleCloudDocumentaiV1DocumentPageDetectedLanguageResponse(dict):
    """
    Detected language for a structural component.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "languageCode":
            suggest = "language_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDocumentaiV1DocumentPageDetectedLanguageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDocumentaiV1DocumentPageDetectedLanguageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDocumentaiV1DocumentPageDetectedLanguageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 confidence: float,
                 language_code: str):
        """
        Detected language for a structural component.
        :param float confidence: Confidence of detected language. Range `[0, 1]`.
        :param str language_code: The BCP-47 language code, such as `en-US` or `sr-Latn`. For more information, see https://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
        """
        pulumi.set(__self__, "confidence", confidence)
        pulumi.set(__self__, "language_code", language_code)

    @property
    @pulumi.getter
    def confidence(self) -> float:
        """
        Confidence of detected language. Range `[0, 1]`.
        """
        return pulumi.get(self, "confidence")

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> str:
        """
        The BCP-47 language code, such as `en-US` or `sr-Latn`. For more information, see https://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
        """
        return pulumi.get(self, "language_code")


@pulumi.output_type
class GoogleCloudDocumentaiV1DocumentPageDimensionResponse(dict):
    """
    Dimension for the page.
    """
    def __init__(__self__, *,
                 height: float,
                 unit: str,
                 width: float):
        """
        Dimension for the page.
        :param float height: Page height.
        :param str unit: Dimension unit.
        :param float width: Page width.
        """
        pulumi.set(__self__, "height", height)
        pulumi.set(__self__, "unit", unit)
        pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def height(self) -> float:
        """
        Page height.
        """
        return pulumi.get(self, "height")

    @property
    @pulumi.getter
    def unit(self) -> str:
        """
        Dimension unit.
        """
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter
    def width(self) -> float:
        """
        Page width.
        """
        return pulumi.get(self, "width")


@pulumi.output_type
class GoogleCloudDocumentaiV1DocumentPageFormFieldResponse(dict):
    """
    A form field detected on the page.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "correctedKeyText":
            suggest = "corrected_key_text"
        elif key == "correctedValueText":
            suggest = "corrected_value_text"
        elif key == "fieldName":
            suggest = "field_name"
        elif key == "fieldValue":
            suggest = "field_value"
        elif key == "nameDetectedLanguages":
            suggest = "name_detected_languages"
        elif key == "valueDetectedLanguages":
            suggest = "value_detected_languages"
        elif key == "valueType":
            suggest = "value_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDocumentaiV1DocumentPageFormFieldResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDocumentaiV1DocumentPageFormFieldResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDocumentaiV1DocumentPageFormFieldResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 corrected_key_text: str,
                 corrected_value_text: str,
                 field_name: 'outputs.GoogleCloudDocumentaiV1DocumentPageLayoutResponse',
                 field_value: 'outputs.GoogleCloudDocumentaiV1DocumentPageLayoutResponse',
                 name_detected_languages: Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageDetectedLanguageResponse'],
                 provenance: 'outputs.GoogleCloudDocumentaiV1DocumentProvenanceResponse',
                 value_detected_languages: Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageDetectedLanguageResponse'],
                 value_type: str):
        """
        A form field detected on the page.
        :param str corrected_key_text: Created for Labeling UI to export key text. If corrections were made to the text identified by the `field_name.text_anchor`, this field will contain the correction.
        :param str corrected_value_text: Created for Labeling UI to export value text. If corrections were made to the text identified by the `field_value.text_anchor`, this field will contain the correction.
        :param 'GoogleCloudDocumentaiV1DocumentPageLayoutResponse' field_name: Layout for the FormField name. e.g. `Address`, `Email`, `Grand total`, `Phone number`, etc.
        :param 'GoogleCloudDocumentaiV1DocumentPageLayoutResponse' field_value: Layout for the FormField value.
        :param Sequence['GoogleCloudDocumentaiV1DocumentPageDetectedLanguageResponse'] name_detected_languages: A list of detected languages for name together with confidence.
        :param 'GoogleCloudDocumentaiV1DocumentProvenanceResponse' provenance: The history of this annotation.
        :param Sequence['GoogleCloudDocumentaiV1DocumentPageDetectedLanguageResponse'] value_detected_languages: A list of detected languages for value together with confidence.
        :param str value_type: If the value is non-textual, this field represents the type. Current valid values are: - blank (this indicates the `field_value` is normal text) - `unfilled_checkbox` - `filled_checkbox`
        """
        pulumi.set(__self__, "corrected_key_text", corrected_key_text)
        pulumi.set(__self__, "corrected_value_text", corrected_value_text)
        pulumi.set(__self__, "field_name", field_name)
        pulumi.set(__self__, "field_value", field_value)
        pulumi.set(__self__, "name_detected_languages", name_detected_languages)
        pulumi.set(__self__, "provenance", provenance)
        pulumi.set(__self__, "value_detected_languages", value_detected_languages)
        pulumi.set(__self__, "value_type", value_type)

    @property
    @pulumi.getter(name="correctedKeyText")
    def corrected_key_text(self) -> str:
        """
        Created for Labeling UI to export key text. If corrections were made to the text identified by the `field_name.text_anchor`, this field will contain the correction.
        """
        return pulumi.get(self, "corrected_key_text")

    @property
    @pulumi.getter(name="correctedValueText")
    def corrected_value_text(self) -> str:
        """
        Created for Labeling UI to export value text. If corrections were made to the text identified by the `field_value.text_anchor`, this field will contain the correction.
        """
        return pulumi.get(self, "corrected_value_text")

    @property
    @pulumi.getter(name="fieldName")
    def field_name(self) -> 'outputs.GoogleCloudDocumentaiV1DocumentPageLayoutResponse':
        """
        Layout for the FormField name. e.g. `Address`, `Email`, `Grand total`, `Phone number`, etc.
        """
        return pulumi.get(self, "field_name")

    @property
    @pulumi.getter(name="fieldValue")
    def field_value(self) -> 'outputs.GoogleCloudDocumentaiV1DocumentPageLayoutResponse':
        """
        Layout for the FormField value.
        """
        return pulumi.get(self, "field_value")

    @property
    @pulumi.getter(name="nameDetectedLanguages")
    def name_detected_languages(self) -> Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageDetectedLanguageResponse']:
        """
        A list of detected languages for name together with confidence.
        """
        return pulumi.get(self, "name_detected_languages")

    @property
    @pulumi.getter
    def provenance(self) -> 'outputs.GoogleCloudDocumentaiV1DocumentProvenanceResponse':
        """
        The history of this annotation.
        """
        return pulumi.get(self, "provenance")

    @property
    @pulumi.getter(name="valueDetectedLanguages")
    def value_detected_languages(self) -> Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageDetectedLanguageResponse']:
        """
        A list of detected languages for value together with confidence.
        """
        return pulumi.get(self, "value_detected_languages")

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> str:
        """
        If the value is non-textual, this field represents the type. Current valid values are: - blank (this indicates the `field_value` is normal text) - `unfilled_checkbox` - `filled_checkbox`
        """
        return pulumi.get(self, "value_type")


@pulumi.output_type
class GoogleCloudDocumentaiV1DocumentPageImageQualityScoresDetectedDefectResponse(dict):
    """
    Image Quality Defects
    """
    def __init__(__self__, *,
                 confidence: float,
                 type: str):
        """
        Image Quality Defects
        :param float confidence: Confidence of detected defect. Range `[0, 1]` where 1 indicates strong confidence of that the defect exists.
        :param str type: Name of the defect type. Supported values are: - `quality/defect_blurry` - `quality/defect_noisy` - `quality/defect_dark` - `quality/defect_faint` - `quality/defect_text_too_small` - `quality/defect_document_cutoff` - `quality/defect_text_cutoff` - `quality/defect_glare`
        """
        pulumi.set(__self__, "confidence", confidence)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def confidence(self) -> float:
        """
        Confidence of detected defect. Range `[0, 1]` where 1 indicates strong confidence of that the defect exists.
        """
        return pulumi.get(self, "confidence")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Name of the defect type. Supported values are: - `quality/defect_blurry` - `quality/defect_noisy` - `quality/defect_dark` - `quality/defect_faint` - `quality/defect_text_too_small` - `quality/defect_document_cutoff` - `quality/defect_text_cutoff` - `quality/defect_glare`
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GoogleCloudDocumentaiV1DocumentPageImageQualityScoresResponse(dict):
    """
    Image Quality Scores for the page image
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "detectedDefects":
            suggest = "detected_defects"
        elif key == "qualityScore":
            suggest = "quality_score"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDocumentaiV1DocumentPageImageQualityScoresResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDocumentaiV1DocumentPageImageQualityScoresResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDocumentaiV1DocumentPageImageQualityScoresResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 detected_defects: Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageImageQualityScoresDetectedDefectResponse'],
                 quality_score: float):
        """
        Image Quality Scores for the page image
        :param Sequence['GoogleCloudDocumentaiV1DocumentPageImageQualityScoresDetectedDefectResponse'] detected_defects: A list of detected defects.
        :param float quality_score: The overall quality score. Range `[0, 1]` where 1 is perfect quality.
        """
        pulumi.set(__self__, "detected_defects", detected_defects)
        pulumi.set(__self__, "quality_score", quality_score)

    @property
    @pulumi.getter(name="detectedDefects")
    def detected_defects(self) -> Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageImageQualityScoresDetectedDefectResponse']:
        """
        A list of detected defects.
        """
        return pulumi.get(self, "detected_defects")

    @property
    @pulumi.getter(name="qualityScore")
    def quality_score(self) -> float:
        """
        The overall quality score. Range `[0, 1]` where 1 is perfect quality.
        """
        return pulumi.get(self, "quality_score")


@pulumi.output_type
class GoogleCloudDocumentaiV1DocumentPageImageResponse(dict):
    """
    Rendered image contents for this page.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mimeType":
            suggest = "mime_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDocumentaiV1DocumentPageImageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDocumentaiV1DocumentPageImageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDocumentaiV1DocumentPageImageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content: str,
                 height: int,
                 mime_type: str,
                 width: int):
        """
        Rendered image contents for this page.
        :param str content: Raw byte content of the image.
        :param int height: Height of the image in pixels.
        :param str mime_type: Encoding mime type for the image.
        :param int width: Width of the image in pixels.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "height", height)
        pulumi.set(__self__, "mime_type", mime_type)
        pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def content(self) -> str:
        """
        Raw byte content of the image.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def height(self) -> int:
        """
        Height of the image in pixels.
        """
        return pulumi.get(self, "height")

    @property
    @pulumi.getter(name="mimeType")
    def mime_type(self) -> str:
        """
        Encoding mime type for the image.
        """
        return pulumi.get(self, "mime_type")

    @property
    @pulumi.getter
    def width(self) -> int:
        """
        Width of the image in pixels.
        """
        return pulumi.get(self, "width")


@pulumi.output_type
class GoogleCloudDocumentaiV1DocumentPageLayoutResponse(dict):
    """
    Visual element describing a layout unit on a page.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "boundingPoly":
            suggest = "bounding_poly"
        elif key == "textAnchor":
            suggest = "text_anchor"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDocumentaiV1DocumentPageLayoutResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDocumentaiV1DocumentPageLayoutResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDocumentaiV1DocumentPageLayoutResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bounding_poly: 'outputs.GoogleCloudDocumentaiV1BoundingPolyResponse',
                 confidence: float,
                 orientation: str,
                 text_anchor: 'outputs.GoogleCloudDocumentaiV1DocumentTextAnchorResponse'):
        """
        Visual element describing a layout unit on a page.
        :param 'GoogleCloudDocumentaiV1BoundingPolyResponse' bounding_poly: The bounding polygon for the Layout.
        :param float confidence: Confidence of the current Layout within context of the object this layout is for. e.g. confidence can be for a single token, a table, a visual element, etc. depending on context. Range `[0, 1]`.
        :param str orientation: Detected orientation for the Layout.
        :param 'GoogleCloudDocumentaiV1DocumentTextAnchorResponse' text_anchor: Text anchor indexing into the Document.text.
        """
        pulumi.set(__self__, "bounding_poly", bounding_poly)
        pulumi.set(__self__, "confidence", confidence)
        pulumi.set(__self__, "orientation", orientation)
        pulumi.set(__self__, "text_anchor", text_anchor)

    @property
    @pulumi.getter(name="boundingPoly")
    def bounding_poly(self) -> 'outputs.GoogleCloudDocumentaiV1BoundingPolyResponse':
        """
        The bounding polygon for the Layout.
        """
        return pulumi.get(self, "bounding_poly")

    @property
    @pulumi.getter
    def confidence(self) -> float:
        """
        Confidence of the current Layout within context of the object this layout is for. e.g. confidence can be for a single token, a table, a visual element, etc. depending on context. Range `[0, 1]`.
        """
        return pulumi.get(self, "confidence")

    @property
    @pulumi.getter
    def orientation(self) -> str:
        """
        Detected orientation for the Layout.
        """
        return pulumi.get(self, "orientation")

    @property
    @pulumi.getter(name="textAnchor")
    def text_anchor(self) -> 'outputs.GoogleCloudDocumentaiV1DocumentTextAnchorResponse':
        """
        Text anchor indexing into the Document.text.
        """
        return pulumi.get(self, "text_anchor")


@pulumi.output_type
class GoogleCloudDocumentaiV1DocumentPageLineResponse(dict):
    """
    A collection of tokens that a human would perceive as a line. Does not cross column boundaries, can be horizontal, vertical, etc.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "detectedLanguages":
            suggest = "detected_languages"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDocumentaiV1DocumentPageLineResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDocumentaiV1DocumentPageLineResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDocumentaiV1DocumentPageLineResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 detected_languages: Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageDetectedLanguageResponse'],
                 layout: 'outputs.GoogleCloudDocumentaiV1DocumentPageLayoutResponse',
                 provenance: 'outputs.GoogleCloudDocumentaiV1DocumentProvenanceResponse'):
        """
        A collection of tokens that a human would perceive as a line. Does not cross column boundaries, can be horizontal, vertical, etc.
        :param Sequence['GoogleCloudDocumentaiV1DocumentPageDetectedLanguageResponse'] detected_languages: A list of detected languages together with confidence.
        :param 'GoogleCloudDocumentaiV1DocumentPageLayoutResponse' layout: Layout for Line.
        :param 'GoogleCloudDocumentaiV1DocumentProvenanceResponse' provenance: The history of this annotation.
        """
        pulumi.set(__self__, "detected_languages", detected_languages)
        pulumi.set(__self__, "layout", layout)
        pulumi.set(__self__, "provenance", provenance)

    @property
    @pulumi.getter(name="detectedLanguages")
    def detected_languages(self) -> Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageDetectedLanguageResponse']:
        """
        A list of detected languages together with confidence.
        """
        return pulumi.get(self, "detected_languages")

    @property
    @pulumi.getter
    def layout(self) -> 'outputs.GoogleCloudDocumentaiV1DocumentPageLayoutResponse':
        """
        Layout for Line.
        """
        return pulumi.get(self, "layout")

    @property
    @pulumi.getter
    def provenance(self) -> 'outputs.GoogleCloudDocumentaiV1DocumentProvenanceResponse':
        """
        The history of this annotation.
        """
        return pulumi.get(self, "provenance")


@pulumi.output_type
class GoogleCloudDocumentaiV1DocumentPageMatrixResponse(dict):
    """
    Representation for transformation matrix, intended to be compatible and used with OpenCV format for image manipulation.
    """
    def __init__(__self__, *,
                 cols: int,
                 data: str,
                 rows: int,
                 type: int):
        """
        Representation for transformation matrix, intended to be compatible and used with OpenCV format for image manipulation.
        :param int cols: Number of columns in the matrix.
        :param str data: The matrix data.
        :param int rows: Number of rows in the matrix.
        :param int type: This encodes information about what data type the matrix uses. For example, 0 (CV_8U) is an unsigned 8-bit image. For the full list of OpenCV primitive data types, please refer to https://docs.opencv.org/4.3.0/d1/d1b/group__core__hal__interface.html
        """
        pulumi.set(__self__, "cols", cols)
        pulumi.set(__self__, "data", data)
        pulumi.set(__self__, "rows", rows)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def cols(self) -> int:
        """
        Number of columns in the matrix.
        """
        return pulumi.get(self, "cols")

    @property
    @pulumi.getter
    def data(self) -> str:
        """
        The matrix data.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter
    def rows(self) -> int:
        """
        Number of rows in the matrix.
        """
        return pulumi.get(self, "rows")

    @property
    @pulumi.getter
    def type(self) -> int:
        """
        This encodes information about what data type the matrix uses. For example, 0 (CV_8U) is an unsigned 8-bit image. For the full list of OpenCV primitive data types, please refer to https://docs.opencv.org/4.3.0/d1/d1b/group__core__hal__interface.html
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GoogleCloudDocumentaiV1DocumentPageParagraphResponse(dict):
    """
    A collection of lines that a human would perceive as a paragraph.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "detectedLanguages":
            suggest = "detected_languages"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDocumentaiV1DocumentPageParagraphResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDocumentaiV1DocumentPageParagraphResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDocumentaiV1DocumentPageParagraphResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 detected_languages: Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageDetectedLanguageResponse'],
                 layout: 'outputs.GoogleCloudDocumentaiV1DocumentPageLayoutResponse',
                 provenance: 'outputs.GoogleCloudDocumentaiV1DocumentProvenanceResponse'):
        """
        A collection of lines that a human would perceive as a paragraph.
        :param Sequence['GoogleCloudDocumentaiV1DocumentPageDetectedLanguageResponse'] detected_languages: A list of detected languages together with confidence.
        :param 'GoogleCloudDocumentaiV1DocumentPageLayoutResponse' layout: Layout for Paragraph.
        :param 'GoogleCloudDocumentaiV1DocumentProvenanceResponse' provenance: The history of this annotation.
        """
        pulumi.set(__self__, "detected_languages", detected_languages)
        pulumi.set(__self__, "layout", layout)
        pulumi.set(__self__, "provenance", provenance)

    @property
    @pulumi.getter(name="detectedLanguages")
    def detected_languages(self) -> Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageDetectedLanguageResponse']:
        """
        A list of detected languages together with confidence.
        """
        return pulumi.get(self, "detected_languages")

    @property
    @pulumi.getter
    def layout(self) -> 'outputs.GoogleCloudDocumentaiV1DocumentPageLayoutResponse':
        """
        Layout for Paragraph.
        """
        return pulumi.get(self, "layout")

    @property
    @pulumi.getter
    def provenance(self) -> 'outputs.GoogleCloudDocumentaiV1DocumentProvenanceResponse':
        """
        The history of this annotation.
        """
        return pulumi.get(self, "provenance")


@pulumi.output_type
class GoogleCloudDocumentaiV1DocumentPageResponse(dict):
    """
    A page in a Document.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "detectedBarcodes":
            suggest = "detected_barcodes"
        elif key == "detectedLanguages":
            suggest = "detected_languages"
        elif key == "formFields":
            suggest = "form_fields"
        elif key == "imageQualityScores":
            suggest = "image_quality_scores"
        elif key == "pageNumber":
            suggest = "page_number"
        elif key == "visualElements":
            suggest = "visual_elements"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDocumentaiV1DocumentPageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDocumentaiV1DocumentPageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDocumentaiV1DocumentPageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 blocks: Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageBlockResponse'],
                 detected_barcodes: Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageDetectedBarcodeResponse'],
                 detected_languages: Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageDetectedLanguageResponse'],
                 dimension: 'outputs.GoogleCloudDocumentaiV1DocumentPageDimensionResponse',
                 form_fields: Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageFormFieldResponse'],
                 image: 'outputs.GoogleCloudDocumentaiV1DocumentPageImageResponse',
                 image_quality_scores: 'outputs.GoogleCloudDocumentaiV1DocumentPageImageQualityScoresResponse',
                 layout: 'outputs.GoogleCloudDocumentaiV1DocumentPageLayoutResponse',
                 lines: Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageLineResponse'],
                 page_number: int,
                 paragraphs: Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageParagraphResponse'],
                 provenance: 'outputs.GoogleCloudDocumentaiV1DocumentProvenanceResponse',
                 symbols: Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageSymbolResponse'],
                 tables: Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageTableResponse'],
                 tokens: Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageTokenResponse'],
                 transforms: Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageMatrixResponse'],
                 visual_elements: Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageVisualElementResponse']):
        """
        A page in a Document.
        :param Sequence['GoogleCloudDocumentaiV1DocumentPageBlockResponse'] blocks: A list of visually detected text blocks on the page. A block has a set of lines (collected into paragraphs) that have a common line-spacing and orientation.
        :param Sequence['GoogleCloudDocumentaiV1DocumentPageDetectedBarcodeResponse'] detected_barcodes: A list of detected barcodes.
        :param Sequence['GoogleCloudDocumentaiV1DocumentPageDetectedLanguageResponse'] detected_languages: A list of detected languages together with confidence.
        :param 'GoogleCloudDocumentaiV1DocumentPageDimensionResponse' dimension: Physical dimension of the page.
        :param Sequence['GoogleCloudDocumentaiV1DocumentPageFormFieldResponse'] form_fields: A list of visually detected form fields on the page.
        :param 'GoogleCloudDocumentaiV1DocumentPageImageResponse' image: Rendered image for this page. This image is preprocessed to remove any skew, rotation, and distortions such that the annotation bounding boxes can be upright and axis-aligned.
        :param 'GoogleCloudDocumentaiV1DocumentPageImageQualityScoresResponse' image_quality_scores: Image Quality Scores.
        :param 'GoogleCloudDocumentaiV1DocumentPageLayoutResponse' layout: Layout for the page.
        :param Sequence['GoogleCloudDocumentaiV1DocumentPageLineResponse'] lines: A list of visually detected text lines on the page. A collection of tokens that a human would perceive as a line.
        :param int page_number: 1-based index for current Page in a parent Document. Useful when a page is taken out of a Document for individual processing.
        :param Sequence['GoogleCloudDocumentaiV1DocumentPageParagraphResponse'] paragraphs: A list of visually detected text paragraphs on the page. A collection of lines that a human would perceive as a paragraph.
        :param 'GoogleCloudDocumentaiV1DocumentProvenanceResponse' provenance: The history of this page.
        :param Sequence['GoogleCloudDocumentaiV1DocumentPageSymbolResponse'] symbols: A list of visually detected symbols on the page.
        :param Sequence['GoogleCloudDocumentaiV1DocumentPageTableResponse'] tables: A list of visually detected tables on the page.
        :param Sequence['GoogleCloudDocumentaiV1DocumentPageTokenResponse'] tokens: A list of visually detected tokens on the page.
        :param Sequence['GoogleCloudDocumentaiV1DocumentPageMatrixResponse'] transforms: Transformation matrices that were applied to the original document image to produce Page.image.
        :param Sequence['GoogleCloudDocumentaiV1DocumentPageVisualElementResponse'] visual_elements: A list of detected non-text visual elements e.g. checkbox, signature etc. on the page.
        """
        pulumi.set(__self__, "blocks", blocks)
        pulumi.set(__self__, "detected_barcodes", detected_barcodes)
        pulumi.set(__self__, "detected_languages", detected_languages)
        pulumi.set(__self__, "dimension", dimension)
        pulumi.set(__self__, "form_fields", form_fields)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "image_quality_scores", image_quality_scores)
        pulumi.set(__self__, "layout", layout)
        pulumi.set(__self__, "lines", lines)
        pulumi.set(__self__, "page_number", page_number)
        pulumi.set(__self__, "paragraphs", paragraphs)
        pulumi.set(__self__, "provenance", provenance)
        pulumi.set(__self__, "symbols", symbols)
        pulumi.set(__self__, "tables", tables)
        pulumi.set(__self__, "tokens", tokens)
        pulumi.set(__self__, "transforms", transforms)
        pulumi.set(__self__, "visual_elements", visual_elements)

    @property
    @pulumi.getter
    def blocks(self) -> Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageBlockResponse']:
        """
        A list of visually detected text blocks on the page. A block has a set of lines (collected into paragraphs) that have a common line-spacing and orientation.
        """
        return pulumi.get(self, "blocks")

    @property
    @pulumi.getter(name="detectedBarcodes")
    def detected_barcodes(self) -> Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageDetectedBarcodeResponse']:
        """
        A list of detected barcodes.
        """
        return pulumi.get(self, "detected_barcodes")

    @property
    @pulumi.getter(name="detectedLanguages")
    def detected_languages(self) -> Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageDetectedLanguageResponse']:
        """
        A list of detected languages together with confidence.
        """
        return pulumi.get(self, "detected_languages")

    @property
    @pulumi.getter
    def dimension(self) -> 'outputs.GoogleCloudDocumentaiV1DocumentPageDimensionResponse':
        """
        Physical dimension of the page.
        """
        return pulumi.get(self, "dimension")

    @property
    @pulumi.getter(name="formFields")
    def form_fields(self) -> Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageFormFieldResponse']:
        """
        A list of visually detected form fields on the page.
        """
        return pulumi.get(self, "form_fields")

    @property
    @pulumi.getter
    def image(self) -> 'outputs.GoogleCloudDocumentaiV1DocumentPageImageResponse':
        """
        Rendered image for this page. This image is preprocessed to remove any skew, rotation, and distortions such that the annotation bounding boxes can be upright and axis-aligned.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="imageQualityScores")
    def image_quality_scores(self) -> 'outputs.GoogleCloudDocumentaiV1DocumentPageImageQualityScoresResponse':
        """
        Image Quality Scores.
        """
        return pulumi.get(self, "image_quality_scores")

    @property
    @pulumi.getter
    def layout(self) -> 'outputs.GoogleCloudDocumentaiV1DocumentPageLayoutResponse':
        """
        Layout for the page.
        """
        return pulumi.get(self, "layout")

    @property
    @pulumi.getter
    def lines(self) -> Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageLineResponse']:
        """
        A list of visually detected text lines on the page. A collection of tokens that a human would perceive as a line.
        """
        return pulumi.get(self, "lines")

    @property
    @pulumi.getter(name="pageNumber")
    def page_number(self) -> int:
        """
        1-based index for current Page in a parent Document. Useful when a page is taken out of a Document for individual processing.
        """
        return pulumi.get(self, "page_number")

    @property
    @pulumi.getter
    def paragraphs(self) -> Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageParagraphResponse']:
        """
        A list of visually detected text paragraphs on the page. A collection of lines that a human would perceive as a paragraph.
        """
        return pulumi.get(self, "paragraphs")

    @property
    @pulumi.getter
    def provenance(self) -> 'outputs.GoogleCloudDocumentaiV1DocumentProvenanceResponse':
        """
        The history of this page.
        """
        return pulumi.get(self, "provenance")

    @property
    @pulumi.getter
    def symbols(self) -> Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageSymbolResponse']:
        """
        A list of visually detected symbols on the page.
        """
        return pulumi.get(self, "symbols")

    @property
    @pulumi.getter
    def tables(self) -> Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageTableResponse']:
        """
        A list of visually detected tables on the page.
        """
        return pulumi.get(self, "tables")

    @property
    @pulumi.getter
    def tokens(self) -> Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageTokenResponse']:
        """
        A list of visually detected tokens on the page.
        """
        return pulumi.get(self, "tokens")

    @property
    @pulumi.getter
    def transforms(self) -> Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageMatrixResponse']:
        """
        Transformation matrices that were applied to the original document image to produce Page.image.
        """
        return pulumi.get(self, "transforms")

    @property
    @pulumi.getter(name="visualElements")
    def visual_elements(self) -> Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageVisualElementResponse']:
        """
        A list of detected non-text visual elements e.g. checkbox, signature etc. on the page.
        """
        return pulumi.get(self, "visual_elements")


@pulumi.output_type
class GoogleCloudDocumentaiV1DocumentPageSymbolResponse(dict):
    """
    A detected symbol.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "detectedLanguages":
            suggest = "detected_languages"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDocumentaiV1DocumentPageSymbolResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDocumentaiV1DocumentPageSymbolResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDocumentaiV1DocumentPageSymbolResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 detected_languages: Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageDetectedLanguageResponse'],
                 layout: 'outputs.GoogleCloudDocumentaiV1DocumentPageLayoutResponse'):
        """
        A detected symbol.
        :param Sequence['GoogleCloudDocumentaiV1DocumentPageDetectedLanguageResponse'] detected_languages: A list of detected languages together with confidence.
        :param 'GoogleCloudDocumentaiV1DocumentPageLayoutResponse' layout: Layout for Symbol.
        """
        pulumi.set(__self__, "detected_languages", detected_languages)
        pulumi.set(__self__, "layout", layout)

    @property
    @pulumi.getter(name="detectedLanguages")
    def detected_languages(self) -> Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageDetectedLanguageResponse']:
        """
        A list of detected languages together with confidence.
        """
        return pulumi.get(self, "detected_languages")

    @property
    @pulumi.getter
    def layout(self) -> 'outputs.GoogleCloudDocumentaiV1DocumentPageLayoutResponse':
        """
        Layout for Symbol.
        """
        return pulumi.get(self, "layout")


@pulumi.output_type
class GoogleCloudDocumentaiV1DocumentPageTableResponse(dict):
    """
    A table representation similar to HTML table structure.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bodyRows":
            suggest = "body_rows"
        elif key == "detectedLanguages":
            suggest = "detected_languages"
        elif key == "headerRows":
            suggest = "header_rows"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDocumentaiV1DocumentPageTableResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDocumentaiV1DocumentPageTableResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDocumentaiV1DocumentPageTableResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 body_rows: Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageTableTableRowResponse'],
                 detected_languages: Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageDetectedLanguageResponse'],
                 header_rows: Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageTableTableRowResponse'],
                 layout: 'outputs.GoogleCloudDocumentaiV1DocumentPageLayoutResponse',
                 provenance: 'outputs.GoogleCloudDocumentaiV1DocumentProvenanceResponse'):
        """
        A table representation similar to HTML table structure.
        :param Sequence['GoogleCloudDocumentaiV1DocumentPageTableTableRowResponse'] body_rows: Body rows of the table.
        :param Sequence['GoogleCloudDocumentaiV1DocumentPageDetectedLanguageResponse'] detected_languages: A list of detected languages together with confidence.
        :param Sequence['GoogleCloudDocumentaiV1DocumentPageTableTableRowResponse'] header_rows: Header rows of the table.
        :param 'GoogleCloudDocumentaiV1DocumentPageLayoutResponse' layout: Layout for Table.
        :param 'GoogleCloudDocumentaiV1DocumentProvenanceResponse' provenance: The history of this table.
        """
        pulumi.set(__self__, "body_rows", body_rows)
        pulumi.set(__self__, "detected_languages", detected_languages)
        pulumi.set(__self__, "header_rows", header_rows)
        pulumi.set(__self__, "layout", layout)
        pulumi.set(__self__, "provenance", provenance)

    @property
    @pulumi.getter(name="bodyRows")
    def body_rows(self) -> Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageTableTableRowResponse']:
        """
        Body rows of the table.
        """
        return pulumi.get(self, "body_rows")

    @property
    @pulumi.getter(name="detectedLanguages")
    def detected_languages(self) -> Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageDetectedLanguageResponse']:
        """
        A list of detected languages together with confidence.
        """
        return pulumi.get(self, "detected_languages")

    @property
    @pulumi.getter(name="headerRows")
    def header_rows(self) -> Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageTableTableRowResponse']:
        """
        Header rows of the table.
        """
        return pulumi.get(self, "header_rows")

    @property
    @pulumi.getter
    def layout(self) -> 'outputs.GoogleCloudDocumentaiV1DocumentPageLayoutResponse':
        """
        Layout for Table.
        """
        return pulumi.get(self, "layout")

    @property
    @pulumi.getter
    def provenance(self) -> 'outputs.GoogleCloudDocumentaiV1DocumentProvenanceResponse':
        """
        The history of this table.
        """
        return pulumi.get(self, "provenance")


@pulumi.output_type
class GoogleCloudDocumentaiV1DocumentPageTableTableCellResponse(dict):
    """
    A cell representation inside the table.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "colSpan":
            suggest = "col_span"
        elif key == "detectedLanguages":
            suggest = "detected_languages"
        elif key == "rowSpan":
            suggest = "row_span"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDocumentaiV1DocumentPageTableTableCellResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDocumentaiV1DocumentPageTableTableCellResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDocumentaiV1DocumentPageTableTableCellResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 col_span: int,
                 detected_languages: Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageDetectedLanguageResponse'],
                 layout: 'outputs.GoogleCloudDocumentaiV1DocumentPageLayoutResponse',
                 row_span: int):
        """
        A cell representation inside the table.
        :param int col_span: How many columns this cell spans.
        :param Sequence['GoogleCloudDocumentaiV1DocumentPageDetectedLanguageResponse'] detected_languages: A list of detected languages together with confidence.
        :param 'GoogleCloudDocumentaiV1DocumentPageLayoutResponse' layout: Layout for TableCell.
        :param int row_span: How many rows this cell spans.
        """
        pulumi.set(__self__, "col_span", col_span)
        pulumi.set(__self__, "detected_languages", detected_languages)
        pulumi.set(__self__, "layout", layout)
        pulumi.set(__self__, "row_span", row_span)

    @property
    @pulumi.getter(name="colSpan")
    def col_span(self) -> int:
        """
        How many columns this cell spans.
        """
        return pulumi.get(self, "col_span")

    @property
    @pulumi.getter(name="detectedLanguages")
    def detected_languages(self) -> Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageDetectedLanguageResponse']:
        """
        A list of detected languages together with confidence.
        """
        return pulumi.get(self, "detected_languages")

    @property
    @pulumi.getter
    def layout(self) -> 'outputs.GoogleCloudDocumentaiV1DocumentPageLayoutResponse':
        """
        Layout for TableCell.
        """
        return pulumi.get(self, "layout")

    @property
    @pulumi.getter(name="rowSpan")
    def row_span(self) -> int:
        """
        How many rows this cell spans.
        """
        return pulumi.get(self, "row_span")


@pulumi.output_type
class GoogleCloudDocumentaiV1DocumentPageTableTableRowResponse(dict):
    """
    A row of table cells.
    """
    def __init__(__self__, *,
                 cells: Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageTableTableCellResponse']):
        """
        A row of table cells.
        :param Sequence['GoogleCloudDocumentaiV1DocumentPageTableTableCellResponse'] cells: Cells that make up this row.
        """
        pulumi.set(__self__, "cells", cells)

    @property
    @pulumi.getter
    def cells(self) -> Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageTableTableCellResponse']:
        """
        Cells that make up this row.
        """
        return pulumi.get(self, "cells")


@pulumi.output_type
class GoogleCloudDocumentaiV1DocumentPageTokenDetectedBreakResponse(dict):
    """
    Detected break at the end of a Token.
    """
    def __init__(__self__, *,
                 type: str):
        """
        Detected break at the end of a Token.
        :param str type: Detected break type.
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Detected break type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GoogleCloudDocumentaiV1DocumentPageTokenResponse(dict):
    """
    A detected token.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "detectedBreak":
            suggest = "detected_break"
        elif key == "detectedLanguages":
            suggest = "detected_languages"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDocumentaiV1DocumentPageTokenResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDocumentaiV1DocumentPageTokenResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDocumentaiV1DocumentPageTokenResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 detected_break: 'outputs.GoogleCloudDocumentaiV1DocumentPageTokenDetectedBreakResponse',
                 detected_languages: Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageDetectedLanguageResponse'],
                 layout: 'outputs.GoogleCloudDocumentaiV1DocumentPageLayoutResponse',
                 provenance: 'outputs.GoogleCloudDocumentaiV1DocumentProvenanceResponse'):
        """
        A detected token.
        :param 'GoogleCloudDocumentaiV1DocumentPageTokenDetectedBreakResponse' detected_break: Detected break at the end of a Token.
        :param Sequence['GoogleCloudDocumentaiV1DocumentPageDetectedLanguageResponse'] detected_languages: A list of detected languages together with confidence.
        :param 'GoogleCloudDocumentaiV1DocumentPageLayoutResponse' layout: Layout for Token.
        :param 'GoogleCloudDocumentaiV1DocumentProvenanceResponse' provenance: The history of this annotation.
        """
        pulumi.set(__self__, "detected_break", detected_break)
        pulumi.set(__self__, "detected_languages", detected_languages)
        pulumi.set(__self__, "layout", layout)
        pulumi.set(__self__, "provenance", provenance)

    @property
    @pulumi.getter(name="detectedBreak")
    def detected_break(self) -> 'outputs.GoogleCloudDocumentaiV1DocumentPageTokenDetectedBreakResponse':
        """
        Detected break at the end of a Token.
        """
        return pulumi.get(self, "detected_break")

    @property
    @pulumi.getter(name="detectedLanguages")
    def detected_languages(self) -> Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageDetectedLanguageResponse']:
        """
        A list of detected languages together with confidence.
        """
        return pulumi.get(self, "detected_languages")

    @property
    @pulumi.getter
    def layout(self) -> 'outputs.GoogleCloudDocumentaiV1DocumentPageLayoutResponse':
        """
        Layout for Token.
        """
        return pulumi.get(self, "layout")

    @property
    @pulumi.getter
    def provenance(self) -> 'outputs.GoogleCloudDocumentaiV1DocumentProvenanceResponse':
        """
        The history of this annotation.
        """
        return pulumi.get(self, "provenance")


@pulumi.output_type
class GoogleCloudDocumentaiV1DocumentPageVisualElementResponse(dict):
    """
    Detected non-text visual elements e.g. checkbox, signature etc. on the page.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "detectedLanguages":
            suggest = "detected_languages"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDocumentaiV1DocumentPageVisualElementResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDocumentaiV1DocumentPageVisualElementResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDocumentaiV1DocumentPageVisualElementResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 detected_languages: Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageDetectedLanguageResponse'],
                 layout: 'outputs.GoogleCloudDocumentaiV1DocumentPageLayoutResponse',
                 type: str):
        """
        Detected non-text visual elements e.g. checkbox, signature etc. on the page.
        :param Sequence['GoogleCloudDocumentaiV1DocumentPageDetectedLanguageResponse'] detected_languages: A list of detected languages together with confidence.
        :param 'GoogleCloudDocumentaiV1DocumentPageLayoutResponse' layout: Layout for VisualElement.
        :param str type: Type of the VisualElement.
        """
        pulumi.set(__self__, "detected_languages", detected_languages)
        pulumi.set(__self__, "layout", layout)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="detectedLanguages")
    def detected_languages(self) -> Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageDetectedLanguageResponse']:
        """
        A list of detected languages together with confidence.
        """
        return pulumi.get(self, "detected_languages")

    @property
    @pulumi.getter
    def layout(self) -> 'outputs.GoogleCloudDocumentaiV1DocumentPageLayoutResponse':
        """
        Layout for VisualElement.
        """
        return pulumi.get(self, "layout")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the VisualElement.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GoogleCloudDocumentaiV1DocumentProvenanceParentResponse(dict):
    """
    The parent element the current element is based on. Used for referencing/aligning, removal and replacement operations.
    """
    def __init__(__self__, *,
                 index: int,
                 revision: int):
        """
        The parent element the current element is based on. Used for referencing/aligning, removal and replacement operations.
        :param int index: The index of the parent item in the corresponding item list (eg. list of entities, properties within entities, etc.) in the parent revision.
        :param int revision: The index of the index into current revision's parent_ids list.
        """
        pulumi.set(__self__, "index", index)
        pulumi.set(__self__, "revision", revision)

    @property
    @pulumi.getter
    def index(self) -> int:
        """
        The index of the parent item in the corresponding item list (eg. list of entities, properties within entities, etc.) in the parent revision.
        """
        return pulumi.get(self, "index")

    @property
    @pulumi.getter
    def revision(self) -> int:
        """
        The index of the index into current revision's parent_ids list.
        """
        return pulumi.get(self, "revision")


@pulumi.output_type
class GoogleCloudDocumentaiV1DocumentProvenanceResponse(dict):
    """
    Structure to identify provenance relationships between annotations in different revisions.
    """
    def __init__(__self__, *,
                 parents: Sequence['outputs.GoogleCloudDocumentaiV1DocumentProvenanceParentResponse'],
                 revision: int,
                 type: str):
        """
        Structure to identify provenance relationships between annotations in different revisions.
        :param Sequence['GoogleCloudDocumentaiV1DocumentProvenanceParentResponse'] parents: References to the original elements that are replaced.
        :param int revision: The index of the revision that produced this element.
        :param str type: The type of provenance operation.
        """
        pulumi.set(__self__, "parents", parents)
        pulumi.set(__self__, "revision", revision)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def parents(self) -> Sequence['outputs.GoogleCloudDocumentaiV1DocumentProvenanceParentResponse']:
        """
        References to the original elements that are replaced.
        """
        return pulumi.get(self, "parents")

    @property
    @pulumi.getter
    def revision(self) -> int:
        """
        The index of the revision that produced this element.
        """
        return pulumi.get(self, "revision")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of provenance operation.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GoogleCloudDocumentaiV1DocumentResponse(dict):
    """
    Document represents the canonical document resource in Document AI. It is an interchange format that provides insights into documents and allows for collaboration between users and Document AI to iterate and optimize for quality.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entityRelations":
            suggest = "entity_relations"
        elif key == "mimeType":
            suggest = "mime_type"
        elif key == "shardInfo":
            suggest = "shard_info"
        elif key == "textChanges":
            suggest = "text_changes"
        elif key == "textStyles":
            suggest = "text_styles"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDocumentaiV1DocumentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDocumentaiV1DocumentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDocumentaiV1DocumentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content: str,
                 entities: Sequence['outputs.GoogleCloudDocumentaiV1DocumentEntityResponse'],
                 entity_relations: Sequence['outputs.GoogleCloudDocumentaiV1DocumentEntityRelationResponse'],
                 error: 'outputs.GoogleRpcStatusResponse',
                 mime_type: str,
                 pages: Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageResponse'],
                 revisions: Sequence['outputs.GoogleCloudDocumentaiV1DocumentRevisionResponse'],
                 shard_info: 'outputs.GoogleCloudDocumentaiV1DocumentShardInfoResponse',
                 text: str,
                 text_changes: Sequence['outputs.GoogleCloudDocumentaiV1DocumentTextChangeResponse'],
                 text_styles: Sequence['outputs.GoogleCloudDocumentaiV1DocumentStyleResponse'],
                 uri: str):
        """
        Document represents the canonical document resource in Document AI. It is an interchange format that provides insights into documents and allows for collaboration between users and Document AI to iterate and optimize for quality.
        :param str content: Optional. Inline document content, represented as a stream of bytes. Note: As with all `bytes` fields, protobuffers use a pure binary representation, whereas JSON representations use base64.
        :param Sequence['GoogleCloudDocumentaiV1DocumentEntityResponse'] entities: A list of entities detected on Document.text. For document shards, entities in this list may cross shard boundaries.
        :param Sequence['GoogleCloudDocumentaiV1DocumentEntityRelationResponse'] entity_relations: Placeholder. Relationship among Document.entities.
        :param 'GoogleRpcStatusResponse' error: Any error that occurred while processing this document.
        :param str mime_type: An IANA published MIME type (also referred to as media type). For more information, see https://www.iana.org/assignments/media-types/media-types.xhtml.
        :param Sequence['GoogleCloudDocumentaiV1DocumentPageResponse'] pages: Visual page layout for the Document.
        :param Sequence['GoogleCloudDocumentaiV1DocumentRevisionResponse'] revisions: Placeholder. Revision history of this document.
        :param 'GoogleCloudDocumentaiV1DocumentShardInfoResponse' shard_info: Information about the sharding if this document is sharded part of a larger document. If the document is not sharded, this message is not specified.
        :param str text: Optional. UTF-8 encoded text in reading order from the document.
        :param Sequence['GoogleCloudDocumentaiV1DocumentTextChangeResponse'] text_changes: Placeholder. A list of text corrections made to Document.text. This is usually used for annotating corrections to OCR mistakes. Text changes for a given revision may not overlap with each other.
        :param Sequence['GoogleCloudDocumentaiV1DocumentStyleResponse'] text_styles: Styles for the Document.text.
        :param str uri: Optional. Currently supports Google Cloud Storage URI of the form `gs://bucket_name/object_name`. Object versioning is not supported. See [Google Cloud Storage Request URIs](https://cloud.google.com/storage/docs/reference-uris) for more info.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "entities", entities)
        pulumi.set(__self__, "entity_relations", entity_relations)
        pulumi.set(__self__, "error", error)
        pulumi.set(__self__, "mime_type", mime_type)
        pulumi.set(__self__, "pages", pages)
        pulumi.set(__self__, "revisions", revisions)
        pulumi.set(__self__, "shard_info", shard_info)
        pulumi.set(__self__, "text", text)
        pulumi.set(__self__, "text_changes", text_changes)
        pulumi.set(__self__, "text_styles", text_styles)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def content(self) -> str:
        """
        Optional. Inline document content, represented as a stream of bytes. Note: As with all `bytes` fields, protobuffers use a pure binary representation, whereas JSON representations use base64.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def entities(self) -> Sequence['outputs.GoogleCloudDocumentaiV1DocumentEntityResponse']:
        """
        A list of entities detected on Document.text. For document shards, entities in this list may cross shard boundaries.
        """
        return pulumi.get(self, "entities")

    @property
    @pulumi.getter(name="entityRelations")
    def entity_relations(self) -> Sequence['outputs.GoogleCloudDocumentaiV1DocumentEntityRelationResponse']:
        """
        Placeholder. Relationship among Document.entities.
        """
        return pulumi.get(self, "entity_relations")

    @property
    @pulumi.getter
    def error(self) -> 'outputs.GoogleRpcStatusResponse':
        """
        Any error that occurred while processing this document.
        """
        return pulumi.get(self, "error")

    @property
    @pulumi.getter(name="mimeType")
    def mime_type(self) -> str:
        """
        An IANA published MIME type (also referred to as media type). For more information, see https://www.iana.org/assignments/media-types/media-types.xhtml.
        """
        return pulumi.get(self, "mime_type")

    @property
    @pulumi.getter
    def pages(self) -> Sequence['outputs.GoogleCloudDocumentaiV1DocumentPageResponse']:
        """
        Visual page layout for the Document.
        """
        return pulumi.get(self, "pages")

    @property
    @pulumi.getter
    def revisions(self) -> Sequence['outputs.GoogleCloudDocumentaiV1DocumentRevisionResponse']:
        """
        Placeholder. Revision history of this document.
        """
        return pulumi.get(self, "revisions")

    @property
    @pulumi.getter(name="shardInfo")
    def shard_info(self) -> 'outputs.GoogleCloudDocumentaiV1DocumentShardInfoResponse':
        """
        Information about the sharding if this document is sharded part of a larger document. If the document is not sharded, this message is not specified.
        """
        return pulumi.get(self, "shard_info")

    @property
    @pulumi.getter
    def text(self) -> str:
        """
        Optional. UTF-8 encoded text in reading order from the document.
        """
        return pulumi.get(self, "text")

    @property
    @pulumi.getter(name="textChanges")
    def text_changes(self) -> Sequence['outputs.GoogleCloudDocumentaiV1DocumentTextChangeResponse']:
        """
        Placeholder. A list of text corrections made to Document.text. This is usually used for annotating corrections to OCR mistakes. Text changes for a given revision may not overlap with each other.
        """
        return pulumi.get(self, "text_changes")

    @property
    @pulumi.getter(name="textStyles")
    def text_styles(self) -> Sequence['outputs.GoogleCloudDocumentaiV1DocumentStyleResponse']:
        """
        Styles for the Document.text.
        """
        return pulumi.get(self, "text_styles")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        Optional. Currently supports Google Cloud Storage URI of the form `gs://bucket_name/object_name`. Object versioning is not supported. See [Google Cloud Storage Request URIs](https://cloud.google.com/storage/docs/reference-uris) for more info.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GoogleCloudDocumentaiV1DocumentRevisionHumanReviewResponse(dict):
    """
    Human Review information of the document.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "stateMessage":
            suggest = "state_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDocumentaiV1DocumentRevisionHumanReviewResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDocumentaiV1DocumentRevisionHumanReviewResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDocumentaiV1DocumentRevisionHumanReviewResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 state: str,
                 state_message: str):
        """
        Human Review information of the document.
        :param str state: Human review state. e.g. `requested`, `succeeded`, `rejected`.
        :param str state_message: A message providing more details about the current state of processing. For example, the rejection reason when the state is `rejected`.
        """
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "state_message", state_message)

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Human review state. e.g. `requested`, `succeeded`, `rejected`.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> str:
        """
        A message providing more details about the current state of processing. For example, the rejection reason when the state is `rejected`.
        """
        return pulumi.get(self, "state_message")


@pulumi.output_type
class GoogleCloudDocumentaiV1DocumentRevisionResponse(dict):
    """
    Contains past or forward revisions of this document.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createTime":
            suggest = "create_time"
        elif key == "humanReview":
            suggest = "human_review"
        elif key == "parentIds":
            suggest = "parent_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDocumentaiV1DocumentRevisionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDocumentaiV1DocumentRevisionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDocumentaiV1DocumentRevisionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 agent: str,
                 create_time: str,
                 human_review: 'outputs.GoogleCloudDocumentaiV1DocumentRevisionHumanReviewResponse',
                 parent: Sequence[int],
                 parent_ids: Sequence[str],
                 processor: str):
        """
        Contains past or forward revisions of this document.
        :param str agent: If the change was made by a person specify the name or id of that person.
        :param str create_time: The time that the revision was created, internally generated by doc proto storage at the time of create.
        :param 'GoogleCloudDocumentaiV1DocumentRevisionHumanReviewResponse' human_review: Human Review information of this revision.
        :param Sequence[int] parent: The revisions that this revision is based on. This can include one or more parent (when documents are merged.) This field represents the index into the `revisions` field.
        :param Sequence[str] parent_ids: The revisions that this revision is based on. Must include all the ids that have anything to do with this revision - eg. there are `provenance.parent.revision` fields that index into this field.
        :param str processor: If the annotation was made by processor identify the processor by its resource name.
        """
        pulumi.set(__self__, "agent", agent)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "human_review", human_review)
        pulumi.set(__self__, "parent", parent)
        pulumi.set(__self__, "parent_ids", parent_ids)
        pulumi.set(__self__, "processor", processor)

    @property
    @pulumi.getter
    def agent(self) -> str:
        """
        If the change was made by a person specify the name or id of that person.
        """
        return pulumi.get(self, "agent")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time that the revision was created, internally generated by doc proto storage at the time of create.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="humanReview")
    def human_review(self) -> 'outputs.GoogleCloudDocumentaiV1DocumentRevisionHumanReviewResponse':
        """
        Human Review information of this revision.
        """
        return pulumi.get(self, "human_review")

    @property
    @pulumi.getter
    def parent(self) -> Sequence[int]:
        """
        The revisions that this revision is based on. This can include one or more parent (when documents are merged.) This field represents the index into the `revisions` field.
        """
        return pulumi.get(self, "parent")

    @property
    @pulumi.getter(name="parentIds")
    def parent_ids(self) -> Sequence[str]:
        """
        The revisions that this revision is based on. Must include all the ids that have anything to do with this revision - eg. there are `provenance.parent.revision` fields that index into this field.
        """
        return pulumi.get(self, "parent_ids")

    @property
    @pulumi.getter
    def processor(self) -> str:
        """
        If the annotation was made by processor identify the processor by its resource name.
        """
        return pulumi.get(self, "processor")


@pulumi.output_type
class GoogleCloudDocumentaiV1DocumentShardInfoResponse(dict):
    """
    For a large document, sharding may be performed to produce several document shards. Each document shard contains this field to detail which shard it is.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "shardCount":
            suggest = "shard_count"
        elif key == "shardIndex":
            suggest = "shard_index"
        elif key == "textOffset":
            suggest = "text_offset"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDocumentaiV1DocumentShardInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDocumentaiV1DocumentShardInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDocumentaiV1DocumentShardInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 shard_count: str,
                 shard_index: str,
                 text_offset: str):
        """
        For a large document, sharding may be performed to produce several document shards. Each document shard contains this field to detail which shard it is.
        :param str shard_count: Total number of shards.
        :param str shard_index: The 0-based index of this shard.
        :param str text_offset: The index of the first character in Document.text in the overall document global text.
        """
        pulumi.set(__self__, "shard_count", shard_count)
        pulumi.set(__self__, "shard_index", shard_index)
        pulumi.set(__self__, "text_offset", text_offset)

    @property
    @pulumi.getter(name="shardCount")
    def shard_count(self) -> str:
        """
        Total number of shards.
        """
        return pulumi.get(self, "shard_count")

    @property
    @pulumi.getter(name="shardIndex")
    def shard_index(self) -> str:
        """
        The 0-based index of this shard.
        """
        return pulumi.get(self, "shard_index")

    @property
    @pulumi.getter(name="textOffset")
    def text_offset(self) -> str:
        """
        The index of the first character in Document.text in the overall document global text.
        """
        return pulumi.get(self, "text_offset")


@pulumi.output_type
class GoogleCloudDocumentaiV1DocumentStyleFontSizeResponse(dict):
    """
    Font size with unit.
    """
    def __init__(__self__, *,
                 size: float,
                 unit: str):
        """
        Font size with unit.
        :param float size: Font size for the text.
        :param str unit: Unit for the font size. Follows CSS naming (in, px, pt, etc.).
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter
    def size(self) -> float:
        """
        Font size for the text.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def unit(self) -> str:
        """
        Unit for the font size. Follows CSS naming (in, px, pt, etc.).
        """
        return pulumi.get(self, "unit")


@pulumi.output_type
class GoogleCloudDocumentaiV1DocumentStyleResponse(dict):
    """
    Annotation for common text style attributes. This adheres to CSS conventions as much as possible.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backgroundColor":
            suggest = "background_color"
        elif key == "fontFamily":
            suggest = "font_family"
        elif key == "fontSize":
            suggest = "font_size"
        elif key == "fontWeight":
            suggest = "font_weight"
        elif key == "textAnchor":
            suggest = "text_anchor"
        elif key == "textDecoration":
            suggest = "text_decoration"
        elif key == "textStyle":
            suggest = "text_style"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDocumentaiV1DocumentStyleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDocumentaiV1DocumentStyleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDocumentaiV1DocumentStyleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 background_color: 'outputs.GoogleTypeColorResponse',
                 color: 'outputs.GoogleTypeColorResponse',
                 font_family: str,
                 font_size: 'outputs.GoogleCloudDocumentaiV1DocumentStyleFontSizeResponse',
                 font_weight: str,
                 text_anchor: 'outputs.GoogleCloudDocumentaiV1DocumentTextAnchorResponse',
                 text_decoration: str,
                 text_style: str):
        """
        Annotation for common text style attributes. This adheres to CSS conventions as much as possible.
        :param 'GoogleTypeColorResponse' background_color: Text background color.
        :param 'GoogleTypeColorResponse' color: Text color.
        :param str font_family: Font family such as `Arial`, `Times New Roman`. https://www.w3schools.com/cssref/pr_font_font-family.asp
        :param 'GoogleCloudDocumentaiV1DocumentStyleFontSizeResponse' font_size: Font size.
        :param str font_weight: Font weight. Possible values are normal, bold, bolder, and lighter. https://www.w3schools.com/cssref/pr_font_weight.asp
        :param 'GoogleCloudDocumentaiV1DocumentTextAnchorResponse' text_anchor: Text anchor indexing into the Document.text.
        :param str text_decoration: Text decoration. Follows CSS standard. https://www.w3schools.com/cssref/pr_text_text-decoration.asp
        :param str text_style: Text style. Possible values are normal, italic, and oblique. https://www.w3schools.com/cssref/pr_font_font-style.asp
        """
        pulumi.set(__self__, "background_color", background_color)
        pulumi.set(__self__, "color", color)
        pulumi.set(__self__, "font_family", font_family)
        pulumi.set(__self__, "font_size", font_size)
        pulumi.set(__self__, "font_weight", font_weight)
        pulumi.set(__self__, "text_anchor", text_anchor)
        pulumi.set(__self__, "text_decoration", text_decoration)
        pulumi.set(__self__, "text_style", text_style)

    @property
    @pulumi.getter(name="backgroundColor")
    def background_color(self) -> 'outputs.GoogleTypeColorResponse':
        """
        Text background color.
        """
        return pulumi.get(self, "background_color")

    @property
    @pulumi.getter
    def color(self) -> 'outputs.GoogleTypeColorResponse':
        """
        Text color.
        """
        return pulumi.get(self, "color")

    @property
    @pulumi.getter(name="fontFamily")
    def font_family(self) -> str:
        """
        Font family such as `Arial`, `Times New Roman`. https://www.w3schools.com/cssref/pr_font_font-family.asp
        """
        return pulumi.get(self, "font_family")

    @property
    @pulumi.getter(name="fontSize")
    def font_size(self) -> 'outputs.GoogleCloudDocumentaiV1DocumentStyleFontSizeResponse':
        """
        Font size.
        """
        return pulumi.get(self, "font_size")

    @property
    @pulumi.getter(name="fontWeight")
    def font_weight(self) -> str:
        """
        Font weight. Possible values are normal, bold, bolder, and lighter. https://www.w3schools.com/cssref/pr_font_weight.asp
        """
        return pulumi.get(self, "font_weight")

    @property
    @pulumi.getter(name="textAnchor")
    def text_anchor(self) -> 'outputs.GoogleCloudDocumentaiV1DocumentTextAnchorResponse':
        """
        Text anchor indexing into the Document.text.
        """
        return pulumi.get(self, "text_anchor")

    @property
    @pulumi.getter(name="textDecoration")
    def text_decoration(self) -> str:
        """
        Text decoration. Follows CSS standard. https://www.w3schools.com/cssref/pr_text_text-decoration.asp
        """
        return pulumi.get(self, "text_decoration")

    @property
    @pulumi.getter(name="textStyle")
    def text_style(self) -> str:
        """
        Text style. Possible values are normal, italic, and oblique. https://www.w3schools.com/cssref/pr_font_font-style.asp
        """
        return pulumi.get(self, "text_style")


@pulumi.output_type
class GoogleCloudDocumentaiV1DocumentTextAnchorResponse(dict):
    """
    Text reference indexing into the Document.text.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "textSegments":
            suggest = "text_segments"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDocumentaiV1DocumentTextAnchorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDocumentaiV1DocumentTextAnchorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDocumentaiV1DocumentTextAnchorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content: str,
                 text_segments: Sequence['outputs.GoogleCloudDocumentaiV1DocumentTextAnchorTextSegmentResponse']):
        """
        Text reference indexing into the Document.text.
        :param str content: Contains the content of the text span so that users do not have to look it up in the text_segments. It is always populated for formFields.
        :param Sequence['GoogleCloudDocumentaiV1DocumentTextAnchorTextSegmentResponse'] text_segments: The text segments from the Document.text.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "text_segments", text_segments)

    @property
    @pulumi.getter
    def content(self) -> str:
        """
        Contains the content of the text span so that users do not have to look it up in the text_segments. It is always populated for formFields.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="textSegments")
    def text_segments(self) -> Sequence['outputs.GoogleCloudDocumentaiV1DocumentTextAnchorTextSegmentResponse']:
        """
        The text segments from the Document.text.
        """
        return pulumi.get(self, "text_segments")


@pulumi.output_type
class GoogleCloudDocumentaiV1DocumentTextAnchorTextSegmentResponse(dict):
    """
    A text segment in the Document.text. The indices may be out of bounds which indicate that the text extends into another document shard for large sharded documents. See ShardInfo.text_offset
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endIndex":
            suggest = "end_index"
        elif key == "startIndex":
            suggest = "start_index"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDocumentaiV1DocumentTextAnchorTextSegmentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDocumentaiV1DocumentTextAnchorTextSegmentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDocumentaiV1DocumentTextAnchorTextSegmentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_index: str,
                 start_index: str):
        """
        A text segment in the Document.text. The indices may be out of bounds which indicate that the text extends into another document shard for large sharded documents. See ShardInfo.text_offset
        :param str end_index: TextSegment half open end UTF-8 char index in the Document.text.
        :param str start_index: TextSegment start UTF-8 char index in the Document.text.
        """
        pulumi.set(__self__, "end_index", end_index)
        pulumi.set(__self__, "start_index", start_index)

    @property
    @pulumi.getter(name="endIndex")
    def end_index(self) -> str:
        """
        TextSegment half open end UTF-8 char index in the Document.text.
        """
        return pulumi.get(self, "end_index")

    @property
    @pulumi.getter(name="startIndex")
    def start_index(self) -> str:
        """
        TextSegment start UTF-8 char index in the Document.text.
        """
        return pulumi.get(self, "start_index")


@pulumi.output_type
class GoogleCloudDocumentaiV1DocumentTextChangeResponse(dict):
    """
    This message is used for text changes aka. OCR corrections.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "changedText":
            suggest = "changed_text"
        elif key == "textAnchor":
            suggest = "text_anchor"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDocumentaiV1DocumentTextChangeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDocumentaiV1DocumentTextChangeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDocumentaiV1DocumentTextChangeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 changed_text: str,
                 provenance: Sequence['outputs.GoogleCloudDocumentaiV1DocumentProvenanceResponse'],
                 text_anchor: 'outputs.GoogleCloudDocumentaiV1DocumentTextAnchorResponse'):
        """
        This message is used for text changes aka. OCR corrections.
        :param str changed_text: The text that replaces the text identified in the `text_anchor`.
        :param Sequence['GoogleCloudDocumentaiV1DocumentProvenanceResponse'] provenance: The history of this annotation.
        :param 'GoogleCloudDocumentaiV1DocumentTextAnchorResponse' text_anchor: Provenance of the correction. Text anchor indexing into the Document.text. There can only be a single `TextAnchor.text_segments` element. If the start and end index of the text segment are the same, the text change is inserted before that index.
        """
        pulumi.set(__self__, "changed_text", changed_text)
        pulumi.set(__self__, "provenance", provenance)
        pulumi.set(__self__, "text_anchor", text_anchor)

    @property
    @pulumi.getter(name="changedText")
    def changed_text(self) -> str:
        """
        The text that replaces the text identified in the `text_anchor`.
        """
        return pulumi.get(self, "changed_text")

    @property
    @pulumi.getter
    def provenance(self) -> Sequence['outputs.GoogleCloudDocumentaiV1DocumentProvenanceResponse']:
        """
        The history of this annotation.
        """
        return pulumi.get(self, "provenance")

    @property
    @pulumi.getter(name="textAnchor")
    def text_anchor(self) -> 'outputs.GoogleCloudDocumentaiV1DocumentTextAnchorResponse':
        """
        Provenance of the correction. Text anchor indexing into the Document.text. There can only be a single `TextAnchor.text_segments` element. If the start and end index of the text segment are the same, the text change is inserted before that index.
        """
        return pulumi.get(self, "text_anchor")


@pulumi.output_type
class GoogleCloudDocumentaiV1NormalizedVertexResponse(dict):
    """
    A vertex represents a 2D point in the image. NOTE: the normalized vertex coordinates are relative to the original image and range from 0 to 1.
    """
    def __init__(__self__, *,
                 x: float,
                 y: float):
        """
        A vertex represents a 2D point in the image. NOTE: the normalized vertex coordinates are relative to the original image and range from 0 to 1.
        :param float x: X coordinate.
        :param float y: Y coordinate (starts from the top of the image).
        """
        pulumi.set(__self__, "x", x)
        pulumi.set(__self__, "y", y)

    @property
    @pulumi.getter
    def x(self) -> float:
        """
        X coordinate.
        """
        return pulumi.get(self, "x")

    @property
    @pulumi.getter
    def y(self) -> float:
        """
        Y coordinate (starts from the top of the image).
        """
        return pulumi.get(self, "y")


@pulumi.output_type
class GoogleCloudDocumentaiV1VertexResponse(dict):
    """
    A vertex represents a 2D point in the image. NOTE: the vertex coordinates are in the same scale as the original image.
    """
    def __init__(__self__, *,
                 x: int,
                 y: int):
        """
        A vertex represents a 2D point in the image. NOTE: the vertex coordinates are in the same scale as the original image.
        :param int x: X coordinate.
        :param int y: Y coordinate (starts from the top of the image).
        """
        pulumi.set(__self__, "x", x)
        pulumi.set(__self__, "y", y)

    @property
    @pulumi.getter
    def x(self) -> int:
        """
        X coordinate.
        """
        return pulumi.get(self, "x")

    @property
    @pulumi.getter
    def y(self) -> int:
        """
        Y coordinate (starts from the top of the image).
        """
        return pulumi.get(self, "y")


@pulumi.output_type
class GoogleIamV1AuditConfigResponse(dict):
    """
    Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "auditLogConfigs":
            suggest = "audit_log_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleIamV1AuditConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleIamV1AuditConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleIamV1AuditConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audit_log_configs: Sequence['outputs.GoogleIamV1AuditLogConfigResponse'],
                 service: str):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
        :param Sequence['GoogleIamV1AuditLogConfigResponse'] audit_log_configs: The configuration for logging of each type of permission.
        :param str service: Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Sequence['outputs.GoogleIamV1AuditLogConfigResponse']:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class GoogleIamV1AuditLogConfigResponse(dict):
    """
    Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exemptedMembers":
            suggest = "exempted_members"
        elif key == "logType":
            suggest = "log_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleIamV1AuditLogConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleIamV1AuditLogConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleIamV1AuditLogConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exempted_members: Sequence[str],
                 log_type: str):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param Sequence[str] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param str log_type: The log type that this config enables.
        """
        pulumi.set(__self__, "exempted_members", exempted_members)
        pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Sequence[str]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> str:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")


@pulumi.output_type
class GoogleIamV1BindingResponse(dict):
    """
    Associates `members`, or principals, with a `role`.
    """
    def __init__(__self__, *,
                 condition: 'outputs.GoogleTypeExprResponse',
                 members: Sequence[str],
                 role: str):
        """
        Associates `members`, or principals, with a `role`.
        :param 'GoogleTypeExprResponse' condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param Sequence[str] members: Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. Does not include identities that come from external identity providers (IdPs) through identity federation. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a Google service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An identifier for a [Kubernetes service account](https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts). For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding.
        :param str role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.GoogleTypeExprResponse':
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def members(self) -> Sequence[str]:
        """
        Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. Does not include identities that come from external identity providers (IdPs) through identity federation. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a Google service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An identifier for a [Kubernetes service account](https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts). For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding.
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class GoogleIamV1PolicyResponse(dict):
    """
    An Identity and Access Management (IAM) policy, which specifies access controls for Google Cloud resources. A `Policy` is a collection of `bindings`. A `binding` binds one or more `members`, or principals, to a single `role`. Principals can be user accounts, service accounts, Google groups, and domains (such as G Suite). A `role` is a named list of permissions; each `role` can be an IAM predefined role or a user-created custom role. For some types of Google Cloud resources, a `binding` can also specify a `condition`, which is a logical expression that allows access to a resource only if the expression evaluates to `true`. A condition can add constraints based on attributes of the request, the resource, or both. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies). **JSON example:** { "bindings": [ { "role": "roles/resourcemanager.organizationAdmin", "members": [ "user:mike@example.com", "group:admins@example.com", "domain:google.com", "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role": "roles/resourcemanager.organizationViewer", "members": [ "user:eve@example.com" ], "condition": { "title": "expirable access", "description": "Does not grant access after Sep 2020", "expression": "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag": "BwWWja0YfJA=", "version": 3 } **YAML example:** bindings: - members: - user:mike@example.com - group:admins@example.com - domain:google.com - serviceAccount:my-project-id@appspot.gserviceaccount.com role: roles/resourcemanager.organizationAdmin - members: - user:eve@example.com role: roles/resourcemanager.organizationViewer condition: title: expirable access description: Does not grant access after Sep 2020 expression: request.time < timestamp('2020-10-01T00:00:00.000Z') etag: BwWWja0YfJA= version: 3 For a description of IAM and its features, see the [IAM documentation](https://cloud.google.com/iam/docs/).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "auditConfigs":
            suggest = "audit_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleIamV1PolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleIamV1PolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleIamV1PolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audit_configs: Sequence['outputs.GoogleIamV1AuditConfigResponse'],
                 bindings: Sequence['outputs.GoogleIamV1BindingResponse'],
                 etag: str,
                 version: int):
        """
        An Identity and Access Management (IAM) policy, which specifies access controls for Google Cloud resources. A `Policy` is a collection of `bindings`. A `binding` binds one or more `members`, or principals, to a single `role`. Principals can be user accounts, service accounts, Google groups, and domains (such as G Suite). A `role` is a named list of permissions; each `role` can be an IAM predefined role or a user-created custom role. For some types of Google Cloud resources, a `binding` can also specify a `condition`, which is a logical expression that allows access to a resource only if the expression evaluates to `true`. A condition can add constraints based on attributes of the request, the resource, or both. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies). **JSON example:** { "bindings": [ { "role": "roles/resourcemanager.organizationAdmin", "members": [ "user:mike@example.com", "group:admins@example.com", "domain:google.com", "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role": "roles/resourcemanager.organizationViewer", "members": [ "user:eve@example.com" ], "condition": { "title": "expirable access", "description": "Does not grant access after Sep 2020", "expression": "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag": "BwWWja0YfJA=", "version": 3 } **YAML example:** bindings: - members: - user:mike@example.com - group:admins@example.com - domain:google.com - serviceAccount:my-project-id@appspot.gserviceaccount.com role: roles/resourcemanager.organizationAdmin - members: - user:eve@example.com role: roles/resourcemanager.organizationViewer condition: title: expirable access description: Does not grant access after Sep 2020 expression: request.time < timestamp('2020-10-01T00:00:00.000Z') etag: BwWWja0YfJA= version: 3 For a description of IAM and its features, see the [IAM documentation](https://cloud.google.com/iam/docs/).
        :param Sequence['GoogleIamV1AuditConfigResponse'] audit_configs: Specifies cloud audit logging configuration for this policy.
        :param Sequence['GoogleIamV1BindingResponse'] bindings: Associates a list of `members`, or principals, with a `role`. Optionally, may specify a `condition` that determines how and when the `bindings` are applied. Each of the `bindings` must contain at least one principal. The `bindings` in a `Policy` can refer to up to 1,500 principals; up to 250 of these principals can be Google groups. Each occurrence of a principal counts towards these limits. For example, if the `bindings` grant 50 different roles to `user:alice@example.com`, and not to any other principal, then you can add another 1,450 principals to the `bindings` in the `Policy`.
        :param str etag: `etag` is used for optimistic concurrency control as a way to help prevent simultaneous updates of a policy from overwriting each other. It is strongly suggested that systems make use of the `etag` in the read-modify-write cycle to perform policy updates in order to avoid race conditions: An `etag` is returned in the response to `getIamPolicy`, and systems are expected to put that etag in the request to `setIamPolicy` to ensure that their change will be applied to the same version of the policy. **Important:** If you use IAM Conditions, you must include the `etag` field whenever you call `setIamPolicy`. If you omit this field, then IAM allows you to overwrite a version `3` policy with a version `1` policy, and all of the conditions in the version `3` policy are lost.
        :param int version: Specifies the format of the policy. Valid values are `0`, `1`, and `3`. Requests that specify an invalid value are rejected. Any operation that affects conditional role bindings must specify version `3`. This requirement applies to the following operations: * Getting a policy that includes a conditional role binding * Adding a conditional role binding to a policy * Changing a conditional role binding in a policy * Removing any role binding, with or without a condition, from a policy that includes conditions **Important:** If you use IAM Conditions, you must include the `etag` field whenever you call `setIamPolicy`. If you omit this field, then IAM allows you to overwrite a version `3` policy with a version `1` policy, and all of the conditions in the version `3` policy are lost. If a policy does not include any conditions, operations on that policy may specify any valid version or leave the field unset. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        pulumi.set(__self__, "audit_configs", audit_configs)
        pulumi.set(__self__, "bindings", bindings)
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="auditConfigs")
    def audit_configs(self) -> Sequence['outputs.GoogleIamV1AuditConfigResponse']:
        """
        Specifies cloud audit logging configuration for this policy.
        """
        return pulumi.get(self, "audit_configs")

    @property
    @pulumi.getter
    def bindings(self) -> Sequence['outputs.GoogleIamV1BindingResponse']:
        """
        Associates a list of `members`, or principals, with a `role`. Optionally, may specify a `condition` that determines how and when the `bindings` are applied. Each of the `bindings` must contain at least one principal. The `bindings` in a `Policy` can refer to up to 1,500 principals; up to 250 of these principals can be Google groups. Each occurrence of a principal counts towards these limits. For example, if the `bindings` grant 50 different roles to `user:alice@example.com`, and not to any other principal, then you can add another 1,450 principals to the `bindings` in the `Policy`.
        """
        return pulumi.get(self, "bindings")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        `etag` is used for optimistic concurrency control as a way to help prevent simultaneous updates of a policy from overwriting each other. It is strongly suggested that systems make use of the `etag` in the read-modify-write cycle to perform policy updates in order to avoid race conditions: An `etag` is returned in the response to `getIamPolicy`, and systems are expected to put that etag in the request to `setIamPolicy` to ensure that their change will be applied to the same version of the policy. **Important:** If you use IAM Conditions, you must include the `etag` field whenever you call `setIamPolicy`. If you omit this field, then IAM allows you to overwrite a version `3` policy with a version `1` policy, and all of the conditions in the version `3` policy are lost.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def version(self) -> int:
        """
        Specifies the format of the policy. Valid values are `0`, `1`, and `3`. Requests that specify an invalid value are rejected. Any operation that affects conditional role bindings must specify version `3`. This requirement applies to the following operations: * Getting a policy that includes a conditional role binding * Adding a conditional role binding to a policy * Changing a conditional role binding in a policy * Removing any role binding, with or without a condition, from a policy that includes conditions **Important:** If you use IAM Conditions, you must include the `etag` field whenever you call `setIamPolicy`. If you omit this field, then IAM allows you to overwrite a version `3` policy with a version `1` policy, and all of the conditions in the version `3` policy are lost. If a policy does not include any conditions, operations on that policy may specify any valid version or leave the field unset. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GoogleRpcStatusResponse(dict):
    """
    The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
    """
    def __init__(__self__, *,
                 code: int,
                 details: Sequence[Mapping[str, str]],
                 message: str):
        """
        The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
        :param int code: The status code, which should be an enum value of google.rpc.Code.
        :param Sequence[Mapping[str, str]] details: A list of messages that carry the error details. There is a common set of message types for APIs to use.
        :param str message: A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> int:
        """
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Sequence[Mapping[str, str]]:
        """
        A list of messages that carry the error details. There is a common set of message types for APIs to use.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class GoogleTypeColorResponse(dict):
    """
    Represents a color in the RGBA color space. This representation is designed for simplicity of conversion to/from color representations in various languages over compactness. For example, the fields of this representation can be trivially provided to the constructor of `java.awt.Color` in Java; it can also be trivially provided to UIColor's `+colorWithRed:green:blue:alpha` method in iOS; and, with just a little work, it can be easily formatted into a CSS `rgba()` string in JavaScript. This reference page doesn't carry information about the absolute color space that should be used to interpret the RGB value (e.g. sRGB, Adobe RGB, DCI-P3, BT.2020, etc.). By default, applications should assume the sRGB color space. When color equality needs to be decided, implementations, unless documented otherwise, treat two colors as equal if all their red, green, blue, and alpha values each differ by at most 1e-5. Example (Java): import com.google.type.Color; // ... public static java.awt.Color fromProto(Color protocolor) { float alpha = protocolor.hasAlpha() ? protocolor.getAlpha().getValue() : 1.0; return new java.awt.Color( protocolor.getRed(), protocolor.getGreen(), protocolor.getBlue(), alpha); } public static Color toProto(java.awt.Color color) { float red = (float) color.getRed(); float green = (float) color.getGreen(); float blue = (float) color.getBlue(); float denominator = 255.0; Color.Builder resultBuilder = Color .newBuilder() .setRed(red / denominator) .setGreen(green / denominator) .setBlue(blue / denominator); int alpha = color.getAlpha(); if (alpha != 255) { result.setAlpha( FloatValue .newBuilder() .setValue(((float) alpha) / denominator) .build()); } return resultBuilder.build(); } // ... Example (iOS / Obj-C): // ... static UIColor* fromProto(Color* protocolor) { float red = [protocolor red]; float green = [protocolor green]; float blue = [protocolor blue]; FloatValue* alpha_wrapper = [protocolor alpha]; float alpha = 1.0; if (alpha_wrapper != nil) { alpha = [alpha_wrapper value]; } return [UIColor colorWithRed:red green:green blue:blue alpha:alpha]; } static Color* toProto(UIColor* color) { CGFloat red, green, blue, alpha; if (![color getRed:&red green:&green blue:&blue alpha:&alpha]) { return nil; } Color* result = [[Color alloc] init]; [result setRed:red]; [result setGreen:green]; [result setBlue:blue]; if (alpha <= 0.9999) { [result setAlpha:floatWrapperWithValue(alpha)]; } [result autorelease]; return result; } // ... Example (JavaScript): // ... var protoToCssColor = function(rgb_color) { var redFrac = rgb_color.red || 0.0; var greenFrac = rgb_color.green || 0.0; var blueFrac = rgb_color.blue || 0.0; var red = Math.floor(redFrac * 255); var green = Math.floor(greenFrac * 255); var blue = Math.floor(blueFrac * 255); if (!('alpha' in rgb_color)) { return rgbToCssColor(red, green, blue); } var alphaFrac = rgb_color.alpha.value || 0.0; var rgbParams = [red, green, blue].join(','); return ['rgba(', rgbParams, ',', alphaFrac, ')'].join(''); }; var rgbToCssColor = function(red, green, blue) { var rgbNumber = new Number((red << 16) | (green << 8) | blue); var hexString = rgbNumber.toString(16); var missingZeros = 6 - hexString.length; var resultBuilder = ['#']; for (var i = 0; i < missingZeros; i++) { resultBuilder.push('0'); } resultBuilder.push(hexString); return resultBuilder.join(''); }; // ...
    """
    def __init__(__self__, *,
                 alpha: float,
                 blue: float,
                 green: float,
                 red: float):
        """
        Represents a color in the RGBA color space. This representation is designed for simplicity of conversion to/from color representations in various languages over compactness. For example, the fields of this representation can be trivially provided to the constructor of `java.awt.Color` in Java; it can also be trivially provided to UIColor's `+colorWithRed:green:blue:alpha` method in iOS; and, with just a little work, it can be easily formatted into a CSS `rgba()` string in JavaScript. This reference page doesn't carry information about the absolute color space that should be used to interpret the RGB value (e.g. sRGB, Adobe RGB, DCI-P3, BT.2020, etc.). By default, applications should assume the sRGB color space. When color equality needs to be decided, implementations, unless documented otherwise, treat two colors as equal if all their red, green, blue, and alpha values each differ by at most 1e-5. Example (Java): import com.google.type.Color; // ... public static java.awt.Color fromProto(Color protocolor) { float alpha = protocolor.hasAlpha() ? protocolor.getAlpha().getValue() : 1.0; return new java.awt.Color( protocolor.getRed(), protocolor.getGreen(), protocolor.getBlue(), alpha); } public static Color toProto(java.awt.Color color) { float red = (float) color.getRed(); float green = (float) color.getGreen(); float blue = (float) color.getBlue(); float denominator = 255.0; Color.Builder resultBuilder = Color .newBuilder() .setRed(red / denominator) .setGreen(green / denominator) .setBlue(blue / denominator); int alpha = color.getAlpha(); if (alpha != 255) { result.setAlpha( FloatValue .newBuilder() .setValue(((float) alpha) / denominator) .build()); } return resultBuilder.build(); } // ... Example (iOS / Obj-C): // ... static UIColor* fromProto(Color* protocolor) { float red = [protocolor red]; float green = [protocolor green]; float blue = [protocolor blue]; FloatValue* alpha_wrapper = [protocolor alpha]; float alpha = 1.0; if (alpha_wrapper != nil) { alpha = [alpha_wrapper value]; } return [UIColor colorWithRed:red green:green blue:blue alpha:alpha]; } static Color* toProto(UIColor* color) { CGFloat red, green, blue, alpha; if (![color getRed:&red green:&green blue:&blue alpha:&alpha]) { return nil; } Color* result = [[Color alloc] init]; [result setRed:red]; [result setGreen:green]; [result setBlue:blue]; if (alpha <= 0.9999) { [result setAlpha:floatWrapperWithValue(alpha)]; } [result autorelease]; return result; } // ... Example (JavaScript): // ... var protoToCssColor = function(rgb_color) { var redFrac = rgb_color.red || 0.0; var greenFrac = rgb_color.green || 0.0; var blueFrac = rgb_color.blue || 0.0; var red = Math.floor(redFrac * 255); var green = Math.floor(greenFrac * 255); var blue = Math.floor(blueFrac * 255); if (!('alpha' in rgb_color)) { return rgbToCssColor(red, green, blue); } var alphaFrac = rgb_color.alpha.value || 0.0; var rgbParams = [red, green, blue].join(','); return ['rgba(', rgbParams, ',', alphaFrac, ')'].join(''); }; var rgbToCssColor = function(red, green, blue) { var rgbNumber = new Number((red << 16) | (green << 8) | blue); var hexString = rgbNumber.toString(16); var missingZeros = 6 - hexString.length; var resultBuilder = ['#']; for (var i = 0; i < missingZeros; i++) { resultBuilder.push('0'); } resultBuilder.push(hexString); return resultBuilder.join(''); }; // ...
        :param float alpha: The fraction of this color that should be applied to the pixel. That is, the final pixel color is defined by the equation: `pixel color = alpha * (this color) + (1.0 - alpha) * (background color)` This means that a value of 1.0 corresponds to a solid color, whereas a value of 0.0 corresponds to a completely transparent color. This uses a wrapper message rather than a simple float scalar so that it is possible to distinguish between a default value and the value being unset. If omitted, this color object is rendered as a solid color (as if the alpha value had been explicitly given a value of 1.0).
        :param float blue: The amount of blue in the color as a value in the interval [0, 1].
        :param float green: The amount of green in the color as a value in the interval [0, 1].
        :param float red: The amount of red in the color as a value in the interval [0, 1].
        """
        pulumi.set(__self__, "alpha", alpha)
        pulumi.set(__self__, "blue", blue)
        pulumi.set(__self__, "green", green)
        pulumi.set(__self__, "red", red)

    @property
    @pulumi.getter
    def alpha(self) -> float:
        """
        The fraction of this color that should be applied to the pixel. That is, the final pixel color is defined by the equation: `pixel color = alpha * (this color) + (1.0 - alpha) * (background color)` This means that a value of 1.0 corresponds to a solid color, whereas a value of 0.0 corresponds to a completely transparent color. This uses a wrapper message rather than a simple float scalar so that it is possible to distinguish between a default value and the value being unset. If omitted, this color object is rendered as a solid color (as if the alpha value had been explicitly given a value of 1.0).
        """
        return pulumi.get(self, "alpha")

    @property
    @pulumi.getter
    def blue(self) -> float:
        """
        The amount of blue in the color as a value in the interval [0, 1].
        """
        return pulumi.get(self, "blue")

    @property
    @pulumi.getter
    def green(self) -> float:
        """
        The amount of green in the color as a value in the interval [0, 1].
        """
        return pulumi.get(self, "green")

    @property
    @pulumi.getter
    def red(self) -> float:
        """
        The amount of red in the color as a value in the interval [0, 1].
        """
        return pulumi.get(self, "red")


@pulumi.output_type
class GoogleTypeDateResponse(dict):
    """
    Represents a whole or partial calendar date, such as a birthday. The time of day and time zone are either specified elsewhere or are insignificant. The date is relative to the Gregorian Calendar. This can represent one of the following: * A full date, with non-zero year, month, and day values. * A month and day, with a zero year (for example, an anniversary). * A year on its own, with a zero month and a zero day. * A year and month, with a zero day (for example, a credit card expiration date). Related types: * google.type.TimeOfDay * google.type.DateTime * google.protobuf.Timestamp
    """
    def __init__(__self__, *,
                 day: int,
                 month: int,
                 year: int):
        """
        Represents a whole or partial calendar date, such as a birthday. The time of day and time zone are either specified elsewhere or are insignificant. The date is relative to the Gregorian Calendar. This can represent one of the following: * A full date, with non-zero year, month, and day values. * A month and day, with a zero year (for example, an anniversary). * A year on its own, with a zero month and a zero day. * A year and month, with a zero day (for example, a credit card expiration date). Related types: * google.type.TimeOfDay * google.type.DateTime * google.protobuf.Timestamp
        :param int day: Day of a month. Must be from 1 to 31 and valid for the year and month, or 0 to specify a year by itself or a year and month where the day isn't significant.
        :param int month: Month of a year. Must be from 1 to 12, or 0 to specify a year without a month and day.
        :param int year: Year of the date. Must be from 1 to 9999, or 0 to specify a date without a year.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "month", month)
        pulumi.set(__self__, "year", year)

    @property
    @pulumi.getter
    def day(self) -> int:
        """
        Day of a month. Must be from 1 to 31 and valid for the year and month, or 0 to specify a year by itself or a year and month where the day isn't significant.
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter
    def month(self) -> int:
        """
        Month of a year. Must be from 1 to 12, or 0 to specify a year without a month and day.
        """
        return pulumi.get(self, "month")

    @property
    @pulumi.getter
    def year(self) -> int:
        """
        Year of the date. Must be from 1 to 9999, or 0 to specify a date without a year.
        """
        return pulumi.get(self, "year")


@pulumi.output_type
class GoogleTypeDateTimeResponse(dict):
    """
    Represents civil time (or occasionally physical time). This type can represent a civil time in one of a few possible ways: * When utc_offset is set and time_zone is unset: a civil time on a calendar day with a particular offset from UTC. * When time_zone is set and utc_offset is unset: a civil time on a calendar day in a particular time zone. * When neither time_zone nor utc_offset is set: a civil time on a calendar day in local time. The date is relative to the Proleptic Gregorian Calendar. If year, month, or day are 0, the DateTime is considered not to have a specific year, month, or day respectively. This type may also be used to represent a physical time if all the date and time fields are set and either case of the `time_offset` oneof is set. Consider using `Timestamp` message for physical time instead. If your use case also would like to store the user's timezone, that can be done in another field. This type is more flexible than some applications may want. Make sure to document and validate your application's limitations.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timeZone":
            suggest = "time_zone"
        elif key == "utcOffset":
            suggest = "utc_offset"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleTypeDateTimeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleTypeDateTimeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleTypeDateTimeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day: int,
                 hours: int,
                 minutes: int,
                 month: int,
                 nanos: int,
                 seconds: int,
                 time_zone: 'outputs.GoogleTypeTimeZoneResponse',
                 utc_offset: str,
                 year: int):
        """
        Represents civil time (or occasionally physical time). This type can represent a civil time in one of a few possible ways: * When utc_offset is set and time_zone is unset: a civil time on a calendar day with a particular offset from UTC. * When time_zone is set and utc_offset is unset: a civil time on a calendar day in a particular time zone. * When neither time_zone nor utc_offset is set: a civil time on a calendar day in local time. The date is relative to the Proleptic Gregorian Calendar. If year, month, or day are 0, the DateTime is considered not to have a specific year, month, or day respectively. This type may also be used to represent a physical time if all the date and time fields are set and either case of the `time_offset` oneof is set. Consider using `Timestamp` message for physical time instead. If your use case also would like to store the user's timezone, that can be done in another field. This type is more flexible than some applications may want. Make sure to document and validate your application's limitations.
        :param int day: Optional. Day of month. Must be from 1 to 31 and valid for the year and month, or 0 if specifying a datetime without a day.
        :param int hours: Optional. Hours of day in 24 hour format. Should be from 0 to 23, defaults to 0 (midnight). An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        :param int minutes: Optional. Minutes of hour of day. Must be from 0 to 59, defaults to 0.
        :param int month: Optional. Month of year. Must be from 1 to 12, or 0 if specifying a datetime without a month.
        :param int nanos: Optional. Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999, defaults to 0.
        :param int seconds: Optional. Seconds of minutes of the time. Must normally be from 0 to 59, defaults to 0. An API may allow the value 60 if it allows leap-seconds.
        :param 'GoogleTypeTimeZoneResponse' time_zone: Time zone.
        :param str utc_offset: UTC offset. Must be whole seconds, between -18 hours and +18 hours. For example, a UTC offset of -4:00 would be represented as { seconds: -14400 }.
        :param int year: Optional. Year of date. Must be from 1 to 9999, or 0 if specifying a datetime without a year.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "hours", hours)
        pulumi.set(__self__, "minutes", minutes)
        pulumi.set(__self__, "month", month)
        pulumi.set(__self__, "nanos", nanos)
        pulumi.set(__self__, "seconds", seconds)
        pulumi.set(__self__, "time_zone", time_zone)
        pulumi.set(__self__, "utc_offset", utc_offset)
        pulumi.set(__self__, "year", year)

    @property
    @pulumi.getter
    def day(self) -> int:
        """
        Optional. Day of month. Must be from 1 to 31 and valid for the year and month, or 0 if specifying a datetime without a day.
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter
    def hours(self) -> int:
        """
        Optional. Hours of day in 24 hour format. Should be from 0 to 23, defaults to 0 (midnight). An API may choose to allow the value "24:00:00" for scenarios like business closing time.
        """
        return pulumi.get(self, "hours")

    @property
    @pulumi.getter
    def minutes(self) -> int:
        """
        Optional. Minutes of hour of day. Must be from 0 to 59, defaults to 0.
        """
        return pulumi.get(self, "minutes")

    @property
    @pulumi.getter
    def month(self) -> int:
        """
        Optional. Month of year. Must be from 1 to 12, or 0 if specifying a datetime without a month.
        """
        return pulumi.get(self, "month")

    @property
    @pulumi.getter
    def nanos(self) -> int:
        """
        Optional. Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999, defaults to 0.
        """
        return pulumi.get(self, "nanos")

    @property
    @pulumi.getter
    def seconds(self) -> int:
        """
        Optional. Seconds of minutes of the time. Must normally be from 0 to 59, defaults to 0. An API may allow the value 60 if it allows leap-seconds.
        """
        return pulumi.get(self, "seconds")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> 'outputs.GoogleTypeTimeZoneResponse':
        """
        Time zone.
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter(name="utcOffset")
    def utc_offset(self) -> str:
        """
        UTC offset. Must be whole seconds, between -18 hours and +18 hours. For example, a UTC offset of -4:00 would be represented as { seconds: -14400 }.
        """
        return pulumi.get(self, "utc_offset")

    @property
    @pulumi.getter
    def year(self) -> int:
        """
        Optional. Year of date. Must be from 1 to 9999, or 0 if specifying a datetime without a year.
        """
        return pulumi.get(self, "year")


@pulumi.output_type
class GoogleTypeExprResponse(dict):
    """
    Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
    """
    def __init__(__self__, *,
                 description: str,
                 expression: str,
                 location: str,
                 title: str):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param str description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param str title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class GoogleTypeMoneyResponse(dict):
    """
    Represents an amount of money with its currency type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "currencyCode":
            suggest = "currency_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleTypeMoneyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleTypeMoneyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleTypeMoneyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 currency_code: str,
                 nanos: int,
                 units: str):
        """
        Represents an amount of money with its currency type.
        :param str currency_code: The three-letter currency code defined in ISO 4217.
        :param int nanos: Number of nano (10^-9) units of the amount. The value must be between -999,999,999 and +999,999,999 inclusive. If `units` is positive, `nanos` must be positive or zero. If `units` is zero, `nanos` can be positive, zero, or negative. If `units` is negative, `nanos` must be negative or zero. For example $-1.75 is represented as `units`=-1 and `nanos`=-750,000,000.
        :param str units: The whole units of the amount. For example if `currencyCode` is `"USD"`, then 1 unit is one US dollar.
        """
        pulumi.set(__self__, "currency_code", currency_code)
        pulumi.set(__self__, "nanos", nanos)
        pulumi.set(__self__, "units", units)

    @property
    @pulumi.getter(name="currencyCode")
    def currency_code(self) -> str:
        """
        The three-letter currency code defined in ISO 4217.
        """
        return pulumi.get(self, "currency_code")

    @property
    @pulumi.getter
    def nanos(self) -> int:
        """
        Number of nano (10^-9) units of the amount. The value must be between -999,999,999 and +999,999,999 inclusive. If `units` is positive, `nanos` must be positive or zero. If `units` is zero, `nanos` can be positive, zero, or negative. If `units` is negative, `nanos` must be negative or zero. For example $-1.75 is represented as `units`=-1 and `nanos`=-750,000,000.
        """
        return pulumi.get(self, "nanos")

    @property
    @pulumi.getter
    def units(self) -> str:
        """
        The whole units of the amount. For example if `currencyCode` is `"USD"`, then 1 unit is one US dollar.
        """
        return pulumi.get(self, "units")


@pulumi.output_type
class GoogleTypePostalAddressResponse(dict):
    """
    Represents a postal address, e.g. for postal delivery or payments addresses. Given a postal address, a postal service can deliver items to a premise, P.O. Box or similar. It is not intended to model geographical locations (roads, towns, mountains). In typical usage an address would be created via user input or from importing existing data, depending on the type of process. Advice on address input / editing: - Use an internationalization-ready address widget such as https://github.com/google/libaddressinput) - Users should not be presented with UI elements for input or editing of fields outside countries where that field is used. For more guidance on how to use this schema, please see: https://support.google.com/business/answer/6397478
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressLines":
            suggest = "address_lines"
        elif key == "administrativeArea":
            suggest = "administrative_area"
        elif key == "languageCode":
            suggest = "language_code"
        elif key == "postalCode":
            suggest = "postal_code"
        elif key == "regionCode":
            suggest = "region_code"
        elif key == "sortingCode":
            suggest = "sorting_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleTypePostalAddressResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleTypePostalAddressResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleTypePostalAddressResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address_lines: Sequence[str],
                 administrative_area: str,
                 language_code: str,
                 locality: str,
                 organization: str,
                 postal_code: str,
                 recipients: Sequence[str],
                 region_code: str,
                 revision: int,
                 sorting_code: str,
                 sublocality: str):
        """
        Represents a postal address, e.g. for postal delivery or payments addresses. Given a postal address, a postal service can deliver items to a premise, P.O. Box or similar. It is not intended to model geographical locations (roads, towns, mountains). In typical usage an address would be created via user input or from importing existing data, depending on the type of process. Advice on address input / editing: - Use an internationalization-ready address widget such as https://github.com/google/libaddressinput) - Users should not be presented with UI elements for input or editing of fields outside countries where that field is used. For more guidance on how to use this schema, please see: https://support.google.com/business/answer/6397478
        :param Sequence[str] address_lines: Unstructured address lines describing the lower levels of an address. Because values in address_lines do not have type information and may sometimes contain multiple values in a single field (e.g. "Austin, TX"), it is important that the line order is clear. The order of address lines should be "envelope order" for the country/region of the address. In places where this can vary (e.g. Japan), address_language is used to make it explicit (e.g. "ja" for large-to-small ordering and "ja-Latn" or "en" for small-to-large). This way, the most specific line of an address can be selected based on the language. The minimum permitted structural representation of an address consists of a region_code with all remaining information placed in the address_lines. It would be possible to format such an address very approximately without geocoding, but no semantic reasoning could be made about any of the address components until it was at least partially resolved. Creating an address only containing a region_code and address_lines, and then geocoding is the recommended way to handle completely unstructured addresses (as opposed to guessing which parts of the address should be localities or administrative areas).
        :param str administrative_area: Optional. Highest administrative subdivision which is used for postal addresses of a country or region. For example, this can be a state, a province, an oblast, or a prefecture. Specifically, for Spain this is the province and not the autonomous community (e.g. "Barcelona" and not "Catalonia"). Many countries don't use an administrative area in postal addresses. E.g. in Switzerland this should be left unpopulated.
        :param str language_code: Optional. BCP-47 language code of the contents of this address (if known). This is often the UI language of the input form or is expected to match one of the languages used in the address' country/region, or their transliterated equivalents. This can affect formatting in certain countries, but is not critical to the correctness of the data and will never affect any validation or other non-formatting related operations. If this value is not known, it should be omitted (rather than specifying a possibly incorrect default). Examples: "zh-Hant", "ja", "ja-Latn", "en".
        :param str locality: Optional. Generally refers to the city/town portion of the address. Examples: US city, IT comune, UK post town. In regions of the world where localities are not well defined or do not fit into this structure well, leave locality empty and use address_lines.
        :param str organization: Optional. The name of the organization at the address.
        :param str postal_code: Optional. Postal code of the address. Not all countries use or require postal codes to be present, but where they are used, they may trigger additional validation with other parts of the address (e.g. state/zip validation in the U.S.A.).
        :param Sequence[str] recipients: Optional. The recipient at the address. This field may, under certain circumstances, contain multiline information. For example, it might contain "care of" information.
        :param str region_code: CLDR region code of the country/region of the address. This is never inferred and it is up to the user to ensure the value is correct. See https://cldr.unicode.org/ and https://www.unicode.org/cldr/charts/30/supplemental/territory_information.html for details. Example: "CH" for Switzerland.
        :param int revision: The schema revision of the `PostalAddress`. This must be set to 0, which is the latest revision. All new revisions **must** be backward compatible with old revisions.
        :param str sorting_code: Optional. Additional, country-specific, sorting code. This is not used in most regions. Where it is used, the value is either a string like "CEDEX", optionally followed by a number (e.g. "CEDEX 7"), or just a number alone, representing the "sector code" (Jamaica), "delivery area indicator" (Malawi) or "post office indicator" (e.g. Côte d'Ivoire).
        :param str sublocality: Optional. Sublocality of the address. For example, this can be neighborhoods, boroughs, districts.
        """
        pulumi.set(__self__, "address_lines", address_lines)
        pulumi.set(__self__, "administrative_area", administrative_area)
        pulumi.set(__self__, "language_code", language_code)
        pulumi.set(__self__, "locality", locality)
        pulumi.set(__self__, "organization", organization)
        pulumi.set(__self__, "postal_code", postal_code)
        pulumi.set(__self__, "recipients", recipients)
        pulumi.set(__self__, "region_code", region_code)
        pulumi.set(__self__, "revision", revision)
        pulumi.set(__self__, "sorting_code", sorting_code)
        pulumi.set(__self__, "sublocality", sublocality)

    @property
    @pulumi.getter(name="addressLines")
    def address_lines(self) -> Sequence[str]:
        """
        Unstructured address lines describing the lower levels of an address. Because values in address_lines do not have type information and may sometimes contain multiple values in a single field (e.g. "Austin, TX"), it is important that the line order is clear. The order of address lines should be "envelope order" for the country/region of the address. In places where this can vary (e.g. Japan), address_language is used to make it explicit (e.g. "ja" for large-to-small ordering and "ja-Latn" or "en" for small-to-large). This way, the most specific line of an address can be selected based on the language. The minimum permitted structural representation of an address consists of a region_code with all remaining information placed in the address_lines. It would be possible to format such an address very approximately without geocoding, but no semantic reasoning could be made about any of the address components until it was at least partially resolved. Creating an address only containing a region_code and address_lines, and then geocoding is the recommended way to handle completely unstructured addresses (as opposed to guessing which parts of the address should be localities or administrative areas).
        """
        return pulumi.get(self, "address_lines")

    @property
    @pulumi.getter(name="administrativeArea")
    def administrative_area(self) -> str:
        """
        Optional. Highest administrative subdivision which is used for postal addresses of a country or region. For example, this can be a state, a province, an oblast, or a prefecture. Specifically, for Spain this is the province and not the autonomous community (e.g. "Barcelona" and not "Catalonia"). Many countries don't use an administrative area in postal addresses. E.g. in Switzerland this should be left unpopulated.
        """
        return pulumi.get(self, "administrative_area")

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> str:
        """
        Optional. BCP-47 language code of the contents of this address (if known). This is often the UI language of the input form or is expected to match one of the languages used in the address' country/region, or their transliterated equivalents. This can affect formatting in certain countries, but is not critical to the correctness of the data and will never affect any validation or other non-formatting related operations. If this value is not known, it should be omitted (rather than specifying a possibly incorrect default). Examples: "zh-Hant", "ja", "ja-Latn", "en".
        """
        return pulumi.get(self, "language_code")

    @property
    @pulumi.getter
    def locality(self) -> str:
        """
        Optional. Generally refers to the city/town portion of the address. Examples: US city, IT comune, UK post town. In regions of the world where localities are not well defined or do not fit into this structure well, leave locality empty and use address_lines.
        """
        return pulumi.get(self, "locality")

    @property
    @pulumi.getter
    def organization(self) -> str:
        """
        Optional. The name of the organization at the address.
        """
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> str:
        """
        Optional. Postal code of the address. Not all countries use or require postal codes to be present, but where they are used, they may trigger additional validation with other parts of the address (e.g. state/zip validation in the U.S.A.).
        """
        return pulumi.get(self, "postal_code")

    @property
    @pulumi.getter
    def recipients(self) -> Sequence[str]:
        """
        Optional. The recipient at the address. This field may, under certain circumstances, contain multiline information. For example, it might contain "care of" information.
        """
        return pulumi.get(self, "recipients")

    @property
    @pulumi.getter(name="regionCode")
    def region_code(self) -> str:
        """
        CLDR region code of the country/region of the address. This is never inferred and it is up to the user to ensure the value is correct. See https://cldr.unicode.org/ and https://www.unicode.org/cldr/charts/30/supplemental/territory_information.html for details. Example: "CH" for Switzerland.
        """
        return pulumi.get(self, "region_code")

    @property
    @pulumi.getter
    def revision(self) -> int:
        """
        The schema revision of the `PostalAddress`. This must be set to 0, which is the latest revision. All new revisions **must** be backward compatible with old revisions.
        """
        return pulumi.get(self, "revision")

    @property
    @pulumi.getter(name="sortingCode")
    def sorting_code(self) -> str:
        """
        Optional. Additional, country-specific, sorting code. This is not used in most regions. Where it is used, the value is either a string like "CEDEX", optionally followed by a number (e.g. "CEDEX 7"), or just a number alone, representing the "sector code" (Jamaica), "delivery area indicator" (Malawi) or "post office indicator" (e.g. Côte d'Ivoire).
        """
        return pulumi.get(self, "sorting_code")

    @property
    @pulumi.getter
    def sublocality(self) -> str:
        """
        Optional. Sublocality of the address. For example, this can be neighborhoods, boroughs, districts.
        """
        return pulumi.get(self, "sublocality")


@pulumi.output_type
class GoogleTypeTimeZoneResponse(dict):
    """
    Represents a time zone from the [IANA Time Zone Database](https://www.iana.org/time-zones).
    """
    def __init__(__self__, *,
                 version: str):
        """
        Represents a time zone from the [IANA Time Zone Database](https://www.iana.org/time-zones).
        :param str version: Optional. IANA Time Zone Database version number, e.g. "2019a".
        """
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Optional. IANA Time Zone Database version number, e.g. "2019a".
        """
        return pulumi.get(self, "version")


