# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetRuleSetResult',
    'AwaitableGetRuleSetResult',
    'get_rule_set',
    'get_rule_set_output',
]

@pulumi.output_type
class GetRuleSetResult:
    def __init__(__self__, description=None, name=None, rules=None, source=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if rules and not isinstance(rules, list):
            raise TypeError("Expected argument 'rules' to be a list")
        pulumi.set(__self__, "rules", rules)
        if source and not isinstance(source, str):
            raise TypeError("Expected argument 'source' to be a str")
        pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Short description of the rule-set.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name of the rule set. Managed internally. Format: projects/{project_number}/locations/{location}/ruleSet/{rule_set_id}. The name is ignored when creating a rule set.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GoogleCloudContentwarehouseV1RuleResponse']:
        """
        List of rules given by the customer.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        Source of the rules i.e., customer name.
        """
        return pulumi.get(self, "source")


class AwaitableGetRuleSetResult(GetRuleSetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRuleSetResult(
            description=self.description,
            name=self.name,
            rules=self.rules,
            source=self.source)


def get_rule_set(location: Optional[str] = None,
                 project: Optional[str] = None,
                 rule_set_id: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRuleSetResult:
    """
    Gets a ruleset. Returns NOT_FOUND if the ruleset does not exist.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['project'] = project
    __args__['ruleSetId'] = rule_set_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:contentwarehouse/v1:getRuleSet', __args__, opts=opts, typ=GetRuleSetResult).value

    return AwaitableGetRuleSetResult(
        description=__ret__.description,
        name=__ret__.name,
        rules=__ret__.rules,
        source=__ret__.source)


@_utilities.lift_output_func(get_rule_set)
def get_rule_set_output(location: Optional[pulumi.Input[str]] = None,
                        project: Optional[pulumi.Input[Optional[str]]] = None,
                        rule_set_id: Optional[pulumi.Input[str]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRuleSetResult]:
    """
    Gets a ruleset. Returns NOT_FOUND if the ruleset does not exist.
    """
    ...
