# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AcceleratorConfigResponse',
    'AddonsConfigResponse',
    'AdvancedMachineFeaturesResponse',
    'AuthenticatorGroupsConfigResponse',
    'AutoUpgradeOptionsResponse',
    'AutopilotResponse',
    'AutoprovisioningNodePoolDefaultsResponse',
    'BigQueryDestinationResponse',
    'BinaryAuthorizationResponse',
    'BlueGreenInfoResponse',
    'BlueGreenSettingsResponse',
    'CidrBlockResponse',
    'ClientCertificateConfigResponse',
    'CloudRunConfigResponse',
    'ClusterAutoscalingResponse',
    'ConfidentialNodesResponse',
    'ConfigConnectorConfigResponse',
    'ConsumptionMeteringConfigResponse',
    'CostManagementConfigResponse',
    'DNSConfigResponse',
    'DailyMaintenanceWindowResponse',
    'DatabaseEncryptionResponse',
    'DefaultSnatStatusResponse',
    'DnsCacheConfigResponse',
    'EphemeralStorageLocalSsdConfigResponse',
    'FastSocketResponse',
    'FilterResponse',
    'GPUSharingConfigResponse',
    'GatewayAPIConfigResponse',
    'GcePersistentDiskCsiDriverConfigResponse',
    'GcfsConfigResponse',
    'GcpFilestoreCsiDriverConfigResponse',
    'GkeBackupAgentConfigResponse',
    'HorizontalPodAutoscalingResponse',
    'HttpLoadBalancingResponse',
    'IPAllocationPolicyResponse',
    'IdentityServiceConfigResponse',
    'KubernetesDashboardResponse',
    'LegacyAbacResponse',
    'LinuxNodeConfigResponse',
    'LocalNvmeSsdBlockConfigResponse',
    'LoggingComponentConfigResponse',
    'LoggingConfigResponse',
    'LoggingVariantConfigResponse',
    'MaintenanceExclusionOptionsResponse',
    'MaintenancePolicyResponse',
    'MaintenanceWindowResponse',
    'ManagedPrometheusConfigResponse',
    'MasterAuthResponse',
    'MasterAuthorizedNetworksConfigResponse',
    'MaxPodsConstraintResponse',
    'MeshCertificatesResponse',
    'MonitoringComponentConfigResponse',
    'MonitoringConfigResponse',
    'NetworkConfigResponse',
    'NetworkPerformanceConfigResponse',
    'NetworkPolicyConfigResponse',
    'NetworkPolicyResponse',
    'NetworkTagsResponse',
    'NodeConfigDefaultsResponse',
    'NodeConfigResponse',
    'NodeKubeletConfigResponse',
    'NodeManagementResponse',
    'NodeNetworkConfigResponse',
    'NodePoolAutoConfigResponse',
    'NodePoolAutoscalingResponse',
    'NodePoolDefaultsResponse',
    'NodePoolLoggingConfigResponse',
    'NodePoolResponse',
    'NodeTaintResponse',
    'NotificationConfigResponse',
    'PlacementPolicyResponse',
    'PrivateClusterConfigResponse',
    'PrivateClusterMasterGlobalAccessConfigResponse',
    'PubSubResponse',
    'RecurringTimeWindowResponse',
    'ReleaseChannelConfigResponse',
    'ReleaseChannelResponse',
    'ReservationAffinityResponse',
    'ResourceLimitResponse',
    'ResourceUsageExportConfigResponse',
    'SandboxConfigResponse',
    'ServiceExternalIPsConfigResponse',
    'ShieldedInstanceConfigResponse',
    'ShieldedNodesResponse',
    'StandardRolloutPolicyResponse',
    'StatusConditionResponse',
    'TimeWindowResponse',
    'UpdateInfoResponse',
    'UpgradeSettingsResponse',
    'VerticalPodAutoscalingResponse',
    'VirtualNICResponse',
    'WindowsNodeConfigResponse',
    'WorkloadIdentityConfigResponse',
    'WorkloadMetadataConfigResponse',
]

@pulumi.output_type
class AcceleratorConfigResponse(dict):
    """
    AcceleratorConfig represents a Hardware Accelerator request.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acceleratorCount":
            suggest = "accelerator_count"
        elif key == "acceleratorType":
            suggest = "accelerator_type"
        elif key == "gpuPartitionSize":
            suggest = "gpu_partition_size"
        elif key == "gpuSharingConfig":
            suggest = "gpu_sharing_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AcceleratorConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AcceleratorConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AcceleratorConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accelerator_count: str,
                 accelerator_type: str,
                 gpu_partition_size: str,
                 gpu_sharing_config: 'outputs.GPUSharingConfigResponse'):
        """
        AcceleratorConfig represents a Hardware Accelerator request.
        :param str accelerator_count: The number of the accelerator cards exposed to an instance.
        :param str accelerator_type: The accelerator type resource name. List of supported accelerators [here](https://cloud.google.com/compute/docs/gpus)
        :param str gpu_partition_size: Size of partitions to create on the GPU. Valid values are described in the NVIDIA [mig user guide](https://docs.nvidia.com/datacenter/tesla/mig-user-guide/#partitioning).
        :param 'GPUSharingConfigResponse' gpu_sharing_config: The configuration for GPU sharing options.
        """
        pulumi.set(__self__, "accelerator_count", accelerator_count)
        pulumi.set(__self__, "accelerator_type", accelerator_type)
        pulumi.set(__self__, "gpu_partition_size", gpu_partition_size)
        pulumi.set(__self__, "gpu_sharing_config", gpu_sharing_config)

    @property
    @pulumi.getter(name="acceleratorCount")
    def accelerator_count(self) -> str:
        """
        The number of the accelerator cards exposed to an instance.
        """
        return pulumi.get(self, "accelerator_count")

    @property
    @pulumi.getter(name="acceleratorType")
    def accelerator_type(self) -> str:
        """
        The accelerator type resource name. List of supported accelerators [here](https://cloud.google.com/compute/docs/gpus)
        """
        return pulumi.get(self, "accelerator_type")

    @property
    @pulumi.getter(name="gpuPartitionSize")
    def gpu_partition_size(self) -> str:
        """
        Size of partitions to create on the GPU. Valid values are described in the NVIDIA [mig user guide](https://docs.nvidia.com/datacenter/tesla/mig-user-guide/#partitioning).
        """
        return pulumi.get(self, "gpu_partition_size")

    @property
    @pulumi.getter(name="gpuSharingConfig")
    def gpu_sharing_config(self) -> 'outputs.GPUSharingConfigResponse':
        """
        The configuration for GPU sharing options.
        """
        return pulumi.get(self, "gpu_sharing_config")


@pulumi.output_type
class AddonsConfigResponse(dict):
    """
    Configuration for the addons that can be automatically spun up in the cluster, enabling additional functionality.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudRunConfig":
            suggest = "cloud_run_config"
        elif key == "configConnectorConfig":
            suggest = "config_connector_config"
        elif key == "dnsCacheConfig":
            suggest = "dns_cache_config"
        elif key == "gcePersistentDiskCsiDriverConfig":
            suggest = "gce_persistent_disk_csi_driver_config"
        elif key == "gcpFilestoreCsiDriverConfig":
            suggest = "gcp_filestore_csi_driver_config"
        elif key == "gkeBackupAgentConfig":
            suggest = "gke_backup_agent_config"
        elif key == "horizontalPodAutoscaling":
            suggest = "horizontal_pod_autoscaling"
        elif key == "httpLoadBalancing":
            suggest = "http_load_balancing"
        elif key == "kubernetesDashboard":
            suggest = "kubernetes_dashboard"
        elif key == "networkPolicyConfig":
            suggest = "network_policy_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AddonsConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AddonsConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AddonsConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_run_config: 'outputs.CloudRunConfigResponse',
                 config_connector_config: 'outputs.ConfigConnectorConfigResponse',
                 dns_cache_config: 'outputs.DnsCacheConfigResponse',
                 gce_persistent_disk_csi_driver_config: 'outputs.GcePersistentDiskCsiDriverConfigResponse',
                 gcp_filestore_csi_driver_config: 'outputs.GcpFilestoreCsiDriverConfigResponse',
                 gke_backup_agent_config: 'outputs.GkeBackupAgentConfigResponse',
                 horizontal_pod_autoscaling: 'outputs.HorizontalPodAutoscalingResponse',
                 http_load_balancing: 'outputs.HttpLoadBalancingResponse',
                 kubernetes_dashboard: 'outputs.KubernetesDashboardResponse',
                 network_policy_config: 'outputs.NetworkPolicyConfigResponse'):
        """
        Configuration for the addons that can be automatically spun up in the cluster, enabling additional functionality.
        :param 'CloudRunConfigResponse' cloud_run_config: Configuration for the Cloud Run addon, which allows the user to use a managed Knative service.
        :param 'ConfigConnectorConfigResponse' config_connector_config: Configuration for the ConfigConnector add-on, a Kubernetes extension to manage hosted GCP services through the Kubernetes API
        :param 'DnsCacheConfigResponse' dns_cache_config: Configuration for NodeLocalDNS, a dns cache running on cluster nodes
        :param 'GcePersistentDiskCsiDriverConfigResponse' gce_persistent_disk_csi_driver_config: Configuration for the Compute Engine Persistent Disk CSI driver.
        :param 'GcpFilestoreCsiDriverConfigResponse' gcp_filestore_csi_driver_config: Configuration for the GCP Filestore CSI driver.
        :param 'GkeBackupAgentConfigResponse' gke_backup_agent_config: Configuration for the Backup for GKE agent addon.
        :param 'HorizontalPodAutoscalingResponse' horizontal_pod_autoscaling: Configuration for the horizontal pod autoscaling feature, which increases or decreases the number of replica pods a replication controller has based on the resource usage of the existing pods.
        :param 'HttpLoadBalancingResponse' http_load_balancing: Configuration for the HTTP (L7) load balancing controller addon, which makes it easy to set up HTTP load balancers for services in a cluster.
        :param 'KubernetesDashboardResponse' kubernetes_dashboard: Configuration for the Kubernetes Dashboard. This addon is deprecated, and will be disabled in 1.15. It is recommended to use the Cloud Console to manage and monitor your Kubernetes clusters, workloads and applications. For more information, see: https://cloud.google.com/kubernetes-engine/docs/concepts/dashboards
        :param 'NetworkPolicyConfigResponse' network_policy_config: Configuration for NetworkPolicy. This only tracks whether the addon is enabled or not on the Master, it does not track whether network policy is enabled for the nodes.
        """
        pulumi.set(__self__, "cloud_run_config", cloud_run_config)
        pulumi.set(__self__, "config_connector_config", config_connector_config)
        pulumi.set(__self__, "dns_cache_config", dns_cache_config)
        pulumi.set(__self__, "gce_persistent_disk_csi_driver_config", gce_persistent_disk_csi_driver_config)
        pulumi.set(__self__, "gcp_filestore_csi_driver_config", gcp_filestore_csi_driver_config)
        pulumi.set(__self__, "gke_backup_agent_config", gke_backup_agent_config)
        pulumi.set(__self__, "horizontal_pod_autoscaling", horizontal_pod_autoscaling)
        pulumi.set(__self__, "http_load_balancing", http_load_balancing)
        pulumi.set(__self__, "kubernetes_dashboard", kubernetes_dashboard)
        pulumi.set(__self__, "network_policy_config", network_policy_config)

    @property
    @pulumi.getter(name="cloudRunConfig")
    def cloud_run_config(self) -> 'outputs.CloudRunConfigResponse':
        """
        Configuration for the Cloud Run addon, which allows the user to use a managed Knative service.
        """
        return pulumi.get(self, "cloud_run_config")

    @property
    @pulumi.getter(name="configConnectorConfig")
    def config_connector_config(self) -> 'outputs.ConfigConnectorConfigResponse':
        """
        Configuration for the ConfigConnector add-on, a Kubernetes extension to manage hosted GCP services through the Kubernetes API
        """
        return pulumi.get(self, "config_connector_config")

    @property
    @pulumi.getter(name="dnsCacheConfig")
    def dns_cache_config(self) -> 'outputs.DnsCacheConfigResponse':
        """
        Configuration for NodeLocalDNS, a dns cache running on cluster nodes
        """
        return pulumi.get(self, "dns_cache_config")

    @property
    @pulumi.getter(name="gcePersistentDiskCsiDriverConfig")
    def gce_persistent_disk_csi_driver_config(self) -> 'outputs.GcePersistentDiskCsiDriverConfigResponse':
        """
        Configuration for the Compute Engine Persistent Disk CSI driver.
        """
        return pulumi.get(self, "gce_persistent_disk_csi_driver_config")

    @property
    @pulumi.getter(name="gcpFilestoreCsiDriverConfig")
    def gcp_filestore_csi_driver_config(self) -> 'outputs.GcpFilestoreCsiDriverConfigResponse':
        """
        Configuration for the GCP Filestore CSI driver.
        """
        return pulumi.get(self, "gcp_filestore_csi_driver_config")

    @property
    @pulumi.getter(name="gkeBackupAgentConfig")
    def gke_backup_agent_config(self) -> 'outputs.GkeBackupAgentConfigResponse':
        """
        Configuration for the Backup for GKE agent addon.
        """
        return pulumi.get(self, "gke_backup_agent_config")

    @property
    @pulumi.getter(name="horizontalPodAutoscaling")
    def horizontal_pod_autoscaling(self) -> 'outputs.HorizontalPodAutoscalingResponse':
        """
        Configuration for the horizontal pod autoscaling feature, which increases or decreases the number of replica pods a replication controller has based on the resource usage of the existing pods.
        """
        return pulumi.get(self, "horizontal_pod_autoscaling")

    @property
    @pulumi.getter(name="httpLoadBalancing")
    def http_load_balancing(self) -> 'outputs.HttpLoadBalancingResponse':
        """
        Configuration for the HTTP (L7) load balancing controller addon, which makes it easy to set up HTTP load balancers for services in a cluster.
        """
        return pulumi.get(self, "http_load_balancing")

    @property
    @pulumi.getter(name="kubernetesDashboard")
    def kubernetes_dashboard(self) -> 'outputs.KubernetesDashboardResponse':
        """
        Configuration for the Kubernetes Dashboard. This addon is deprecated, and will be disabled in 1.15. It is recommended to use the Cloud Console to manage and monitor your Kubernetes clusters, workloads and applications. For more information, see: https://cloud.google.com/kubernetes-engine/docs/concepts/dashboards
        """
        return pulumi.get(self, "kubernetes_dashboard")

    @property
    @pulumi.getter(name="networkPolicyConfig")
    def network_policy_config(self) -> 'outputs.NetworkPolicyConfigResponse':
        """
        Configuration for NetworkPolicy. This only tracks whether the addon is enabled or not on the Master, it does not track whether network policy is enabled for the nodes.
        """
        return pulumi.get(self, "network_policy_config")


@pulumi.output_type
class AdvancedMachineFeaturesResponse(dict):
    """
    Specifies options for controlling advanced machine features.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "threadsPerCore":
            suggest = "threads_per_core"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AdvancedMachineFeaturesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AdvancedMachineFeaturesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AdvancedMachineFeaturesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 threads_per_core: str):
        """
        Specifies options for controlling advanced machine features.
        :param str threads_per_core: The number of threads per physical core. To disable simultaneous multithreading (SMT) set this to 1. If unset, the maximum number of threads supported per core by the underlying processor is assumed.
        """
        pulumi.set(__self__, "threads_per_core", threads_per_core)

    @property
    @pulumi.getter(name="threadsPerCore")
    def threads_per_core(self) -> str:
        """
        The number of threads per physical core. To disable simultaneous multithreading (SMT) set this to 1. If unset, the maximum number of threads supported per core by the underlying processor is assumed.
        """
        return pulumi.get(self, "threads_per_core")


@pulumi.output_type
class AuthenticatorGroupsConfigResponse(dict):
    """
    Configuration for returning group information from authenticators.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "securityGroup":
            suggest = "security_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthenticatorGroupsConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthenticatorGroupsConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthenticatorGroupsConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 security_group: str):
        """
        Configuration for returning group information from authenticators.
        :param bool enabled: Whether this cluster should return group membership lookups during authentication using a group of security groups.
        :param str security_group: The name of the security group-of-groups to be used. Only relevant if enabled = true.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "security_group", security_group)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether this cluster should return group membership lookups during authentication using a group of security groups.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="securityGroup")
    def security_group(self) -> str:
        """
        The name of the security group-of-groups to be used. Only relevant if enabled = true.
        """
        return pulumi.get(self, "security_group")


@pulumi.output_type
class AutoUpgradeOptionsResponse(dict):
    """
    AutoUpgradeOptions defines the set of options for the user to control how the Auto Upgrades will proceed.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoUpgradeStartTime":
            suggest = "auto_upgrade_start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoUpgradeOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoUpgradeOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoUpgradeOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_upgrade_start_time: str,
                 description: str):
        """
        AutoUpgradeOptions defines the set of options for the user to control how the Auto Upgrades will proceed.
        :param str auto_upgrade_start_time: [Output only] This field is set when upgrades are about to commence with the approximate start time for the upgrades, in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
        :param str description: [Output only] This field is set when upgrades are about to commence with the description of the upgrade.
        """
        pulumi.set(__self__, "auto_upgrade_start_time", auto_upgrade_start_time)
        pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="autoUpgradeStartTime")
    def auto_upgrade_start_time(self) -> str:
        """
        [Output only] This field is set when upgrades are about to commence with the approximate start time for the upgrades, in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
        """
        return pulumi.get(self, "auto_upgrade_start_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        [Output only] This field is set when upgrades are about to commence with the description of the upgrade.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class AutopilotResponse(dict):
    """
    Autopilot is the configuration for Autopilot settings on the cluster.
    """
    def __init__(__self__, *,
                 enabled: bool):
        """
        Autopilot is the configuration for Autopilot settings on the cluster.
        :param bool enabled: Enable Autopilot
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Enable Autopilot
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class AutoprovisioningNodePoolDefaultsResponse(dict):
    """
    AutoprovisioningNodePoolDefaults contains defaults for a node pool created by NAP.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bootDiskKmsKey":
            suggest = "boot_disk_kms_key"
        elif key == "diskSizeGb":
            suggest = "disk_size_gb"
        elif key == "diskType":
            suggest = "disk_type"
        elif key == "imageType":
            suggest = "image_type"
        elif key == "minCpuPlatform":
            suggest = "min_cpu_platform"
        elif key == "oauthScopes":
            suggest = "oauth_scopes"
        elif key == "serviceAccount":
            suggest = "service_account"
        elif key == "shieldedInstanceConfig":
            suggest = "shielded_instance_config"
        elif key == "upgradeSettings":
            suggest = "upgrade_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoprovisioningNodePoolDefaultsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoprovisioningNodePoolDefaultsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoprovisioningNodePoolDefaultsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 boot_disk_kms_key: str,
                 disk_size_gb: int,
                 disk_type: str,
                 image_type: str,
                 management: 'outputs.NodeManagementResponse',
                 min_cpu_platform: str,
                 oauth_scopes: Sequence[str],
                 service_account: str,
                 shielded_instance_config: 'outputs.ShieldedInstanceConfigResponse',
                 upgrade_settings: 'outputs.UpgradeSettingsResponse'):
        """
        AutoprovisioningNodePoolDefaults contains defaults for a node pool created by NAP.
        :param str boot_disk_kms_key: The Customer Managed Encryption Key used to encrypt the boot disk attached to each node in the node pool. This should be of the form projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME]. For more information about protecting resources with Cloud KMS Keys please see: https://cloud.google.com/compute/docs/disks/customer-managed-encryption
        :param int disk_size_gb: Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB. If unspecified, the default disk size is 100GB.
        :param str disk_type: Type of the disk attached to each node (e.g. 'pd-standard', 'pd-ssd' or 'pd-balanced') If unspecified, the default disk type is 'pd-standard'
        :param str image_type: The image type to use for NAP created node. Please see https://cloud.google.com/kubernetes-engine/docs/concepts/node-images for available image types.
        :param 'NodeManagementResponse' management: Specifies the node management options for NAP created node-pools.
        :param str min_cpu_platform: Deprecated. Minimum CPU platform to be used for NAP created node pools. The instance may be scheduled on the specified or newer CPU platform. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: Intel Haswell or minCpuPlatform: Intel Sandy Bridge. For more information, read [how to specify min CPU platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform). This field is deprecated, min_cpu_platform should be specified using `cloud.google.com/requested-min-cpu-platform` label selector on the pod. To unset the min cpu platform field pass "automatic" as field value.
        :param Sequence[str] oauth_scopes: Scopes that are used by NAP when creating node pools.
        :param str service_account: The Google Cloud Platform Service Account to be used by the node VMs.
        :param 'ShieldedInstanceConfigResponse' shielded_instance_config: Shielded Instance options.
        :param 'UpgradeSettingsResponse' upgrade_settings: Specifies the upgrade settings for NAP created node pools
        """
        pulumi.set(__self__, "boot_disk_kms_key", boot_disk_kms_key)
        pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        pulumi.set(__self__, "disk_type", disk_type)
        pulumi.set(__self__, "image_type", image_type)
        pulumi.set(__self__, "management", management)
        pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        pulumi.set(__self__, "oauth_scopes", oauth_scopes)
        pulumi.set(__self__, "service_account", service_account)
        pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        pulumi.set(__self__, "upgrade_settings", upgrade_settings)

    @property
    @pulumi.getter(name="bootDiskKmsKey")
    def boot_disk_kms_key(self) -> str:
        """
        The Customer Managed Encryption Key used to encrypt the boot disk attached to each node in the node pool. This should be of the form projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME]. For more information about protecting resources with Cloud KMS Keys please see: https://cloud.google.com/compute/docs/disks/customer-managed-encryption
        """
        return pulumi.get(self, "boot_disk_kms_key")

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> int:
        """
        Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB. If unspecified, the default disk size is 100GB.
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> str:
        """
        Type of the disk attached to each node (e.g. 'pd-standard', 'pd-ssd' or 'pd-balanced') If unspecified, the default disk type is 'pd-standard'
        """
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter(name="imageType")
    def image_type(self) -> str:
        """
        The image type to use for NAP created node. Please see https://cloud.google.com/kubernetes-engine/docs/concepts/node-images for available image types.
        """
        return pulumi.get(self, "image_type")

    @property
    @pulumi.getter
    def management(self) -> 'outputs.NodeManagementResponse':
        """
        Specifies the node management options for NAP created node-pools.
        """
        return pulumi.get(self, "management")

    @property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> str:
        """
        Deprecated. Minimum CPU platform to be used for NAP created node pools. The instance may be scheduled on the specified or newer CPU platform. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: Intel Haswell or minCpuPlatform: Intel Sandy Bridge. For more information, read [how to specify min CPU platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform). This field is deprecated, min_cpu_platform should be specified using `cloud.google.com/requested-min-cpu-platform` label selector on the pod. To unset the min cpu platform field pass "automatic" as field value.
        """
        return pulumi.get(self, "min_cpu_platform")

    @property
    @pulumi.getter(name="oauthScopes")
    def oauth_scopes(self) -> Sequence[str]:
        """
        Scopes that are used by NAP when creating node pools.
        """
        return pulumi.get(self, "oauth_scopes")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> str:
        """
        The Google Cloud Platform Service Account to be used by the node VMs.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> 'outputs.ShieldedInstanceConfigResponse':
        """
        Shielded Instance options.
        """
        return pulumi.get(self, "shielded_instance_config")

    @property
    @pulumi.getter(name="upgradeSettings")
    def upgrade_settings(self) -> 'outputs.UpgradeSettingsResponse':
        """
        Specifies the upgrade settings for NAP created node pools
        """
        return pulumi.get(self, "upgrade_settings")


@pulumi.output_type
class BigQueryDestinationResponse(dict):
    """
    Parameters for using BigQuery as the destination of resource usage export.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetId":
            suggest = "dataset_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BigQueryDestinationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BigQueryDestinationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BigQueryDestinationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_id: str):
        """
        Parameters for using BigQuery as the destination of resource usage export.
        :param str dataset_id: The ID of a BigQuery Dataset.
        """
        pulumi.set(__self__, "dataset_id", dataset_id)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> str:
        """
        The ID of a BigQuery Dataset.
        """
        return pulumi.get(self, "dataset_id")


@pulumi.output_type
class BinaryAuthorizationResponse(dict):
    """
    Configuration for Binary Authorization.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "evaluationMode":
            suggest = "evaluation_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BinaryAuthorizationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BinaryAuthorizationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BinaryAuthorizationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 evaluation_mode: str):
        """
        Configuration for Binary Authorization.
        :param bool enabled: This field is deprecated. Leave this unset and instead configure BinaryAuthorization using evaluation_mode. If evaluation_mode is set to anything other than EVALUATION_MODE_UNSPECIFIED, this field is ignored.
        :param str evaluation_mode: Mode of operation for binauthz policy evaluation. If unspecified, defaults to DISABLED.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "evaluation_mode", evaluation_mode)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        This field is deprecated. Leave this unset and instead configure BinaryAuthorization using evaluation_mode. If evaluation_mode is set to anything other than EVALUATION_MODE_UNSPECIFIED, this field is ignored.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="evaluationMode")
    def evaluation_mode(self) -> str:
        """
        Mode of operation for binauthz policy evaluation. If unspecified, defaults to DISABLED.
        """
        return pulumi.get(self, "evaluation_mode")


@pulumi.output_type
class BlueGreenInfoResponse(dict):
    """
    Information relevant to blue-green upgrade.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blueInstanceGroupUrls":
            suggest = "blue_instance_group_urls"
        elif key == "bluePoolDeletionStartTime":
            suggest = "blue_pool_deletion_start_time"
        elif key == "greenInstanceGroupUrls":
            suggest = "green_instance_group_urls"
        elif key == "greenPoolVersion":
            suggest = "green_pool_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BlueGreenInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BlueGreenInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BlueGreenInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 blue_instance_group_urls: Sequence[str],
                 blue_pool_deletion_start_time: str,
                 green_instance_group_urls: Sequence[str],
                 green_pool_version: str,
                 phase: str):
        """
        Information relevant to blue-green upgrade.
        :param Sequence[str] blue_instance_group_urls: The resource URLs of the [managed instance groups] (/compute/docs/instance-groups/creating-groups-of-managed-instances) associated with blue pool.
        :param str blue_pool_deletion_start_time: Time to start deleting blue pool to complete blue-green upgrade, in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
        :param Sequence[str] green_instance_group_urls: The resource URLs of the [managed instance groups] (/compute/docs/instance-groups/creating-groups-of-managed-instances) associated with green pool.
        :param str green_pool_version: Version of green pool.
        :param str phase: Current blue-green upgrade phase.
        """
        pulumi.set(__self__, "blue_instance_group_urls", blue_instance_group_urls)
        pulumi.set(__self__, "blue_pool_deletion_start_time", blue_pool_deletion_start_time)
        pulumi.set(__self__, "green_instance_group_urls", green_instance_group_urls)
        pulumi.set(__self__, "green_pool_version", green_pool_version)
        pulumi.set(__self__, "phase", phase)

    @property
    @pulumi.getter(name="blueInstanceGroupUrls")
    def blue_instance_group_urls(self) -> Sequence[str]:
        """
        The resource URLs of the [managed instance groups] (/compute/docs/instance-groups/creating-groups-of-managed-instances) associated with blue pool.
        """
        return pulumi.get(self, "blue_instance_group_urls")

    @property
    @pulumi.getter(name="bluePoolDeletionStartTime")
    def blue_pool_deletion_start_time(self) -> str:
        """
        Time to start deleting blue pool to complete blue-green upgrade, in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
        """
        return pulumi.get(self, "blue_pool_deletion_start_time")

    @property
    @pulumi.getter(name="greenInstanceGroupUrls")
    def green_instance_group_urls(self) -> Sequence[str]:
        """
        The resource URLs of the [managed instance groups] (/compute/docs/instance-groups/creating-groups-of-managed-instances) associated with green pool.
        """
        return pulumi.get(self, "green_instance_group_urls")

    @property
    @pulumi.getter(name="greenPoolVersion")
    def green_pool_version(self) -> str:
        """
        Version of green pool.
        """
        return pulumi.get(self, "green_pool_version")

    @property
    @pulumi.getter
    def phase(self) -> str:
        """
        Current blue-green upgrade phase.
        """
        return pulumi.get(self, "phase")


@pulumi.output_type
class BlueGreenSettingsResponse(dict):
    """
    Settings for blue-green upgrade.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodePoolSoakDuration":
            suggest = "node_pool_soak_duration"
        elif key == "standardRolloutPolicy":
            suggest = "standard_rollout_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BlueGreenSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BlueGreenSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BlueGreenSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_pool_soak_duration: str,
                 standard_rollout_policy: 'outputs.StandardRolloutPolicyResponse'):
        """
        Settings for blue-green upgrade.
        :param str node_pool_soak_duration: Time needed after draining entire blue pool. After this period, blue pool will be cleaned up.
        :param 'StandardRolloutPolicyResponse' standard_rollout_policy: Standard policy for the blue-green upgrade.
        """
        pulumi.set(__self__, "node_pool_soak_duration", node_pool_soak_duration)
        pulumi.set(__self__, "standard_rollout_policy", standard_rollout_policy)

    @property
    @pulumi.getter(name="nodePoolSoakDuration")
    def node_pool_soak_duration(self) -> str:
        """
        Time needed after draining entire blue pool. After this period, blue pool will be cleaned up.
        """
        return pulumi.get(self, "node_pool_soak_duration")

    @property
    @pulumi.getter(name="standardRolloutPolicy")
    def standard_rollout_policy(self) -> 'outputs.StandardRolloutPolicyResponse':
        """
        Standard policy for the blue-green upgrade.
        """
        return pulumi.get(self, "standard_rollout_policy")


@pulumi.output_type
class CidrBlockResponse(dict):
    """
    CidrBlock contains an optional name and one CIDR block.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cidrBlock":
            suggest = "cidr_block"
        elif key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CidrBlockResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CidrBlockResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CidrBlockResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cidr_block: str,
                 display_name: str):
        """
        CidrBlock contains an optional name and one CIDR block.
        :param str cidr_block: cidr_block must be specified in CIDR notation.
        :param str display_name: display_name is an optional field for users to identify CIDR blocks.
        """
        pulumi.set(__self__, "cidr_block", cidr_block)
        pulumi.set(__self__, "display_name", display_name)

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> str:
        """
        cidr_block must be specified in CIDR notation.
        """
        return pulumi.get(self, "cidr_block")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        display_name is an optional field for users to identify CIDR blocks.
        """
        return pulumi.get(self, "display_name")


@pulumi.output_type
class ClientCertificateConfigResponse(dict):
    """
    Configuration for client certificates on the cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "issueClientCertificate":
            suggest = "issue_client_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClientCertificateConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClientCertificateConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClientCertificateConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 issue_client_certificate: bool):
        """
        Configuration for client certificates on the cluster.
        :param bool issue_client_certificate: Issue a client certificate.
        """
        pulumi.set(__self__, "issue_client_certificate", issue_client_certificate)

    @property
    @pulumi.getter(name="issueClientCertificate")
    def issue_client_certificate(self) -> bool:
        """
        Issue a client certificate.
        """
        return pulumi.get(self, "issue_client_certificate")


@pulumi.output_type
class CloudRunConfigResponse(dict):
    """
    Configuration options for the Cloud Run feature.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "loadBalancerType":
            suggest = "load_balancer_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudRunConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudRunConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudRunConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disabled: bool,
                 load_balancer_type: str):
        """
        Configuration options for the Cloud Run feature.
        :param bool disabled: Whether Cloud Run addon is enabled for this cluster.
        :param str load_balancer_type: Which load balancer type is installed for Cloud Run.
        """
        pulumi.set(__self__, "disabled", disabled)
        pulumi.set(__self__, "load_balancer_type", load_balancer_type)

    @property
    @pulumi.getter
    def disabled(self) -> bool:
        """
        Whether Cloud Run addon is enabled for this cluster.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> str:
        """
        Which load balancer type is installed for Cloud Run.
        """
        return pulumi.get(self, "load_balancer_type")


@pulumi.output_type
class ClusterAutoscalingResponse(dict):
    """
    ClusterAutoscaling contains global, per-cluster information required by Cluster Autoscaler to automatically adjust the size of the cluster and create/delete node pools based on the current needs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoprovisioningLocations":
            suggest = "autoprovisioning_locations"
        elif key == "autoprovisioningNodePoolDefaults":
            suggest = "autoprovisioning_node_pool_defaults"
        elif key == "autoscalingProfile":
            suggest = "autoscaling_profile"
        elif key == "enableNodeAutoprovisioning":
            suggest = "enable_node_autoprovisioning"
        elif key == "resourceLimits":
            suggest = "resource_limits"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterAutoscalingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterAutoscalingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterAutoscalingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoprovisioning_locations: Sequence[str],
                 autoprovisioning_node_pool_defaults: 'outputs.AutoprovisioningNodePoolDefaultsResponse',
                 autoscaling_profile: str,
                 enable_node_autoprovisioning: bool,
                 resource_limits: Sequence['outputs.ResourceLimitResponse']):
        """
        ClusterAutoscaling contains global, per-cluster information required by Cluster Autoscaler to automatically adjust the size of the cluster and create/delete node pools based on the current needs.
        :param Sequence[str] autoprovisioning_locations: The list of Google Compute Engine [zones](https://cloud.google.com/compute/docs/zones#available) in which the NodePool's nodes can be created by NAP.
        :param 'AutoprovisioningNodePoolDefaultsResponse' autoprovisioning_node_pool_defaults: AutoprovisioningNodePoolDefaults contains defaults for a node pool created by NAP.
        :param str autoscaling_profile: Defines autoscaling behaviour.
        :param bool enable_node_autoprovisioning: Enables automatic node pool creation and deletion.
        :param Sequence['ResourceLimitResponse'] resource_limits: Contains global constraints regarding minimum and maximum amount of resources in the cluster.
        """
        pulumi.set(__self__, "autoprovisioning_locations", autoprovisioning_locations)
        pulumi.set(__self__, "autoprovisioning_node_pool_defaults", autoprovisioning_node_pool_defaults)
        pulumi.set(__self__, "autoscaling_profile", autoscaling_profile)
        pulumi.set(__self__, "enable_node_autoprovisioning", enable_node_autoprovisioning)
        pulumi.set(__self__, "resource_limits", resource_limits)

    @property
    @pulumi.getter(name="autoprovisioningLocations")
    def autoprovisioning_locations(self) -> Sequence[str]:
        """
        The list of Google Compute Engine [zones](https://cloud.google.com/compute/docs/zones#available) in which the NodePool's nodes can be created by NAP.
        """
        return pulumi.get(self, "autoprovisioning_locations")

    @property
    @pulumi.getter(name="autoprovisioningNodePoolDefaults")
    def autoprovisioning_node_pool_defaults(self) -> 'outputs.AutoprovisioningNodePoolDefaultsResponse':
        """
        AutoprovisioningNodePoolDefaults contains defaults for a node pool created by NAP.
        """
        return pulumi.get(self, "autoprovisioning_node_pool_defaults")

    @property
    @pulumi.getter(name="autoscalingProfile")
    def autoscaling_profile(self) -> str:
        """
        Defines autoscaling behaviour.
        """
        return pulumi.get(self, "autoscaling_profile")

    @property
    @pulumi.getter(name="enableNodeAutoprovisioning")
    def enable_node_autoprovisioning(self) -> bool:
        """
        Enables automatic node pool creation and deletion.
        """
        return pulumi.get(self, "enable_node_autoprovisioning")

    @property
    @pulumi.getter(name="resourceLimits")
    def resource_limits(self) -> Sequence['outputs.ResourceLimitResponse']:
        """
        Contains global constraints regarding minimum and maximum amount of resources in the cluster.
        """
        return pulumi.get(self, "resource_limits")


@pulumi.output_type
class ConfidentialNodesResponse(dict):
    """
    ConfidentialNodes is configuration for the confidential nodes feature, which makes nodes run on confidential VMs.
    """
    def __init__(__self__, *,
                 enabled: bool):
        """
        ConfidentialNodes is configuration for the confidential nodes feature, which makes nodes run on confidential VMs.
        :param bool enabled: Whether Confidential Nodes feature is enabled.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether Confidential Nodes feature is enabled.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ConfigConnectorConfigResponse(dict):
    """
    Configuration options for the Config Connector add-on.
    """
    def __init__(__self__, *,
                 enabled: bool):
        """
        Configuration options for the Config Connector add-on.
        :param bool enabled: Whether Cloud Connector is enabled for this cluster.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether Cloud Connector is enabled for this cluster.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ConsumptionMeteringConfigResponse(dict):
    """
    Parameters for controlling consumption metering.
    """
    def __init__(__self__, *,
                 enabled: bool):
        """
        Parameters for controlling consumption metering.
        :param bool enabled: Whether to enable consumption metering for this cluster. If enabled, a second BigQuery table will be created to hold resource consumption records.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether to enable consumption metering for this cluster. If enabled, a second BigQuery table will be created to hold resource consumption records.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class CostManagementConfigResponse(dict):
    """
    Configuration for fine-grained cost management feature.
    """
    def __init__(__self__, *,
                 enabled: bool):
        """
        Configuration for fine-grained cost management feature.
        :param bool enabled: Whether the feature is enabled or not.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether the feature is enabled or not.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class DNSConfigResponse(dict):
    """
    DNSConfig contains the desired set of options for configuring clusterDNS.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterDns":
            suggest = "cluster_dns"
        elif key == "clusterDnsDomain":
            suggest = "cluster_dns_domain"
        elif key == "clusterDnsScope":
            suggest = "cluster_dns_scope"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DNSConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DNSConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DNSConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_dns: str,
                 cluster_dns_domain: str,
                 cluster_dns_scope: str):
        """
        DNSConfig contains the desired set of options for configuring clusterDNS.
        :param str cluster_dns: cluster_dns indicates which in-cluster DNS provider should be used.
        :param str cluster_dns_domain: cluster_dns_domain is the suffix used for all cluster service records.
        :param str cluster_dns_scope: cluster_dns_scope indicates the scope of access to cluster DNS records.
        """
        pulumi.set(__self__, "cluster_dns", cluster_dns)
        pulumi.set(__self__, "cluster_dns_domain", cluster_dns_domain)
        pulumi.set(__self__, "cluster_dns_scope", cluster_dns_scope)

    @property
    @pulumi.getter(name="clusterDns")
    def cluster_dns(self) -> str:
        """
        cluster_dns indicates which in-cluster DNS provider should be used.
        """
        return pulumi.get(self, "cluster_dns")

    @property
    @pulumi.getter(name="clusterDnsDomain")
    def cluster_dns_domain(self) -> str:
        """
        cluster_dns_domain is the suffix used for all cluster service records.
        """
        return pulumi.get(self, "cluster_dns_domain")

    @property
    @pulumi.getter(name="clusterDnsScope")
    def cluster_dns_scope(self) -> str:
        """
        cluster_dns_scope indicates the scope of access to cluster DNS records.
        """
        return pulumi.get(self, "cluster_dns_scope")


@pulumi.output_type
class DailyMaintenanceWindowResponse(dict):
    """
    Time window specified for daily maintenance operations.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DailyMaintenanceWindowResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DailyMaintenanceWindowResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DailyMaintenanceWindowResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration: str,
                 start_time: str):
        """
        Time window specified for daily maintenance operations.
        :param str duration: [Output only] Duration of the time window, automatically chosen to be smallest possible in the given scenario. Duration will be in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) format "PTnHnMnS".
        :param str start_time: Time within the maintenance window to start the maintenance operations. Time format should be in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) format "HH:MM", where HH : [00-23] and MM : [00-59] GMT.
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter
    def duration(self) -> str:
        """
        [Output only] Duration of the time window, automatically chosen to be smallest possible in the given scenario. Duration will be in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) format "PTnHnMnS".
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Time within the maintenance window to start the maintenance operations. Time format should be in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) format "HH:MM", where HH : [00-23] and MM : [00-59] GMT.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class DatabaseEncryptionResponse(dict):
    """
    Configuration of etcd encryption.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyName":
            suggest = "key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseEncryptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseEncryptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseEncryptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_name: str,
                 state: str):
        """
        Configuration of etcd encryption.
        :param str key_name: Name of CloudKMS key to use for the encryption of secrets in etcd. Ex. projects/my-project/locations/global/keyRings/my-ring/cryptoKeys/my-key
        :param str state: Denotes the state of etcd encryption.
        """
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> str:
        """
        Name of CloudKMS key to use for the encryption of secrets in etcd. Ex. projects/my-project/locations/global/keyRings/my-ring/cryptoKeys/my-key
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Denotes the state of etcd encryption.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class DefaultSnatStatusResponse(dict):
    """
    DefaultSnatStatus contains the desired state of whether default sNAT should be disabled on the cluster.
    """
    def __init__(__self__, *,
                 disabled: bool):
        """
        DefaultSnatStatus contains the desired state of whether default sNAT should be disabled on the cluster.
        :param bool disabled: Disables cluster default sNAT rules.
        """
        pulumi.set(__self__, "disabled", disabled)

    @property
    @pulumi.getter
    def disabled(self) -> bool:
        """
        Disables cluster default sNAT rules.
        """
        return pulumi.get(self, "disabled")


@pulumi.output_type
class DnsCacheConfigResponse(dict):
    """
    Configuration for NodeLocal DNSCache
    """
    def __init__(__self__, *,
                 enabled: bool):
        """
        Configuration for NodeLocal DNSCache
        :param bool enabled: Whether NodeLocal DNSCache is enabled for this cluster.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether NodeLocal DNSCache is enabled for this cluster.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class EphemeralStorageLocalSsdConfigResponse(dict):
    """
    EphemeralStorageLocalSsdConfig contains configuration for the node ephemeral storage using Local SSD.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localSsdCount":
            suggest = "local_ssd_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EphemeralStorageLocalSsdConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EphemeralStorageLocalSsdConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EphemeralStorageLocalSsdConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 local_ssd_count: int):
        """
        EphemeralStorageLocalSsdConfig contains configuration for the node ephemeral storage using Local SSD.
        :param int local_ssd_count: Number of local SSDs to use to back ephemeral storage. Uses NVMe interfaces. Each local SSD is 375 GB in size. If zero, it means to disable using local SSDs as ephemeral storage. The limit for this value is dependent upon the maximum number of disks available on a machine per zone. See: https://cloud.google.com/compute/docs/disks/local-ssd for more information.
        """
        pulumi.set(__self__, "local_ssd_count", local_ssd_count)

    @property
    @pulumi.getter(name="localSsdCount")
    def local_ssd_count(self) -> int:
        """
        Number of local SSDs to use to back ephemeral storage. Uses NVMe interfaces. Each local SSD is 375 GB in size. If zero, it means to disable using local SSDs as ephemeral storage. The limit for this value is dependent upon the maximum number of disks available on a machine per zone. See: https://cloud.google.com/compute/docs/disks/local-ssd for more information.
        """
        return pulumi.get(self, "local_ssd_count")


@pulumi.output_type
class FastSocketResponse(dict):
    """
    Configuration of Fast Socket feature.
    """
    def __init__(__self__, *,
                 enabled: bool):
        """
        Configuration of Fast Socket feature.
        :param bool enabled: Whether Fast Socket features are enabled in the node pool.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether Fast Socket features are enabled in the node pool.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class FilterResponse(dict):
    """
    Allows filtering to one or more specific event types. If event types are present, those and only those event types will be transmitted to the cluster. Other types will be skipped. If no filter is specified, or no event types are present, all event types will be sent
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventType":
            suggest = "event_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_type: Sequence[str]):
        """
        Allows filtering to one or more specific event types. If event types are present, those and only those event types will be transmitted to the cluster. Other types will be skipped. If no filter is specified, or no event types are present, all event types will be sent
        :param Sequence[str] event_type: Event types to allowlist.
        """
        pulumi.set(__self__, "event_type", event_type)

    @property
    @pulumi.getter(name="eventType")
    def event_type(self) -> Sequence[str]:
        """
        Event types to allowlist.
        """
        return pulumi.get(self, "event_type")


@pulumi.output_type
class GPUSharingConfigResponse(dict):
    """
    GPUSharingConfig represents the GPU sharing configuration for Hardware Accelerators.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gpuSharingStrategy":
            suggest = "gpu_sharing_strategy"
        elif key == "maxSharedClientsPerGpu":
            suggest = "max_shared_clients_per_gpu"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GPUSharingConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GPUSharingConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GPUSharingConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gpu_sharing_strategy: str,
                 max_shared_clients_per_gpu: str):
        """
        GPUSharingConfig represents the GPU sharing configuration for Hardware Accelerators.
        :param str gpu_sharing_strategy: The type of GPU sharing strategy to enable on the GPU node.
        :param str max_shared_clients_per_gpu: The max number of containers that can share a physical GPU.
        """
        pulumi.set(__self__, "gpu_sharing_strategy", gpu_sharing_strategy)
        pulumi.set(__self__, "max_shared_clients_per_gpu", max_shared_clients_per_gpu)

    @property
    @pulumi.getter(name="gpuSharingStrategy")
    def gpu_sharing_strategy(self) -> str:
        """
        The type of GPU sharing strategy to enable on the GPU node.
        """
        return pulumi.get(self, "gpu_sharing_strategy")

    @property
    @pulumi.getter(name="maxSharedClientsPerGpu")
    def max_shared_clients_per_gpu(self) -> str:
        """
        The max number of containers that can share a physical GPU.
        """
        return pulumi.get(self, "max_shared_clients_per_gpu")


@pulumi.output_type
class GatewayAPIConfigResponse(dict):
    """
    GatewayAPIConfig contains the desired config of Gateway API on this cluster.
    """
    def __init__(__self__, *,
                 channel: str):
        """
        GatewayAPIConfig contains the desired config of Gateway API on this cluster.
        :param str channel: The Gateway API release channel to use for Gateway API.
        """
        pulumi.set(__self__, "channel", channel)

    @property
    @pulumi.getter
    def channel(self) -> str:
        """
        The Gateway API release channel to use for Gateway API.
        """
        return pulumi.get(self, "channel")


@pulumi.output_type
class GcePersistentDiskCsiDriverConfigResponse(dict):
    """
    Configuration for the Compute Engine PD CSI driver.
    """
    def __init__(__self__, *,
                 enabled: bool):
        """
        Configuration for the Compute Engine PD CSI driver.
        :param bool enabled: Whether the Compute Engine PD CSI driver is enabled for this cluster.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether the Compute Engine PD CSI driver is enabled for this cluster.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GcfsConfigResponse(dict):
    """
    GcfsConfig contains configurations of Google Container File System (image streaming).
    """
    def __init__(__self__, *,
                 enabled: bool):
        """
        GcfsConfig contains configurations of Google Container File System (image streaming).
        :param bool enabled: Whether to use GCFS.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether to use GCFS.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GcpFilestoreCsiDriverConfigResponse(dict):
    """
    Configuration for the GCP Filestore CSI driver.
    """
    def __init__(__self__, *,
                 enabled: bool):
        """
        Configuration for the GCP Filestore CSI driver.
        :param bool enabled: Whether the GCP Filestore CSI driver is enabled for this cluster.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether the GCP Filestore CSI driver is enabled for this cluster.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GkeBackupAgentConfigResponse(dict):
    """
    Configuration for the Backup for GKE Agent.
    """
    def __init__(__self__, *,
                 enabled: bool):
        """
        Configuration for the Backup for GKE Agent.
        :param bool enabled: Whether the Backup for GKE agent is enabled for this cluster.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether the Backup for GKE agent is enabled for this cluster.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class HorizontalPodAutoscalingResponse(dict):
    """
    Configuration options for the horizontal pod autoscaling feature, which increases or decreases the number of replica pods a replication controller has based on the resource usage of the existing pods.
    """
    def __init__(__self__, *,
                 disabled: bool):
        """
        Configuration options for the horizontal pod autoscaling feature, which increases or decreases the number of replica pods a replication controller has based on the resource usage of the existing pods.
        :param bool disabled: Whether the Horizontal Pod Autoscaling feature is enabled in the cluster. When enabled, it ensures that metrics are collected into Stackdriver Monitoring.
        """
        pulumi.set(__self__, "disabled", disabled)

    @property
    @pulumi.getter
    def disabled(self) -> bool:
        """
        Whether the Horizontal Pod Autoscaling feature is enabled in the cluster. When enabled, it ensures that metrics are collected into Stackdriver Monitoring.
        """
        return pulumi.get(self, "disabled")


@pulumi.output_type
class HttpLoadBalancingResponse(dict):
    """
    Configuration options for the HTTP (L7) load balancing controller addon, which makes it easy to set up HTTP load balancers for services in a cluster.
    """
    def __init__(__self__, *,
                 disabled: bool):
        """
        Configuration options for the HTTP (L7) load balancing controller addon, which makes it easy to set up HTTP load balancers for services in a cluster.
        :param bool disabled: Whether the HTTP Load Balancing controller is enabled in the cluster. When enabled, it runs a small pod in the cluster that manages the load balancers.
        """
        pulumi.set(__self__, "disabled", disabled)

    @property
    @pulumi.getter
    def disabled(self) -> bool:
        """
        Whether the HTTP Load Balancing controller is enabled in the cluster. When enabled, it runs a small pod in the cluster that manages the load balancers.
        """
        return pulumi.get(self, "disabled")


@pulumi.output_type
class IPAllocationPolicyResponse(dict):
    """
    Configuration for controlling how IPs are allocated in the cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterIpv4Cidr":
            suggest = "cluster_ipv4_cidr"
        elif key == "clusterIpv4CidrBlock":
            suggest = "cluster_ipv4_cidr_block"
        elif key == "clusterSecondaryRangeName":
            suggest = "cluster_secondary_range_name"
        elif key == "createSubnetwork":
            suggest = "create_subnetwork"
        elif key == "ipv6AccessType":
            suggest = "ipv6_access_type"
        elif key == "nodeIpv4Cidr":
            suggest = "node_ipv4_cidr"
        elif key == "nodeIpv4CidrBlock":
            suggest = "node_ipv4_cidr_block"
        elif key == "servicesIpv4Cidr":
            suggest = "services_ipv4_cidr"
        elif key == "servicesIpv4CidrBlock":
            suggest = "services_ipv4_cidr_block"
        elif key == "servicesIpv6CidrBlock":
            suggest = "services_ipv6_cidr_block"
        elif key == "servicesSecondaryRangeName":
            suggest = "services_secondary_range_name"
        elif key == "stackType":
            suggest = "stack_type"
        elif key == "subnetIpv6CidrBlock":
            suggest = "subnet_ipv6_cidr_block"
        elif key == "subnetworkName":
            suggest = "subnetwork_name"
        elif key == "tpuIpv4CidrBlock":
            suggest = "tpu_ipv4_cidr_block"
        elif key == "useIpAliases":
            suggest = "use_ip_aliases"
        elif key == "useRoutes":
            suggest = "use_routes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IPAllocationPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IPAllocationPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IPAllocationPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_ipv4_cidr: str,
                 cluster_ipv4_cidr_block: str,
                 cluster_secondary_range_name: str,
                 create_subnetwork: bool,
                 ipv6_access_type: str,
                 node_ipv4_cidr: str,
                 node_ipv4_cidr_block: str,
                 services_ipv4_cidr: str,
                 services_ipv4_cidr_block: str,
                 services_ipv6_cidr_block: str,
                 services_secondary_range_name: str,
                 stack_type: str,
                 subnet_ipv6_cidr_block: str,
                 subnetwork_name: str,
                 tpu_ipv4_cidr_block: str,
                 use_ip_aliases: bool,
                 use_routes: bool):
        """
        Configuration for controlling how IPs are allocated in the cluster.
        :param str cluster_ipv4_cidr: This field is deprecated, use cluster_ipv4_cidr_block.
        :param str cluster_ipv4_cidr_block: The IP address range for the cluster pod IPs. If this field is set, then `cluster.cluster_ipv4_cidr` must be left blank. This field is only applicable when `use_ip_aliases` is true. Set to blank to have a range chosen with the default size. Set to /netmask (e.g. `/14`) to have a range chosen with a specific netmask. Set to a [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g. `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range to use.
        :param str cluster_secondary_range_name: The name of the secondary range to be used for the cluster CIDR block. The secondary range will be used for pod IP addresses. This must be an existing secondary range associated with the cluster subnetwork. This field is only applicable with use_ip_aliases is true and create_subnetwork is false.
        :param bool create_subnetwork: Whether a new subnetwork will be created automatically for the cluster. This field is only applicable when `use_ip_aliases` is true.
        :param str ipv6_access_type: The ipv6 access type (internal or external) when create_subnetwork is true
        :param str node_ipv4_cidr: This field is deprecated, use node_ipv4_cidr_block.
        :param str node_ipv4_cidr_block: The IP address range of the instance IPs in this cluster. This is applicable only if `create_subnetwork` is true. Set to blank to have a range chosen with the default size. Set to /netmask (e.g. `/14`) to have a range chosen with a specific netmask. Set to a [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g. `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range to use.
        :param str services_ipv4_cidr: This field is deprecated, use services_ipv4_cidr_block.
        :param str services_ipv4_cidr_block: The IP address range of the services IPs in this cluster. If blank, a range will be automatically chosen with the default size. This field is only applicable when `use_ip_aliases` is true. Set to blank to have a range chosen with the default size. Set to /netmask (e.g. `/14`) to have a range chosen with a specific netmask. Set to a [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g. `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range to use.
        :param str services_ipv6_cidr_block: [Output only] The services IPv6 CIDR block for the cluster.
        :param str services_secondary_range_name: The name of the secondary range to be used as for the services CIDR block. The secondary range will be used for service ClusterIPs. This must be an existing secondary range associated with the cluster subnetwork. This field is only applicable with use_ip_aliases is true and create_subnetwork is false.
        :param str stack_type: The IP stack type of the cluster
        :param str subnet_ipv6_cidr_block: [Output only] The subnet's IPv6 CIDR block used by nodes and pods.
        :param str subnetwork_name: A custom subnetwork name to be used if `create_subnetwork` is true. If this field is empty, then an automatic name will be chosen for the new subnetwork.
        :param str tpu_ipv4_cidr_block: The IP address range of the Cloud TPUs in this cluster. If unspecified, a range will be automatically chosen with the default size. This field is only applicable when `use_ip_aliases` is true. If unspecified, the range will use the default size. Set to /netmask (e.g. `/14`) to have a range chosen with a specific netmask. Set to a [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g. `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range to use.
        :param bool use_ip_aliases: Whether alias IPs will be used for pod IPs in the cluster. This is used in conjunction with use_routes. It cannot be true if use_routes is true. If both use_ip_aliases and use_routes are false, then the server picks the default IP allocation mode
        :param bool use_routes: Whether routes will be used for pod IPs in the cluster. This is used in conjunction with use_ip_aliases. It cannot be true if use_ip_aliases is true. If both use_ip_aliases and use_routes are false, then the server picks the default IP allocation mode
        """
        pulumi.set(__self__, "cluster_ipv4_cidr", cluster_ipv4_cidr)
        pulumi.set(__self__, "cluster_ipv4_cidr_block", cluster_ipv4_cidr_block)
        pulumi.set(__self__, "cluster_secondary_range_name", cluster_secondary_range_name)
        pulumi.set(__self__, "create_subnetwork", create_subnetwork)
        pulumi.set(__self__, "ipv6_access_type", ipv6_access_type)
        pulumi.set(__self__, "node_ipv4_cidr", node_ipv4_cidr)
        pulumi.set(__self__, "node_ipv4_cidr_block", node_ipv4_cidr_block)
        pulumi.set(__self__, "services_ipv4_cidr", services_ipv4_cidr)
        pulumi.set(__self__, "services_ipv4_cidr_block", services_ipv4_cidr_block)
        pulumi.set(__self__, "services_ipv6_cidr_block", services_ipv6_cidr_block)
        pulumi.set(__self__, "services_secondary_range_name", services_secondary_range_name)
        pulumi.set(__self__, "stack_type", stack_type)
        pulumi.set(__self__, "subnet_ipv6_cidr_block", subnet_ipv6_cidr_block)
        pulumi.set(__self__, "subnetwork_name", subnetwork_name)
        pulumi.set(__self__, "tpu_ipv4_cidr_block", tpu_ipv4_cidr_block)
        pulumi.set(__self__, "use_ip_aliases", use_ip_aliases)
        pulumi.set(__self__, "use_routes", use_routes)

    @property
    @pulumi.getter(name="clusterIpv4Cidr")
    def cluster_ipv4_cidr(self) -> str:
        """
        This field is deprecated, use cluster_ipv4_cidr_block.
        """
        return pulumi.get(self, "cluster_ipv4_cidr")

    @property
    @pulumi.getter(name="clusterIpv4CidrBlock")
    def cluster_ipv4_cidr_block(self) -> str:
        """
        The IP address range for the cluster pod IPs. If this field is set, then `cluster.cluster_ipv4_cidr` must be left blank. This field is only applicable when `use_ip_aliases` is true. Set to blank to have a range chosen with the default size. Set to /netmask (e.g. `/14`) to have a range chosen with a specific netmask. Set to a [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g. `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range to use.
        """
        return pulumi.get(self, "cluster_ipv4_cidr_block")

    @property
    @pulumi.getter(name="clusterSecondaryRangeName")
    def cluster_secondary_range_name(self) -> str:
        """
        The name of the secondary range to be used for the cluster CIDR block. The secondary range will be used for pod IP addresses. This must be an existing secondary range associated with the cluster subnetwork. This field is only applicable with use_ip_aliases is true and create_subnetwork is false.
        """
        return pulumi.get(self, "cluster_secondary_range_name")

    @property
    @pulumi.getter(name="createSubnetwork")
    def create_subnetwork(self) -> bool:
        """
        Whether a new subnetwork will be created automatically for the cluster. This field is only applicable when `use_ip_aliases` is true.
        """
        return pulumi.get(self, "create_subnetwork")

    @property
    @pulumi.getter(name="ipv6AccessType")
    def ipv6_access_type(self) -> str:
        """
        The ipv6 access type (internal or external) when create_subnetwork is true
        """
        return pulumi.get(self, "ipv6_access_type")

    @property
    @pulumi.getter(name="nodeIpv4Cidr")
    def node_ipv4_cidr(self) -> str:
        """
        This field is deprecated, use node_ipv4_cidr_block.
        """
        return pulumi.get(self, "node_ipv4_cidr")

    @property
    @pulumi.getter(name="nodeIpv4CidrBlock")
    def node_ipv4_cidr_block(self) -> str:
        """
        The IP address range of the instance IPs in this cluster. This is applicable only if `create_subnetwork` is true. Set to blank to have a range chosen with the default size. Set to /netmask (e.g. `/14`) to have a range chosen with a specific netmask. Set to a [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g. `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range to use.
        """
        return pulumi.get(self, "node_ipv4_cidr_block")

    @property
    @pulumi.getter(name="servicesIpv4Cidr")
    def services_ipv4_cidr(self) -> str:
        """
        This field is deprecated, use services_ipv4_cidr_block.
        """
        return pulumi.get(self, "services_ipv4_cidr")

    @property
    @pulumi.getter(name="servicesIpv4CidrBlock")
    def services_ipv4_cidr_block(self) -> str:
        """
        The IP address range of the services IPs in this cluster. If blank, a range will be automatically chosen with the default size. This field is only applicable when `use_ip_aliases` is true. Set to blank to have a range chosen with the default size. Set to /netmask (e.g. `/14`) to have a range chosen with a specific netmask. Set to a [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g. `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range to use.
        """
        return pulumi.get(self, "services_ipv4_cidr_block")

    @property
    @pulumi.getter(name="servicesIpv6CidrBlock")
    def services_ipv6_cidr_block(self) -> str:
        """
        [Output only] The services IPv6 CIDR block for the cluster.
        """
        return pulumi.get(self, "services_ipv6_cidr_block")

    @property
    @pulumi.getter(name="servicesSecondaryRangeName")
    def services_secondary_range_name(self) -> str:
        """
        The name of the secondary range to be used as for the services CIDR block. The secondary range will be used for service ClusterIPs. This must be an existing secondary range associated with the cluster subnetwork. This field is only applicable with use_ip_aliases is true and create_subnetwork is false.
        """
        return pulumi.get(self, "services_secondary_range_name")

    @property
    @pulumi.getter(name="stackType")
    def stack_type(self) -> str:
        """
        The IP stack type of the cluster
        """
        return pulumi.get(self, "stack_type")

    @property
    @pulumi.getter(name="subnetIpv6CidrBlock")
    def subnet_ipv6_cidr_block(self) -> str:
        """
        [Output only] The subnet's IPv6 CIDR block used by nodes and pods.
        """
        return pulumi.get(self, "subnet_ipv6_cidr_block")

    @property
    @pulumi.getter(name="subnetworkName")
    def subnetwork_name(self) -> str:
        """
        A custom subnetwork name to be used if `create_subnetwork` is true. If this field is empty, then an automatic name will be chosen for the new subnetwork.
        """
        return pulumi.get(self, "subnetwork_name")

    @property
    @pulumi.getter(name="tpuIpv4CidrBlock")
    def tpu_ipv4_cidr_block(self) -> str:
        """
        The IP address range of the Cloud TPUs in this cluster. If unspecified, a range will be automatically chosen with the default size. This field is only applicable when `use_ip_aliases` is true. If unspecified, the range will use the default size. Set to /netmask (e.g. `/14`) to have a range chosen with a specific netmask. Set to a [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g. `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range to use.
        """
        return pulumi.get(self, "tpu_ipv4_cidr_block")

    @property
    @pulumi.getter(name="useIpAliases")
    def use_ip_aliases(self) -> bool:
        """
        Whether alias IPs will be used for pod IPs in the cluster. This is used in conjunction with use_routes. It cannot be true if use_routes is true. If both use_ip_aliases and use_routes are false, then the server picks the default IP allocation mode
        """
        return pulumi.get(self, "use_ip_aliases")

    @property
    @pulumi.getter(name="useRoutes")
    def use_routes(self) -> bool:
        """
        Whether routes will be used for pod IPs in the cluster. This is used in conjunction with use_ip_aliases. It cannot be true if use_ip_aliases is true. If both use_ip_aliases and use_routes are false, then the server picks the default IP allocation mode
        """
        return pulumi.get(self, "use_routes")


@pulumi.output_type
class IdentityServiceConfigResponse(dict):
    """
    IdentityServiceConfig is configuration for Identity Service which allows customers to use external identity providers with the K8S API
    """
    def __init__(__self__, *,
                 enabled: bool):
        """
        IdentityServiceConfig is configuration for Identity Service which allows customers to use external identity providers with the K8S API
        :param bool enabled: Whether to enable the Identity Service component
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether to enable the Identity Service component
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class KubernetesDashboardResponse(dict):
    """
    Configuration for the Kubernetes Dashboard.
    """
    def __init__(__self__, *,
                 disabled: bool):
        """
        Configuration for the Kubernetes Dashboard.
        :param bool disabled: Whether the Kubernetes Dashboard is enabled for this cluster.
        """
        pulumi.set(__self__, "disabled", disabled)

    @property
    @pulumi.getter
    def disabled(self) -> bool:
        """
        Whether the Kubernetes Dashboard is enabled for this cluster.
        """
        return pulumi.get(self, "disabled")


@pulumi.output_type
class LegacyAbacResponse(dict):
    """
    Configuration for the legacy Attribute Based Access Control authorization mode.
    """
    def __init__(__self__, *,
                 enabled: bool):
        """
        Configuration for the legacy Attribute Based Access Control authorization mode.
        :param bool enabled: Whether the ABAC authorizer is enabled for this cluster. When enabled, identities in the system, including service accounts, nodes, and controllers, will have statically granted permissions beyond those provided by the RBAC configuration or IAM.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether the ABAC authorizer is enabled for this cluster. When enabled, identities in the system, including service accounts, nodes, and controllers, will have statically granted permissions beyond those provided by the RBAC configuration or IAM.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class LinuxNodeConfigResponse(dict):
    """
    Parameters that can be configured on Linux nodes.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cgroupMode":
            suggest = "cgroup_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinuxNodeConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinuxNodeConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinuxNodeConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cgroup_mode: str,
                 sysctls: Mapping[str, str]):
        """
        Parameters that can be configured on Linux nodes.
        :param str cgroup_mode: cgroup_mode specifies the cgroup mode to be used on the node.
        :param Mapping[str, str] sysctls: The Linux kernel parameters to be applied to the nodes and all pods running on the nodes. The following parameters are supported. net.core.busy_poll net.core.busy_read net.core.netdev_max_backlog net.core.rmem_max net.core.wmem_default net.core.wmem_max net.core.optmem_max net.core.somaxconn net.ipv4.tcp_rmem net.ipv4.tcp_wmem net.ipv4.tcp_tw_reuse
        """
        pulumi.set(__self__, "cgroup_mode", cgroup_mode)
        pulumi.set(__self__, "sysctls", sysctls)

    @property
    @pulumi.getter(name="cgroupMode")
    def cgroup_mode(self) -> str:
        """
        cgroup_mode specifies the cgroup mode to be used on the node.
        """
        return pulumi.get(self, "cgroup_mode")

    @property
    @pulumi.getter
    def sysctls(self) -> Mapping[str, str]:
        """
        The Linux kernel parameters to be applied to the nodes and all pods running on the nodes. The following parameters are supported. net.core.busy_poll net.core.busy_read net.core.netdev_max_backlog net.core.rmem_max net.core.wmem_default net.core.wmem_max net.core.optmem_max net.core.somaxconn net.ipv4.tcp_rmem net.ipv4.tcp_wmem net.ipv4.tcp_tw_reuse
        """
        return pulumi.get(self, "sysctls")


@pulumi.output_type
class LocalNvmeSsdBlockConfigResponse(dict):
    """
    LocalNvmeSsdBlockConfig contains configuration for using raw-block local NVMe SSD.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localSsdCount":
            suggest = "local_ssd_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LocalNvmeSsdBlockConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LocalNvmeSsdBlockConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LocalNvmeSsdBlockConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 local_ssd_count: int):
        """
        LocalNvmeSsdBlockConfig contains configuration for using raw-block local NVMe SSD.
        :param int local_ssd_count: The number of raw-block local NVMe SSD disks to be attached to the node. Each local SSD is 375 GB in size. If zero, it means no raw-block local NVMe SSD disks to be attached to the node. The limit for this value is dependent upon the maximum number of disks available on a machine per zone. See: https://cloud.google.com/compute/docs/disks/local-ssd for more information.
        """
        pulumi.set(__self__, "local_ssd_count", local_ssd_count)

    @property
    @pulumi.getter(name="localSsdCount")
    def local_ssd_count(self) -> int:
        """
        The number of raw-block local NVMe SSD disks to be attached to the node. Each local SSD is 375 GB in size. If zero, it means no raw-block local NVMe SSD disks to be attached to the node. The limit for this value is dependent upon the maximum number of disks available on a machine per zone. See: https://cloud.google.com/compute/docs/disks/local-ssd for more information.
        """
        return pulumi.get(self, "local_ssd_count")


@pulumi.output_type
class LoggingComponentConfigResponse(dict):
    """
    LoggingComponentConfig is cluster logging component configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableComponents":
            suggest = "enable_components"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoggingComponentConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoggingComponentConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoggingComponentConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_components: Sequence[str]):
        """
        LoggingComponentConfig is cluster logging component configuration.
        :param Sequence[str] enable_components: Select components to collect logs. An empty set would disable all logging.
        """
        pulumi.set(__self__, "enable_components", enable_components)

    @property
    @pulumi.getter(name="enableComponents")
    def enable_components(self) -> Sequence[str]:
        """
        Select components to collect logs. An empty set would disable all logging.
        """
        return pulumi.get(self, "enable_components")


@pulumi.output_type
class LoggingConfigResponse(dict):
    """
    LoggingConfig is cluster logging configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "componentConfig":
            suggest = "component_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoggingConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoggingConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoggingConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 component_config: 'outputs.LoggingComponentConfigResponse'):
        """
        LoggingConfig is cluster logging configuration.
        :param 'LoggingComponentConfigResponse' component_config: Logging components configuration
        """
        pulumi.set(__self__, "component_config", component_config)

    @property
    @pulumi.getter(name="componentConfig")
    def component_config(self) -> 'outputs.LoggingComponentConfigResponse':
        """
        Logging components configuration
        """
        return pulumi.get(self, "component_config")


@pulumi.output_type
class LoggingVariantConfigResponse(dict):
    """
    LoggingVariantConfig specifies the behaviour of the logging component.
    """
    def __init__(__self__, *,
                 variant: str):
        """
        LoggingVariantConfig specifies the behaviour of the logging component.
        :param str variant: Logging variant deployed on nodes.
        """
        pulumi.set(__self__, "variant", variant)

    @property
    @pulumi.getter
    def variant(self) -> str:
        """
        Logging variant deployed on nodes.
        """
        return pulumi.get(self, "variant")


@pulumi.output_type
class MaintenanceExclusionOptionsResponse(dict):
    """
    Represents the Maintenance exclusion option.
    """
    def __init__(__self__, *,
                 scope: str):
        """
        Represents the Maintenance exclusion option.
        :param str scope: Scope specifies the upgrade scope which upgrades are blocked by the exclusion.
        """
        pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter
    def scope(self) -> str:
        """
        Scope specifies the upgrade scope which upgrades are blocked by the exclusion.
        """
        return pulumi.get(self, "scope")


@pulumi.output_type
class MaintenancePolicyResponse(dict):
    """
    MaintenancePolicy defines the maintenance policy to be used for the cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceVersion":
            suggest = "resource_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MaintenancePolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MaintenancePolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MaintenancePolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_version: str,
                 window: 'outputs.MaintenanceWindowResponse'):
        """
        MaintenancePolicy defines the maintenance policy to be used for the cluster.
        :param str resource_version: A hash identifying the version of this policy, so that updates to fields of the policy won't accidentally undo intermediate changes (and so that users of the API unaware of some fields won't accidentally remove other fields). Make a `get()` request to the cluster to get the current resource version and include it with requests to set the policy.
        :param 'MaintenanceWindowResponse' window: Specifies the maintenance window in which maintenance may be performed.
        """
        pulumi.set(__self__, "resource_version", resource_version)
        pulumi.set(__self__, "window", window)

    @property
    @pulumi.getter(name="resourceVersion")
    def resource_version(self) -> str:
        """
        A hash identifying the version of this policy, so that updates to fields of the policy won't accidentally undo intermediate changes (and so that users of the API unaware of some fields won't accidentally remove other fields). Make a `get()` request to the cluster to get the current resource version and include it with requests to set the policy.
        """
        return pulumi.get(self, "resource_version")

    @property
    @pulumi.getter
    def window(self) -> 'outputs.MaintenanceWindowResponse':
        """
        Specifies the maintenance window in which maintenance may be performed.
        """
        return pulumi.get(self, "window")


@pulumi.output_type
class MaintenanceWindowResponse(dict):
    """
    MaintenanceWindow defines the maintenance window to be used for the cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dailyMaintenanceWindow":
            suggest = "daily_maintenance_window"
        elif key == "maintenanceExclusions":
            suggest = "maintenance_exclusions"
        elif key == "recurringWindow":
            suggest = "recurring_window"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MaintenanceWindowResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MaintenanceWindowResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MaintenanceWindowResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 daily_maintenance_window: 'outputs.DailyMaintenanceWindowResponse',
                 maintenance_exclusions: Mapping[str, str],
                 recurring_window: 'outputs.RecurringTimeWindowResponse'):
        """
        MaintenanceWindow defines the maintenance window to be used for the cluster.
        :param 'DailyMaintenanceWindowResponse' daily_maintenance_window: DailyMaintenanceWindow specifies a daily maintenance operation window.
        :param Mapping[str, str] maintenance_exclusions: Exceptions to maintenance window. Non-emergency maintenance should not occur in these windows.
        :param 'RecurringTimeWindowResponse' recurring_window: RecurringWindow specifies some number of recurring time periods for maintenance to occur. The time windows may be overlapping. If no maintenance windows are set, maintenance can occur at any time.
        """
        pulumi.set(__self__, "daily_maintenance_window", daily_maintenance_window)
        pulumi.set(__self__, "maintenance_exclusions", maintenance_exclusions)
        pulumi.set(__self__, "recurring_window", recurring_window)

    @property
    @pulumi.getter(name="dailyMaintenanceWindow")
    def daily_maintenance_window(self) -> 'outputs.DailyMaintenanceWindowResponse':
        """
        DailyMaintenanceWindow specifies a daily maintenance operation window.
        """
        return pulumi.get(self, "daily_maintenance_window")

    @property
    @pulumi.getter(name="maintenanceExclusions")
    def maintenance_exclusions(self) -> Mapping[str, str]:
        """
        Exceptions to maintenance window. Non-emergency maintenance should not occur in these windows.
        """
        return pulumi.get(self, "maintenance_exclusions")

    @property
    @pulumi.getter(name="recurringWindow")
    def recurring_window(self) -> 'outputs.RecurringTimeWindowResponse':
        """
        RecurringWindow specifies some number of recurring time periods for maintenance to occur. The time windows may be overlapping. If no maintenance windows are set, maintenance can occur at any time.
        """
        return pulumi.get(self, "recurring_window")


@pulumi.output_type
class ManagedPrometheusConfigResponse(dict):
    """
    ManagedPrometheusConfig defines the configuration for Google Cloud Managed Service for Prometheus.
    """
    def __init__(__self__, *,
                 enabled: bool):
        """
        ManagedPrometheusConfig defines the configuration for Google Cloud Managed Service for Prometheus.
        :param bool enabled: Enable Managed Collection.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Enable Managed Collection.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class MasterAuthResponse(dict):
    """
    The authentication information for accessing the master endpoint. Authentication can be done using HTTP basic auth or using client certificates.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientCertificate":
            suggest = "client_certificate"
        elif key == "clientCertificateConfig":
            suggest = "client_certificate_config"
        elif key == "clientKey":
            suggest = "client_key"
        elif key == "clusterCaCertificate":
            suggest = "cluster_ca_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MasterAuthResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MasterAuthResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MasterAuthResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_certificate: str,
                 client_certificate_config: 'outputs.ClientCertificateConfigResponse',
                 client_key: str,
                 cluster_ca_certificate: str,
                 password: str,
                 username: str):
        """
        The authentication information for accessing the master endpoint. Authentication can be done using HTTP basic auth or using client certificates.
        :param str client_certificate: [Output only] Base64-encoded public certificate used by clients to authenticate to the cluster endpoint.
        :param 'ClientCertificateConfigResponse' client_certificate_config: Configuration for client certificate authentication on the cluster. For clusters before v1.12, if no configuration is specified, a client certificate is issued.
        :param str client_key: [Output only] Base64-encoded private key used by clients to authenticate to the cluster endpoint.
        :param str cluster_ca_certificate: [Output only] Base64-encoded public certificate that is the root of trust for the cluster.
        :param str password: The password to use for HTTP basic authentication to the master endpoint. Because the master endpoint is open to the Internet, you should create a strong password. If a password is provided for cluster creation, username must be non-empty. Warning: basic authentication is deprecated, and will be removed in GKE control plane versions 1.19 and newer. For a list of recommended authentication methods, see: https://cloud.google.com/kubernetes-engine/docs/how-to/api-server-authentication
        :param str username: The username to use for HTTP basic authentication to the master endpoint. For clusters v1.6.0 and later, basic authentication can be disabled by leaving username unspecified (or setting it to the empty string). Warning: basic authentication is deprecated, and will be removed in GKE control plane versions 1.19 and newer. For a list of recommended authentication methods, see: https://cloud.google.com/kubernetes-engine/docs/how-to/api-server-authentication
        """
        pulumi.set(__self__, "client_certificate", client_certificate)
        pulumi.set(__self__, "client_certificate_config", client_certificate_config)
        pulumi.set(__self__, "client_key", client_key)
        pulumi.set(__self__, "cluster_ca_certificate", cluster_ca_certificate)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> str:
        """
        [Output only] Base64-encoded public certificate used by clients to authenticate to the cluster endpoint.
        """
        return pulumi.get(self, "client_certificate")

    @property
    @pulumi.getter(name="clientCertificateConfig")
    def client_certificate_config(self) -> 'outputs.ClientCertificateConfigResponse':
        """
        Configuration for client certificate authentication on the cluster. For clusters before v1.12, if no configuration is specified, a client certificate is issued.
        """
        return pulumi.get(self, "client_certificate_config")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> str:
        """
        [Output only] Base64-encoded private key used by clients to authenticate to the cluster endpoint.
        """
        return pulumi.get(self, "client_key")

    @property
    @pulumi.getter(name="clusterCaCertificate")
    def cluster_ca_certificate(self) -> str:
        """
        [Output only] Base64-encoded public certificate that is the root of trust for the cluster.
        """
        return pulumi.get(self, "cluster_ca_certificate")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The password to use for HTTP basic authentication to the master endpoint. Because the master endpoint is open to the Internet, you should create a strong password. If a password is provided for cluster creation, username must be non-empty. Warning: basic authentication is deprecated, and will be removed in GKE control plane versions 1.19 and newer. For a list of recommended authentication methods, see: https://cloud.google.com/kubernetes-engine/docs/how-to/api-server-authentication
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The username to use for HTTP basic authentication to the master endpoint. For clusters v1.6.0 and later, basic authentication can be disabled by leaving username unspecified (or setting it to the empty string). Warning: basic authentication is deprecated, and will be removed in GKE control plane versions 1.19 and newer. For a list of recommended authentication methods, see: https://cloud.google.com/kubernetes-engine/docs/how-to/api-server-authentication
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class MasterAuthorizedNetworksConfigResponse(dict):
    """
    Configuration options for the master authorized networks feature. Enabled master authorized networks will disallow all external traffic to access Kubernetes master through HTTPS except traffic from the given CIDR blocks, Google Compute Engine Public IPs and Google Prod IPs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cidrBlocks":
            suggest = "cidr_blocks"
        elif key == "gcpPublicCidrsAccessEnabled":
            suggest = "gcp_public_cidrs_access_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MasterAuthorizedNetworksConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MasterAuthorizedNetworksConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MasterAuthorizedNetworksConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cidr_blocks: Sequence['outputs.CidrBlockResponse'],
                 enabled: bool,
                 gcp_public_cidrs_access_enabled: bool):
        """
        Configuration options for the master authorized networks feature. Enabled master authorized networks will disallow all external traffic to access Kubernetes master through HTTPS except traffic from the given CIDR blocks, Google Compute Engine Public IPs and Google Prod IPs.
        :param Sequence['CidrBlockResponse'] cidr_blocks: cidr_blocks define up to 50 external networks that could access Kubernetes master through HTTPS.
        :param bool enabled: Whether or not master authorized networks is enabled.
        :param bool gcp_public_cidrs_access_enabled: Whether master is accessbile via Google Compute Engine Public IP addresses.
        """
        pulumi.set(__self__, "cidr_blocks", cidr_blocks)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "gcp_public_cidrs_access_enabled", gcp_public_cidrs_access_enabled)

    @property
    @pulumi.getter(name="cidrBlocks")
    def cidr_blocks(self) -> Sequence['outputs.CidrBlockResponse']:
        """
        cidr_blocks define up to 50 external networks that could access Kubernetes master through HTTPS.
        """
        return pulumi.get(self, "cidr_blocks")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether or not master authorized networks is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="gcpPublicCidrsAccessEnabled")
    def gcp_public_cidrs_access_enabled(self) -> bool:
        """
        Whether master is accessbile via Google Compute Engine Public IP addresses.
        """
        return pulumi.get(self, "gcp_public_cidrs_access_enabled")


@pulumi.output_type
class MaxPodsConstraintResponse(dict):
    """
    Constraints applied to pods.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxPodsPerNode":
            suggest = "max_pods_per_node"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MaxPodsConstraintResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MaxPodsConstraintResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MaxPodsConstraintResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_pods_per_node: str):
        """
        Constraints applied to pods.
        :param str max_pods_per_node: Constraint enforced on the max num of pods per node.
        """
        pulumi.set(__self__, "max_pods_per_node", max_pods_per_node)

    @property
    @pulumi.getter(name="maxPodsPerNode")
    def max_pods_per_node(self) -> str:
        """
        Constraint enforced on the max num of pods per node.
        """
        return pulumi.get(self, "max_pods_per_node")


@pulumi.output_type
class MeshCertificatesResponse(dict):
    """
    Configuration for issuance of mTLS keys and certificates to Kubernetes pods.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableCertificates":
            suggest = "enable_certificates"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MeshCertificatesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MeshCertificatesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MeshCertificatesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_certificates: bool):
        """
        Configuration for issuance of mTLS keys and certificates to Kubernetes pods.
        :param bool enable_certificates: enable_certificates controls issuance of workload mTLS certificates. If set, the GKE Workload Identity Certificates controller and node agent will be deployed in the cluster, which can then be configured by creating a WorkloadCertificateConfig Custom Resource. Requires Workload Identity (workload_pool must be non-empty).
        """
        pulumi.set(__self__, "enable_certificates", enable_certificates)

    @property
    @pulumi.getter(name="enableCertificates")
    def enable_certificates(self) -> bool:
        """
        enable_certificates controls issuance of workload mTLS certificates. If set, the GKE Workload Identity Certificates controller and node agent will be deployed in the cluster, which can then be configured by creating a WorkloadCertificateConfig Custom Resource. Requires Workload Identity (workload_pool must be non-empty).
        """
        return pulumi.get(self, "enable_certificates")


@pulumi.output_type
class MonitoringComponentConfigResponse(dict):
    """
    MonitoringComponentConfig is cluster monitoring component configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableComponents":
            suggest = "enable_components"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringComponentConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringComponentConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringComponentConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_components: Sequence[str]):
        """
        MonitoringComponentConfig is cluster monitoring component configuration.
        :param Sequence[str] enable_components: Select components to collect metrics. An empty set would disable all monitoring.
        """
        pulumi.set(__self__, "enable_components", enable_components)

    @property
    @pulumi.getter(name="enableComponents")
    def enable_components(self) -> Sequence[str]:
        """
        Select components to collect metrics. An empty set would disable all monitoring.
        """
        return pulumi.get(self, "enable_components")


@pulumi.output_type
class MonitoringConfigResponse(dict):
    """
    MonitoringConfig is cluster monitoring configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "componentConfig":
            suggest = "component_config"
        elif key == "managedPrometheusConfig":
            suggest = "managed_prometheus_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoringConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoringConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoringConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 component_config: 'outputs.MonitoringComponentConfigResponse',
                 managed_prometheus_config: 'outputs.ManagedPrometheusConfigResponse'):
        """
        MonitoringConfig is cluster monitoring configuration.
        :param 'MonitoringComponentConfigResponse' component_config: Monitoring components configuration
        :param 'ManagedPrometheusConfigResponse' managed_prometheus_config: Enable Google Cloud Managed Service for Prometheus in the cluster.
        """
        pulumi.set(__self__, "component_config", component_config)
        pulumi.set(__self__, "managed_prometheus_config", managed_prometheus_config)

    @property
    @pulumi.getter(name="componentConfig")
    def component_config(self) -> 'outputs.MonitoringComponentConfigResponse':
        """
        Monitoring components configuration
        """
        return pulumi.get(self, "component_config")

    @property
    @pulumi.getter(name="managedPrometheusConfig")
    def managed_prometheus_config(self) -> 'outputs.ManagedPrometheusConfigResponse':
        """
        Enable Google Cloud Managed Service for Prometheus in the cluster.
        """
        return pulumi.get(self, "managed_prometheus_config")


@pulumi.output_type
class NetworkConfigResponse(dict):
    """
    NetworkConfig reports the relative names of network & subnetwork.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datapathProvider":
            suggest = "datapath_provider"
        elif key == "defaultSnatStatus":
            suggest = "default_snat_status"
        elif key == "dnsConfig":
            suggest = "dns_config"
        elif key == "enableIntraNodeVisibility":
            suggest = "enable_intra_node_visibility"
        elif key == "enableL4ilbSubsetting":
            suggest = "enable_l4ilb_subsetting"
        elif key == "gatewayApiConfig":
            suggest = "gateway_api_config"
        elif key == "privateIpv6GoogleAccess":
            suggest = "private_ipv6_google_access"
        elif key == "serviceExternalIpsConfig":
            suggest = "service_external_ips_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 datapath_provider: str,
                 default_snat_status: 'outputs.DefaultSnatStatusResponse',
                 dns_config: 'outputs.DNSConfigResponse',
                 enable_intra_node_visibility: bool,
                 enable_l4ilb_subsetting: bool,
                 gateway_api_config: 'outputs.GatewayAPIConfigResponse',
                 network: str,
                 private_ipv6_google_access: str,
                 service_external_ips_config: 'outputs.ServiceExternalIPsConfigResponse',
                 subnetwork: str):
        """
        NetworkConfig reports the relative names of network & subnetwork.
        :param str datapath_provider: The desired datapath provider for this cluster. By default, uses the IPTables-based kube-proxy implementation.
        :param 'DefaultSnatStatusResponse' default_snat_status: Whether the cluster disables default in-node sNAT rules. In-node sNAT rules will be disabled when default_snat_status is disabled. When disabled is set to false, default IP masquerade rules will be applied to the nodes to prevent sNAT on cluster internal traffic.
        :param 'DNSConfigResponse' dns_config: DNSConfig contains clusterDNS config for this cluster.
        :param bool enable_intra_node_visibility: Whether Intra-node visibility is enabled for this cluster. This makes same node pod to pod traffic visible for VPC network.
        :param bool enable_l4ilb_subsetting: Whether L4ILB Subsetting is enabled for this cluster.
        :param 'GatewayAPIConfigResponse' gateway_api_config: GatewayAPIConfig contains the desired config of Gateway API on this cluster.
        :param str network: The relative name of the Google Compute Engine network(https://cloud.google.com/compute/docs/networks-and-firewalls#networks) to which the cluster is connected. Example: projects/my-project/global/networks/my-network
        :param str private_ipv6_google_access: The desired state of IPv6 connectivity to Google Services. By default, no private IPv6 access to or from Google Services (all access will be via IPv4)
        :param 'ServiceExternalIPsConfigResponse' service_external_ips_config: ServiceExternalIPsConfig specifies if services with externalIPs field are blocked or not.
        :param str subnetwork: The relative name of the Google Compute Engine [subnetwork](https://cloud.google.com/compute/docs/vpc) to which the cluster is connected. Example: projects/my-project/regions/us-central1/subnetworks/my-subnet
        """
        pulumi.set(__self__, "datapath_provider", datapath_provider)
        pulumi.set(__self__, "default_snat_status", default_snat_status)
        pulumi.set(__self__, "dns_config", dns_config)
        pulumi.set(__self__, "enable_intra_node_visibility", enable_intra_node_visibility)
        pulumi.set(__self__, "enable_l4ilb_subsetting", enable_l4ilb_subsetting)
        pulumi.set(__self__, "gateway_api_config", gateway_api_config)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "private_ipv6_google_access", private_ipv6_google_access)
        pulumi.set(__self__, "service_external_ips_config", service_external_ips_config)
        pulumi.set(__self__, "subnetwork", subnetwork)

    @property
    @pulumi.getter(name="datapathProvider")
    def datapath_provider(self) -> str:
        """
        The desired datapath provider for this cluster. By default, uses the IPTables-based kube-proxy implementation.
        """
        return pulumi.get(self, "datapath_provider")

    @property
    @pulumi.getter(name="defaultSnatStatus")
    def default_snat_status(self) -> 'outputs.DefaultSnatStatusResponse':
        """
        Whether the cluster disables default in-node sNAT rules. In-node sNAT rules will be disabled when default_snat_status is disabled. When disabled is set to false, default IP masquerade rules will be applied to the nodes to prevent sNAT on cluster internal traffic.
        """
        return pulumi.get(self, "default_snat_status")

    @property
    @pulumi.getter(name="dnsConfig")
    def dns_config(self) -> 'outputs.DNSConfigResponse':
        """
        DNSConfig contains clusterDNS config for this cluster.
        """
        return pulumi.get(self, "dns_config")

    @property
    @pulumi.getter(name="enableIntraNodeVisibility")
    def enable_intra_node_visibility(self) -> bool:
        """
        Whether Intra-node visibility is enabled for this cluster. This makes same node pod to pod traffic visible for VPC network.
        """
        return pulumi.get(self, "enable_intra_node_visibility")

    @property
    @pulumi.getter(name="enableL4ilbSubsetting")
    def enable_l4ilb_subsetting(self) -> bool:
        """
        Whether L4ILB Subsetting is enabled for this cluster.
        """
        return pulumi.get(self, "enable_l4ilb_subsetting")

    @property
    @pulumi.getter(name="gatewayApiConfig")
    def gateway_api_config(self) -> 'outputs.GatewayAPIConfigResponse':
        """
        GatewayAPIConfig contains the desired config of Gateway API on this cluster.
        """
        return pulumi.get(self, "gateway_api_config")

    @property
    @pulumi.getter
    def network(self) -> str:
        """
        The relative name of the Google Compute Engine network(https://cloud.google.com/compute/docs/networks-and-firewalls#networks) to which the cluster is connected. Example: projects/my-project/global/networks/my-network
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="privateIpv6GoogleAccess")
    def private_ipv6_google_access(self) -> str:
        """
        The desired state of IPv6 connectivity to Google Services. By default, no private IPv6 access to or from Google Services (all access will be via IPv4)
        """
        return pulumi.get(self, "private_ipv6_google_access")

    @property
    @pulumi.getter(name="serviceExternalIpsConfig")
    def service_external_ips_config(self) -> 'outputs.ServiceExternalIPsConfigResponse':
        """
        ServiceExternalIPsConfig specifies if services with externalIPs field are blocked or not.
        """
        return pulumi.get(self, "service_external_ips_config")

    @property
    @pulumi.getter
    def subnetwork(self) -> str:
        """
        The relative name of the Google Compute Engine [subnetwork](https://cloud.google.com/compute/docs/vpc) to which the cluster is connected. Example: projects/my-project/regions/us-central1/subnetworks/my-subnet
        """
        return pulumi.get(self, "subnetwork")


@pulumi.output_type
class NetworkPerformanceConfigResponse(dict):
    """
    Configuration of all network bandwidth tiers
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "totalEgressBandwidthTier":
            suggest = "total_egress_bandwidth_tier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkPerformanceConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkPerformanceConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkPerformanceConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 total_egress_bandwidth_tier: str):
        """
        Configuration of all network bandwidth tiers
        :param str total_egress_bandwidth_tier: Specifies the total network bandwidth tier for the NodePool.
        """
        pulumi.set(__self__, "total_egress_bandwidth_tier", total_egress_bandwidth_tier)

    @property
    @pulumi.getter(name="totalEgressBandwidthTier")
    def total_egress_bandwidth_tier(self) -> str:
        """
        Specifies the total network bandwidth tier for the NodePool.
        """
        return pulumi.get(self, "total_egress_bandwidth_tier")


@pulumi.output_type
class NetworkPolicyConfigResponse(dict):
    """
    Configuration for NetworkPolicy. This only tracks whether the addon is enabled or not on the Master, it does not track whether network policy is enabled for the nodes.
    """
    def __init__(__self__, *,
                 disabled: bool):
        """
        Configuration for NetworkPolicy. This only tracks whether the addon is enabled or not on the Master, it does not track whether network policy is enabled for the nodes.
        :param bool disabled: Whether NetworkPolicy is enabled for this cluster.
        """
        pulumi.set(__self__, "disabled", disabled)

    @property
    @pulumi.getter
    def disabled(self) -> bool:
        """
        Whether NetworkPolicy is enabled for this cluster.
        """
        return pulumi.get(self, "disabled")


@pulumi.output_type
class NetworkPolicyResponse(dict):
    """
    Configuration options for the NetworkPolicy feature. https://kubernetes.io/docs/concepts/services-networking/networkpolicies/
    """
    def __init__(__self__, *,
                 enabled: bool,
                 provider: str):
        """
        Configuration options for the NetworkPolicy feature. https://kubernetes.io/docs/concepts/services-networking/networkpolicies/
        :param bool enabled: Whether network policy is enabled on the cluster.
        :param str provider: The selected network policy provider.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "provider", provider)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether network policy is enabled on the cluster.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def provider(self) -> str:
        """
        The selected network policy provider.
        """
        return pulumi.get(self, "provider")


@pulumi.output_type
class NetworkTagsResponse(dict):
    """
    Collection of Compute Engine network tags that can be applied to a node's underlying VM instance.
    """
    def __init__(__self__, *,
                 tags: Sequence[str]):
        """
        Collection of Compute Engine network tags that can be applied to a node's underlying VM instance.
        :param Sequence[str] tags: List of network tags.
        """
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        List of network tags.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class NodeConfigDefaultsResponse(dict):
    """
    Subset of NodeConfig message that has defaults.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gcfsConfig":
            suggest = "gcfs_config"
        elif key == "loggingConfig":
            suggest = "logging_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeConfigDefaultsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeConfigDefaultsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeConfigDefaultsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gcfs_config: 'outputs.GcfsConfigResponse',
                 logging_config: 'outputs.NodePoolLoggingConfigResponse'):
        """
        Subset of NodeConfig message that has defaults.
        :param 'GcfsConfigResponse' gcfs_config: GCFS (Google Container File System, also known as Riptide) options.
        :param 'NodePoolLoggingConfigResponse' logging_config: Logging configuration for node pools.
        """
        pulumi.set(__self__, "gcfs_config", gcfs_config)
        pulumi.set(__self__, "logging_config", logging_config)

    @property
    @pulumi.getter(name="gcfsConfig")
    def gcfs_config(self) -> 'outputs.GcfsConfigResponse':
        """
        GCFS (Google Container File System, also known as Riptide) options.
        """
        return pulumi.get(self, "gcfs_config")

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> 'outputs.NodePoolLoggingConfigResponse':
        """
        Logging configuration for node pools.
        """
        return pulumi.get(self, "logging_config")


@pulumi.output_type
class NodeConfigResponse(dict):
    """
    Parameters that describe the nodes in a cluster. GKE Autopilot clusters do not recognize parameters in `NodeConfig`. Use AutoprovisioningNodePoolDefaults instead.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "advancedMachineFeatures":
            suggest = "advanced_machine_features"
        elif key == "bootDiskKmsKey":
            suggest = "boot_disk_kms_key"
        elif key == "confidentialNodes":
            suggest = "confidential_nodes"
        elif key == "diskSizeGb":
            suggest = "disk_size_gb"
        elif key == "diskType":
            suggest = "disk_type"
        elif key == "ephemeralStorageLocalSsdConfig":
            suggest = "ephemeral_storage_local_ssd_config"
        elif key == "fastSocket":
            suggest = "fast_socket"
        elif key == "gcfsConfig":
            suggest = "gcfs_config"
        elif key == "imageType":
            suggest = "image_type"
        elif key == "kubeletConfig":
            suggest = "kubelet_config"
        elif key == "linuxNodeConfig":
            suggest = "linux_node_config"
        elif key == "localNvmeSsdBlockConfig":
            suggest = "local_nvme_ssd_block_config"
        elif key == "localSsdCount":
            suggest = "local_ssd_count"
        elif key == "loggingConfig":
            suggest = "logging_config"
        elif key == "machineType":
            suggest = "machine_type"
        elif key == "minCpuPlatform":
            suggest = "min_cpu_platform"
        elif key == "nodeGroup":
            suggest = "node_group"
        elif key == "oauthScopes":
            suggest = "oauth_scopes"
        elif key == "reservationAffinity":
            suggest = "reservation_affinity"
        elif key == "resourceLabels":
            suggest = "resource_labels"
        elif key == "sandboxConfig":
            suggest = "sandbox_config"
        elif key == "serviceAccount":
            suggest = "service_account"
        elif key == "shieldedInstanceConfig":
            suggest = "shielded_instance_config"
        elif key == "windowsNodeConfig":
            suggest = "windows_node_config"
        elif key == "workloadMetadataConfig":
            suggest = "workload_metadata_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accelerators: Sequence['outputs.AcceleratorConfigResponse'],
                 advanced_machine_features: 'outputs.AdvancedMachineFeaturesResponse',
                 boot_disk_kms_key: str,
                 confidential_nodes: 'outputs.ConfidentialNodesResponse',
                 disk_size_gb: int,
                 disk_type: str,
                 ephemeral_storage_local_ssd_config: 'outputs.EphemeralStorageLocalSsdConfigResponse',
                 fast_socket: 'outputs.FastSocketResponse',
                 gcfs_config: 'outputs.GcfsConfigResponse',
                 gvnic: 'outputs.VirtualNICResponse',
                 image_type: str,
                 kubelet_config: 'outputs.NodeKubeletConfigResponse',
                 labels: Mapping[str, str],
                 linux_node_config: 'outputs.LinuxNodeConfigResponse',
                 local_nvme_ssd_block_config: 'outputs.LocalNvmeSsdBlockConfigResponse',
                 local_ssd_count: int,
                 logging_config: 'outputs.NodePoolLoggingConfigResponse',
                 machine_type: str,
                 metadata: Mapping[str, str],
                 min_cpu_platform: str,
                 node_group: str,
                 oauth_scopes: Sequence[str],
                 preemptible: bool,
                 reservation_affinity: 'outputs.ReservationAffinityResponse',
                 resource_labels: Mapping[str, str],
                 sandbox_config: 'outputs.SandboxConfigResponse',
                 service_account: str,
                 shielded_instance_config: 'outputs.ShieldedInstanceConfigResponse',
                 spot: bool,
                 tags: Sequence[str],
                 taints: Sequence['outputs.NodeTaintResponse'],
                 windows_node_config: 'outputs.WindowsNodeConfigResponse',
                 workload_metadata_config: 'outputs.WorkloadMetadataConfigResponse'):
        """
        Parameters that describe the nodes in a cluster. GKE Autopilot clusters do not recognize parameters in `NodeConfig`. Use AutoprovisioningNodePoolDefaults instead.
        :param Sequence['AcceleratorConfigResponse'] accelerators: A list of hardware accelerators to be attached to each node. See https://cloud.google.com/compute/docs/gpus for more information about support for GPUs.
        :param 'AdvancedMachineFeaturesResponse' advanced_machine_features: Advanced features for the Compute Engine VM.
        :param str boot_disk_kms_key:  The Customer Managed Encryption Key used to encrypt the boot disk attached to each node in the node pool. This should be of the form projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME]. For more information about protecting resources with Cloud KMS Keys please see: https://cloud.google.com/compute/docs/disks/customer-managed-encryption
        :param 'ConfidentialNodesResponse' confidential_nodes: Confidential nodes config. All the nodes in the node pool will be Confidential VM once enabled.
        :param int disk_size_gb: Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB. If unspecified, the default disk size is 100GB.
        :param str disk_type: Type of the disk attached to each node (e.g. 'pd-standard', 'pd-ssd' or 'pd-balanced') If unspecified, the default disk type is 'pd-standard'
        :param 'EphemeralStorageLocalSsdConfigResponse' ephemeral_storage_local_ssd_config: Parameters for the node ephemeral storage using Local SSDs. If unspecified, ephemeral storage is backed by the boot disk.
        :param 'FastSocketResponse' fast_socket: Enable or disable NCCL fast socket for the node pool.
        :param 'GcfsConfigResponse' gcfs_config: Google Container File System (image streaming) configs.
        :param 'VirtualNICResponse' gvnic: Enable or disable gvnic in the node pool.
        :param str image_type: The image type to use for this node. Note that for a given image type, the latest version of it will be used. Please see https://cloud.google.com/kubernetes-engine/docs/concepts/node-images for available image types.
        :param 'NodeKubeletConfigResponse' kubelet_config: Node kubelet configs.
        :param Mapping[str, str] labels: The map of Kubernetes labels (key/value pairs) to be applied to each node. These will added in addition to any default label(s) that Kubernetes may apply to the node. In case of conflict in label keys, the applied set may differ depending on the Kubernetes version -- it's best to assume the behavior is undefined and conflicts should be avoided. For more information, including usage and the valid values, see: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/
        :param 'LinuxNodeConfigResponse' linux_node_config: Parameters that can be configured on Linux nodes.
        :param 'LocalNvmeSsdBlockConfigResponse' local_nvme_ssd_block_config: Parameters for using raw-block Local NVMe SSDs.
        :param int local_ssd_count: The number of local SSD disks to be attached to the node. The limit for this value is dependent upon the maximum number of disks available on a machine per zone. See: https://cloud.google.com/compute/docs/disks/local-ssd for more information.
        :param 'NodePoolLoggingConfigResponse' logging_config: Logging configuration.
        :param str machine_type: The name of a Google Compute Engine [machine type](https://cloud.google.com/compute/docs/machine-types) If unspecified, the default machine type is `e2-medium`.
        :param Mapping[str, str] metadata: The metadata key/value pairs assigned to instances in the cluster. Keys must conform to the regexp `[a-zA-Z0-9-_]+` and be less than 128 bytes in length. These are reflected as part of a URL in the metadata server. Additionally, to avoid ambiguity, keys must not conflict with any other metadata keys for the project or be one of the reserved keys: - "cluster-location" - "cluster-name" - "cluster-uid" - "configure-sh" - "containerd-configure-sh" - "enable-os-login" - "gci-ensure-gke-docker" - "gci-metrics-enabled" - "gci-update-strategy" - "instance-template" - "kube-env" - "startup-script" - "user-data" - "disable-address-manager" - "windows-startup-script-ps1" - "common-psm1" - "k8s-node-setup-psm1" - "install-ssh-psm1" - "user-profile-psm1" Values are free-form strings, and only have meaning as interpreted by the image running in the instance. The only restriction placed on them is that each value's size must be less than or equal to 32 KB. The total size of all keys and values must be less than 512 KB.
        :param str min_cpu_platform: Minimum CPU platform to be used by this instance. The instance may be scheduled on the specified or newer CPU platform. Applicable values are the friendly names of CPU platforms, such as `minCpuPlatform: "Intel Haswell"` or `minCpuPlatform: "Intel Sandy Bridge"`. For more information, read [how to specify min CPU platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
        :param str node_group: Setting this field will assign instances of this pool to run on the specified node group. This is useful for running workloads on [sole tenant nodes](https://cloud.google.com/compute/docs/nodes/sole-tenant-nodes).
        :param Sequence[str] oauth_scopes: The set of Google API scopes to be made available on all of the node VMs under the "default" service account. The following scopes are recommended, but not required, and by default are not included: * `https://www.googleapis.com/auth/compute` is required for mounting persistent storage on your nodes. * `https://www.googleapis.com/auth/devstorage.read_only` is required for communicating with **gcr.io** (the [Google Container Registry](https://cloud.google.com/container-registry/)). If unspecified, no scopes are added, unless Cloud Logging or Cloud Monitoring are enabled, in which case their required scopes will be added.
        :param bool preemptible: Whether the nodes are created as preemptible VM instances. See: https://cloud.google.com/compute/docs/instances/preemptible for more information about preemptible VM instances.
        :param 'ReservationAffinityResponse' reservation_affinity: The optional reservation affinity. Setting this field will apply the specified [Zonal Compute Reservation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources) to this node pool.
        :param Mapping[str, str] resource_labels: The resource labels for the node pool to use to annotate any related Google Compute Engine resources.
        :param 'SandboxConfigResponse' sandbox_config: Sandbox configuration for this node.
        :param str service_account: The Google Cloud Platform Service Account to be used by the node VMs. Specify the email address of the Service Account; otherwise, if no Service Account is specified, the "default" service account is used.
        :param 'ShieldedInstanceConfigResponse' shielded_instance_config: Shielded Instance options.
        :param bool spot: Spot flag for enabling Spot VM, which is a rebrand of the existing preemptible flag.
        :param Sequence[str] tags: The list of instance tags applied to all nodes. Tags are used to identify valid sources or targets for network firewalls and are specified by the client during cluster or node pool creation. Each tag within the list must comply with RFC1035.
        :param Sequence['NodeTaintResponse'] taints: List of kubernetes taints to be applied to each node. For more information, including usage and the valid values, see: https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
        :param 'WindowsNodeConfigResponse' windows_node_config: Parameters that can be configured on Windows nodes.
        :param 'WorkloadMetadataConfigResponse' workload_metadata_config: The workload metadata configuration for this node.
        """
        pulumi.set(__self__, "accelerators", accelerators)
        pulumi.set(__self__, "advanced_machine_features", advanced_machine_features)
        pulumi.set(__self__, "boot_disk_kms_key", boot_disk_kms_key)
        pulumi.set(__self__, "confidential_nodes", confidential_nodes)
        pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        pulumi.set(__self__, "disk_type", disk_type)
        pulumi.set(__self__, "ephemeral_storage_local_ssd_config", ephemeral_storage_local_ssd_config)
        pulumi.set(__self__, "fast_socket", fast_socket)
        pulumi.set(__self__, "gcfs_config", gcfs_config)
        pulumi.set(__self__, "gvnic", gvnic)
        pulumi.set(__self__, "image_type", image_type)
        pulumi.set(__self__, "kubelet_config", kubelet_config)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "linux_node_config", linux_node_config)
        pulumi.set(__self__, "local_nvme_ssd_block_config", local_nvme_ssd_block_config)
        pulumi.set(__self__, "local_ssd_count", local_ssd_count)
        pulumi.set(__self__, "logging_config", logging_config)
        pulumi.set(__self__, "machine_type", machine_type)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        pulumi.set(__self__, "node_group", node_group)
        pulumi.set(__self__, "oauth_scopes", oauth_scopes)
        pulumi.set(__self__, "preemptible", preemptible)
        pulumi.set(__self__, "reservation_affinity", reservation_affinity)
        pulumi.set(__self__, "resource_labels", resource_labels)
        pulumi.set(__self__, "sandbox_config", sandbox_config)
        pulumi.set(__self__, "service_account", service_account)
        pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        pulumi.set(__self__, "spot", spot)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "taints", taints)
        pulumi.set(__self__, "windows_node_config", windows_node_config)
        pulumi.set(__self__, "workload_metadata_config", workload_metadata_config)

    @property
    @pulumi.getter
    def accelerators(self) -> Sequence['outputs.AcceleratorConfigResponse']:
        """
        A list of hardware accelerators to be attached to each node. See https://cloud.google.com/compute/docs/gpus for more information about support for GPUs.
        """
        return pulumi.get(self, "accelerators")

    @property
    @pulumi.getter(name="advancedMachineFeatures")
    def advanced_machine_features(self) -> 'outputs.AdvancedMachineFeaturesResponse':
        """
        Advanced features for the Compute Engine VM.
        """
        return pulumi.get(self, "advanced_machine_features")

    @property
    @pulumi.getter(name="bootDiskKmsKey")
    def boot_disk_kms_key(self) -> str:
        """
         The Customer Managed Encryption Key used to encrypt the boot disk attached to each node in the node pool. This should be of the form projects/[KEY_PROJECT_ID]/locations/[LOCATION]/keyRings/[RING_NAME]/cryptoKeys/[KEY_NAME]. For more information about protecting resources with Cloud KMS Keys please see: https://cloud.google.com/compute/docs/disks/customer-managed-encryption
        """
        return pulumi.get(self, "boot_disk_kms_key")

    @property
    @pulumi.getter(name="confidentialNodes")
    def confidential_nodes(self) -> 'outputs.ConfidentialNodesResponse':
        """
        Confidential nodes config. All the nodes in the node pool will be Confidential VM once enabled.
        """
        return pulumi.get(self, "confidential_nodes")

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> int:
        """
        Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB. If unspecified, the default disk size is 100GB.
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> str:
        """
        Type of the disk attached to each node (e.g. 'pd-standard', 'pd-ssd' or 'pd-balanced') If unspecified, the default disk type is 'pd-standard'
        """
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter(name="ephemeralStorageLocalSsdConfig")
    def ephemeral_storage_local_ssd_config(self) -> 'outputs.EphemeralStorageLocalSsdConfigResponse':
        """
        Parameters for the node ephemeral storage using Local SSDs. If unspecified, ephemeral storage is backed by the boot disk.
        """
        return pulumi.get(self, "ephemeral_storage_local_ssd_config")

    @property
    @pulumi.getter(name="fastSocket")
    def fast_socket(self) -> 'outputs.FastSocketResponse':
        """
        Enable or disable NCCL fast socket for the node pool.
        """
        return pulumi.get(self, "fast_socket")

    @property
    @pulumi.getter(name="gcfsConfig")
    def gcfs_config(self) -> 'outputs.GcfsConfigResponse':
        """
        Google Container File System (image streaming) configs.
        """
        return pulumi.get(self, "gcfs_config")

    @property
    @pulumi.getter
    def gvnic(self) -> 'outputs.VirtualNICResponse':
        """
        Enable or disable gvnic in the node pool.
        """
        return pulumi.get(self, "gvnic")

    @property
    @pulumi.getter(name="imageType")
    def image_type(self) -> str:
        """
        The image type to use for this node. Note that for a given image type, the latest version of it will be used. Please see https://cloud.google.com/kubernetes-engine/docs/concepts/node-images for available image types.
        """
        return pulumi.get(self, "image_type")

    @property
    @pulumi.getter(name="kubeletConfig")
    def kubelet_config(self) -> 'outputs.NodeKubeletConfigResponse':
        """
        Node kubelet configs.
        """
        return pulumi.get(self, "kubelet_config")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        The map of Kubernetes labels (key/value pairs) to be applied to each node. These will added in addition to any default label(s) that Kubernetes may apply to the node. In case of conflict in label keys, the applied set may differ depending on the Kubernetes version -- it's best to assume the behavior is undefined and conflicts should be avoided. For more information, including usage and the valid values, see: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="linuxNodeConfig")
    def linux_node_config(self) -> 'outputs.LinuxNodeConfigResponse':
        """
        Parameters that can be configured on Linux nodes.
        """
        return pulumi.get(self, "linux_node_config")

    @property
    @pulumi.getter(name="localNvmeSsdBlockConfig")
    def local_nvme_ssd_block_config(self) -> 'outputs.LocalNvmeSsdBlockConfigResponse':
        """
        Parameters for using raw-block Local NVMe SSDs.
        """
        return pulumi.get(self, "local_nvme_ssd_block_config")

    @property
    @pulumi.getter(name="localSsdCount")
    def local_ssd_count(self) -> int:
        """
        The number of local SSD disks to be attached to the node. The limit for this value is dependent upon the maximum number of disks available on a machine per zone. See: https://cloud.google.com/compute/docs/disks/local-ssd for more information.
        """
        return pulumi.get(self, "local_ssd_count")

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> 'outputs.NodePoolLoggingConfigResponse':
        """
        Logging configuration.
        """
        return pulumi.get(self, "logging_config")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> str:
        """
        The name of a Google Compute Engine [machine type](https://cloud.google.com/compute/docs/machine-types) If unspecified, the default machine type is `e2-medium`.
        """
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter
    def metadata(self) -> Mapping[str, str]:
        """
        The metadata key/value pairs assigned to instances in the cluster. Keys must conform to the regexp `[a-zA-Z0-9-_]+` and be less than 128 bytes in length. These are reflected as part of a URL in the metadata server. Additionally, to avoid ambiguity, keys must not conflict with any other metadata keys for the project or be one of the reserved keys: - "cluster-location" - "cluster-name" - "cluster-uid" - "configure-sh" - "containerd-configure-sh" - "enable-os-login" - "gci-ensure-gke-docker" - "gci-metrics-enabled" - "gci-update-strategy" - "instance-template" - "kube-env" - "startup-script" - "user-data" - "disable-address-manager" - "windows-startup-script-ps1" - "common-psm1" - "k8s-node-setup-psm1" - "install-ssh-psm1" - "user-profile-psm1" Values are free-form strings, and only have meaning as interpreted by the image running in the instance. The only restriction placed on them is that each value's size must be less than or equal to 32 KB. The total size of all keys and values must be less than 512 KB.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> str:
        """
        Minimum CPU platform to be used by this instance. The instance may be scheduled on the specified or newer CPU platform. Applicable values are the friendly names of CPU platforms, such as `minCpuPlatform: "Intel Haswell"` or `minCpuPlatform: "Intel Sandy Bridge"`. For more information, read [how to specify min CPU platform](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
        """
        return pulumi.get(self, "min_cpu_platform")

    @property
    @pulumi.getter(name="nodeGroup")
    def node_group(self) -> str:
        """
        Setting this field will assign instances of this pool to run on the specified node group. This is useful for running workloads on [sole tenant nodes](https://cloud.google.com/compute/docs/nodes/sole-tenant-nodes).
        """
        return pulumi.get(self, "node_group")

    @property
    @pulumi.getter(name="oauthScopes")
    def oauth_scopes(self) -> Sequence[str]:
        """
        The set of Google API scopes to be made available on all of the node VMs under the "default" service account. The following scopes are recommended, but not required, and by default are not included: * `https://www.googleapis.com/auth/compute` is required for mounting persistent storage on your nodes. * `https://www.googleapis.com/auth/devstorage.read_only` is required for communicating with **gcr.io** (the [Google Container Registry](https://cloud.google.com/container-registry/)). If unspecified, no scopes are added, unless Cloud Logging or Cloud Monitoring are enabled, in which case their required scopes will be added.
        """
        return pulumi.get(self, "oauth_scopes")

    @property
    @pulumi.getter
    def preemptible(self) -> bool:
        """
        Whether the nodes are created as preemptible VM instances. See: https://cloud.google.com/compute/docs/instances/preemptible for more information about preemptible VM instances.
        """
        return pulumi.get(self, "preemptible")

    @property
    @pulumi.getter(name="reservationAffinity")
    def reservation_affinity(self) -> 'outputs.ReservationAffinityResponse':
        """
        The optional reservation affinity. Setting this field will apply the specified [Zonal Compute Reservation](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources) to this node pool.
        """
        return pulumi.get(self, "reservation_affinity")

    @property
    @pulumi.getter(name="resourceLabels")
    def resource_labels(self) -> Mapping[str, str]:
        """
        The resource labels for the node pool to use to annotate any related Google Compute Engine resources.
        """
        return pulumi.get(self, "resource_labels")

    @property
    @pulumi.getter(name="sandboxConfig")
    def sandbox_config(self) -> 'outputs.SandboxConfigResponse':
        """
        Sandbox configuration for this node.
        """
        return pulumi.get(self, "sandbox_config")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> str:
        """
        The Google Cloud Platform Service Account to be used by the node VMs. Specify the email address of the Service Account; otherwise, if no Service Account is specified, the "default" service account is used.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> 'outputs.ShieldedInstanceConfigResponse':
        """
        Shielded Instance options.
        """
        return pulumi.get(self, "shielded_instance_config")

    @property
    @pulumi.getter
    def spot(self) -> bool:
        """
        Spot flag for enabling Spot VM, which is a rebrand of the existing preemptible flag.
        """
        return pulumi.get(self, "spot")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        The list of instance tags applied to all nodes. Tags are used to identify valid sources or targets for network firewalls and are specified by the client during cluster or node pool creation. Each tag within the list must comply with RFC1035.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def taints(self) -> Sequence['outputs.NodeTaintResponse']:
        """
        List of kubernetes taints to be applied to each node. For more information, including usage and the valid values, see: https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
        """
        return pulumi.get(self, "taints")

    @property
    @pulumi.getter(name="windowsNodeConfig")
    def windows_node_config(self) -> 'outputs.WindowsNodeConfigResponse':
        """
        Parameters that can be configured on Windows nodes.
        """
        return pulumi.get(self, "windows_node_config")

    @property
    @pulumi.getter(name="workloadMetadataConfig")
    def workload_metadata_config(self) -> 'outputs.WorkloadMetadataConfigResponse':
        """
        The workload metadata configuration for this node.
        """
        return pulumi.get(self, "workload_metadata_config")


@pulumi.output_type
class NodeKubeletConfigResponse(dict):
    """
    Node kubelet configs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuCfsQuota":
            suggest = "cpu_cfs_quota"
        elif key == "cpuCfsQuotaPeriod":
            suggest = "cpu_cfs_quota_period"
        elif key == "cpuManagerPolicy":
            suggest = "cpu_manager_policy"
        elif key == "podPidsLimit":
            suggest = "pod_pids_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeKubeletConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeKubeletConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeKubeletConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu_cfs_quota: bool,
                 cpu_cfs_quota_period: str,
                 cpu_manager_policy: str,
                 pod_pids_limit: str):
        """
        Node kubelet configs.
        :param bool cpu_cfs_quota: Enable CPU CFS quota enforcement for containers that specify CPU limits. This option is enabled by default which makes kubelet use CFS quota (https://www.kernel.org/doc/Documentation/scheduler/sched-bwc.txt) to enforce container CPU limits. Otherwise, CPU limits will not be enforced at all. Disable this option to mitigate CPU throttling problems while still having your pods to be in Guaranteed QoS class by specifying the CPU limits. The default value is 'true' if unspecified.
        :param str cpu_cfs_quota_period: Set the CPU CFS quota period value 'cpu.cfs_period_us'. The string must be a sequence of decimal numbers, each with optional fraction and a unit suffix, such as "300ms". Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h". The value must be a positive duration.
        :param str cpu_manager_policy: Control the CPU management policy on the node. See https://kubernetes.io/docs/tasks/administer-cluster/cpu-management-policies/ The following values are allowed. * "none": the default, which represents the existing scheduling behavior. * "static": allows pods with certain resource characteristics to be granted increased CPU affinity and exclusivity on the node. The default value is 'none' if unspecified.
        :param str pod_pids_limit: Set the Pod PID limits. See https://kubernetes.io/docs/concepts/policy/pid-limiting/#pod-pid-limits Controls the maximum number of processes allowed to run in a pod. The value must be greater than or equal to 1024 and less than 4194304.
        """
        pulumi.set(__self__, "cpu_cfs_quota", cpu_cfs_quota)
        pulumi.set(__self__, "cpu_cfs_quota_period", cpu_cfs_quota_period)
        pulumi.set(__self__, "cpu_manager_policy", cpu_manager_policy)
        pulumi.set(__self__, "pod_pids_limit", pod_pids_limit)

    @property
    @pulumi.getter(name="cpuCfsQuota")
    def cpu_cfs_quota(self) -> bool:
        """
        Enable CPU CFS quota enforcement for containers that specify CPU limits. This option is enabled by default which makes kubelet use CFS quota (https://www.kernel.org/doc/Documentation/scheduler/sched-bwc.txt) to enforce container CPU limits. Otherwise, CPU limits will not be enforced at all. Disable this option to mitigate CPU throttling problems while still having your pods to be in Guaranteed QoS class by specifying the CPU limits. The default value is 'true' if unspecified.
        """
        return pulumi.get(self, "cpu_cfs_quota")

    @property
    @pulumi.getter(name="cpuCfsQuotaPeriod")
    def cpu_cfs_quota_period(self) -> str:
        """
        Set the CPU CFS quota period value 'cpu.cfs_period_us'. The string must be a sequence of decimal numbers, each with optional fraction and a unit suffix, such as "300ms". Valid time units are "ns", "us" (or "µs"), "ms", "s", "m", "h". The value must be a positive duration.
        """
        return pulumi.get(self, "cpu_cfs_quota_period")

    @property
    @pulumi.getter(name="cpuManagerPolicy")
    def cpu_manager_policy(self) -> str:
        """
        Control the CPU management policy on the node. See https://kubernetes.io/docs/tasks/administer-cluster/cpu-management-policies/ The following values are allowed. * "none": the default, which represents the existing scheduling behavior. * "static": allows pods with certain resource characteristics to be granted increased CPU affinity and exclusivity on the node. The default value is 'none' if unspecified.
        """
        return pulumi.get(self, "cpu_manager_policy")

    @property
    @pulumi.getter(name="podPidsLimit")
    def pod_pids_limit(self) -> str:
        """
        Set the Pod PID limits. See https://kubernetes.io/docs/concepts/policy/pid-limiting/#pod-pid-limits Controls the maximum number of processes allowed to run in a pod. The value must be greater than or equal to 1024 and less than 4194304.
        """
        return pulumi.get(self, "pod_pids_limit")


@pulumi.output_type
class NodeManagementResponse(dict):
    """
    NodeManagement defines the set of node management services turned on for the node pool.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoRepair":
            suggest = "auto_repair"
        elif key == "autoUpgrade":
            suggest = "auto_upgrade"
        elif key == "upgradeOptions":
            suggest = "upgrade_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeManagementResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeManagementResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeManagementResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_repair: bool,
                 auto_upgrade: bool,
                 upgrade_options: 'outputs.AutoUpgradeOptionsResponse'):
        """
        NodeManagement defines the set of node management services turned on for the node pool.
        :param bool auto_repair: A flag that specifies whether the node auto-repair is enabled for the node pool. If enabled, the nodes in this node pool will be monitored and, if they fail health checks too many times, an automatic repair action will be triggered.
        :param bool auto_upgrade: A flag that specifies whether node auto-upgrade is enabled for the node pool. If enabled, node auto-upgrade helps keep the nodes in your node pool up to date with the latest release version of Kubernetes.
        :param 'AutoUpgradeOptionsResponse' upgrade_options: Specifies the Auto Upgrade knobs for the node pool.
        """
        pulumi.set(__self__, "auto_repair", auto_repair)
        pulumi.set(__self__, "auto_upgrade", auto_upgrade)
        pulumi.set(__self__, "upgrade_options", upgrade_options)

    @property
    @pulumi.getter(name="autoRepair")
    def auto_repair(self) -> bool:
        """
        A flag that specifies whether the node auto-repair is enabled for the node pool. If enabled, the nodes in this node pool will be monitored and, if they fail health checks too many times, an automatic repair action will be triggered.
        """
        return pulumi.get(self, "auto_repair")

    @property
    @pulumi.getter(name="autoUpgrade")
    def auto_upgrade(self) -> bool:
        """
        A flag that specifies whether node auto-upgrade is enabled for the node pool. If enabled, node auto-upgrade helps keep the nodes in your node pool up to date with the latest release version of Kubernetes.
        """
        return pulumi.get(self, "auto_upgrade")

    @property
    @pulumi.getter(name="upgradeOptions")
    def upgrade_options(self) -> 'outputs.AutoUpgradeOptionsResponse':
        """
        Specifies the Auto Upgrade knobs for the node pool.
        """
        return pulumi.get(self, "upgrade_options")


@pulumi.output_type
class NodeNetworkConfigResponse(dict):
    """
    Parameters for node pool-level network config.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createPodRange":
            suggest = "create_pod_range"
        elif key == "enablePrivateNodes":
            suggest = "enable_private_nodes"
        elif key == "networkPerformanceConfig":
            suggest = "network_performance_config"
        elif key == "podIpv4CidrBlock":
            suggest = "pod_ipv4_cidr_block"
        elif key == "podRange":
            suggest = "pod_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeNetworkConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeNetworkConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeNetworkConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_pod_range: bool,
                 enable_private_nodes: bool,
                 network_performance_config: 'outputs.NetworkPerformanceConfigResponse',
                 pod_ipv4_cidr_block: str,
                 pod_range: str):
        """
        Parameters for node pool-level network config.
        :param bool create_pod_range: Input only. Whether to create a new range for pod IPs in this node pool. Defaults are provided for `pod_range` and `pod_ipv4_cidr_block` if they are not specified. If neither `create_pod_range` or `pod_range` are specified, the cluster-level default (`ip_allocation_policy.cluster_ipv4_cidr_block`) is used. Only applicable if `ip_allocation_policy.use_ip_aliases` is true. This field cannot be changed after the node pool has been created.
        :param bool enable_private_nodes: Whether nodes have internal IP addresses only. If enable_private_nodes is not specified, then the value is derived from cluster.privateClusterConfig.enablePrivateNodes
        :param 'NetworkPerformanceConfigResponse' network_performance_config: Network bandwidth tier configuration.
        :param str pod_ipv4_cidr_block: The IP address range for pod IPs in this node pool. Only applicable if `create_pod_range` is true. Set to blank to have a range chosen with the default size. Set to /netmask (e.g. `/14`) to have a range chosen with a specific netmask. Set to a [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `10.96.0.0/14`) to pick a specific range to use. Only applicable if `ip_allocation_policy.use_ip_aliases` is true. This field cannot be changed after the node pool has been created.
        :param str pod_range: The ID of the secondary range for pod IPs. If `create_pod_range` is true, this ID is used for the new range. If `create_pod_range` is false, uses an existing secondary range with this ID. Only applicable if `ip_allocation_policy.use_ip_aliases` is true. This field cannot be changed after the node pool has been created.
        """
        pulumi.set(__self__, "create_pod_range", create_pod_range)
        pulumi.set(__self__, "enable_private_nodes", enable_private_nodes)
        pulumi.set(__self__, "network_performance_config", network_performance_config)
        pulumi.set(__self__, "pod_ipv4_cidr_block", pod_ipv4_cidr_block)
        pulumi.set(__self__, "pod_range", pod_range)

    @property
    @pulumi.getter(name="createPodRange")
    def create_pod_range(self) -> bool:
        """
        Input only. Whether to create a new range for pod IPs in this node pool. Defaults are provided for `pod_range` and `pod_ipv4_cidr_block` if they are not specified. If neither `create_pod_range` or `pod_range` are specified, the cluster-level default (`ip_allocation_policy.cluster_ipv4_cidr_block`) is used. Only applicable if `ip_allocation_policy.use_ip_aliases` is true. This field cannot be changed after the node pool has been created.
        """
        return pulumi.get(self, "create_pod_range")

    @property
    @pulumi.getter(name="enablePrivateNodes")
    def enable_private_nodes(self) -> bool:
        """
        Whether nodes have internal IP addresses only. If enable_private_nodes is not specified, then the value is derived from cluster.privateClusterConfig.enablePrivateNodes
        """
        return pulumi.get(self, "enable_private_nodes")

    @property
    @pulumi.getter(name="networkPerformanceConfig")
    def network_performance_config(self) -> 'outputs.NetworkPerformanceConfigResponse':
        """
        Network bandwidth tier configuration.
        """
        return pulumi.get(self, "network_performance_config")

    @property
    @pulumi.getter(name="podIpv4CidrBlock")
    def pod_ipv4_cidr_block(self) -> str:
        """
        The IP address range for pod IPs in this node pool. Only applicable if `create_pod_range` is true. Set to blank to have a range chosen with the default size. Set to /netmask (e.g. `/14`) to have a range chosen with a specific netmask. Set to a [CIDR](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `10.96.0.0/14`) to pick a specific range to use. Only applicable if `ip_allocation_policy.use_ip_aliases` is true. This field cannot be changed after the node pool has been created.
        """
        return pulumi.get(self, "pod_ipv4_cidr_block")

    @property
    @pulumi.getter(name="podRange")
    def pod_range(self) -> str:
        """
        The ID of the secondary range for pod IPs. If `create_pod_range` is true, this ID is used for the new range. If `create_pod_range` is false, uses an existing secondary range with this ID. Only applicable if `ip_allocation_policy.use_ip_aliases` is true. This field cannot be changed after the node pool has been created.
        """
        return pulumi.get(self, "pod_range")


@pulumi.output_type
class NodePoolAutoConfigResponse(dict):
    """
    Node pool configs that apply to all auto-provisioned node pools in autopilot clusters and node auto-provisioning enabled clusters.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkTags":
            suggest = "network_tags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolAutoConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolAutoConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolAutoConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_tags: 'outputs.NetworkTagsResponse'):
        """
        Node pool configs that apply to all auto-provisioned node pools in autopilot clusters and node auto-provisioning enabled clusters.
        :param 'NetworkTagsResponse' network_tags: The list of instance tags applied to all nodes. Tags are used to identify valid sources or targets for network firewalls and are specified by the client during cluster creation. Each tag within the list must comply with RFC1035.
        """
        pulumi.set(__self__, "network_tags", network_tags)

    @property
    @pulumi.getter(name="networkTags")
    def network_tags(self) -> 'outputs.NetworkTagsResponse':
        """
        The list of instance tags applied to all nodes. Tags are used to identify valid sources or targets for network firewalls and are specified by the client during cluster creation. Each tag within the list must comply with RFC1035.
        """
        return pulumi.get(self, "network_tags")


@pulumi.output_type
class NodePoolAutoscalingResponse(dict):
    """
    NodePoolAutoscaling contains information required by cluster autoscaler to adjust the size of the node pool to the current cluster usage.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "locationPolicy":
            suggest = "location_policy"
        elif key == "maxNodeCount":
            suggest = "max_node_count"
        elif key == "minNodeCount":
            suggest = "min_node_count"
        elif key == "totalMaxNodeCount":
            suggest = "total_max_node_count"
        elif key == "totalMinNodeCount":
            suggest = "total_min_node_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolAutoscalingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolAutoscalingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolAutoscalingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoprovisioned: bool,
                 enabled: bool,
                 location_policy: str,
                 max_node_count: int,
                 min_node_count: int,
                 total_max_node_count: int,
                 total_min_node_count: int):
        """
        NodePoolAutoscaling contains information required by cluster autoscaler to adjust the size of the node pool to the current cluster usage.
        :param bool autoprovisioned: Can this node pool be deleted automatically.
        :param bool enabled: Is autoscaling enabled for this node pool.
        :param str location_policy: Location policy used when scaling up a nodepool.
        :param int max_node_count: Maximum number of nodes for one location in the NodePool. Must be >= min_node_count. There has to be enough quota to scale up the cluster.
        :param int min_node_count: Minimum number of nodes for one location in the NodePool. Must be >= 1 and <= max_node_count.
        :param int total_max_node_count: Maximum number of nodes in the node pool. Must be greater than total_min_node_count. There has to be enough quota to scale up the cluster. The total_*_node_count fields are mutually exclusive with the *_node_count fields.
        :param int total_min_node_count: Minimum number of nodes in the node pool. Must be greater than 1 less than total_max_node_count. The total_*_node_count fields are mutually exclusive with the *_node_count fields.
        """
        pulumi.set(__self__, "autoprovisioned", autoprovisioned)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "location_policy", location_policy)
        pulumi.set(__self__, "max_node_count", max_node_count)
        pulumi.set(__self__, "min_node_count", min_node_count)
        pulumi.set(__self__, "total_max_node_count", total_max_node_count)
        pulumi.set(__self__, "total_min_node_count", total_min_node_count)

    @property
    @pulumi.getter
    def autoprovisioned(self) -> bool:
        """
        Can this node pool be deleted automatically.
        """
        return pulumi.get(self, "autoprovisioned")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Is autoscaling enabled for this node pool.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="locationPolicy")
    def location_policy(self) -> str:
        """
        Location policy used when scaling up a nodepool.
        """
        return pulumi.get(self, "location_policy")

    @property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> int:
        """
        Maximum number of nodes for one location in the NodePool. Must be >= min_node_count. There has to be enough quota to scale up the cluster.
        """
        return pulumi.get(self, "max_node_count")

    @property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> int:
        """
        Minimum number of nodes for one location in the NodePool. Must be >= 1 and <= max_node_count.
        """
        return pulumi.get(self, "min_node_count")

    @property
    @pulumi.getter(name="totalMaxNodeCount")
    def total_max_node_count(self) -> int:
        """
        Maximum number of nodes in the node pool. Must be greater than total_min_node_count. There has to be enough quota to scale up the cluster. The total_*_node_count fields are mutually exclusive with the *_node_count fields.
        """
        return pulumi.get(self, "total_max_node_count")

    @property
    @pulumi.getter(name="totalMinNodeCount")
    def total_min_node_count(self) -> int:
        """
        Minimum number of nodes in the node pool. Must be greater than 1 less than total_max_node_count. The total_*_node_count fields are mutually exclusive with the *_node_count fields.
        """
        return pulumi.get(self, "total_min_node_count")


@pulumi.output_type
class NodePoolDefaultsResponse(dict):
    """
    Subset of Nodepool message that has defaults.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeConfigDefaults":
            suggest = "node_config_defaults"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolDefaultsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolDefaultsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolDefaultsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_config_defaults: 'outputs.NodeConfigDefaultsResponse'):
        """
        Subset of Nodepool message that has defaults.
        :param 'NodeConfigDefaultsResponse' node_config_defaults: Subset of NodeConfig message that has defaults.
        """
        pulumi.set(__self__, "node_config_defaults", node_config_defaults)

    @property
    @pulumi.getter(name="nodeConfigDefaults")
    def node_config_defaults(self) -> 'outputs.NodeConfigDefaultsResponse':
        """
        Subset of NodeConfig message that has defaults.
        """
        return pulumi.get(self, "node_config_defaults")


@pulumi.output_type
class NodePoolLoggingConfigResponse(dict):
    """
    NodePoolLoggingConfig specifies logging configuration for nodepools.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "variantConfig":
            suggest = "variant_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolLoggingConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolLoggingConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolLoggingConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 variant_config: 'outputs.LoggingVariantConfigResponse'):
        """
        NodePoolLoggingConfig specifies logging configuration for nodepools.
        :param 'LoggingVariantConfigResponse' variant_config: Logging variant configuration.
        """
        pulumi.set(__self__, "variant_config", variant_config)

    @property
    @pulumi.getter(name="variantConfig")
    def variant_config(self) -> 'outputs.LoggingVariantConfigResponse':
        """
        Logging variant configuration.
        """
        return pulumi.get(self, "variant_config")


@pulumi.output_type
class NodePoolResponse(dict):
    """
    NodePool contains the name and configuration for a cluster's node pool. Node pools are a set of nodes (i.e. VM's), with a common configuration and specification, under the control of the cluster master. They may have a set of Kubernetes labels applied to them, which may be used to reference them during pod scheduling. They may also be resized up or down, to accommodate the workload.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "initialNodeCount":
            suggest = "initial_node_count"
        elif key == "instanceGroupUrls":
            suggest = "instance_group_urls"
        elif key == "maxPodsConstraint":
            suggest = "max_pods_constraint"
        elif key == "networkConfig":
            suggest = "network_config"
        elif key == "placementPolicy":
            suggest = "placement_policy"
        elif key == "podIpv4CidrSize":
            suggest = "pod_ipv4_cidr_size"
        elif key == "selfLink":
            suggest = "self_link"
        elif key == "statusMessage":
            suggest = "status_message"
        elif key == "updateInfo":
            suggest = "update_info"
        elif key == "upgradeSettings":
            suggest = "upgrade_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscaling: 'outputs.NodePoolAutoscalingResponse',
                 conditions: Sequence['outputs.StatusConditionResponse'],
                 config: 'outputs.NodeConfigResponse',
                 etag: str,
                 initial_node_count: int,
                 instance_group_urls: Sequence[str],
                 locations: Sequence[str],
                 management: 'outputs.NodeManagementResponse',
                 max_pods_constraint: 'outputs.MaxPodsConstraintResponse',
                 name: str,
                 network_config: 'outputs.NodeNetworkConfigResponse',
                 placement_policy: 'outputs.PlacementPolicyResponse',
                 pod_ipv4_cidr_size: int,
                 self_link: str,
                 status: str,
                 status_message: str,
                 update_info: 'outputs.UpdateInfoResponse',
                 upgrade_settings: 'outputs.UpgradeSettingsResponse',
                 version: str):
        """
        NodePool contains the name and configuration for a cluster's node pool. Node pools are a set of nodes (i.e. VM's), with a common configuration and specification, under the control of the cluster master. They may have a set of Kubernetes labels applied to them, which may be used to reference them during pod scheduling. They may also be resized up or down, to accommodate the workload.
        :param 'NodePoolAutoscalingResponse' autoscaling: Autoscaler configuration for this NodePool. Autoscaler is enabled only if a valid configuration is present.
        :param Sequence['StatusConditionResponse'] conditions: Which conditions caused the current node pool state.
        :param 'NodeConfigResponse' config: The node configuration of the pool.
        :param str etag: This checksum is computed by the server based on the value of node pool fields, and may be sent on update requests to ensure the client has an up-to-date value before proceeding.
        :param int initial_node_count: The initial node count for the pool. You must ensure that your Compute Engine [resource quota](https://cloud.google.com/compute/quotas) is sufficient for this number of instances. You must also have available firewall and routes quota.
        :param Sequence[str] instance_group_urls: [Output only] The resource URLs of the [managed instance groups](https://cloud.google.com/compute/docs/instance-groups/creating-groups-of-managed-instances) associated with this node pool. During the node pool blue-green upgrade operation, the URLs contain both blue and green resources.
        :param Sequence[str] locations: The list of Google Compute Engine [zones](https://cloud.google.com/compute/docs/zones#available) in which the NodePool's nodes should be located. If this value is unspecified during node pool creation, the [Cluster.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters#Cluster.FIELDS.locations) value will be used, instead. Warning: changing node pool locations will result in nodes being added and/or removed.
        :param 'NodeManagementResponse' management: NodeManagement configuration for this NodePool.
        :param 'MaxPodsConstraintResponse' max_pods_constraint: The constraint on the maximum number of pods that can be run simultaneously on a node in the node pool.
        :param str name: The name of the node pool.
        :param 'NodeNetworkConfigResponse' network_config: Networking configuration for this NodePool. If specified, it overrides the cluster-level defaults.
        :param 'PlacementPolicyResponse' placement_policy: Specifies the node placement policy.
        :param int pod_ipv4_cidr_size: [Output only] The pod CIDR block size per node in this node pool.
        :param str self_link: [Output only] Server-defined URL for the resource.
        :param str status: [Output only] The status of the nodes in this pool instance.
        :param str status_message: [Output only] Deprecated. Use conditions instead. Additional information about the current status of this node pool instance, if available.
        :param 'UpdateInfoResponse' update_info: [Output only] Update info contains relevant information during a node pool update.
        :param 'UpgradeSettingsResponse' upgrade_settings: Upgrade settings control disruption and speed of the upgrade.
        :param str version: The version of Kubernetes running on this NodePool's nodes. If unspecified, it defaults as described [here](https://cloud.google.com/kubernetes-engine/versioning#specifying_node_version).
        """
        pulumi.set(__self__, "autoscaling", autoscaling)
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "config", config)
        pulumi.set(__self__, "etag", etag)
        pulumi.set(__self__, "initial_node_count", initial_node_count)
        pulumi.set(__self__, "instance_group_urls", instance_group_urls)
        pulumi.set(__self__, "locations", locations)
        pulumi.set(__self__, "management", management)
        pulumi.set(__self__, "max_pods_constraint", max_pods_constraint)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_config", network_config)
        pulumi.set(__self__, "placement_policy", placement_policy)
        pulumi.set(__self__, "pod_ipv4_cidr_size", pod_ipv4_cidr_size)
        pulumi.set(__self__, "self_link", self_link)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "status_message", status_message)
        pulumi.set(__self__, "update_info", update_info)
        pulumi.set(__self__, "upgrade_settings", upgrade_settings)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def autoscaling(self) -> 'outputs.NodePoolAutoscalingResponse':
        """
        Autoscaler configuration for this NodePool. Autoscaler is enabled only if a valid configuration is present.
        """
        return pulumi.get(self, "autoscaling")

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.StatusConditionResponse']:
        """
        Which conditions caused the current node pool state.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def config(self) -> 'outputs.NodeConfigResponse':
        """
        The node configuration of the pool.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        This checksum is computed by the server based on the value of node pool fields, and may be sent on update requests to ensure the client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="initialNodeCount")
    def initial_node_count(self) -> int:
        """
        The initial node count for the pool. You must ensure that your Compute Engine [resource quota](https://cloud.google.com/compute/quotas) is sufficient for this number of instances. You must also have available firewall and routes quota.
        """
        return pulumi.get(self, "initial_node_count")

    @property
    @pulumi.getter(name="instanceGroupUrls")
    def instance_group_urls(self) -> Sequence[str]:
        """
        [Output only] The resource URLs of the [managed instance groups](https://cloud.google.com/compute/docs/instance-groups/creating-groups-of-managed-instances) associated with this node pool. During the node pool blue-green upgrade operation, the URLs contain both blue and green resources.
        """
        return pulumi.get(self, "instance_group_urls")

    @property
    @pulumi.getter
    def locations(self) -> Sequence[str]:
        """
        The list of Google Compute Engine [zones](https://cloud.google.com/compute/docs/zones#available) in which the NodePool's nodes should be located. If this value is unspecified during node pool creation, the [Cluster.Locations](https://cloud.google.com/kubernetes-engine/docs/reference/rest/v1/projects.locations.clusters#Cluster.FIELDS.locations) value will be used, instead. Warning: changing node pool locations will result in nodes being added and/or removed.
        """
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter
    def management(self) -> 'outputs.NodeManagementResponse':
        """
        NodeManagement configuration for this NodePool.
        """
        return pulumi.get(self, "management")

    @property
    @pulumi.getter(name="maxPodsConstraint")
    def max_pods_constraint(self) -> 'outputs.MaxPodsConstraintResponse':
        """
        The constraint on the maximum number of pods that can be run simultaneously on a node in the node pool.
        """
        return pulumi.get(self, "max_pods_constraint")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the node pool.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> 'outputs.NodeNetworkConfigResponse':
        """
        Networking configuration for this NodePool. If specified, it overrides the cluster-level defaults.
        """
        return pulumi.get(self, "network_config")

    @property
    @pulumi.getter(name="placementPolicy")
    def placement_policy(self) -> 'outputs.PlacementPolicyResponse':
        """
        Specifies the node placement policy.
        """
        return pulumi.get(self, "placement_policy")

    @property
    @pulumi.getter(name="podIpv4CidrSize")
    def pod_ipv4_cidr_size(self) -> int:
        """
        [Output only] The pod CIDR block size per node in this node pool.
        """
        return pulumi.get(self, "pod_ipv4_cidr_size")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> str:
        """
        [Output only] Server-defined URL for the resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        [Output only] The status of the nodes in this pool instance.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> str:
        """
        [Output only] Deprecated. Use conditions instead. Additional information about the current status of this node pool instance, if available.
        """
        return pulumi.get(self, "status_message")

    @property
    @pulumi.getter(name="updateInfo")
    def update_info(self) -> 'outputs.UpdateInfoResponse':
        """
        [Output only] Update info contains relevant information during a node pool update.
        """
        return pulumi.get(self, "update_info")

    @property
    @pulumi.getter(name="upgradeSettings")
    def upgrade_settings(self) -> 'outputs.UpgradeSettingsResponse':
        """
        Upgrade settings control disruption and speed of the upgrade.
        """
        return pulumi.get(self, "upgrade_settings")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The version of Kubernetes running on this NodePool's nodes. If unspecified, it defaults as described [here](https://cloud.google.com/kubernetes-engine/versioning#specifying_node_version).
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class NodeTaintResponse(dict):
    """
    Kubernetes taint is comprised of three fields: key, value, and effect. Effect can only be one of three types: NoSchedule, PreferNoSchedule or NoExecute. See [here](https://kubernetes.io/docs/concepts/configuration/taint-and-toleration) for more information, including usage and the valid values.
    """
    def __init__(__self__, *,
                 effect: str,
                 key: str,
                 value: str):
        """
        Kubernetes taint is comprised of three fields: key, value, and effect. Effect can only be one of three types: NoSchedule, PreferNoSchedule or NoExecute. See [here](https://kubernetes.io/docs/concepts/configuration/taint-and-toleration) for more information, including usage and the valid values.
        :param str effect: Effect for taint.
        :param str key: Key for taint.
        :param str value: Value for taint.
        """
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> str:
        """
        Effect for taint.
        """
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Key for taint.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Value for taint.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class NotificationConfigResponse(dict):
    """
    NotificationConfig is the configuration of notifications.
    """
    def __init__(__self__, *,
                 pubsub: 'outputs.PubSubResponse'):
        """
        NotificationConfig is the configuration of notifications.
        :param 'PubSubResponse' pubsub: Notification config for Pub/Sub.
        """
        pulumi.set(__self__, "pubsub", pubsub)

    @property
    @pulumi.getter
    def pubsub(self) -> 'outputs.PubSubResponse':
        """
        Notification config for Pub/Sub.
        """
        return pulumi.get(self, "pubsub")


@pulumi.output_type
class PlacementPolicyResponse(dict):
    """
    PlacementPolicy defines the placement policy used by the node pool.
    """
    def __init__(__self__, *,
                 type: str):
        """
        PlacementPolicy defines the placement policy used by the node pool.
        :param str type: The type of placement.
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of placement.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PrivateClusterConfigResponse(dict):
    """
    Configuration options for private clusters.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enablePrivateEndpoint":
            suggest = "enable_private_endpoint"
        elif key == "enablePrivateNodes":
            suggest = "enable_private_nodes"
        elif key == "masterGlobalAccessConfig":
            suggest = "master_global_access_config"
        elif key == "masterIpv4CidrBlock":
            suggest = "master_ipv4_cidr_block"
        elif key == "peeringName":
            suggest = "peering_name"
        elif key == "privateEndpoint":
            suggest = "private_endpoint"
        elif key == "privateEndpointSubnetwork":
            suggest = "private_endpoint_subnetwork"
        elif key == "publicEndpoint":
            suggest = "public_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrivateClusterConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrivateClusterConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrivateClusterConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_private_endpoint: bool,
                 enable_private_nodes: bool,
                 master_global_access_config: 'outputs.PrivateClusterMasterGlobalAccessConfigResponse',
                 master_ipv4_cidr_block: str,
                 peering_name: str,
                 private_endpoint: str,
                 private_endpoint_subnetwork: str,
                 public_endpoint: str):
        """
        Configuration options for private clusters.
        :param bool enable_private_endpoint: Whether the master's internal IP address is used as the cluster endpoint.
        :param bool enable_private_nodes: Whether nodes have internal IP addresses only. If enabled, all nodes are given only RFC 1918 private addresses and communicate with the master via private networking.
        :param 'PrivateClusterMasterGlobalAccessConfigResponse' master_global_access_config: Controls master global access settings.
        :param str master_ipv4_cidr_block: The IP range in CIDR notation to use for the hosted master network. This range will be used for assigning internal IP addresses to the master or set of masters, as well as the ILB VIP. This range must not overlap with any other ranges in use within the cluster's network.
        :param str peering_name: The peering name in the customer VPC used by this cluster.
        :param str private_endpoint: The internal IP address of this cluster's master endpoint.
        :param str private_endpoint_subnetwork: Subnet to provision the master's private endpoint during cluster creation. Specified in projects/*/regions/*/subnetworks/* format.
        :param str public_endpoint: The external IP address of this cluster's master endpoint.
        """
        pulumi.set(__self__, "enable_private_endpoint", enable_private_endpoint)
        pulumi.set(__self__, "enable_private_nodes", enable_private_nodes)
        pulumi.set(__self__, "master_global_access_config", master_global_access_config)
        pulumi.set(__self__, "master_ipv4_cidr_block", master_ipv4_cidr_block)
        pulumi.set(__self__, "peering_name", peering_name)
        pulumi.set(__self__, "private_endpoint", private_endpoint)
        pulumi.set(__self__, "private_endpoint_subnetwork", private_endpoint_subnetwork)
        pulumi.set(__self__, "public_endpoint", public_endpoint)

    @property
    @pulumi.getter(name="enablePrivateEndpoint")
    def enable_private_endpoint(self) -> bool:
        """
        Whether the master's internal IP address is used as the cluster endpoint.
        """
        return pulumi.get(self, "enable_private_endpoint")

    @property
    @pulumi.getter(name="enablePrivateNodes")
    def enable_private_nodes(self) -> bool:
        """
        Whether nodes have internal IP addresses only. If enabled, all nodes are given only RFC 1918 private addresses and communicate with the master via private networking.
        """
        return pulumi.get(self, "enable_private_nodes")

    @property
    @pulumi.getter(name="masterGlobalAccessConfig")
    def master_global_access_config(self) -> 'outputs.PrivateClusterMasterGlobalAccessConfigResponse':
        """
        Controls master global access settings.
        """
        return pulumi.get(self, "master_global_access_config")

    @property
    @pulumi.getter(name="masterIpv4CidrBlock")
    def master_ipv4_cidr_block(self) -> str:
        """
        The IP range in CIDR notation to use for the hosted master network. This range will be used for assigning internal IP addresses to the master or set of masters, as well as the ILB VIP. This range must not overlap with any other ranges in use within the cluster's network.
        """
        return pulumi.get(self, "master_ipv4_cidr_block")

    @property
    @pulumi.getter(name="peeringName")
    def peering_name(self) -> str:
        """
        The peering name in the customer VPC used by this cluster.
        """
        return pulumi.get(self, "peering_name")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> str:
        """
        The internal IP address of this cluster's master endpoint.
        """
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter(name="privateEndpointSubnetwork")
    def private_endpoint_subnetwork(self) -> str:
        """
        Subnet to provision the master's private endpoint during cluster creation. Specified in projects/*/regions/*/subnetworks/* format.
        """
        return pulumi.get(self, "private_endpoint_subnetwork")

    @property
    @pulumi.getter(name="publicEndpoint")
    def public_endpoint(self) -> str:
        """
        The external IP address of this cluster's master endpoint.
        """
        return pulumi.get(self, "public_endpoint")


@pulumi.output_type
class PrivateClusterMasterGlobalAccessConfigResponse(dict):
    """
    Configuration for controlling master global access settings.
    """
    def __init__(__self__, *,
                 enabled: bool):
        """
        Configuration for controlling master global access settings.
        :param bool enabled: Whenever master is accessible globally or not.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whenever master is accessible globally or not.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class PubSubResponse(dict):
    """
    Pub/Sub specific notification config.
    """
    def __init__(__self__, *,
                 enabled: bool,
                 filter: 'outputs.FilterResponse',
                 topic: str):
        """
        Pub/Sub specific notification config.
        :param bool enabled: Enable notifications for Pub/Sub.
        :param 'FilterResponse' filter: Allows filtering to one or more specific event types. If no filter is specified, or if a filter is specified with no event types, all event types will be sent
        :param str topic: The desired Pub/Sub topic to which notifications will be sent by GKE. Format is `projects/{project}/topics/{topic}`.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "topic", topic)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Enable notifications for Pub/Sub.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def filter(self) -> 'outputs.FilterResponse':
        """
        Allows filtering to one or more specific event types. If no filter is specified, or if a filter is specified with no event types, all event types will be sent
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def topic(self) -> str:
        """
        The desired Pub/Sub topic to which notifications will be sent by GKE. Format is `projects/{project}/topics/{topic}`.
        """
        return pulumi.get(self, "topic")


@pulumi.output_type
class RecurringTimeWindowResponse(dict):
    """
    Represents an arbitrary window of time that recurs.
    """
    def __init__(__self__, *,
                 recurrence: str,
                 window: 'outputs.TimeWindowResponse'):
        """
        Represents an arbitrary window of time that recurs.
        :param str recurrence: An RRULE (https://tools.ietf.org/html/rfc5545#section-3.8.5.3) for how this window reccurs. They go on for the span of time between the start and end time. For example, to have something repeat every weekday, you'd use: `FREQ=WEEKLY;BYDAY=MO,TU,WE,TH,FR` To repeat some window daily (equivalent to the DailyMaintenanceWindow): `FREQ=DAILY` For the first weekend of every month: `FREQ=MONTHLY;BYSETPOS=1;BYDAY=SA,SU` This specifies how frequently the window starts. Eg, if you wanted to have a 9-5 UTC-4 window every weekday, you'd use something like: ``` start time = 2019-01-01T09:00:00-0400 end time = 2019-01-01T17:00:00-0400 recurrence = FREQ=WEEKLY;BYDAY=MO,TU,WE,TH,FR ``` Windows can span multiple days. Eg, to make the window encompass every weekend from midnight Saturday till the last minute of Sunday UTC: ``` start time = 2019-01-05T00:00:00Z end time = 2019-01-07T23:59:00Z recurrence = FREQ=WEEKLY;BYDAY=SA ``` Note the start and end time's specific dates are largely arbitrary except to specify duration of the window and when it first starts. The FREQ values of HOURLY, MINUTELY, and SECONDLY are not supported.
        :param 'TimeWindowResponse' window: The window of the first recurrence.
        """
        pulumi.set(__self__, "recurrence", recurrence)
        pulumi.set(__self__, "window", window)

    @property
    @pulumi.getter
    def recurrence(self) -> str:
        """
        An RRULE (https://tools.ietf.org/html/rfc5545#section-3.8.5.3) for how this window reccurs. They go on for the span of time between the start and end time. For example, to have something repeat every weekday, you'd use: `FREQ=WEEKLY;BYDAY=MO,TU,WE,TH,FR` To repeat some window daily (equivalent to the DailyMaintenanceWindow): `FREQ=DAILY` For the first weekend of every month: `FREQ=MONTHLY;BYSETPOS=1;BYDAY=SA,SU` This specifies how frequently the window starts. Eg, if you wanted to have a 9-5 UTC-4 window every weekday, you'd use something like: ``` start time = 2019-01-01T09:00:00-0400 end time = 2019-01-01T17:00:00-0400 recurrence = FREQ=WEEKLY;BYDAY=MO,TU,WE,TH,FR ``` Windows can span multiple days. Eg, to make the window encompass every weekend from midnight Saturday till the last minute of Sunday UTC: ``` start time = 2019-01-05T00:00:00Z end time = 2019-01-07T23:59:00Z recurrence = FREQ=WEEKLY;BYDAY=SA ``` Note the start and end time's specific dates are largely arbitrary except to specify duration of the window and when it first starts. The FREQ values of HOURLY, MINUTELY, and SECONDLY are not supported.
        """
        return pulumi.get(self, "recurrence")

    @property
    @pulumi.getter
    def window(self) -> 'outputs.TimeWindowResponse':
        """
        The window of the first recurrence.
        """
        return pulumi.get(self, "window")


@pulumi.output_type
class ReleaseChannelConfigResponse(dict):
    """
    ReleaseChannelConfig exposes configuration for a release channel.
    """
    def __init__(__self__, *,
                 channel: str,
                 default_version: str,
                 valid_versions: Sequence[str]):
        """
        ReleaseChannelConfig exposes configuration for a release channel.
        :param str channel: The release channel this configuration applies to.
        :param str default_version: The default version for newly created clusters on the channel.
        :param Sequence[str] valid_versions: List of valid versions for the channel.
        """
        pulumi.set(__self__, "channel", channel)
        pulumi.set(__self__, "default_version", default_version)
        pulumi.set(__self__, "valid_versions", valid_versions)

    @property
    @pulumi.getter
    def channel(self) -> str:
        """
        The release channel this configuration applies to.
        """
        return pulumi.get(self, "channel")

    @property
    @pulumi.getter(name="defaultVersion")
    def default_version(self) -> str:
        """
        The default version for newly created clusters on the channel.
        """
        return pulumi.get(self, "default_version")

    @property
    @pulumi.getter(name="validVersions")
    def valid_versions(self) -> Sequence[str]:
        """
        List of valid versions for the channel.
        """
        return pulumi.get(self, "valid_versions")


@pulumi.output_type
class ReleaseChannelResponse(dict):
    """
    ReleaseChannel indicates which release channel a cluster is subscribed to. Release channels are arranged in order of risk. When a cluster is subscribed to a release channel, Google maintains both the master version and the node version. Node auto-upgrade defaults to true and cannot be disabled.
    """
    def __init__(__self__, *,
                 channel: str):
        """
        ReleaseChannel indicates which release channel a cluster is subscribed to. Release channels are arranged in order of risk. When a cluster is subscribed to a release channel, Google maintains both the master version and the node version. Node auto-upgrade defaults to true and cannot be disabled.
        :param str channel: channel specifies which release channel the cluster is subscribed to.
        """
        pulumi.set(__self__, "channel", channel)

    @property
    @pulumi.getter
    def channel(self) -> str:
        """
        channel specifies which release channel the cluster is subscribed to.
        """
        return pulumi.get(self, "channel")


@pulumi.output_type
class ReservationAffinityResponse(dict):
    """
    [ReservationAffinity](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources) is the configuration of desired reservation which instances could take capacity from.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "consumeReservationType":
            suggest = "consume_reservation_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReservationAffinityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReservationAffinityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReservationAffinityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 consume_reservation_type: str,
                 key: str,
                 values: Sequence[str]):
        """
        [ReservationAffinity](https://cloud.google.com/compute/docs/instances/reserving-zonal-resources) is the configuration of desired reservation which instances could take capacity from.
        :param str consume_reservation_type: Corresponds to the type of reservation consumption.
        :param str key: Corresponds to the label key of a reservation resource. To target a SPECIFIC_RESERVATION by name, specify "compute.googleapis.com/reservation-name" as the key and specify the name of your reservation as its value.
        :param Sequence[str] values: Corresponds to the label value(s) of reservation resource(s).
        """
        pulumi.set(__self__, "consume_reservation_type", consume_reservation_type)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="consumeReservationType")
    def consume_reservation_type(self) -> str:
        """
        Corresponds to the type of reservation consumption.
        """
        return pulumi.get(self, "consume_reservation_type")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Corresponds to the label key of a reservation resource. To target a SPECIFIC_RESERVATION by name, specify "compute.googleapis.com/reservation-name" as the key and specify the name of your reservation as its value.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Corresponds to the label value(s) of reservation resource(s).
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class ResourceLimitResponse(dict):
    """
    Contains information about amount of some resource in the cluster. For memory, value should be in GB.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceType":
            suggest = "resource_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceLimitResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceLimitResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceLimitResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 maximum: str,
                 minimum: str,
                 resource_type: str):
        """
        Contains information about amount of some resource in the cluster. For memory, value should be in GB.
        :param str maximum: Maximum amount of the resource in the cluster.
        :param str minimum: Minimum amount of the resource in the cluster.
        :param str resource_type: Resource name "cpu", "memory" or gpu-specific string.
        """
        pulumi.set(__self__, "maximum", maximum)
        pulumi.set(__self__, "minimum", minimum)
        pulumi.set(__self__, "resource_type", resource_type)

    @property
    @pulumi.getter
    def maximum(self) -> str:
        """
        Maximum amount of the resource in the cluster.
        """
        return pulumi.get(self, "maximum")

    @property
    @pulumi.getter
    def minimum(self) -> str:
        """
        Minimum amount of the resource in the cluster.
        """
        return pulumi.get(self, "minimum")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        Resource name "cpu", "memory" or gpu-specific string.
        """
        return pulumi.get(self, "resource_type")


@pulumi.output_type
class ResourceUsageExportConfigResponse(dict):
    """
    Configuration for exporting cluster resource usages.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bigqueryDestination":
            suggest = "bigquery_destination"
        elif key == "consumptionMeteringConfig":
            suggest = "consumption_metering_config"
        elif key == "enableNetworkEgressMetering":
            suggest = "enable_network_egress_metering"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceUsageExportConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceUsageExportConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceUsageExportConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bigquery_destination: 'outputs.BigQueryDestinationResponse',
                 consumption_metering_config: 'outputs.ConsumptionMeteringConfigResponse',
                 enable_network_egress_metering: bool):
        """
        Configuration for exporting cluster resource usages.
        :param 'BigQueryDestinationResponse' bigquery_destination: Configuration to use BigQuery as usage export destination.
        :param 'ConsumptionMeteringConfigResponse' consumption_metering_config: Configuration to enable resource consumption metering.
        :param bool enable_network_egress_metering: Whether to enable network egress metering for this cluster. If enabled, a daemonset will be created in the cluster to meter network egress traffic.
        """
        pulumi.set(__self__, "bigquery_destination", bigquery_destination)
        pulumi.set(__self__, "consumption_metering_config", consumption_metering_config)
        pulumi.set(__self__, "enable_network_egress_metering", enable_network_egress_metering)

    @property
    @pulumi.getter(name="bigqueryDestination")
    def bigquery_destination(self) -> 'outputs.BigQueryDestinationResponse':
        """
        Configuration to use BigQuery as usage export destination.
        """
        return pulumi.get(self, "bigquery_destination")

    @property
    @pulumi.getter(name="consumptionMeteringConfig")
    def consumption_metering_config(self) -> 'outputs.ConsumptionMeteringConfigResponse':
        """
        Configuration to enable resource consumption metering.
        """
        return pulumi.get(self, "consumption_metering_config")

    @property
    @pulumi.getter(name="enableNetworkEgressMetering")
    def enable_network_egress_metering(self) -> bool:
        """
        Whether to enable network egress metering for this cluster. If enabled, a daemonset will be created in the cluster to meter network egress traffic.
        """
        return pulumi.get(self, "enable_network_egress_metering")


@pulumi.output_type
class SandboxConfigResponse(dict):
    """
    SandboxConfig contains configurations of the sandbox to use for the node.
    """
    def __init__(__self__, *,
                 type: str):
        """
        SandboxConfig contains configurations of the sandbox to use for the node.
        :param str type: Type of the sandbox to use for the node.
        """
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the sandbox to use for the node.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ServiceExternalIPsConfigResponse(dict):
    """
    Config to block services with externalIPs field.
    """
    def __init__(__self__, *,
                 enabled: bool):
        """
        Config to block services with externalIPs field.
        :param bool enabled: Whether Services with ExternalIPs field are allowed or not.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether Services with ExternalIPs field are allowed or not.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ShieldedInstanceConfigResponse(dict):
    """
    A set of Shielded Instance options.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableIntegrityMonitoring":
            suggest = "enable_integrity_monitoring"
        elif key == "enableSecureBoot":
            suggest = "enable_secure_boot"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ShieldedInstanceConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ShieldedInstanceConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ShieldedInstanceConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_integrity_monitoring: bool,
                 enable_secure_boot: bool):
        """
        A set of Shielded Instance options.
        :param bool enable_integrity_monitoring: Defines whether the instance has integrity monitoring enabled. Enables monitoring and attestation of the boot integrity of the instance. The attestation is performed against the integrity policy baseline. This baseline is initially derived from the implicitly trusted boot image when the instance is created.
        :param bool enable_secure_boot: Defines whether the instance has Secure Boot enabled. Secure Boot helps ensure that the system only runs authentic software by verifying the digital signature of all boot components, and halting the boot process if signature verification fails.
        """
        pulumi.set(__self__, "enable_integrity_monitoring", enable_integrity_monitoring)
        pulumi.set(__self__, "enable_secure_boot", enable_secure_boot)

    @property
    @pulumi.getter(name="enableIntegrityMonitoring")
    def enable_integrity_monitoring(self) -> bool:
        """
        Defines whether the instance has integrity monitoring enabled. Enables monitoring and attestation of the boot integrity of the instance. The attestation is performed against the integrity policy baseline. This baseline is initially derived from the implicitly trusted boot image when the instance is created.
        """
        return pulumi.get(self, "enable_integrity_monitoring")

    @property
    @pulumi.getter(name="enableSecureBoot")
    def enable_secure_boot(self) -> bool:
        """
        Defines whether the instance has Secure Boot enabled. Secure Boot helps ensure that the system only runs authentic software by verifying the digital signature of all boot components, and halting the boot process if signature verification fails.
        """
        return pulumi.get(self, "enable_secure_boot")


@pulumi.output_type
class ShieldedNodesResponse(dict):
    """
    Configuration of Shielded Nodes feature.
    """
    def __init__(__self__, *,
                 enabled: bool):
        """
        Configuration of Shielded Nodes feature.
        :param bool enabled: Whether Shielded Nodes features are enabled on all nodes in this cluster.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether Shielded Nodes features are enabled on all nodes in this cluster.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class StandardRolloutPolicyResponse(dict):
    """
    Standard rollout policy is the default policy for blue-green.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "batchNodeCount":
            suggest = "batch_node_count"
        elif key == "batchPercentage":
            suggest = "batch_percentage"
        elif key == "batchSoakDuration":
            suggest = "batch_soak_duration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StandardRolloutPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StandardRolloutPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StandardRolloutPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 batch_node_count: int,
                 batch_percentage: float,
                 batch_soak_duration: str):
        """
        Standard rollout policy is the default policy for blue-green.
        :param int batch_node_count: Number of blue nodes to drain in a batch.
        :param float batch_percentage: Percentage of the blue pool nodes to drain in a batch. The range of this field should be (0.0, 1.0].
        :param str batch_soak_duration: Soak time after each batch gets drained. Default to zero.
        """
        pulumi.set(__self__, "batch_node_count", batch_node_count)
        pulumi.set(__self__, "batch_percentage", batch_percentage)
        pulumi.set(__self__, "batch_soak_duration", batch_soak_duration)

    @property
    @pulumi.getter(name="batchNodeCount")
    def batch_node_count(self) -> int:
        """
        Number of blue nodes to drain in a batch.
        """
        return pulumi.get(self, "batch_node_count")

    @property
    @pulumi.getter(name="batchPercentage")
    def batch_percentage(self) -> float:
        """
        Percentage of the blue pool nodes to drain in a batch. The range of this field should be (0.0, 1.0].
        """
        return pulumi.get(self, "batch_percentage")

    @property
    @pulumi.getter(name="batchSoakDuration")
    def batch_soak_duration(self) -> str:
        """
        Soak time after each batch gets drained. Default to zero.
        """
        return pulumi.get(self, "batch_soak_duration")


@pulumi.output_type
class StatusConditionResponse(dict):
    """
    StatusCondition describes why a cluster or a node pool has a certain status (e.g., ERROR or DEGRADED).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "canonicalCode":
            suggest = "canonical_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StatusConditionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StatusConditionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StatusConditionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 canonical_code: str,
                 code: str,
                 message: str):
        """
        StatusCondition describes why a cluster or a node pool has a certain status (e.g., ERROR or DEGRADED).
        :param str canonical_code: Canonical code of the condition.
        :param str code: Machine-friendly representation of the condition Deprecated. Use canonical_code instead.
        :param str message: Human-friendly representation of the condition
        """
        pulumi.set(__self__, "canonical_code", canonical_code)
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter(name="canonicalCode")
    def canonical_code(self) -> str:
        """
        Canonical code of the condition.
        """
        return pulumi.get(self, "canonical_code")

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        Machine-friendly representation of the condition Deprecated. Use canonical_code instead.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Human-friendly representation of the condition
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class TimeWindowResponse(dict):
    """
    Represents an arbitrary window of time.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "maintenanceExclusionOptions":
            suggest = "maintenance_exclusion_options"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TimeWindowResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TimeWindowResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TimeWindowResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time: str,
                 maintenance_exclusion_options: 'outputs.MaintenanceExclusionOptionsResponse',
                 start_time: str):
        """
        Represents an arbitrary window of time.
        :param str end_time: The time that the window ends. The end time should take place after the start time.
        :param 'MaintenanceExclusionOptionsResponse' maintenance_exclusion_options: MaintenanceExclusionOptions provides maintenance exclusion related options.
        :param str start_time: The time that the window first starts.
        """
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "maintenance_exclusion_options", maintenance_exclusion_options)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        The time that the window ends. The end time should take place after the start time.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="maintenanceExclusionOptions")
    def maintenance_exclusion_options(self) -> 'outputs.MaintenanceExclusionOptionsResponse':
        """
        MaintenanceExclusionOptions provides maintenance exclusion related options.
        """
        return pulumi.get(self, "maintenance_exclusion_options")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        The time that the window first starts.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class UpdateInfoResponse(dict):
    """
    UpdateInfo contains resource (instance groups, etc), status and other intermediate information relevant to a node pool upgrade.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blueGreenInfo":
            suggest = "blue_green_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UpdateInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UpdateInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UpdateInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 blue_green_info: 'outputs.BlueGreenInfoResponse'):
        """
        UpdateInfo contains resource (instance groups, etc), status and other intermediate information relevant to a node pool upgrade.
        :param 'BlueGreenInfoResponse' blue_green_info: Information of a blue-green upgrade.
        """
        pulumi.set(__self__, "blue_green_info", blue_green_info)

    @property
    @pulumi.getter(name="blueGreenInfo")
    def blue_green_info(self) -> 'outputs.BlueGreenInfoResponse':
        """
        Information of a blue-green upgrade.
        """
        return pulumi.get(self, "blue_green_info")


@pulumi.output_type
class UpgradeSettingsResponse(dict):
    """
    These upgrade settings control the level of parallelism and the level of disruption caused by an upgrade. maxUnavailable controls the number of nodes that can be simultaneously unavailable. maxSurge controls the number of additional nodes that can be added to the node pool temporarily for the time of the upgrade to increase the number of available nodes. (maxUnavailable + maxSurge) determines the level of parallelism (how many nodes are being upgraded at the same time). Note: upgrades inevitably introduce some disruption since workloads need to be moved from old nodes to new, upgraded ones. Even if maxUnavailable=0, this holds true. (Disruption stays within the limits of PodDisruptionBudget, if it is configured.) Consider a hypothetical node pool with 5 nodes having maxSurge=2, maxUnavailable=1. This means the upgrade process upgrades 3 nodes simultaneously. It creates 2 additional (upgraded) nodes, then it brings down 3 old (not yet upgraded) nodes at the same time. This ensures that there are always at least 4 nodes available. These upgrade settings configure the upgrade strategy for the node pool. Use strategy to switch between the strategies applied to the node pool. If the strategy is ROLLING, use max_surge and max_unavailable to control the level of parallelism and the level of disruption caused by upgrade. 1. maxSurge controls the number of additional nodes that can be added to the node pool temporarily for the time of the upgrade to increase the number of available nodes. 2. maxUnavailable controls the number of nodes that can be simultaneously unavailable. 3. (maxUnavailable + maxSurge) determines the level of parallelism (how many nodes are being upgraded at the same time). If the strategy is BLUE_GREEN, use blue_green_settings to configure the blue-green upgrade related settings. 1. standard_rollout_policy is the default policy. The policy is used to control the way blue pool gets drained. The draining is executed in the batch mode. The batch size could be specified as either percentage of the node pool size or the number of nodes. batch_soak_duration is the soak time after each batch gets drained. 2. node_pool_soak_duration is the soak time after all blue nodes are drained. After this period, the blue pool nodes will be deleted.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blueGreenSettings":
            suggest = "blue_green_settings"
        elif key == "maxSurge":
            suggest = "max_surge"
        elif key == "maxUnavailable":
            suggest = "max_unavailable"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UpgradeSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UpgradeSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UpgradeSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 blue_green_settings: 'outputs.BlueGreenSettingsResponse',
                 max_surge: int,
                 max_unavailable: int,
                 strategy: str):
        """
        These upgrade settings control the level of parallelism and the level of disruption caused by an upgrade. maxUnavailable controls the number of nodes that can be simultaneously unavailable. maxSurge controls the number of additional nodes that can be added to the node pool temporarily for the time of the upgrade to increase the number of available nodes. (maxUnavailable + maxSurge) determines the level of parallelism (how many nodes are being upgraded at the same time). Note: upgrades inevitably introduce some disruption since workloads need to be moved from old nodes to new, upgraded ones. Even if maxUnavailable=0, this holds true. (Disruption stays within the limits of PodDisruptionBudget, if it is configured.) Consider a hypothetical node pool with 5 nodes having maxSurge=2, maxUnavailable=1. This means the upgrade process upgrades 3 nodes simultaneously. It creates 2 additional (upgraded) nodes, then it brings down 3 old (not yet upgraded) nodes at the same time. This ensures that there are always at least 4 nodes available. These upgrade settings configure the upgrade strategy for the node pool. Use strategy to switch between the strategies applied to the node pool. If the strategy is ROLLING, use max_surge and max_unavailable to control the level of parallelism and the level of disruption caused by upgrade. 1. maxSurge controls the number of additional nodes that can be added to the node pool temporarily for the time of the upgrade to increase the number of available nodes. 2. maxUnavailable controls the number of nodes that can be simultaneously unavailable. 3. (maxUnavailable + maxSurge) determines the level of parallelism (how many nodes are being upgraded at the same time). If the strategy is BLUE_GREEN, use blue_green_settings to configure the blue-green upgrade related settings. 1. standard_rollout_policy is the default policy. The policy is used to control the way blue pool gets drained. The draining is executed in the batch mode. The batch size could be specified as either percentage of the node pool size or the number of nodes. batch_soak_duration is the soak time after each batch gets drained. 2. node_pool_soak_duration is the soak time after all blue nodes are drained. After this period, the blue pool nodes will be deleted.
        :param 'BlueGreenSettingsResponse' blue_green_settings: Settings for blue-green upgrade strategy.
        :param int max_surge: The maximum number of nodes that can be created beyond the current size of the node pool during the upgrade process.
        :param int max_unavailable: The maximum number of nodes that can be simultaneously unavailable during the upgrade process. A node is considered available if its status is Ready.
        :param str strategy: Update strategy of the node pool.
        """
        pulumi.set(__self__, "blue_green_settings", blue_green_settings)
        pulumi.set(__self__, "max_surge", max_surge)
        pulumi.set(__self__, "max_unavailable", max_unavailable)
        pulumi.set(__self__, "strategy", strategy)

    @property
    @pulumi.getter(name="blueGreenSettings")
    def blue_green_settings(self) -> 'outputs.BlueGreenSettingsResponse':
        """
        Settings for blue-green upgrade strategy.
        """
        return pulumi.get(self, "blue_green_settings")

    @property
    @pulumi.getter(name="maxSurge")
    def max_surge(self) -> int:
        """
        The maximum number of nodes that can be created beyond the current size of the node pool during the upgrade process.
        """
        return pulumi.get(self, "max_surge")

    @property
    @pulumi.getter(name="maxUnavailable")
    def max_unavailable(self) -> int:
        """
        The maximum number of nodes that can be simultaneously unavailable during the upgrade process. A node is considered available if its status is Ready.
        """
        return pulumi.get(self, "max_unavailable")

    @property
    @pulumi.getter
    def strategy(self) -> str:
        """
        Update strategy of the node pool.
        """
        return pulumi.get(self, "strategy")


@pulumi.output_type
class VerticalPodAutoscalingResponse(dict):
    """
    VerticalPodAutoscaling contains global, per-cluster information required by Vertical Pod Autoscaler to automatically adjust the resources of pods controlled by it.
    """
    def __init__(__self__, *,
                 enabled: bool):
        """
        VerticalPodAutoscaling contains global, per-cluster information required by Vertical Pod Autoscaler to automatically adjust the resources of pods controlled by it.
        :param bool enabled: Enables vertical pod autoscaling.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Enables vertical pod autoscaling.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class VirtualNICResponse(dict):
    """
    Configuration of gVNIC feature.
    """
    def __init__(__self__, *,
                 enabled: bool):
        """
        Configuration of gVNIC feature.
        :param bool enabled: Whether gVNIC features are enabled in the node pool.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether gVNIC features are enabled in the node pool.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class WindowsNodeConfigResponse(dict):
    """
    Parameters that can be configured on Windows nodes. Windows Node Config that define the parameters that will be used to configure the Windows node pool settings
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "osVersion":
            suggest = "os_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsNodeConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsNodeConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsNodeConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 os_version: str):
        """
        Parameters that can be configured on Windows nodes. Windows Node Config that define the parameters that will be used to configure the Windows node pool settings
        :param str os_version: OSVersion specifies the Windows node config to be used on the node
        """
        pulumi.set(__self__, "os_version", os_version)

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> str:
        """
        OSVersion specifies the Windows node config to be used on the node
        """
        return pulumi.get(self, "os_version")


@pulumi.output_type
class WorkloadIdentityConfigResponse(dict):
    """
    Configuration for the use of Kubernetes Service Accounts in GCP IAM policies.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "workloadPool":
            suggest = "workload_pool"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkloadIdentityConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkloadIdentityConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkloadIdentityConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 workload_pool: str):
        """
        Configuration for the use of Kubernetes Service Accounts in GCP IAM policies.
        :param str workload_pool: The workload pool to attach all Kubernetes service accounts to.
        """
        pulumi.set(__self__, "workload_pool", workload_pool)

    @property
    @pulumi.getter(name="workloadPool")
    def workload_pool(self) -> str:
        """
        The workload pool to attach all Kubernetes service accounts to.
        """
        return pulumi.get(self, "workload_pool")


@pulumi.output_type
class WorkloadMetadataConfigResponse(dict):
    """
    WorkloadMetadataConfig defines the metadata configuration to expose to workloads on the node pool.
    """
    def __init__(__self__, *,
                 mode: str):
        """
        WorkloadMetadataConfig defines the metadata configuration to expose to workloads on the node pool.
        :param str mode: Mode is the configuration for how to expose metadata to workloads running on the node pool.
        """
        pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        Mode is the configuration for how to expose metadata to workloads running on the node pool.
        """
        return pulumi.get(self, "mode")


