# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetAnalysisResult',
    'AwaitableGetAnalysisResult',
    'get_analysis',
    'get_analysis_output',
]

@pulumi.output_type
class GetAnalysisResult:
    def __init__(__self__, analysis_result=None, annotator_selector=None, create_time=None, name=None, request_time=None):
        if analysis_result and not isinstance(analysis_result, dict):
            raise TypeError("Expected argument 'analysis_result' to be a dict")
        pulumi.set(__self__, "analysis_result", analysis_result)
        if annotator_selector and not isinstance(annotator_selector, dict):
            raise TypeError("Expected argument 'annotator_selector' to be a dict")
        pulumi.set(__self__, "annotator_selector", annotator_selector)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if request_time and not isinstance(request_time, str):
            raise TypeError("Expected argument 'request_time' to be a str")
        pulumi.set(__self__, "request_time", request_time)

    @property
    @pulumi.getter(name="analysisResult")
    def analysis_result(self) -> 'outputs.GoogleCloudContactcenterinsightsV1AnalysisResultResponse':
        """
        The result of the analysis, which is populated when the analysis finishes.
        """
        return pulumi.get(self, "analysis_result")

    @property
    @pulumi.getter(name="annotatorSelector")
    def annotator_selector(self) -> 'outputs.GoogleCloudContactcenterinsightsV1AnnotatorSelectorResponse':
        """
        To select the annotators to run and the phrase matchers to use (if any). If not specified, all annotators will be run.
        """
        return pulumi.get(self, "annotator_selector")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time at which the analysis was created, which occurs when the long-running operation completes.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Immutable. The resource name of the analysis. Format: projects/{project}/locations/{location}/conversations/{conversation}/analyses/{analysis}
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="requestTime")
    def request_time(self) -> str:
        """
        The time at which the analysis was requested.
        """
        return pulumi.get(self, "request_time")


class AwaitableGetAnalysisResult(GetAnalysisResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAnalysisResult(
            analysis_result=self.analysis_result,
            annotator_selector=self.annotator_selector,
            create_time=self.create_time,
            name=self.name,
            request_time=self.request_time)


def get_analysis(analysis_id: Optional[str] = None,
                 conversation_id: Optional[str] = None,
                 location: Optional[str] = None,
                 project: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAnalysisResult:
    """
    Gets an analysis.
    """
    __args__ = dict()
    __args__['analysisId'] = analysis_id
    __args__['conversationId'] = conversation_id
    __args__['location'] = location
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:contactcenterinsights/v1:getAnalysis', __args__, opts=opts, typ=GetAnalysisResult).value

    return AwaitableGetAnalysisResult(
        analysis_result=__ret__.analysis_result,
        annotator_selector=__ret__.annotator_selector,
        create_time=__ret__.create_time,
        name=__ret__.name,
        request_time=__ret__.request_time)


@_utilities.lift_output_func(get_analysis)
def get_analysis_output(analysis_id: Optional[pulumi.Input[str]] = None,
                        conversation_id: Optional[pulumi.Input[str]] = None,
                        location: Optional[pulumi.Input[str]] = None,
                        project: Optional[pulumi.Input[Optional[str]]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAnalysisResult]:
    """
    Gets an analysis.
    """
    ...
