# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AnalysisArgs', 'Analysis']

@pulumi.input_type
class AnalysisArgs:
    def __init__(__self__, *,
                 conversation_id: pulumi.Input[str],
                 annotator_selector: Optional[pulumi.Input['GoogleCloudContactcenterinsightsV1AnnotatorSelectorArgs']] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Analysis resource.
        :param pulumi.Input['GoogleCloudContactcenterinsightsV1AnnotatorSelectorArgs'] annotator_selector: To select the annotators to run and the phrase matchers to use (if any). If not specified, all annotators will be run.
        :param pulumi.Input[str] name: Immutable. The resource name of the analysis. Format: projects/{project}/locations/{location}/conversations/{conversation}/analyses/{analysis}
        """
        pulumi.set(__self__, "conversation_id", conversation_id)
        if annotator_selector is not None:
            pulumi.set(__self__, "annotator_selector", annotator_selector)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="conversationId")
    def conversation_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "conversation_id")

    @conversation_id.setter
    def conversation_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "conversation_id", value)

    @property
    @pulumi.getter(name="annotatorSelector")
    def annotator_selector(self) -> Optional[pulumi.Input['GoogleCloudContactcenterinsightsV1AnnotatorSelectorArgs']]:
        """
        To select the annotators to run and the phrase matchers to use (if any). If not specified, all annotators will be run.
        """
        return pulumi.get(self, "annotator_selector")

    @annotator_selector.setter
    def annotator_selector(self, value: Optional[pulumi.Input['GoogleCloudContactcenterinsightsV1AnnotatorSelectorArgs']]):
        pulumi.set(self, "annotator_selector", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Immutable. The resource name of the analysis. Format: projects/{project}/locations/{location}/conversations/{conversation}/analyses/{analysis}
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


class Analysis(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotator_selector: Optional[pulumi.Input[pulumi.InputType['GoogleCloudContactcenterinsightsV1AnnotatorSelectorArgs']]] = None,
                 conversation_id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates an analysis. The long running operation is done when the analysis has completed.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['GoogleCloudContactcenterinsightsV1AnnotatorSelectorArgs']] annotator_selector: To select the annotators to run and the phrase matchers to use (if any). If not specified, all annotators will be run.
        :param pulumi.Input[str] name: Immutable. The resource name of the analysis. Format: projects/{project}/locations/{location}/conversations/{conversation}/analyses/{analysis}
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AnalysisArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates an analysis. The long running operation is done when the analysis has completed.

        :param str resource_name: The name of the resource.
        :param AnalysisArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AnalysisArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotator_selector: Optional[pulumi.Input[pulumi.InputType['GoogleCloudContactcenterinsightsV1AnnotatorSelectorArgs']]] = None,
                 conversation_id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AnalysisArgs.__new__(AnalysisArgs)

            __props__.__dict__["annotator_selector"] = annotator_selector
            if conversation_id is None and not opts.urn:
                raise TypeError("Missing required property 'conversation_id'")
            __props__.__dict__["conversation_id"] = conversation_id
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["analysis_result"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["request_time"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["conversation_id", "location", "project"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Analysis, __self__).__init__(
            'google-native:contactcenterinsights/v1:Analysis',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Analysis':
        """
        Get an existing Analysis resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = AnalysisArgs.__new__(AnalysisArgs)

        __props__.__dict__["analysis_result"] = None
        __props__.__dict__["annotator_selector"] = None
        __props__.__dict__["conversation_id"] = None
        __props__.__dict__["create_time"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["request_time"] = None
        return Analysis(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="analysisResult")
    def analysis_result(self) -> pulumi.Output['outputs.GoogleCloudContactcenterinsightsV1AnalysisResultResponse']:
        """
        The result of the analysis, which is populated when the analysis finishes.
        """
        return pulumi.get(self, "analysis_result")

    @property
    @pulumi.getter(name="annotatorSelector")
    def annotator_selector(self) -> pulumi.Output['outputs.GoogleCloudContactcenterinsightsV1AnnotatorSelectorResponse']:
        """
        To select the annotators to run and the phrase matchers to use (if any). If not specified, all annotators will be run.
        """
        return pulumi.get(self, "annotator_selector")

    @property
    @pulumi.getter(name="conversationId")
    def conversation_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "conversation_id")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The time at which the analysis was created, which occurs when the long-running operation completes.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Immutable. The resource name of the analysis. Format: projects/{project}/locations/{location}/conversations/{conversation}/analyses/{analysis}
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="requestTime")
    def request_time(self) -> pulumi.Output[str]:
        """
        The time at which the analysis was requested.
        """
        return pulumi.get(self, "request_time")

