# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'InstanceConfigResponse',
    'SAMLParamsResponse',
    'URIsResponse',
]

@pulumi.output_type
class InstanceConfigResponse(dict):
    """
    Message storing the instance configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceSize":
            suggest = "instance_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_size: str):
        """
        Message storing the instance configuration.
        :param str instance_size: The instance size of this the instance configuration.
        """
        pulumi.set(__self__, "instance_size", instance_size)

    @property
    @pulumi.getter(name="instanceSize")
    def instance_size(self) -> str:
        """
        The instance size of this the instance configuration.
        """
        return pulumi.get(self, "instance_size")


@pulumi.output_type
class SAMLParamsResponse(dict):
    """
    Message storing SAML params to enable Google as IDP.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entityId":
            suggest = "entity_id"
        elif key == "ssoUri":
            suggest = "sso_uri"
        elif key == "userEmail":
            suggest = "user_email"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SAMLParamsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SAMLParamsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SAMLParamsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate: str,
                 entity_id: str,
                 sso_uri: str,
                 user_email: str):
        """
        Message storing SAML params to enable Google as IDP.
        :param str certificate: SAML certificate
        :param str entity_id: Entity id URL
        :param str sso_uri: Single sign-on URL
        :param str user_email: Email address of the first admin users.
        """
        pulumi.set(__self__, "certificate", certificate)
        pulumi.set(__self__, "entity_id", entity_id)
        pulumi.set(__self__, "sso_uri", sso_uri)
        pulumi.set(__self__, "user_email", user_email)

    @property
    @pulumi.getter
    def certificate(self) -> str:
        """
        SAML certificate
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> str:
        """
        Entity id URL
        """
        return pulumi.get(self, "entity_id")

    @property
    @pulumi.getter(name="ssoUri")
    def sso_uri(self) -> str:
        """
        Single sign-on URL
        """
        return pulumi.get(self, "sso_uri")

    @property
    @pulumi.getter(name="userEmail")
    def user_email(self) -> str:
        """
        Email address of the first admin users.
        """
        return pulumi.get(self, "user_email")


@pulumi.output_type
class URIsResponse(dict):
    """
    Message storing the URIs of the ContactCenter.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "chatBotUri":
            suggest = "chat_bot_uri"
        elif key == "mediaUri":
            suggest = "media_uri"
        elif key == "rootUri":
            suggest = "root_uri"
        elif key == "virtualAgentStreamingServiceUri":
            suggest = "virtual_agent_streaming_service_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in URIsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        URIsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        URIsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 chat_bot_uri: str,
                 media_uri: str,
                 root_uri: str,
                 virtual_agent_streaming_service_uri: str):
        """
        Message storing the URIs of the ContactCenter.
        :param str chat_bot_uri: Chat Bot Uri of the ContactCenter
        :param str media_uri: Media Uri of the ContactCenter.
        :param str root_uri: Root Uri of the ContactCenter.
        :param str virtual_agent_streaming_service_uri: Virtual Agent Streaming Service Uri of the ContactCenter.
        """
        pulumi.set(__self__, "chat_bot_uri", chat_bot_uri)
        pulumi.set(__self__, "media_uri", media_uri)
        pulumi.set(__self__, "root_uri", root_uri)
        pulumi.set(__self__, "virtual_agent_streaming_service_uri", virtual_agent_streaming_service_uri)

    @property
    @pulumi.getter(name="chatBotUri")
    def chat_bot_uri(self) -> str:
        """
        Chat Bot Uri of the ContactCenter
        """
        return pulumi.get(self, "chat_bot_uri")

    @property
    @pulumi.getter(name="mediaUri")
    def media_uri(self) -> str:
        """
        Media Uri of the ContactCenter.
        """
        return pulumi.get(self, "media_uri")

    @property
    @pulumi.getter(name="rootUri")
    def root_uri(self) -> str:
        """
        Root Uri of the ContactCenter.
        """
        return pulumi.get(self, "root_uri")

    @property
    @pulumi.getter(name="virtualAgentStreamingServiceUri")
    def virtual_agent_streaming_service_uri(self) -> str:
        """
        Virtual Agent Streaming Service Uri of the ContactCenter.
        """
        return pulumi.get(self, "virtual_agent_streaming_service_uri")


