# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetContactCenterResult',
    'AwaitableGetContactCenterResult',
    'get_contact_center',
    'get_contact_center_output',
]

@pulumi.output_type
class GetContactCenterResult:
    def __init__(__self__, ccaip_managed_users=None, create_time=None, customer_domain_prefix=None, display_name=None, instance_config=None, labels=None, name=None, saml_params=None, state=None, update_time=None, uris=None, user_email=None):
        if ccaip_managed_users and not isinstance(ccaip_managed_users, bool):
            raise TypeError("Expected argument 'ccaip_managed_users' to be a bool")
        pulumi.set(__self__, "ccaip_managed_users", ccaip_managed_users)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if customer_domain_prefix and not isinstance(customer_domain_prefix, str):
            raise TypeError("Expected argument 'customer_domain_prefix' to be a str")
        pulumi.set(__self__, "customer_domain_prefix", customer_domain_prefix)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if instance_config and not isinstance(instance_config, dict):
            raise TypeError("Expected argument 'instance_config' to be a dict")
        pulumi.set(__self__, "instance_config", instance_config)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if saml_params and not isinstance(saml_params, dict):
            raise TypeError("Expected argument 'saml_params' to be a dict")
        pulumi.set(__self__, "saml_params", saml_params)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)
        if uris and not isinstance(uris, dict):
            raise TypeError("Expected argument 'uris' to be a dict")
        pulumi.set(__self__, "uris", uris)
        if user_email and not isinstance(user_email, str):
            raise TypeError("Expected argument 'user_email' to be a str")
        pulumi.set(__self__, "user_email", user_email)

    @property
    @pulumi.getter(name="ccaipManagedUsers")
    def ccaip_managed_users(self) -> bool:
        """
        Optional. Whether to enable users to be created in the CCAIP-instance concurrently to having users in Cloud identity
        """
        return pulumi.get(self, "ccaip_managed_users")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        [Output only] Create time stamp
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="customerDomainPrefix")
    def customer_domain_prefix(self) -> str:
        """
        Immutable. At least 2 and max 16 char long, must conform to [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
        """
        return pulumi.get(self, "customer_domain_prefix")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user friendly name for the ContactCenter.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="instanceConfig")
    def instance_config(self) -> 'outputs.InstanceConfigResponse':
        """
        The configuration of this instance, it is currently immutable once created.
        """
        return pulumi.get(self, "instance_config")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Labels as key value pairs
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        name of resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="samlParams")
    def saml_params(self) -> 'outputs.SAMLParamsResponse':
        """
        Optional. Params that sets up Google as IdP.
        """
        return pulumi.get(self, "saml_params")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of this contact center.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        [Output only] Update time stamp
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter
    def uris(self) -> 'outputs.URIsResponse':
        """
        URIs to access the deployed ContactCenters.
        """
        return pulumi.get(self, "uris")

    @property
    @pulumi.getter(name="userEmail")
    def user_email(self) -> str:
        """
        Optional. Email address of the first admin users.
        """
        return pulumi.get(self, "user_email")


class AwaitableGetContactCenterResult(GetContactCenterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetContactCenterResult(
            ccaip_managed_users=self.ccaip_managed_users,
            create_time=self.create_time,
            customer_domain_prefix=self.customer_domain_prefix,
            display_name=self.display_name,
            instance_config=self.instance_config,
            labels=self.labels,
            name=self.name,
            saml_params=self.saml_params,
            state=self.state,
            update_time=self.update_time,
            uris=self.uris,
            user_email=self.user_email)


def get_contact_center(contact_center_id: Optional[str] = None,
                       location: Optional[str] = None,
                       project: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetContactCenterResult:
    """
    Gets details of a single ContactCenter.
    """
    __args__ = dict()
    __args__['contactCenterId'] = contact_center_id
    __args__['location'] = location
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:contactcenteraiplatform/v1alpha1:getContactCenter', __args__, opts=opts, typ=GetContactCenterResult).value

    return AwaitableGetContactCenterResult(
        ccaip_managed_users=__ret__.ccaip_managed_users,
        create_time=__ret__.create_time,
        customer_domain_prefix=__ret__.customer_domain_prefix,
        display_name=__ret__.display_name,
        instance_config=__ret__.instance_config,
        labels=__ret__.labels,
        name=__ret__.name,
        saml_params=__ret__.saml_params,
        state=__ret__.state,
        update_time=__ret__.update_time,
        uris=__ret__.uris,
        user_email=__ret__.user_email)


@_utilities.lift_output_func(get_contact_center)
def get_contact_center_output(contact_center_id: Optional[pulumi.Input[str]] = None,
                              location: Optional[pulumi.Input[str]] = None,
                              project: Optional[pulumi.Input[Optional[str]]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetContactCenterResult]:
    """
    Gets details of a single ContactCenter.
    """
    ...
