# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['ContactCenterArgs', 'ContactCenter']

@pulumi.input_type
class ContactCenterArgs:
    def __init__(__self__, *,
                 contact_center_id: pulumi.Input[str],
                 customer_domain_prefix: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 ccaip_managed_users: Optional[pulumi.Input[bool]] = None,
                 instance_config: Optional[pulumi.Input['InstanceConfigArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 request_id: Optional[pulumi.Input[str]] = None,
                 saml_params: Optional[pulumi.Input['SAMLParamsArgs']] = None,
                 user_email: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ContactCenter resource.
        :param pulumi.Input[str] contact_center_id: Required. Id of the requesting object If auto-generating Id server-side, remove this field and contact_center_id from the method_signature of Create RPC
        :param pulumi.Input[str] customer_domain_prefix: Immutable. At least 2 and max 16 char long, must conform to [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
        :param pulumi.Input[str] display_name: A user friendly name for the ContactCenter.
        :param pulumi.Input[bool] ccaip_managed_users: Optional. Whether to enable users to be created in the CCAIP-instance concurrently to having users in Cloud identity
        :param pulumi.Input['InstanceConfigArgs'] instance_config: The configuration of this instance, it is currently immutable once created.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels as key value pairs
        :param pulumi.Input[str] name: name of resource
        :param pulumi.Input[str] request_id: Optional. An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server will guarantee that for at least 60 minutes since the first request. For example, consider a situation where you make an initial request and t he request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
        :param pulumi.Input['SAMLParamsArgs'] saml_params: Optional. Params that sets up Google as IdP.
        :param pulumi.Input[str] user_email: Optional. Email address of the first admin users.
        """
        pulumi.set(__self__, "contact_center_id", contact_center_id)
        pulumi.set(__self__, "customer_domain_prefix", customer_domain_prefix)
        pulumi.set(__self__, "display_name", display_name)
        if ccaip_managed_users is not None:
            pulumi.set(__self__, "ccaip_managed_users", ccaip_managed_users)
        if instance_config is not None:
            pulumi.set(__self__, "instance_config", instance_config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if request_id is not None:
            pulumi.set(__self__, "request_id", request_id)
        if saml_params is not None:
            pulumi.set(__self__, "saml_params", saml_params)
        if user_email is not None:
            pulumi.set(__self__, "user_email", user_email)

    @property
    @pulumi.getter(name="contactCenterId")
    def contact_center_id(self) -> pulumi.Input[str]:
        """
        Required. Id of the requesting object If auto-generating Id server-side, remove this field and contact_center_id from the method_signature of Create RPC
        """
        return pulumi.get(self, "contact_center_id")

    @contact_center_id.setter
    def contact_center_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "contact_center_id", value)

    @property
    @pulumi.getter(name="customerDomainPrefix")
    def customer_domain_prefix(self) -> pulumi.Input[str]:
        """
        Immutable. At least 2 and max 16 char long, must conform to [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
        """
        return pulumi.get(self, "customer_domain_prefix")

    @customer_domain_prefix.setter
    def customer_domain_prefix(self, value: pulumi.Input[str]):
        pulumi.set(self, "customer_domain_prefix", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        A user friendly name for the ContactCenter.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="ccaipManagedUsers")
    def ccaip_managed_users(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Whether to enable users to be created in the CCAIP-instance concurrently to having users in Cloud identity
        """
        return pulumi.get(self, "ccaip_managed_users")

    @ccaip_managed_users.setter
    def ccaip_managed_users(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ccaip_managed_users", value)

    @property
    @pulumi.getter(name="instanceConfig")
    def instance_config(self) -> Optional[pulumi.Input['InstanceConfigArgs']]:
        """
        The configuration of this instance, it is currently immutable once created.
        """
        return pulumi.get(self, "instance_config")

    @instance_config.setter
    def instance_config(self, value: Optional[pulumi.Input['InstanceConfigArgs']]):
        pulumi.set(self, "instance_config", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels as key value pairs
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        name of resource
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="requestId")
    def request_id(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server will guarantee that for at least 60 minutes since the first request. For example, consider a situation where you make an initial request and t he request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
        """
        return pulumi.get(self, "request_id")

    @request_id.setter
    def request_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_id", value)

    @property
    @pulumi.getter(name="samlParams")
    def saml_params(self) -> Optional[pulumi.Input['SAMLParamsArgs']]:
        """
        Optional. Params that sets up Google as IdP.
        """
        return pulumi.get(self, "saml_params")

    @saml_params.setter
    def saml_params(self, value: Optional[pulumi.Input['SAMLParamsArgs']]):
        pulumi.set(self, "saml_params", value)

    @property
    @pulumi.getter(name="userEmail")
    def user_email(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Email address of the first admin users.
        """
        return pulumi.get(self, "user_email")

    @user_email.setter
    def user_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_email", value)


class ContactCenter(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ccaip_managed_users: Optional[pulumi.Input[bool]] = None,
                 contact_center_id: Optional[pulumi.Input[str]] = None,
                 customer_domain_prefix: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 instance_config: Optional[pulumi.Input[pulumi.InputType['InstanceConfigArgs']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 request_id: Optional[pulumi.Input[str]] = None,
                 saml_params: Optional[pulumi.Input[pulumi.InputType['SAMLParamsArgs']]] = None,
                 user_email: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates a new ContactCenter in a given project and location.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] ccaip_managed_users: Optional. Whether to enable users to be created in the CCAIP-instance concurrently to having users in Cloud identity
        :param pulumi.Input[str] contact_center_id: Required. Id of the requesting object If auto-generating Id server-side, remove this field and contact_center_id from the method_signature of Create RPC
        :param pulumi.Input[str] customer_domain_prefix: Immutable. At least 2 and max 16 char long, must conform to [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
        :param pulumi.Input[str] display_name: A user friendly name for the ContactCenter.
        :param pulumi.Input[pulumi.InputType['InstanceConfigArgs']] instance_config: The configuration of this instance, it is currently immutable once created.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels as key value pairs
        :param pulumi.Input[str] name: name of resource
        :param pulumi.Input[str] request_id: Optional. An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server will guarantee that for at least 60 minutes since the first request. For example, consider a situation where you make an initial request and t he request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
        :param pulumi.Input[pulumi.InputType['SAMLParamsArgs']] saml_params: Optional. Params that sets up Google as IdP.
        :param pulumi.Input[str] user_email: Optional. Email address of the first admin users.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ContactCenterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new ContactCenter in a given project and location.

        :param str resource_name: The name of the resource.
        :param ContactCenterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ContactCenterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ccaip_managed_users: Optional[pulumi.Input[bool]] = None,
                 contact_center_id: Optional[pulumi.Input[str]] = None,
                 customer_domain_prefix: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 instance_config: Optional[pulumi.Input[pulumi.InputType['InstanceConfigArgs']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 request_id: Optional[pulumi.Input[str]] = None,
                 saml_params: Optional[pulumi.Input[pulumi.InputType['SAMLParamsArgs']]] = None,
                 user_email: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ContactCenterArgs.__new__(ContactCenterArgs)

            __props__.__dict__["ccaip_managed_users"] = ccaip_managed_users
            if contact_center_id is None and not opts.urn:
                raise TypeError("Missing required property 'contact_center_id'")
            __props__.__dict__["contact_center_id"] = contact_center_id
            if customer_domain_prefix is None and not opts.urn:
                raise TypeError("Missing required property 'customer_domain_prefix'")
            __props__.__dict__["customer_domain_prefix"] = customer_domain_prefix
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["instance_config"] = instance_config
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["request_id"] = request_id
            __props__.__dict__["saml_params"] = saml_params
            __props__.__dict__["user_email"] = user_email
            __props__.__dict__["create_time"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["update_time"] = None
            __props__.__dict__["uris"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["contact_center_id", "location", "project"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(ContactCenter, __self__).__init__(
            'google-native:contactcenteraiplatform/v1alpha1:ContactCenter',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ContactCenter':
        """
        Get an existing ContactCenter resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ContactCenterArgs.__new__(ContactCenterArgs)

        __props__.__dict__["ccaip_managed_users"] = None
        __props__.__dict__["contact_center_id"] = None
        __props__.__dict__["create_time"] = None
        __props__.__dict__["customer_domain_prefix"] = None
        __props__.__dict__["display_name"] = None
        __props__.__dict__["instance_config"] = None
        __props__.__dict__["labels"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["request_id"] = None
        __props__.__dict__["saml_params"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["update_time"] = None
        __props__.__dict__["uris"] = None
        __props__.__dict__["user_email"] = None
        return ContactCenter(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="ccaipManagedUsers")
    def ccaip_managed_users(self) -> pulumi.Output[bool]:
        """
        Optional. Whether to enable users to be created in the CCAIP-instance concurrently to having users in Cloud identity
        """
        return pulumi.get(self, "ccaip_managed_users")

    @property
    @pulumi.getter(name="contactCenterId")
    def contact_center_id(self) -> pulumi.Output[str]:
        """
        Required. Id of the requesting object If auto-generating Id server-side, remove this field and contact_center_id from the method_signature of Create RPC
        """
        return pulumi.get(self, "contact_center_id")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        [Output only] Create time stamp
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="customerDomainPrefix")
    def customer_domain_prefix(self) -> pulumi.Output[str]:
        """
        Immutable. At least 2 and max 16 char long, must conform to [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
        """
        return pulumi.get(self, "customer_domain_prefix")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        A user friendly name for the ContactCenter.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="instanceConfig")
    def instance_config(self) -> pulumi.Output['outputs.InstanceConfigResponse']:
        """
        The configuration of this instance, it is currently immutable once created.
        """
        return pulumi.get(self, "instance_config")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Labels as key value pairs
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        name of resource
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="requestId")
    def request_id(self) -> pulumi.Output[Optional[str]]:
        """
        Optional. An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server will guarantee that for at least 60 minutes since the first request. For example, consider a situation where you make an initial request and t he request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
        """
        return pulumi.get(self, "request_id")

    @property
    @pulumi.getter(name="samlParams")
    def saml_params(self) -> pulumi.Output['outputs.SAMLParamsResponse']:
        """
        Optional. Params that sets up Google as IdP.
        """
        return pulumi.get(self, "saml_params")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The state of this contact center.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        [Output only] Update time stamp
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter
    def uris(self) -> pulumi.Output['outputs.URIsResponse']:
        """
        URIs to access the deployed ContactCenters.
        """
        return pulumi.get(self, "uris")

    @property
    @pulumi.getter(name="userEmail")
    def user_email(self) -> pulumi.Output[str]:
        """
        Optional. Email address of the first admin users.
        """
        return pulumi.get(self, "user_email")

