# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['RegionDiskArgs', 'RegionDisk']

@pulumi.input_type
class RegionDiskArgs:
    def __init__(__self__, *,
                 region: pulumi.Input[str],
                 architecture: Optional[pulumi.Input['RegionDiskArchitecture']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disk_encryption_key: Optional[pulumi.Input['CustomerEncryptionKeyArgs']] = None,
                 erase_windows_vss_signature: Optional[pulumi.Input[bool]] = None,
                 guest_os_features: Optional[pulumi.Input[Sequence[pulumi.Input['GuestOsFeatureArgs']]]] = None,
                 interface: Optional[pulumi.Input['RegionDiskInterface']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 license_codes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 licenses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 location_hint: Optional[pulumi.Input[str]] = None,
                 multi_writer: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[str]] = None,
                 params: Optional[pulumi.Input['DiskParamsArgs']] = None,
                 physical_block_size_bytes: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 provisioned_iops: Optional[pulumi.Input[str]] = None,
                 provisioned_throughput: Optional[pulumi.Input[str]] = None,
                 replica_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 request_id: Optional[pulumi.Input[str]] = None,
                 resource_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 size_gb: Optional[pulumi.Input[str]] = None,
                 source_disk: Optional[pulumi.Input[str]] = None,
                 source_image: Optional[pulumi.Input[str]] = None,
                 source_image_encryption_key: Optional[pulumi.Input['CustomerEncryptionKeyArgs']] = None,
                 source_snapshot: Optional[pulumi.Input[str]] = None,
                 source_snapshot_encryption_key: Optional[pulumi.Input['CustomerEncryptionKeyArgs']] = None,
                 source_storage_object: Optional[pulumi.Input[str]] = None,
                 storage_type: Optional[pulumi.Input['RegionDiskStorageType']] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_licenses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a RegionDisk resource.
        :param pulumi.Input['RegionDiskArchitecture'] architecture: The architecture of the disk. Valid values are ARM64 or X86_64.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input['CustomerEncryptionKeyArgs'] disk_encryption_key: Encrypts the disk using a customer-supplied encryption key or a customer-managed encryption key. Encryption keys do not protect access to metadata of the disk. After you encrypt a disk with a customer-supplied key, you must provide the same key if you use the disk later. For example, to create a disk snapshot, to create a disk image, to create a machine image, or to attach the disk to a virtual machine. After you encrypt a disk with a customer-managed key, the diskEncryptionKey.kmsKeyName is set to a key *version* name once the disk is created. The disk is encrypted with this version of the key. In the response, diskEncryptionKey.kmsKeyName appears in the following format: "diskEncryptionKey.kmsKeyName": "projects/kms_project_id/locations/region/keyRings/ key_region/cryptoKeys/key /cryptoKeysVersions/version If you do not provide an encryption key when creating the disk, then the disk is encrypted using an automatically generated key and you don't need to provide a key to use the disk later.
        :param pulumi.Input[bool] erase_windows_vss_signature: Specifies whether the disk restored from a source snapshot should erase Windows specific VSS signature.
        :param pulumi.Input[Sequence[pulumi.Input['GuestOsFeatureArgs']]] guest_os_features: A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
        :param pulumi.Input['RegionDiskInterface'] interface: [Deprecated] Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels to apply to this disk. These can be later modified by the setLabels method.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] license_codes: Integer license codes indicating which licenses are attached to this disk.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] licenses: A list of publicly visible licenses. Reserved for Google's use.
        :param pulumi.Input[str] location_hint: An opaque location hint used to place the disk close to other resources. This field is for use by internal tools that use the public API.
        :param pulumi.Input[bool] multi_writer: Indicates whether or not the disk can be read/write attached to more than one instance.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input[str] options: Internal use only.
        :param pulumi.Input['DiskParamsArgs'] params: Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
        :param pulumi.Input[str] physical_block_size_bytes: Physical block size of the persistent disk, in bytes. If not present in a request, a default value is used. The currently supported size is 4096, other sizes may be added in the future. If an unsupported value is requested, the error message will list the supported values for the caller's project.
        :param pulumi.Input[str] provisioned_iops: Indicates how many IOPS to provision for the disk. This sets the number of I/O operations per second that the disk can handle. Values must be between 10,000 and 120,000. For more details, see the Extreme persistent disk documentation.
        :param pulumi.Input[str] provisioned_throughput: Indicates how much throughput to provision for the disk. This sets the number of throughput mb per second that the disk can handle. Values must be between 1 and 7,124.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] replica_zones: URLs of the zones where the disk should be replicated to. Only applicable for regional resources.
        :param pulumi.Input[str] request_id: An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resource_policies: Resource policies applied to this disk for automatic snapshot creations.
        :param pulumi.Input[str] size_gb: Size, in GB, of the persistent disk. You can specify this field when creating a persistent disk using the sourceImage, sourceSnapshot, or sourceDisk parameter, or specify it alone to create an empty persistent disk. If you specify this field along with a source, the value of sizeGb must not be less than the size of the source. Acceptable values are 1 to 65536, inclusive.
        :param pulumi.Input[str] source_disk: The source disk used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /disks/disk - https://www.googleapis.com/compute/v1/projects/project/regions/region /disks/disk - projects/project/zones/zone/disks/disk - projects/project/regions/region/disks/disk - zones/zone/disks/disk - regions/region/disks/disk 
        :param pulumi.Input[str] source_image: The source image used to create this disk. If the source image is deleted, this field will not be set. To create a disk with one of the public operating system images, specify the image by its family name. For example, specify family/debian-9 to use the latest Debian 9 image: projects/debian-cloud/global/images/family/debian-9 Alternatively, use a specific version of a public operating system image: projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD To create a disk with a custom image that you created, specify the image name in the following format: global/images/my-custom-image You can also specify a custom image by its image family, which returns the latest version of the image in that family. Replace the image name with family/family-name: global/images/family/my-image-family 
        :param pulumi.Input['CustomerEncryptionKeyArgs'] source_image_encryption_key: The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key.
        :param pulumi.Input[str] source_snapshot: The source snapshot used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project /global/snapshots/snapshot - projects/project/global/snapshots/snapshot - global/snapshots/snapshot 
        :param pulumi.Input['CustomerEncryptionKeyArgs'] source_snapshot_encryption_key: The customer-supplied encryption key of the source snapshot. Required if the source snapshot is protected by a customer-supplied encryption key.
        :param pulumi.Input[str] source_storage_object: The full Google Cloud Storage URI where the disk image is stored. This file must be a gzip-compressed tarball whose name ends in .tar.gz or virtual machine disk whose name ends in vmdk. Valid URIs may start with gs:// or https://storage.googleapis.com/. This flag is not optimized for creating multiple disks from a source storage object. To create many disks from a source storage object, use gcloud compute images import instead.
        :param pulumi.Input['RegionDiskStorageType'] storage_type: [Deprecated] Storage type of the persistent disk.
        :param pulumi.Input[str] type: URL of the disk type resource describing which disk type to use to create the disk. Provide this when creating the disk. For example: projects/project /zones/zone/diskTypes/pd-ssd . See Persistent disk types.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_licenses: A list of publicly visible user-licenses. Unlike regular licenses, user provided licenses can be modified after the disk is created. This includes a list of URLs to the license resource. For example, to provide a debian license: https://www.googleapis.com/compute/v1/projects/debian-cloud/global/licenses/debian-9-stretch 
        """
        pulumi.set(__self__, "region", region)
        if architecture is not None:
            pulumi.set(__self__, "architecture", architecture)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_encryption_key is not None:
            pulumi.set(__self__, "disk_encryption_key", disk_encryption_key)
        if erase_windows_vss_signature is not None:
            pulumi.set(__self__, "erase_windows_vss_signature", erase_windows_vss_signature)
        if guest_os_features is not None:
            pulumi.set(__self__, "guest_os_features", guest_os_features)
        if interface is not None:
            warnings.warn("""[Deprecated] Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI.""", DeprecationWarning)
            pulumi.log.warn("""interface is deprecated: [Deprecated] Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI.""")
        if interface is not None:
            pulumi.set(__self__, "interface", interface)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if license_codes is not None:
            pulumi.set(__self__, "license_codes", license_codes)
        if licenses is not None:
            pulumi.set(__self__, "licenses", licenses)
        if location_hint is not None:
            pulumi.set(__self__, "location_hint", location_hint)
        if multi_writer is not None:
            pulumi.set(__self__, "multi_writer", multi_writer)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if params is not None:
            pulumi.set(__self__, "params", params)
        if physical_block_size_bytes is not None:
            pulumi.set(__self__, "physical_block_size_bytes", physical_block_size_bytes)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if provisioned_iops is not None:
            pulumi.set(__self__, "provisioned_iops", provisioned_iops)
        if provisioned_throughput is not None:
            pulumi.set(__self__, "provisioned_throughput", provisioned_throughput)
        if replica_zones is not None:
            pulumi.set(__self__, "replica_zones", replica_zones)
        if request_id is not None:
            pulumi.set(__self__, "request_id", request_id)
        if resource_policies is not None:
            pulumi.set(__self__, "resource_policies", resource_policies)
        if size_gb is not None:
            pulumi.set(__self__, "size_gb", size_gb)
        if source_disk is not None:
            pulumi.set(__self__, "source_disk", source_disk)
        if source_image is not None:
            pulumi.set(__self__, "source_image", source_image)
        if source_image_encryption_key is not None:
            pulumi.set(__self__, "source_image_encryption_key", source_image_encryption_key)
        if source_snapshot is not None:
            pulumi.set(__self__, "source_snapshot", source_snapshot)
        if source_snapshot_encryption_key is not None:
            pulumi.set(__self__, "source_snapshot_encryption_key", source_snapshot_encryption_key)
        if source_storage_object is not None:
            pulumi.set(__self__, "source_storage_object", source_storage_object)
        if storage_type is not None:
            warnings.warn("""[Deprecated] Storage type of the persistent disk.""", DeprecationWarning)
            pulumi.log.warn("""storage_type is deprecated: [Deprecated] Storage type of the persistent disk.""")
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_licenses is not None:
            pulumi.set(__self__, "user_licenses", user_licenses)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def architecture(self) -> Optional[pulumi.Input['RegionDiskArchitecture']]:
        """
        The architecture of the disk. Valid values are ARM64 or X86_64.
        """
        return pulumi.get(self, "architecture")

    @architecture.setter
    def architecture(self, value: Optional[pulumi.Input['RegionDiskArchitecture']]):
        pulumi.set(self, "architecture", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="diskEncryptionKey")
    def disk_encryption_key(self) -> Optional[pulumi.Input['CustomerEncryptionKeyArgs']]:
        """
        Encrypts the disk using a customer-supplied encryption key or a customer-managed encryption key. Encryption keys do not protect access to metadata of the disk. After you encrypt a disk with a customer-supplied key, you must provide the same key if you use the disk later. For example, to create a disk snapshot, to create a disk image, to create a machine image, or to attach the disk to a virtual machine. After you encrypt a disk with a customer-managed key, the diskEncryptionKey.kmsKeyName is set to a key *version* name once the disk is created. The disk is encrypted with this version of the key. In the response, diskEncryptionKey.kmsKeyName appears in the following format: "diskEncryptionKey.kmsKeyName": "projects/kms_project_id/locations/region/keyRings/ key_region/cryptoKeys/key /cryptoKeysVersions/version If you do not provide an encryption key when creating the disk, then the disk is encrypted using an automatically generated key and you don't need to provide a key to use the disk later.
        """
        return pulumi.get(self, "disk_encryption_key")

    @disk_encryption_key.setter
    def disk_encryption_key(self, value: Optional[pulumi.Input['CustomerEncryptionKeyArgs']]):
        pulumi.set(self, "disk_encryption_key", value)

    @property
    @pulumi.getter(name="eraseWindowsVssSignature")
    def erase_windows_vss_signature(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the disk restored from a source snapshot should erase Windows specific VSS signature.
        """
        return pulumi.get(self, "erase_windows_vss_signature")

    @erase_windows_vss_signature.setter
    def erase_windows_vss_signature(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "erase_windows_vss_signature", value)

    @property
    @pulumi.getter(name="guestOsFeatures")
    def guest_os_features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GuestOsFeatureArgs']]]]:
        """
        A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
        """
        return pulumi.get(self, "guest_os_features")

    @guest_os_features.setter
    def guest_os_features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GuestOsFeatureArgs']]]]):
        pulumi.set(self, "guest_os_features", value)

    @property
    @pulumi.getter
    def interface(self) -> Optional[pulumi.Input['RegionDiskInterface']]:
        """
        [Deprecated] Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI.
        """
        return pulumi.get(self, "interface")

    @interface.setter
    def interface(self, value: Optional[pulumi.Input['RegionDiskInterface']]):
        pulumi.set(self, "interface", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels to apply to this disk. These can be later modified by the setLabels method.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="licenseCodes")
    def license_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Integer license codes indicating which licenses are attached to this disk.
        """
        return pulumi.get(self, "license_codes")

    @license_codes.setter
    def license_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "license_codes", value)

    @property
    @pulumi.getter
    def licenses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of publicly visible licenses. Reserved for Google's use.
        """
        return pulumi.get(self, "licenses")

    @licenses.setter
    def licenses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "licenses", value)

    @property
    @pulumi.getter(name="locationHint")
    def location_hint(self) -> Optional[pulumi.Input[str]]:
        """
        An opaque location hint used to place the disk close to other resources. This field is for use by internal tools that use the public API.
        """
        return pulumi.get(self, "location_hint")

    @location_hint.setter
    def location_hint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location_hint", value)

    @property
    @pulumi.getter(name="multiWriter")
    def multi_writer(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether or not the disk can be read/write attached to more than one instance.
        """
        return pulumi.get(self, "multi_writer")

    @multi_writer.setter
    def multi_writer(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "multi_writer", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[str]]:
        """
        Internal use only.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter
    def params(self) -> Optional[pulumi.Input['DiskParamsArgs']]:
        """
        Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
        """
        return pulumi.get(self, "params")

    @params.setter
    def params(self, value: Optional[pulumi.Input['DiskParamsArgs']]):
        pulumi.set(self, "params", value)

    @property
    @pulumi.getter(name="physicalBlockSizeBytes")
    def physical_block_size_bytes(self) -> Optional[pulumi.Input[str]]:
        """
        Physical block size of the persistent disk, in bytes. If not present in a request, a default value is used. The currently supported size is 4096, other sizes may be added in the future. If an unsupported value is requested, the error message will list the supported values for the caller's project.
        """
        return pulumi.get(self, "physical_block_size_bytes")

    @physical_block_size_bytes.setter
    def physical_block_size_bytes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "physical_block_size_bytes", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="provisionedIops")
    def provisioned_iops(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates how many IOPS to provision for the disk. This sets the number of I/O operations per second that the disk can handle. Values must be between 10,000 and 120,000. For more details, see the Extreme persistent disk documentation.
        """
        return pulumi.get(self, "provisioned_iops")

    @provisioned_iops.setter
    def provisioned_iops(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provisioned_iops", value)

    @property
    @pulumi.getter(name="provisionedThroughput")
    def provisioned_throughput(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates how much throughput to provision for the disk. This sets the number of throughput mb per second that the disk can handle. Values must be between 1 and 7,124.
        """
        return pulumi.get(self, "provisioned_throughput")

    @provisioned_throughput.setter
    def provisioned_throughput(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provisioned_throughput", value)

    @property
    @pulumi.getter(name="replicaZones")
    def replica_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        URLs of the zones where the disk should be replicated to. Only applicable for regional resources.
        """
        return pulumi.get(self, "replica_zones")

    @replica_zones.setter
    def replica_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "replica_zones", value)

    @property
    @pulumi.getter(name="requestId")
    def request_id(self) -> Optional[pulumi.Input[str]]:
        """
        An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        """
        return pulumi.get(self, "request_id")

    @request_id.setter
    def request_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_id", value)

    @property
    @pulumi.getter(name="resourcePolicies")
    def resource_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Resource policies applied to this disk for automatic snapshot creations.
        """
        return pulumi.get(self, "resource_policies")

    @resource_policies.setter
    def resource_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "resource_policies", value)

    @property
    @pulumi.getter(name="sizeGb")
    def size_gb(self) -> Optional[pulumi.Input[str]]:
        """
        Size, in GB, of the persistent disk. You can specify this field when creating a persistent disk using the sourceImage, sourceSnapshot, or sourceDisk parameter, or specify it alone to create an empty persistent disk. If you specify this field along with a source, the value of sizeGb must not be less than the size of the source. Acceptable values are 1 to 65536, inclusive.
        """
        return pulumi.get(self, "size_gb")

    @size_gb.setter
    def size_gb(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size_gb", value)

    @property
    @pulumi.getter(name="sourceDisk")
    def source_disk(self) -> Optional[pulumi.Input[str]]:
        """
        The source disk used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /disks/disk - https://www.googleapis.com/compute/v1/projects/project/regions/region /disks/disk - projects/project/zones/zone/disks/disk - projects/project/regions/region/disks/disk - zones/zone/disks/disk - regions/region/disks/disk 
        """
        return pulumi.get(self, "source_disk")

    @source_disk.setter
    def source_disk(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_disk", value)

    @property
    @pulumi.getter(name="sourceImage")
    def source_image(self) -> Optional[pulumi.Input[str]]:
        """
        The source image used to create this disk. If the source image is deleted, this field will not be set. To create a disk with one of the public operating system images, specify the image by its family name. For example, specify family/debian-9 to use the latest Debian 9 image: projects/debian-cloud/global/images/family/debian-9 Alternatively, use a specific version of a public operating system image: projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD To create a disk with a custom image that you created, specify the image name in the following format: global/images/my-custom-image You can also specify a custom image by its image family, which returns the latest version of the image in that family. Replace the image name with family/family-name: global/images/family/my-image-family 
        """
        return pulumi.get(self, "source_image")

    @source_image.setter
    def source_image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_image", value)

    @property
    @pulumi.getter(name="sourceImageEncryptionKey")
    def source_image_encryption_key(self) -> Optional[pulumi.Input['CustomerEncryptionKeyArgs']]:
        """
        The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key.
        """
        return pulumi.get(self, "source_image_encryption_key")

    @source_image_encryption_key.setter
    def source_image_encryption_key(self, value: Optional[pulumi.Input['CustomerEncryptionKeyArgs']]):
        pulumi.set(self, "source_image_encryption_key", value)

    @property
    @pulumi.getter(name="sourceSnapshot")
    def source_snapshot(self) -> Optional[pulumi.Input[str]]:
        """
        The source snapshot used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project /global/snapshots/snapshot - projects/project/global/snapshots/snapshot - global/snapshots/snapshot 
        """
        return pulumi.get(self, "source_snapshot")

    @source_snapshot.setter
    def source_snapshot(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_snapshot", value)

    @property
    @pulumi.getter(name="sourceSnapshotEncryptionKey")
    def source_snapshot_encryption_key(self) -> Optional[pulumi.Input['CustomerEncryptionKeyArgs']]:
        """
        The customer-supplied encryption key of the source snapshot. Required if the source snapshot is protected by a customer-supplied encryption key.
        """
        return pulumi.get(self, "source_snapshot_encryption_key")

    @source_snapshot_encryption_key.setter
    def source_snapshot_encryption_key(self, value: Optional[pulumi.Input['CustomerEncryptionKeyArgs']]):
        pulumi.set(self, "source_snapshot_encryption_key", value)

    @property
    @pulumi.getter(name="sourceStorageObject")
    def source_storage_object(self) -> Optional[pulumi.Input[str]]:
        """
        The full Google Cloud Storage URI where the disk image is stored. This file must be a gzip-compressed tarball whose name ends in .tar.gz or virtual machine disk whose name ends in vmdk. Valid URIs may start with gs:// or https://storage.googleapis.com/. This flag is not optimized for creating multiple disks from a source storage object. To create many disks from a source storage object, use gcloud compute images import instead.
        """
        return pulumi.get(self, "source_storage_object")

    @source_storage_object.setter
    def source_storage_object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_storage_object", value)

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[pulumi.Input['RegionDiskStorageType']]:
        """
        [Deprecated] Storage type of the persistent disk.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: Optional[pulumi.Input['RegionDiskStorageType']]):
        pulumi.set(self, "storage_type", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the disk type resource describing which disk type to use to create the disk. Provide this when creating the disk. For example: projects/project /zones/zone/diskTypes/pd-ssd . See Persistent disk types.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userLicenses")
    def user_licenses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of publicly visible user-licenses. Unlike regular licenses, user provided licenses can be modified after the disk is created. This includes a list of URLs to the license resource. For example, to provide a debian license: https://www.googleapis.com/compute/v1/projects/debian-cloud/global/licenses/debian-9-stretch 
        """
        return pulumi.get(self, "user_licenses")

    @user_licenses.setter
    def user_licenses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "user_licenses", value)


class RegionDisk(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 architecture: Optional[pulumi.Input['RegionDiskArchitecture']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disk_encryption_key: Optional[pulumi.Input[pulumi.InputType['CustomerEncryptionKeyArgs']]] = None,
                 erase_windows_vss_signature: Optional[pulumi.Input[bool]] = None,
                 guest_os_features: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GuestOsFeatureArgs']]]]] = None,
                 interface: Optional[pulumi.Input['RegionDiskInterface']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 license_codes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 licenses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 location_hint: Optional[pulumi.Input[str]] = None,
                 multi_writer: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[str]] = None,
                 params: Optional[pulumi.Input[pulumi.InputType['DiskParamsArgs']]] = None,
                 physical_block_size_bytes: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 provisioned_iops: Optional[pulumi.Input[str]] = None,
                 provisioned_throughput: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 replica_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 request_id: Optional[pulumi.Input[str]] = None,
                 resource_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 size_gb: Optional[pulumi.Input[str]] = None,
                 source_disk: Optional[pulumi.Input[str]] = None,
                 source_image: Optional[pulumi.Input[str]] = None,
                 source_image_encryption_key: Optional[pulumi.Input[pulumi.InputType['CustomerEncryptionKeyArgs']]] = None,
                 source_snapshot: Optional[pulumi.Input[str]] = None,
                 source_snapshot_encryption_key: Optional[pulumi.Input[pulumi.InputType['CustomerEncryptionKeyArgs']]] = None,
                 source_storage_object: Optional[pulumi.Input[str]] = None,
                 storage_type: Optional[pulumi.Input['RegionDiskStorageType']] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_licenses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Creates a persistent regional disk in the specified project using the data included in the request.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input['RegionDiskArchitecture'] architecture: The architecture of the disk. Valid values are ARM64 or X86_64.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input[pulumi.InputType['CustomerEncryptionKeyArgs']] disk_encryption_key: Encrypts the disk using a customer-supplied encryption key or a customer-managed encryption key. Encryption keys do not protect access to metadata of the disk. After you encrypt a disk with a customer-supplied key, you must provide the same key if you use the disk later. For example, to create a disk snapshot, to create a disk image, to create a machine image, or to attach the disk to a virtual machine. After you encrypt a disk with a customer-managed key, the diskEncryptionKey.kmsKeyName is set to a key *version* name once the disk is created. The disk is encrypted with this version of the key. In the response, diskEncryptionKey.kmsKeyName appears in the following format: "diskEncryptionKey.kmsKeyName": "projects/kms_project_id/locations/region/keyRings/ key_region/cryptoKeys/key /cryptoKeysVersions/version If you do not provide an encryption key when creating the disk, then the disk is encrypted using an automatically generated key and you don't need to provide a key to use the disk later.
        :param pulumi.Input[bool] erase_windows_vss_signature: Specifies whether the disk restored from a source snapshot should erase Windows specific VSS signature.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GuestOsFeatureArgs']]]] guest_os_features: A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
        :param pulumi.Input['RegionDiskInterface'] interface: [Deprecated] Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels to apply to this disk. These can be later modified by the setLabels method.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] license_codes: Integer license codes indicating which licenses are attached to this disk.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] licenses: A list of publicly visible licenses. Reserved for Google's use.
        :param pulumi.Input[str] location_hint: An opaque location hint used to place the disk close to other resources. This field is for use by internal tools that use the public API.
        :param pulumi.Input[bool] multi_writer: Indicates whether or not the disk can be read/write attached to more than one instance.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input[str] options: Internal use only.
        :param pulumi.Input[pulumi.InputType['DiskParamsArgs']] params: Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
        :param pulumi.Input[str] physical_block_size_bytes: Physical block size of the persistent disk, in bytes. If not present in a request, a default value is used. The currently supported size is 4096, other sizes may be added in the future. If an unsupported value is requested, the error message will list the supported values for the caller's project.
        :param pulumi.Input[str] provisioned_iops: Indicates how many IOPS to provision for the disk. This sets the number of I/O operations per second that the disk can handle. Values must be between 10,000 and 120,000. For more details, see the Extreme persistent disk documentation.
        :param pulumi.Input[str] provisioned_throughput: Indicates how much throughput to provision for the disk. This sets the number of throughput mb per second that the disk can handle. Values must be between 1 and 7,124.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] replica_zones: URLs of the zones where the disk should be replicated to. Only applicable for regional resources.
        :param pulumi.Input[str] request_id: An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resource_policies: Resource policies applied to this disk for automatic snapshot creations.
        :param pulumi.Input[str] size_gb: Size, in GB, of the persistent disk. You can specify this field when creating a persistent disk using the sourceImage, sourceSnapshot, or sourceDisk parameter, or specify it alone to create an empty persistent disk. If you specify this field along with a source, the value of sizeGb must not be less than the size of the source. Acceptable values are 1 to 65536, inclusive.
        :param pulumi.Input[str] source_disk: The source disk used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /disks/disk - https://www.googleapis.com/compute/v1/projects/project/regions/region /disks/disk - projects/project/zones/zone/disks/disk - projects/project/regions/region/disks/disk - zones/zone/disks/disk - regions/region/disks/disk 
        :param pulumi.Input[str] source_image: The source image used to create this disk. If the source image is deleted, this field will not be set. To create a disk with one of the public operating system images, specify the image by its family name. For example, specify family/debian-9 to use the latest Debian 9 image: projects/debian-cloud/global/images/family/debian-9 Alternatively, use a specific version of a public operating system image: projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD To create a disk with a custom image that you created, specify the image name in the following format: global/images/my-custom-image You can also specify a custom image by its image family, which returns the latest version of the image in that family. Replace the image name with family/family-name: global/images/family/my-image-family 
        :param pulumi.Input[pulumi.InputType['CustomerEncryptionKeyArgs']] source_image_encryption_key: The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key.
        :param pulumi.Input[str] source_snapshot: The source snapshot used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project /global/snapshots/snapshot - projects/project/global/snapshots/snapshot - global/snapshots/snapshot 
        :param pulumi.Input[pulumi.InputType['CustomerEncryptionKeyArgs']] source_snapshot_encryption_key: The customer-supplied encryption key of the source snapshot. Required if the source snapshot is protected by a customer-supplied encryption key.
        :param pulumi.Input[str] source_storage_object: The full Google Cloud Storage URI where the disk image is stored. This file must be a gzip-compressed tarball whose name ends in .tar.gz or virtual machine disk whose name ends in vmdk. Valid URIs may start with gs:// or https://storage.googleapis.com/. This flag is not optimized for creating multiple disks from a source storage object. To create many disks from a source storage object, use gcloud compute images import instead.
        :param pulumi.Input['RegionDiskStorageType'] storage_type: [Deprecated] Storage type of the persistent disk.
        :param pulumi.Input[str] type: URL of the disk type resource describing which disk type to use to create the disk. Provide this when creating the disk. For example: projects/project /zones/zone/diskTypes/pd-ssd . See Persistent disk types.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] user_licenses: A list of publicly visible user-licenses. Unlike regular licenses, user provided licenses can be modified after the disk is created. This includes a list of URLs to the license resource. For example, to provide a debian license: https://www.googleapis.com/compute/v1/projects/debian-cloud/global/licenses/debian-9-stretch 
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RegionDiskArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a persistent regional disk in the specified project using the data included in the request.

        :param str resource_name: The name of the resource.
        :param RegionDiskArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RegionDiskArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 architecture: Optional[pulumi.Input['RegionDiskArchitecture']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disk_encryption_key: Optional[pulumi.Input[pulumi.InputType['CustomerEncryptionKeyArgs']]] = None,
                 erase_windows_vss_signature: Optional[pulumi.Input[bool]] = None,
                 guest_os_features: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GuestOsFeatureArgs']]]]] = None,
                 interface: Optional[pulumi.Input['RegionDiskInterface']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 license_codes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 licenses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 location_hint: Optional[pulumi.Input[str]] = None,
                 multi_writer: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[str]] = None,
                 params: Optional[pulumi.Input[pulumi.InputType['DiskParamsArgs']]] = None,
                 physical_block_size_bytes: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 provisioned_iops: Optional[pulumi.Input[str]] = None,
                 provisioned_throughput: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 replica_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 request_id: Optional[pulumi.Input[str]] = None,
                 resource_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 size_gb: Optional[pulumi.Input[str]] = None,
                 source_disk: Optional[pulumi.Input[str]] = None,
                 source_image: Optional[pulumi.Input[str]] = None,
                 source_image_encryption_key: Optional[pulumi.Input[pulumi.InputType['CustomerEncryptionKeyArgs']]] = None,
                 source_snapshot: Optional[pulumi.Input[str]] = None,
                 source_snapshot_encryption_key: Optional[pulumi.Input[pulumi.InputType['CustomerEncryptionKeyArgs']]] = None,
                 source_storage_object: Optional[pulumi.Input[str]] = None,
                 storage_type: Optional[pulumi.Input['RegionDiskStorageType']] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_licenses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RegionDiskArgs.__new__(RegionDiskArgs)

            __props__.__dict__["architecture"] = architecture
            __props__.__dict__["description"] = description
            __props__.__dict__["disk_encryption_key"] = disk_encryption_key
            __props__.__dict__["erase_windows_vss_signature"] = erase_windows_vss_signature
            __props__.__dict__["guest_os_features"] = guest_os_features
            if interface is not None and not opts.urn:
                warnings.warn("""[Deprecated] Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI.""", DeprecationWarning)
                pulumi.log.warn("""interface is deprecated: [Deprecated] Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI.""")
            __props__.__dict__["interface"] = interface
            __props__.__dict__["labels"] = labels
            __props__.__dict__["license_codes"] = license_codes
            __props__.__dict__["licenses"] = licenses
            __props__.__dict__["location_hint"] = location_hint
            __props__.__dict__["multi_writer"] = multi_writer
            __props__.__dict__["name"] = name
            __props__.__dict__["options"] = options
            __props__.__dict__["params"] = params
            __props__.__dict__["physical_block_size_bytes"] = physical_block_size_bytes
            __props__.__dict__["project"] = project
            __props__.__dict__["provisioned_iops"] = provisioned_iops
            __props__.__dict__["provisioned_throughput"] = provisioned_throughput
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["replica_zones"] = replica_zones
            __props__.__dict__["request_id"] = request_id
            __props__.__dict__["resource_policies"] = resource_policies
            __props__.__dict__["size_gb"] = size_gb
            __props__.__dict__["source_disk"] = source_disk
            __props__.__dict__["source_image"] = source_image
            __props__.__dict__["source_image_encryption_key"] = source_image_encryption_key
            __props__.__dict__["source_snapshot"] = source_snapshot
            __props__.__dict__["source_snapshot_encryption_key"] = source_snapshot_encryption_key
            __props__.__dict__["source_storage_object"] = source_storage_object
            if storage_type is not None and not opts.urn:
                warnings.warn("""[Deprecated] Storage type of the persistent disk.""", DeprecationWarning)
                pulumi.log.warn("""storage_type is deprecated: [Deprecated] Storage type of the persistent disk.""")
            __props__.__dict__["storage_type"] = storage_type
            __props__.__dict__["type"] = type
            __props__.__dict__["user_licenses"] = user_licenses
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["kind"] = None
            __props__.__dict__["label_fingerprint"] = None
            __props__.__dict__["last_attach_timestamp"] = None
            __props__.__dict__["last_detach_timestamp"] = None
            __props__.__dict__["locked"] = None
            __props__.__dict__["satisfies_pzs"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["source_disk_id"] = None
            __props__.__dict__["source_image_id"] = None
            __props__.__dict__["source_snapshot_id"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["users"] = None
            __props__.__dict__["zone"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["project", "region"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(RegionDisk, __self__).__init__(
            'google-native:compute/beta:RegionDisk',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'RegionDisk':
        """
        Get an existing RegionDisk resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = RegionDiskArgs.__new__(RegionDiskArgs)

        __props__.__dict__["architecture"] = None
        __props__.__dict__["creation_timestamp"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["disk_encryption_key"] = None
        __props__.__dict__["erase_windows_vss_signature"] = None
        __props__.__dict__["guest_os_features"] = None
        __props__.__dict__["interface"] = None
        __props__.__dict__["kind"] = None
        __props__.__dict__["label_fingerprint"] = None
        __props__.__dict__["labels"] = None
        __props__.__dict__["last_attach_timestamp"] = None
        __props__.__dict__["last_detach_timestamp"] = None
        __props__.__dict__["license_codes"] = None
        __props__.__dict__["licenses"] = None
        __props__.__dict__["location_hint"] = None
        __props__.__dict__["locked"] = None
        __props__.__dict__["multi_writer"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["options"] = None
        __props__.__dict__["params"] = None
        __props__.__dict__["physical_block_size_bytes"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["provisioned_iops"] = None
        __props__.__dict__["provisioned_throughput"] = None
        __props__.__dict__["region"] = None
        __props__.__dict__["replica_zones"] = None
        __props__.__dict__["request_id"] = None
        __props__.__dict__["resource_policies"] = None
        __props__.__dict__["satisfies_pzs"] = None
        __props__.__dict__["self_link"] = None
        __props__.__dict__["size_gb"] = None
        __props__.__dict__["source_disk"] = None
        __props__.__dict__["source_disk_id"] = None
        __props__.__dict__["source_image"] = None
        __props__.__dict__["source_image_encryption_key"] = None
        __props__.__dict__["source_image_id"] = None
        __props__.__dict__["source_snapshot"] = None
        __props__.__dict__["source_snapshot_encryption_key"] = None
        __props__.__dict__["source_snapshot_id"] = None
        __props__.__dict__["source_storage_object"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["storage_type"] = None
        __props__.__dict__["type"] = None
        __props__.__dict__["user_licenses"] = None
        __props__.__dict__["users"] = None
        __props__.__dict__["zone"] = None
        return RegionDisk(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def architecture(self) -> pulumi.Output[str]:
        """
        The architecture of the disk. Valid values are ARM64 or X86_64.
        """
        return pulumi.get(self, "architecture")

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[str]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="diskEncryptionKey")
    def disk_encryption_key(self) -> pulumi.Output['outputs.CustomerEncryptionKeyResponse']:
        """
        Encrypts the disk using a customer-supplied encryption key or a customer-managed encryption key. Encryption keys do not protect access to metadata of the disk. After you encrypt a disk with a customer-supplied key, you must provide the same key if you use the disk later. For example, to create a disk snapshot, to create a disk image, to create a machine image, or to attach the disk to a virtual machine. After you encrypt a disk with a customer-managed key, the diskEncryptionKey.kmsKeyName is set to a key *version* name once the disk is created. The disk is encrypted with this version of the key. In the response, diskEncryptionKey.kmsKeyName appears in the following format: "diskEncryptionKey.kmsKeyName": "projects/kms_project_id/locations/region/keyRings/ key_region/cryptoKeys/key /cryptoKeysVersions/version If you do not provide an encryption key when creating the disk, then the disk is encrypted using an automatically generated key and you don't need to provide a key to use the disk later.
        """
        return pulumi.get(self, "disk_encryption_key")

    @property
    @pulumi.getter(name="eraseWindowsVssSignature")
    def erase_windows_vss_signature(self) -> pulumi.Output[bool]:
        """
        Specifies whether the disk restored from a source snapshot should erase Windows specific VSS signature.
        """
        return pulumi.get(self, "erase_windows_vss_signature")

    @property
    @pulumi.getter(name="guestOsFeatures")
    def guest_os_features(self) -> pulumi.Output[Sequence['outputs.GuestOsFeatureResponse']]:
        """
        A list of features to enable on the guest operating system. Applicable only for bootable images. Read Enabling guest operating system features to see a list of available options.
        """
        return pulumi.get(self, "guest_os_features")

    @property
    @pulumi.getter
    def interface(self) -> pulumi.Output[str]:
        """
        [Deprecated] Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI.
        """
        return pulumi.get(self, "interface")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[str]:
        """
        Type of the resource. Always compute#disk for disks.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="labelFingerprint")
    def label_fingerprint(self) -> pulumi.Output[str]:
        """
        A fingerprint for the labels being applied to this disk, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a disk.
        """
        return pulumi.get(self, "label_fingerprint")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Labels to apply to this disk. These can be later modified by the setLabels method.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="lastAttachTimestamp")
    def last_attach_timestamp(self) -> pulumi.Output[str]:
        """
        Last attach timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "last_attach_timestamp")

    @property
    @pulumi.getter(name="lastDetachTimestamp")
    def last_detach_timestamp(self) -> pulumi.Output[str]:
        """
        Last detach timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "last_detach_timestamp")

    @property
    @pulumi.getter(name="licenseCodes")
    def license_codes(self) -> pulumi.Output[Sequence[str]]:
        """
        Integer license codes indicating which licenses are attached to this disk.
        """
        return pulumi.get(self, "license_codes")

    @property
    @pulumi.getter
    def licenses(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of publicly visible licenses. Reserved for Google's use.
        """
        return pulumi.get(self, "licenses")

    @property
    @pulumi.getter(name="locationHint")
    def location_hint(self) -> pulumi.Output[str]:
        """
        An opaque location hint used to place the disk close to other resources. This field is for use by internal tools that use the public API.
        """
        return pulumi.get(self, "location_hint")

    @property
    @pulumi.getter
    def locked(self) -> pulumi.Output[bool]:
        """
        The field indicates if the disk is created from a locked source image. Attachment of a disk created from a locked source image will cause the following operations to become irreversibly prohibited: - R/W or R/O disk attachment to any other instance - Disk detachment. And the disk can only be deleted when the instance is deleted - Creation of images or snapshots - Disk cloning Furthermore, the instance with at least one disk with locked flag set to true will be prohibited from performing the operations below: - Further attachment of secondary disks. - Detachment of any disks - Create machine images - Create instance template - Delete the instance with --keep-disk parameter set to true for locked disks - Attach a locked disk with --auto-delete parameter set to false 
        """
        return pulumi.get(self, "locked")

    @property
    @pulumi.getter(name="multiWriter")
    def multi_writer(self) -> pulumi.Output[bool]:
        """
        Indicates whether or not the disk can be read/write attached to more than one instance.
        """
        return pulumi.get(self, "multi_writer")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def options(self) -> pulumi.Output[str]:
        """
        Internal use only.
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter
    def params(self) -> pulumi.Output['outputs.DiskParamsResponse']:
        """
        Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
        """
        return pulumi.get(self, "params")

    @property
    @pulumi.getter(name="physicalBlockSizeBytes")
    def physical_block_size_bytes(self) -> pulumi.Output[str]:
        """
        Physical block size of the persistent disk, in bytes. If not present in a request, a default value is used. The currently supported size is 4096, other sizes may be added in the future. If an unsupported value is requested, the error message will list the supported values for the caller's project.
        """
        return pulumi.get(self, "physical_block_size_bytes")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="provisionedIops")
    def provisioned_iops(self) -> pulumi.Output[str]:
        """
        Indicates how many IOPS to provision for the disk. This sets the number of I/O operations per second that the disk can handle. Values must be between 10,000 and 120,000. For more details, see the Extreme persistent disk documentation.
        """
        return pulumi.get(self, "provisioned_iops")

    @property
    @pulumi.getter(name="provisionedThroughput")
    def provisioned_throughput(self) -> pulumi.Output[str]:
        """
        Indicates how much throughput to provision for the disk. This sets the number of throughput mb per second that the disk can handle. Values must be between 1 and 7,124.
        """
        return pulumi.get(self, "provisioned_throughput")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="replicaZones")
    def replica_zones(self) -> pulumi.Output[Sequence[str]]:
        """
        URLs of the zones where the disk should be replicated to. Only applicable for regional resources.
        """
        return pulumi.get(self, "replica_zones")

    @property
    @pulumi.getter(name="requestId")
    def request_id(self) -> pulumi.Output[Optional[str]]:
        """
        An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. For example, consider a situation where you make an initial request and the request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported ( 00000000-0000-0000-0000-000000000000).
        """
        return pulumi.get(self, "request_id")

    @property
    @pulumi.getter(name="resourcePolicies")
    def resource_policies(self) -> pulumi.Output[Sequence[str]]:
        """
        Resource policies applied to this disk for automatic snapshot creations.
        """
        return pulumi.get(self, "resource_policies")

    @property
    @pulumi.getter(name="satisfiesPzs")
    def satisfies_pzs(self) -> pulumi.Output[bool]:
        """
        Reserved for future use.
        """
        return pulumi.get(self, "satisfies_pzs")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        Server-defined fully-qualified URL for this resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="sizeGb")
    def size_gb(self) -> pulumi.Output[str]:
        """
        Size, in GB, of the persistent disk. You can specify this field when creating a persistent disk using the sourceImage, sourceSnapshot, or sourceDisk parameter, or specify it alone to create an empty persistent disk. If you specify this field along with a source, the value of sizeGb must not be less than the size of the source. Acceptable values are 1 to 65536, inclusive.
        """
        return pulumi.get(self, "size_gb")

    @property
    @pulumi.getter(name="sourceDisk")
    def source_disk(self) -> pulumi.Output[str]:
        """
        The source disk used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project/zones/zone /disks/disk - https://www.googleapis.com/compute/v1/projects/project/regions/region /disks/disk - projects/project/zones/zone/disks/disk - projects/project/regions/region/disks/disk - zones/zone/disks/disk - regions/region/disks/disk 
        """
        return pulumi.get(self, "source_disk")

    @property
    @pulumi.getter(name="sourceDiskId")
    def source_disk_id(self) -> pulumi.Output[str]:
        """
        The unique ID of the disk used to create this disk. This value identifies the exact disk that was used to create this persistent disk. For example, if you created the persistent disk from a disk that was later deleted and recreated under the same name, the source disk ID would identify the exact version of the disk that was used.
        """
        return pulumi.get(self, "source_disk_id")

    @property
    @pulumi.getter(name="sourceImage")
    def source_image(self) -> pulumi.Output[str]:
        """
        Source image to restore onto a disk. This field is optional.
        """
        return pulumi.get(self, "source_image")

    @property
    @pulumi.getter(name="sourceImageEncryptionKey")
    def source_image_encryption_key(self) -> pulumi.Output['outputs.CustomerEncryptionKeyResponse']:
        """
        The customer-supplied encryption key of the source image. Required if the source image is protected by a customer-supplied encryption key.
        """
        return pulumi.get(self, "source_image_encryption_key")

    @property
    @pulumi.getter(name="sourceImageId")
    def source_image_id(self) -> pulumi.Output[str]:
        """
        The ID value of the image used to create this disk. This value identifies the exact image that was used to create this persistent disk. For example, if you created the persistent disk from an image that was later deleted and recreated under the same name, the source image ID would identify the exact version of the image that was used.
        """
        return pulumi.get(self, "source_image_id")

    @property
    @pulumi.getter(name="sourceSnapshot")
    def source_snapshot(self) -> pulumi.Output[str]:
        """
        The source snapshot used to create this disk. You can provide this as a partial or full URL to the resource. For example, the following are valid values: - https://www.googleapis.com/compute/v1/projects/project /global/snapshots/snapshot - projects/project/global/snapshots/snapshot - global/snapshots/snapshot 
        """
        return pulumi.get(self, "source_snapshot")

    @property
    @pulumi.getter(name="sourceSnapshotEncryptionKey")
    def source_snapshot_encryption_key(self) -> pulumi.Output['outputs.CustomerEncryptionKeyResponse']:
        """
        The customer-supplied encryption key of the source snapshot. Required if the source snapshot is protected by a customer-supplied encryption key.
        """
        return pulumi.get(self, "source_snapshot_encryption_key")

    @property
    @pulumi.getter(name="sourceSnapshotId")
    def source_snapshot_id(self) -> pulumi.Output[str]:
        """
        The unique ID of the snapshot used to create this disk. This value identifies the exact snapshot that was used to create this persistent disk. For example, if you created the persistent disk from a snapshot that was later deleted and recreated under the same name, the source snapshot ID would identify the exact version of the snapshot that was used.
        """
        return pulumi.get(self, "source_snapshot_id")

    @property
    @pulumi.getter(name="sourceStorageObject")
    def source_storage_object(self) -> pulumi.Output[str]:
        """
        The full Google Cloud Storage URI where the disk image is stored. This file must be a gzip-compressed tarball whose name ends in .tar.gz or virtual machine disk whose name ends in vmdk. Valid URIs may start with gs:// or https://storage.googleapis.com/. This flag is not optimized for creating multiple disks from a source storage object. To create many disks from a source storage object, use gcloud compute images import instead.
        """
        return pulumi.get(self, "source_storage_object")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of disk creation. - CREATING: Disk is provisioning. - RESTORING: Source data is being copied into the disk. - FAILED: Disk creation failed. - READY: Disk is ready for use. - DELETING: Disk is deleting. 
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Output[str]:
        """
        [Deprecated] Storage type of the persistent disk.
        """
        return pulumi.get(self, "storage_type")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        URL of the disk type resource describing which disk type to use to create the disk. Provide this when creating the disk. For example: projects/project /zones/zone/diskTypes/pd-ssd . See Persistent disk types.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userLicenses")
    def user_licenses(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of publicly visible user-licenses. Unlike regular licenses, user provided licenses can be modified after the disk is created. This includes a list of URLs to the license resource. For example, to provide a debian license: https://www.googleapis.com/compute/v1/projects/debian-cloud/global/licenses/debian-9-stretch 
        """
        return pulumi.get(self, "user_licenses")

    @property
    @pulumi.getter
    def users(self) -> pulumi.Output[Sequence[str]]:
        """
        Links to the users of the disk (attached instances) in form: projects/project/zones/zone/instances/instance
        """
        return pulumi.get(self, "users")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[str]:
        """
        URL of the zone where the disk resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
        """
        return pulumi.get(self, "zone")

