# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['InboundSsoAssignmentArgs', 'InboundSsoAssignment']

@pulumi.input_type
class InboundSsoAssignmentArgs:
    def __init__(__self__, *,
                 customer: Optional[pulumi.Input[str]] = None,
                 rank: Optional[pulumi.Input[int]] = None,
                 saml_sso_info: Optional[pulumi.Input['SamlSsoInfoArgs']] = None,
                 sign_in_behavior: Optional[pulumi.Input['SignInBehaviorArgs']] = None,
                 sso_mode: Optional[pulumi.Input['InboundSsoAssignmentSsoMode']] = None,
                 target_group: Optional[pulumi.Input[str]] = None,
                 target_org_unit: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a InboundSsoAssignment resource.
        :param pulumi.Input[str] customer: Immutable. The customer. For example: `customers/C0123abc`.
        :param pulumi.Input[int] rank: Must be zero (which is the default value so it can be omitted) for assignments with `target_org_unit` set and must be greater-than-or-equal-to one for assignments with `target_group` set.
        :param pulumi.Input['SamlSsoInfoArgs'] saml_sso_info: SAML SSO details. Must be set if and only if `sso_mode` is set to `SAML_SSO`.
        :param pulumi.Input['SignInBehaviorArgs'] sign_in_behavior: Assertions about users assigned to an IdP will always be accepted from that IdP. This controls whether/when Google should redirect a user to the IdP. Unset (defaults) is the recommended configuration.
        :param pulumi.Input['InboundSsoAssignmentSsoMode'] sso_mode: Inbound SSO behavior.
        :param pulumi.Input[str] target_group: Immutable. Must be of the form `groups/{group}`.
        :param pulumi.Input[str] target_org_unit: Immutable. Must be of the form `orgUnits/{org_unit}`.
        """
        if customer is not None:
            pulumi.set(__self__, "customer", customer)
        if rank is not None:
            pulumi.set(__self__, "rank", rank)
        if saml_sso_info is not None:
            pulumi.set(__self__, "saml_sso_info", saml_sso_info)
        if sign_in_behavior is not None:
            pulumi.set(__self__, "sign_in_behavior", sign_in_behavior)
        if sso_mode is not None:
            pulumi.set(__self__, "sso_mode", sso_mode)
        if target_group is not None:
            pulumi.set(__self__, "target_group", target_group)
        if target_org_unit is not None:
            pulumi.set(__self__, "target_org_unit", target_org_unit)

    @property
    @pulumi.getter
    def customer(self) -> Optional[pulumi.Input[str]]:
        """
        Immutable. The customer. For example: `customers/C0123abc`.
        """
        return pulumi.get(self, "customer")

    @customer.setter
    def customer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer", value)

    @property
    @pulumi.getter
    def rank(self) -> Optional[pulumi.Input[int]]:
        """
        Must be zero (which is the default value so it can be omitted) for assignments with `target_org_unit` set and must be greater-than-or-equal-to one for assignments with `target_group` set.
        """
        return pulumi.get(self, "rank")

    @rank.setter
    def rank(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "rank", value)

    @property
    @pulumi.getter(name="samlSsoInfo")
    def saml_sso_info(self) -> Optional[pulumi.Input['SamlSsoInfoArgs']]:
        """
        SAML SSO details. Must be set if and only if `sso_mode` is set to `SAML_SSO`.
        """
        return pulumi.get(self, "saml_sso_info")

    @saml_sso_info.setter
    def saml_sso_info(self, value: Optional[pulumi.Input['SamlSsoInfoArgs']]):
        pulumi.set(self, "saml_sso_info", value)

    @property
    @pulumi.getter(name="signInBehavior")
    def sign_in_behavior(self) -> Optional[pulumi.Input['SignInBehaviorArgs']]:
        """
        Assertions about users assigned to an IdP will always be accepted from that IdP. This controls whether/when Google should redirect a user to the IdP. Unset (defaults) is the recommended configuration.
        """
        return pulumi.get(self, "sign_in_behavior")

    @sign_in_behavior.setter
    def sign_in_behavior(self, value: Optional[pulumi.Input['SignInBehaviorArgs']]):
        pulumi.set(self, "sign_in_behavior", value)

    @property
    @pulumi.getter(name="ssoMode")
    def sso_mode(self) -> Optional[pulumi.Input['InboundSsoAssignmentSsoMode']]:
        """
        Inbound SSO behavior.
        """
        return pulumi.get(self, "sso_mode")

    @sso_mode.setter
    def sso_mode(self, value: Optional[pulumi.Input['InboundSsoAssignmentSsoMode']]):
        pulumi.set(self, "sso_mode", value)

    @property
    @pulumi.getter(name="targetGroup")
    def target_group(self) -> Optional[pulumi.Input[str]]:
        """
        Immutable. Must be of the form `groups/{group}`.
        """
        return pulumi.get(self, "target_group")

    @target_group.setter
    def target_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_group", value)

    @property
    @pulumi.getter(name="targetOrgUnit")
    def target_org_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Immutable. Must be of the form `orgUnits/{org_unit}`.
        """
        return pulumi.get(self, "target_org_unit")

    @target_org_unit.setter
    def target_org_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_org_unit", value)


class InboundSsoAssignment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 customer: Optional[pulumi.Input[str]] = None,
                 rank: Optional[pulumi.Input[int]] = None,
                 saml_sso_info: Optional[pulumi.Input[pulumi.InputType['SamlSsoInfoArgs']]] = None,
                 sign_in_behavior: Optional[pulumi.Input[pulumi.InputType['SignInBehaviorArgs']]] = None,
                 sso_mode: Optional[pulumi.Input['InboundSsoAssignmentSsoMode']] = None,
                 target_group: Optional[pulumi.Input[str]] = None,
                 target_org_unit: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates an InboundSsoAssignment for users and devices in a `Customer` under a given `Group` or `OrgUnit`.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] customer: Immutable. The customer. For example: `customers/C0123abc`.
        :param pulumi.Input[int] rank: Must be zero (which is the default value so it can be omitted) for assignments with `target_org_unit` set and must be greater-than-or-equal-to one for assignments with `target_group` set.
        :param pulumi.Input[pulumi.InputType['SamlSsoInfoArgs']] saml_sso_info: SAML SSO details. Must be set if and only if `sso_mode` is set to `SAML_SSO`.
        :param pulumi.Input[pulumi.InputType['SignInBehaviorArgs']] sign_in_behavior: Assertions about users assigned to an IdP will always be accepted from that IdP. This controls whether/when Google should redirect a user to the IdP. Unset (defaults) is the recommended configuration.
        :param pulumi.Input['InboundSsoAssignmentSsoMode'] sso_mode: Inbound SSO behavior.
        :param pulumi.Input[str] target_group: Immutable. Must be of the form `groups/{group}`.
        :param pulumi.Input[str] target_org_unit: Immutable. Must be of the form `orgUnits/{org_unit}`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[InboundSsoAssignmentArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates an InboundSsoAssignment for users and devices in a `Customer` under a given `Group` or `OrgUnit`.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param InboundSsoAssignmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InboundSsoAssignmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 customer: Optional[pulumi.Input[str]] = None,
                 rank: Optional[pulumi.Input[int]] = None,
                 saml_sso_info: Optional[pulumi.Input[pulumi.InputType['SamlSsoInfoArgs']]] = None,
                 sign_in_behavior: Optional[pulumi.Input[pulumi.InputType['SignInBehaviorArgs']]] = None,
                 sso_mode: Optional[pulumi.Input['InboundSsoAssignmentSsoMode']] = None,
                 target_group: Optional[pulumi.Input[str]] = None,
                 target_org_unit: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InboundSsoAssignmentArgs.__new__(InboundSsoAssignmentArgs)

            __props__.__dict__["customer"] = customer
            __props__.__dict__["rank"] = rank
            __props__.__dict__["saml_sso_info"] = saml_sso_info
            __props__.__dict__["sign_in_behavior"] = sign_in_behavior
            __props__.__dict__["sso_mode"] = sso_mode
            __props__.__dict__["target_group"] = target_group
            __props__.__dict__["target_org_unit"] = target_org_unit
            __props__.__dict__["name"] = None
        super(InboundSsoAssignment, __self__).__init__(
            'google-native:cloudidentity/v1:InboundSsoAssignment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'InboundSsoAssignment':
        """
        Get an existing InboundSsoAssignment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = InboundSsoAssignmentArgs.__new__(InboundSsoAssignmentArgs)

        __props__.__dict__["customer"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["rank"] = None
        __props__.__dict__["saml_sso_info"] = None
        __props__.__dict__["sign_in_behavior"] = None
        __props__.__dict__["sso_mode"] = None
        __props__.__dict__["target_group"] = None
        __props__.__dict__["target_org_unit"] = None
        return InboundSsoAssignment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def customer(self) -> pulumi.Output[str]:
        """
        Immutable. The customer. For example: `customers/C0123abc`.
        """
        return pulumi.get(self, "customer")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        [Resource name](https://cloud.google.com/apis/design/resource_names) of the Inbound SSO Assignment.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def rank(self) -> pulumi.Output[int]:
        """
        Must be zero (which is the default value so it can be omitted) for assignments with `target_org_unit` set and must be greater-than-or-equal-to one for assignments with `target_group` set.
        """
        return pulumi.get(self, "rank")

    @property
    @pulumi.getter(name="samlSsoInfo")
    def saml_sso_info(self) -> pulumi.Output['outputs.SamlSsoInfoResponse']:
        """
        SAML SSO details. Must be set if and only if `sso_mode` is set to `SAML_SSO`.
        """
        return pulumi.get(self, "saml_sso_info")

    @property
    @pulumi.getter(name="signInBehavior")
    def sign_in_behavior(self) -> pulumi.Output['outputs.SignInBehaviorResponse']:
        """
        Assertions about users assigned to an IdP will always be accepted from that IdP. This controls whether/when Google should redirect a user to the IdP. Unset (defaults) is the recommended configuration.
        """
        return pulumi.get(self, "sign_in_behavior")

    @property
    @pulumi.getter(name="ssoMode")
    def sso_mode(self) -> pulumi.Output[str]:
        """
        Inbound SSO behavior.
        """
        return pulumi.get(self, "sso_mode")

    @property
    @pulumi.getter(name="targetGroup")
    def target_group(self) -> pulumi.Output[str]:
        """
        Immutable. Must be of the form `groups/{group}`.
        """
        return pulumi.get(self, "target_group")

    @property
    @pulumi.getter(name="targetOrgUnit")
    def target_org_unit(self) -> pulumi.Output[str]:
        """
        Immutable. Must be of the form `orgUnits/{org_unit}`.
        """
        return pulumi.get(self, "target_org_unit")

