# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InboundSamlSsoProfileArgs', 'InboundSamlSsoProfile']

@pulumi.input_type
class InboundSamlSsoProfileArgs:
    def __init__(__self__, *,
                 customer: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 idp_config: Optional[pulumi.Input['SamlIdpConfigArgs']] = None,
                 sp_config: Optional[pulumi.Input['SamlSpConfigArgs']] = None):
        """
        The set of arguments for constructing a InboundSamlSsoProfile resource.
        :param pulumi.Input[str] customer: Immutable. The customer. For example: `customers/C0123abc`.
        :param pulumi.Input[str] display_name: Human-readable name of the SAML SSO profile.
        :param pulumi.Input['SamlIdpConfigArgs'] idp_config: SAML identity provider configuration.
        :param pulumi.Input['SamlSpConfigArgs'] sp_config: SAML service provider configuration for this SAML SSO profile. These are the service provider details provided by Google that should be configured on the corresponding identity provider.
        """
        if customer is not None:
            pulumi.set(__self__, "customer", customer)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if idp_config is not None:
            pulumi.set(__self__, "idp_config", idp_config)
        if sp_config is not None:
            pulumi.set(__self__, "sp_config", sp_config)

    @property
    @pulumi.getter
    def customer(self) -> Optional[pulumi.Input[str]]:
        """
        Immutable. The customer. For example: `customers/C0123abc`.
        """
        return pulumi.get(self, "customer")

    @customer.setter
    def customer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable name of the SAML SSO profile.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="idpConfig")
    def idp_config(self) -> Optional[pulumi.Input['SamlIdpConfigArgs']]:
        """
        SAML identity provider configuration.
        """
        return pulumi.get(self, "idp_config")

    @idp_config.setter
    def idp_config(self, value: Optional[pulumi.Input['SamlIdpConfigArgs']]):
        pulumi.set(self, "idp_config", value)

    @property
    @pulumi.getter(name="spConfig")
    def sp_config(self) -> Optional[pulumi.Input['SamlSpConfigArgs']]:
        """
        SAML service provider configuration for this SAML SSO profile. These are the service provider details provided by Google that should be configured on the corresponding identity provider.
        """
        return pulumi.get(self, "sp_config")

    @sp_config.setter
    def sp_config(self, value: Optional[pulumi.Input['SamlSpConfigArgs']]):
        pulumi.set(self, "sp_config", value)


class InboundSamlSsoProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 customer: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 idp_config: Optional[pulumi.Input[pulumi.InputType['SamlIdpConfigArgs']]] = None,
                 sp_config: Optional[pulumi.Input[pulumi.InputType['SamlSpConfigArgs']]] = None,
                 __props__=None):
        """
        Creates an InboundSamlSsoProfile for a customer.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] customer: Immutable. The customer. For example: `customers/C0123abc`.
        :param pulumi.Input[str] display_name: Human-readable name of the SAML SSO profile.
        :param pulumi.Input[pulumi.InputType['SamlIdpConfigArgs']] idp_config: SAML identity provider configuration.
        :param pulumi.Input[pulumi.InputType['SamlSpConfigArgs']] sp_config: SAML service provider configuration for this SAML SSO profile. These are the service provider details provided by Google that should be configured on the corresponding identity provider.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[InboundSamlSsoProfileArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates an InboundSamlSsoProfile for a customer.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param InboundSamlSsoProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InboundSamlSsoProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 customer: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 idp_config: Optional[pulumi.Input[pulumi.InputType['SamlIdpConfigArgs']]] = None,
                 sp_config: Optional[pulumi.Input[pulumi.InputType['SamlSpConfigArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InboundSamlSsoProfileArgs.__new__(InboundSamlSsoProfileArgs)

            __props__.__dict__["customer"] = customer
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["idp_config"] = idp_config
            __props__.__dict__["sp_config"] = sp_config
            __props__.__dict__["name"] = None
        super(InboundSamlSsoProfile, __self__).__init__(
            'google-native:cloudidentity/v1:InboundSamlSsoProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'InboundSamlSsoProfile':
        """
        Get an existing InboundSamlSsoProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = InboundSamlSsoProfileArgs.__new__(InboundSamlSsoProfileArgs)

        __props__.__dict__["customer"] = None
        __props__.__dict__["display_name"] = None
        __props__.__dict__["idp_config"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["sp_config"] = None
        return InboundSamlSsoProfile(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def customer(self) -> pulumi.Output[str]:
        """
        Immutable. The customer. For example: `customers/C0123abc`.
        """
        return pulumi.get(self, "customer")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        Human-readable name of the SAML SSO profile.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="idpConfig")
    def idp_config(self) -> pulumi.Output['outputs.SamlIdpConfigResponse']:
        """
        SAML identity provider configuration.
        """
        return pulumi.get(self, "idp_config")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        [Resource name](https://cloud.google.com/apis/design/resource_names) of the SAML SSO profile.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="spConfig")
    def sp_config(self) -> pulumi.Output['outputs.SamlSpConfigResponse']:
        """
        SAML service provider configuration for this SAML SSO profile. These are the service provider details provided by Google that should be configured on the corresponding identity provider.
        """
        return pulumi.get(self, "sp_config")

