# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetInboundSamlSsoProfileResult',
    'AwaitableGetInboundSamlSsoProfileResult',
    'get_inbound_saml_sso_profile',
    'get_inbound_saml_sso_profile_output',
]

@pulumi.output_type
class GetInboundSamlSsoProfileResult:
    def __init__(__self__, customer=None, display_name=None, idp_config=None, name=None, sp_config=None):
        if customer and not isinstance(customer, str):
            raise TypeError("Expected argument 'customer' to be a str")
        pulumi.set(__self__, "customer", customer)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if idp_config and not isinstance(idp_config, dict):
            raise TypeError("Expected argument 'idp_config' to be a dict")
        pulumi.set(__self__, "idp_config", idp_config)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if sp_config and not isinstance(sp_config, dict):
            raise TypeError("Expected argument 'sp_config' to be a dict")
        pulumi.set(__self__, "sp_config", sp_config)

    @property
    @pulumi.getter
    def customer(self) -> str:
        """
        Immutable. The customer. For example: `customers/C0123abc`.
        """
        return pulumi.get(self, "customer")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Human-readable name of the SAML SSO profile.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="idpConfig")
    def idp_config(self) -> 'outputs.SamlIdpConfigResponse':
        """
        SAML identity provider configuration.
        """
        return pulumi.get(self, "idp_config")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        [Resource name](https://cloud.google.com/apis/design/resource_names) of the SAML SSO profile.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="spConfig")
    def sp_config(self) -> 'outputs.SamlSpConfigResponse':
        """
        SAML service provider configuration for this SAML SSO profile. These are the service provider details provided by Google that should be configured on the corresponding identity provider.
        """
        return pulumi.get(self, "sp_config")


class AwaitableGetInboundSamlSsoProfileResult(GetInboundSamlSsoProfileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInboundSamlSsoProfileResult(
            customer=self.customer,
            display_name=self.display_name,
            idp_config=self.idp_config,
            name=self.name,
            sp_config=self.sp_config)


def get_inbound_saml_sso_profile(inbound_saml_sso_profile_id: Optional[str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInboundSamlSsoProfileResult:
    """
    Gets an InboundSamlSsoProfile.
    """
    __args__ = dict()
    __args__['inboundSamlSsoProfileId'] = inbound_saml_sso_profile_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:cloudidentity/v1:getInboundSamlSsoProfile', __args__, opts=opts, typ=GetInboundSamlSsoProfileResult).value

    return AwaitableGetInboundSamlSsoProfileResult(
        customer=__ret__.customer,
        display_name=__ret__.display_name,
        idp_config=__ret__.idp_config,
        name=__ret__.name,
        sp_config=__ret__.sp_config)


@_utilities.lift_output_func(get_inbound_saml_sso_profile)
def get_inbound_saml_sso_profile_output(inbound_saml_sso_profile_id: Optional[pulumi.Input[str]] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetInboundSamlSsoProfileResult]:
    """
    Gets an InboundSamlSsoProfile.
    """
    ...
