# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'DynamicGroupMetadataArgs',
    'DynamicGroupQueryArgs',
    'EntityKeyArgs',
    'ExpiryDetailArgs',
    'MembershipRoleRestrictionEvaluationArgs',
    'MembershipRoleArgs',
    'RestrictionEvaluationsArgs',
    'SamlIdpConfigArgs',
    'SamlSpConfigArgs',
    'SamlSsoInfoArgs',
    'SignInBehaviorArgs',
]

@pulumi.input_type
class DynamicGroupMetadataArgs:
    def __init__(__self__, *,
                 queries: Optional[pulumi.Input[Sequence[pulumi.Input['DynamicGroupQueryArgs']]]] = None):
        """
        Dynamic group metadata like queries and status.
        :param pulumi.Input[Sequence[pulumi.Input['DynamicGroupQueryArgs']]] queries: Memberships will be the union of all queries. Only one entry with USER resource is currently supported. Customers can create up to 100 dynamic groups.
        """
        if queries is not None:
            pulumi.set(__self__, "queries", queries)

    @property
    @pulumi.getter
    def queries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DynamicGroupQueryArgs']]]]:
        """
        Memberships will be the union of all queries. Only one entry with USER resource is currently supported. Customers can create up to 100 dynamic groups.
        """
        return pulumi.get(self, "queries")

    @queries.setter
    def queries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DynamicGroupQueryArgs']]]]):
        pulumi.set(self, "queries", value)


@pulumi.input_type
class DynamicGroupQueryArgs:
    def __init__(__self__, *,
                 query: Optional[pulumi.Input[str]] = None,
                 resource_type: Optional[pulumi.Input['DynamicGroupQueryResourceType']] = None):
        """
        Defines a query on a resource.
        :param pulumi.Input[str] query: Query that determines the memberships of the dynamic group. Examples: All users with at least one `organizations.department` of engineering. `user.organizations.exists(org, org.department=='engineering')` All users with at least one location that has `area` of `foo` and `building_id` of `bar`. `user.locations.exists(loc, loc.area=='foo' && loc.building_id=='bar')` All users with any variation of the name John Doe (case-insensitive queries add `equalsIgnoreCase()` to the value being queried). `user.name.value.equalsIgnoreCase('jOhn DoE')`
        :param pulumi.Input['DynamicGroupQueryResourceType'] resource_type: Resource type for the Dynamic Group Query
        """
        if query is not None:
            pulumi.set(__self__, "query", query)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)

    @property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input[str]]:
        """
        Query that determines the memberships of the dynamic group. Examples: All users with at least one `organizations.department` of engineering. `user.organizations.exists(org, org.department=='engineering')` All users with at least one location that has `area` of `foo` and `building_id` of `bar`. `user.locations.exists(loc, loc.area=='foo' && loc.building_id=='bar')` All users with any variation of the name John Doe (case-insensitive queries add `equalsIgnoreCase()` to the value being queried). `user.name.value.equalsIgnoreCase('jOhn DoE')`
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input['DynamicGroupQueryResourceType']]:
        """
        Resource type for the Dynamic Group Query
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input['DynamicGroupQueryResourceType']]):
        pulumi.set(self, "resource_type", value)


@pulumi.input_type
class EntityKeyArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None):
        """
        A unique identifier for an entity in the Cloud Identity Groups API. An entity can represent either a group with an optional `namespace` or a user without a `namespace`. The combination of `id` and `namespace` must be unique; however, the same `id` can be used with different `namespace`s.
        :param pulumi.Input[str] id: The ID of the entity. For Google-managed entities, the `id` should be the email address of an existing group or user. For external-identity-mapped entities, the `id` must be a string conforming to the Identity Source's requirements. Must be unique within a `namespace`.
        :param pulumi.Input[str] namespace: The namespace in which the entity exists. If not specified, the `EntityKey` represents a Google-managed entity such as a Google user or a Google Group. If specified, the `EntityKey` represents an external-identity-mapped group. The namespace must correspond to an identity source created in Admin Console and must be in the form of `identitysources/{identity_source}`.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the entity. For Google-managed entities, the `id` should be the email address of an existing group or user. For external-identity-mapped entities, the `id` must be a string conforming to the Identity Source's requirements. Must be unique within a `namespace`.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace in which the entity exists. If not specified, the `EntityKey` represents a Google-managed entity such as a Google user or a Google Group. If specified, the `EntityKey` represents an external-identity-mapped group. The namespace must correspond to an identity source created in Admin Console and must be in the form of `identitysources/{identity_source}`.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)


@pulumi.input_type
class ExpiryDetailArgs:
    def __init__(__self__, *,
                 expire_time: Optional[pulumi.Input[str]] = None):
        """
        The `MembershipRole` expiry details.
        :param pulumi.Input[str] expire_time: The time at which the `MembershipRole` will expire.
        """
        if expire_time is not None:
            pulumi.set(__self__, "expire_time", expire_time)

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time at which the `MembershipRole` will expire.
        """
        return pulumi.get(self, "expire_time")

    @expire_time.setter
    def expire_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expire_time", value)


@pulumi.input_type
class MembershipRoleRestrictionEvaluationArgs:
    def __init__(__self__):
        """
        The evaluated state of this restriction.
        """
        pass


@pulumi.input_type
class MembershipRoleArgs:
    def __init__(__self__, *,
                 expiry_detail: Optional[pulumi.Input['ExpiryDetailArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 restriction_evaluations: Optional[pulumi.Input['RestrictionEvaluationsArgs']] = None):
        """
        A membership role within the Cloud Identity Groups API. A `MembershipRole` defines the privileges granted to a `Membership`.
        :param pulumi.Input['ExpiryDetailArgs'] expiry_detail: The expiry details of the `MembershipRole`. Expiry details are only supported for `MEMBER` `MembershipRoles`. May be set if `name` is `MEMBER`. Must not be set if `name` is any other value.
        :param pulumi.Input[str] name: The name of the `MembershipRole`. Must be one of `OWNER`, `MANAGER`, `MEMBER`.
        :param pulumi.Input['RestrictionEvaluationsArgs'] restriction_evaluations: Evaluations of restrictions applied to parent group on this membership.
        """
        if expiry_detail is not None:
            pulumi.set(__self__, "expiry_detail", expiry_detail)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if restriction_evaluations is not None:
            pulumi.set(__self__, "restriction_evaluations", restriction_evaluations)

    @property
    @pulumi.getter(name="expiryDetail")
    def expiry_detail(self) -> Optional[pulumi.Input['ExpiryDetailArgs']]:
        """
        The expiry details of the `MembershipRole`. Expiry details are only supported for `MEMBER` `MembershipRoles`. May be set if `name` is `MEMBER`. Must not be set if `name` is any other value.
        """
        return pulumi.get(self, "expiry_detail")

    @expiry_detail.setter
    def expiry_detail(self, value: Optional[pulumi.Input['ExpiryDetailArgs']]):
        pulumi.set(self, "expiry_detail", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the `MembershipRole`. Must be one of `OWNER`, `MANAGER`, `MEMBER`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="restrictionEvaluations")
    def restriction_evaluations(self) -> Optional[pulumi.Input['RestrictionEvaluationsArgs']]:
        """
        Evaluations of restrictions applied to parent group on this membership.
        """
        return pulumi.get(self, "restriction_evaluations")

    @restriction_evaluations.setter
    def restriction_evaluations(self, value: Optional[pulumi.Input['RestrictionEvaluationsArgs']]):
        pulumi.set(self, "restriction_evaluations", value)


@pulumi.input_type
class RestrictionEvaluationsArgs:
    def __init__(__self__, *,
                 member_restriction_evaluation: Optional[pulumi.Input['MembershipRoleRestrictionEvaluationArgs']] = None):
        """
        Evaluations of restrictions applied to parent group on this membership.
        :param pulumi.Input['MembershipRoleRestrictionEvaluationArgs'] member_restriction_evaluation: Evaluation of the member restriction applied to this membership. Empty if the user lacks permission to view the restriction evaluation.
        """
        if member_restriction_evaluation is not None:
            pulumi.set(__self__, "member_restriction_evaluation", member_restriction_evaluation)

    @property
    @pulumi.getter(name="memberRestrictionEvaluation")
    def member_restriction_evaluation(self) -> Optional[pulumi.Input['MembershipRoleRestrictionEvaluationArgs']]:
        """
        Evaluation of the member restriction applied to this membership. Empty if the user lacks permission to view the restriction evaluation.
        """
        return pulumi.get(self, "member_restriction_evaluation")

    @member_restriction_evaluation.setter
    def member_restriction_evaluation(self, value: Optional[pulumi.Input['MembershipRoleRestrictionEvaluationArgs']]):
        pulumi.set(self, "member_restriction_evaluation", value)


@pulumi.input_type
class SamlIdpConfigArgs:
    def __init__(__self__, *,
                 entity_id: pulumi.Input[str],
                 single_sign_on_service_uri: pulumi.Input[str],
                 change_password_uri: Optional[pulumi.Input[str]] = None,
                 logout_redirect_uri: Optional[pulumi.Input[str]] = None):
        """
        SAML IDP (identity provider) configuration.
        :param pulumi.Input[str] entity_id: The SAML **Entity ID** of the identity provider.
        :param pulumi.Input[str] single_sign_on_service_uri: The `SingleSignOnService` endpoint location (sign-in page URL) of the identity provider. This is the URL where the `AuthnRequest` will be sent. Must use `HTTPS`. Currently assumed to accept the `HTTP-Redirect` binding.
        :param pulumi.Input[str] change_password_uri: The **Change Password URL** of the identity provider. Users will be sent to this URL when changing their passwords at `myaccount.google.com`. This takes precedence over the change password URL configured at customer-level. Must use `HTTPS`.
        :param pulumi.Input[str] logout_redirect_uri: The **Logout Redirect URL** (sign-out page URL) of the identity provider. When a user clicks the sign-out link on a Google page, they will be redirected to this URL. This is a pure redirect with no attached SAML `LogoutRequest` i.e. SAML single logout is currently not supported. Must use `HTTPS`.
        """
        pulumi.set(__self__, "entity_id", entity_id)
        pulumi.set(__self__, "single_sign_on_service_uri", single_sign_on_service_uri)
        if change_password_uri is not None:
            pulumi.set(__self__, "change_password_uri", change_password_uri)
        if logout_redirect_uri is not None:
            pulumi.set(__self__, "logout_redirect_uri", logout_redirect_uri)

    @property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> pulumi.Input[str]:
        """
        The SAML **Entity ID** of the identity provider.
        """
        return pulumi.get(self, "entity_id")

    @entity_id.setter
    def entity_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "entity_id", value)

    @property
    @pulumi.getter(name="singleSignOnServiceUri")
    def single_sign_on_service_uri(self) -> pulumi.Input[str]:
        """
        The `SingleSignOnService` endpoint location (sign-in page URL) of the identity provider. This is the URL where the `AuthnRequest` will be sent. Must use `HTTPS`. Currently assumed to accept the `HTTP-Redirect` binding.
        """
        return pulumi.get(self, "single_sign_on_service_uri")

    @single_sign_on_service_uri.setter
    def single_sign_on_service_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "single_sign_on_service_uri", value)

    @property
    @pulumi.getter(name="changePasswordUri")
    def change_password_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The **Change Password URL** of the identity provider. Users will be sent to this URL when changing their passwords at `myaccount.google.com`. This takes precedence over the change password URL configured at customer-level. Must use `HTTPS`.
        """
        return pulumi.get(self, "change_password_uri")

    @change_password_uri.setter
    def change_password_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "change_password_uri", value)

    @property
    @pulumi.getter(name="logoutRedirectUri")
    def logout_redirect_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The **Logout Redirect URL** (sign-out page URL) of the identity provider. When a user clicks the sign-out link on a Google page, they will be redirected to this URL. This is a pure redirect with no attached SAML `LogoutRequest` i.e. SAML single logout is currently not supported. Must use `HTTPS`.
        """
        return pulumi.get(self, "logout_redirect_uri")

    @logout_redirect_uri.setter
    def logout_redirect_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logout_redirect_uri", value)


@pulumi.input_type
class SamlSpConfigArgs:
    def __init__(__self__):
        """
        SAML SP (service provider) configuration.
        """
        pass


@pulumi.input_type
class SamlSsoInfoArgs:
    def __init__(__self__, *,
                 inbound_saml_sso_profile: pulumi.Input[str]):
        """
        Details that are applicable when `sso_mode` == `SAML_SSO`.
        :param pulumi.Input[str] inbound_saml_sso_profile: Name of the `InboundSamlSsoProfile` to use. Must be of the form `inboundSamlSsoProfiles/{inbound_saml_sso_profile}`. 
        """
        pulumi.set(__self__, "inbound_saml_sso_profile", inbound_saml_sso_profile)

    @property
    @pulumi.getter(name="inboundSamlSsoProfile")
    def inbound_saml_sso_profile(self) -> pulumi.Input[str]:
        """
        Name of the `InboundSamlSsoProfile` to use. Must be of the form `inboundSamlSsoProfiles/{inbound_saml_sso_profile}`. 
        """
        return pulumi.get(self, "inbound_saml_sso_profile")

    @inbound_saml_sso_profile.setter
    def inbound_saml_sso_profile(self, value: pulumi.Input[str]):
        pulumi.set(self, "inbound_saml_sso_profile", value)


@pulumi.input_type
class SignInBehaviorArgs:
    def __init__(__self__, *,
                 redirect_condition: Optional[pulumi.Input['SignInBehaviorRedirectCondition']] = None):
        """
        Controls sign-in behavior.
        :param pulumi.Input['SignInBehaviorRedirectCondition'] redirect_condition: When to redirect sign-ins to the IdP.
        """
        if redirect_condition is not None:
            pulumi.set(__self__, "redirect_condition", redirect_condition)

    @property
    @pulumi.getter(name="redirectCondition")
    def redirect_condition(self) -> Optional[pulumi.Input['SignInBehaviorRedirectCondition']]:
        """
        When to redirect sign-ins to the IdP.
        """
        return pulumi.get(self, "redirect_condition")

    @redirect_condition.setter
    def redirect_condition(self, value: Optional[pulumi.Input['SignInBehaviorRedirectCondition']]):
        pulumi.set(self, "redirect_condition", value)


