# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

from enum import Enum

__all__ = [
    'BuildOptionsLogStreamingOption',
    'BuildOptionsLogging',
    'BuildOptionsMachineType',
    'BuildOptionsRequestedVerifyOption',
    'BuildOptionsSourceProvenanceHashItem',
    'BuildOptionsSubstitutionOption',
    'GitFileSourceRepoType',
    'GitRepoSourceRepoType',
    'NetworkConfigEgressOption',
    'PubsubConfigState',
    'PullRequestFilterCommentControl',
    'TriggerEventType',
    'TriggerIncludeBuildLogs',
    'WebhookConfigState',
]


class BuildOptionsLogStreamingOption(str, Enum):
    """
    Option to define build log streaming behavior to Google Cloud Storage.
    """
    STREAM_DEFAULT = "STREAM_DEFAULT"
    """
    Service may automatically determine build log streaming behavior.
    """
    STREAM_ON = "STREAM_ON"
    """
    Build logs should be streamed to Google Cloud Storage.
    """
    STREAM_OFF = "STREAM_OFF"
    """
    Build logs should not be streamed to Google Cloud Storage; they will be written when the build is completed.
    """


class BuildOptionsLogging(str, Enum):
    """
    Option to specify the logging mode, which determines if and where build logs are stored.
    """
    LOGGING_UNSPECIFIED = "LOGGING_UNSPECIFIED"
    """
    The service determines the logging mode. The default is `LEGACY`. Do not rely on the default logging behavior as it may change in the future.
    """
    LEGACY = "LEGACY"
    """
    Build logs are stored in Cloud Logging and Cloud Storage.
    """
    GCS_ONLY = "GCS_ONLY"
    """
    Build logs are stored in Cloud Storage.
    """
    STACKDRIVER_ONLY = "STACKDRIVER_ONLY"
    """
    This option is the same as CLOUD_LOGGING_ONLY.
    """
    CLOUD_LOGGING_ONLY = "CLOUD_LOGGING_ONLY"
    """
    Build logs are stored in Cloud Logging. Selecting this option will not allow [logs streaming](https://cloud.google.com/sdk/gcloud/reference/builds/log).
    """
    NONE = "NONE"
    """
    Turn off all logging. No build logs will be captured.
    """


class BuildOptionsMachineType(str, Enum):
    """
    Compute Engine machine type on which to run the build.
    """
    UNSPECIFIED = "UNSPECIFIED"
    """
    Standard machine type.
    """
    N1_HIGHCPU8 = "N1_HIGHCPU_8"
    """
    Highcpu machine with 8 CPUs.
    """
    N1_HIGHCPU32 = "N1_HIGHCPU_32"
    """
    Highcpu machine with 32 CPUs.
    """
    E2_HIGHCPU8 = "E2_HIGHCPU_8"
    """
    Highcpu e2 machine with 8 CPUs.
    """
    E2_HIGHCPU32 = "E2_HIGHCPU_32"
    """
    Highcpu e2 machine with 32 CPUs.
    """


class BuildOptionsRequestedVerifyOption(str, Enum):
    """
    Requested verifiability options.
    """
    NOT_VERIFIED = "NOT_VERIFIED"
    """
    Not a verifiable build (the default).
    """
    VERIFIED = "VERIFIED"
    """
    Build must be verified.
    """


class BuildOptionsSourceProvenanceHashItem(str, Enum):
    NONE = "NONE"
    """
    No hash requested.
    """
    SHA256 = "SHA256"
    """
    Use a sha256 hash.
    """
    MD5 = "MD5"
    """
    Use a md5 hash.
    """


class BuildOptionsSubstitutionOption(str, Enum):
    """
    Option to specify behavior when there is an error in the substitution checks. NOTE: this is always set to ALLOW_LOOSE for triggered builds and cannot be overridden in the build configuration file.
    """
    MUST_MATCH = "MUST_MATCH"
    """
    Fails the build if error in substitutions checks, like missing a substitution in the template or in the map.
    """
    ALLOW_LOOSE = "ALLOW_LOOSE"
    """
    Do not fail the build if error in substitutions checks.
    """


class GitFileSourceRepoType(str, Enum):
    """
    See RepoType above.
    """
    UNKNOWN = "UNKNOWN"
    """
    The default, unknown repo type.
    """
    CLOUD_SOURCE_REPOSITORIES = "CLOUD_SOURCE_REPOSITORIES"
    """
    A Google Cloud Source Repositories-hosted repo.
    """
    GITHUB = "GITHUB"
    """
    A GitHub-hosted repo not necessarily on "github.com" (i.e. GitHub Enterprise).
    """
    BITBUCKET_SERVER = "BITBUCKET_SERVER"
    """
    A Bitbucket Server-hosted repo.
    """
    GITLAB = "GITLAB"
    """
    A GitLab-hosted repo.
    """


class GitRepoSourceRepoType(str, Enum):
    """
    See RepoType below.
    """
    UNKNOWN = "UNKNOWN"
    """
    The default, unknown repo type.
    """
    CLOUD_SOURCE_REPOSITORIES = "CLOUD_SOURCE_REPOSITORIES"
    """
    A Google Cloud Source Repositories-hosted repo.
    """
    GITHUB = "GITHUB"
    """
    A GitHub-hosted repo not necessarily on "github.com" (i.e. GitHub Enterprise).
    """
    BITBUCKET_SERVER = "BITBUCKET_SERVER"
    """
    A Bitbucket Server-hosted repo.
    """
    GITLAB = "GITLAB"
    """
    A GitLab-hosted repo.
    """


class NetworkConfigEgressOption(str, Enum):
    """
    Option to configure network egress for the workers.
    """
    EGRESS_OPTION_UNSPECIFIED = "EGRESS_OPTION_UNSPECIFIED"
    """
    If set, defaults to PUBLIC_EGRESS.
    """
    NO_PUBLIC_EGRESS = "NO_PUBLIC_EGRESS"
    """
    If set, workers are created without any public address, which prevents network egress to public IPs unless a network proxy is configured.
    """
    PUBLIC_EGRESS = "PUBLIC_EGRESS"
    """
    If set, workers are created with a public address which allows for public internet egress.
    """


class PubsubConfigState(str, Enum):
    """
    Potential issues with the underlying Pub/Sub subscription configuration. Only populated on get requests.
    """
    STATE_UNSPECIFIED = "STATE_UNSPECIFIED"
    """
    The subscription configuration has not been checked.
    """
    OK = "OK"
    """
    The Pub/Sub subscription is properly configured.
    """
    SUBSCRIPTION_DELETED = "SUBSCRIPTION_DELETED"
    """
    The subscription has been deleted.
    """
    TOPIC_DELETED = "TOPIC_DELETED"
    """
    The topic has been deleted.
    """
    SUBSCRIPTION_MISCONFIGURED = "SUBSCRIPTION_MISCONFIGURED"
    """
    Some of the subscription's field are misconfigured.
    """


class PullRequestFilterCommentControl(str, Enum):
    """
    Configure builds to run whether a repository owner or collaborator need to comment `/gcbrun`.
    """
    COMMENTS_DISABLED = "COMMENTS_DISABLED"
    """
    Do not require comments on Pull Requests before builds are triggered.
    """
    COMMENTS_ENABLED = "COMMENTS_ENABLED"
    """
    Enforce that repository owners or collaborators must comment on Pull Requests before builds are triggered.
    """
    COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY = "COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY"
    """
    Enforce that repository owners or collaborators must comment on external contributors' Pull Requests before builds are triggered.
    """


class TriggerEventType(str, Enum):
    """
    EventType allows the user to explicitly set the type of event to which this BuildTrigger should respond. This field will be validated against the rest of the configuration if it is set.
    """
    EVENT_TYPE_UNSPECIFIED = "EVENT_TYPE_UNSPECIFIED"
    """
    EVENT_TYPE_UNSPECIFIED event_types are ignored.
    """
    REPO = "REPO"
    """
    REPO corresponds to the supported VCS integrations.
    """
    WEBHOOK = "WEBHOOK"
    """
    WEBHOOK corresponds to webhook triggers.
    """
    PUBSUB = "PUBSUB"
    """
    PUBSUB corresponds to pubsub triggers.
    """
    MANUAL = "MANUAL"
    """
    MANUAL corresponds to manual-only invoked triggers.
    """


class TriggerIncludeBuildLogs(str, Enum):
    """
    If set to INCLUDE_BUILD_LOGS_WITH_STATUS, log url will be shown on GitHub page when build status is final. Setting this field to INCLUDE_BUILD_LOGS_WITH_STATUS for non GitHub triggers results in INVALID_ARGUMENT error.
    """
    INCLUDE_BUILD_LOGS_UNSPECIFIED = "INCLUDE_BUILD_LOGS_UNSPECIFIED"
    """
    Build logs will not be shown on GitHub.
    """
    INCLUDE_BUILD_LOGS_WITH_STATUS = "INCLUDE_BUILD_LOGS_WITH_STATUS"
    """
    Build logs will be shown on GitHub.
    """


class WebhookConfigState(str, Enum):
    """
    Potential issues with the underlying Pub/Sub subscription configuration. Only populated on get requests.
    """
    STATE_UNSPECIFIED = "STATE_UNSPECIFIED"
    """
    The webhook auth configuration not been checked.
    """
    OK = "OK"
    """
    The auth configuration is properly setup.
    """
    SECRET_DELETED = "SECRET_DELETED"
    """
    The secret provided in auth_method has been deleted.
    """
