# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'CertificateAuthorityConfigArgs',
    'CertificateAuthorityServiceConfigArgs',
    'ManagedCertificateArgs',
    'SelfManagedCertificateArgs',
]

@pulumi.input_type
class CertificateAuthorityConfigArgs:
    def __init__(__self__, *,
                 certificate_authority_service_config: Optional[pulumi.Input['CertificateAuthorityServiceConfigArgs']] = None):
        """
        The CA that issues the workload certificate. It includes CA address, type, authentication to CA service, etc.
        :param pulumi.Input['CertificateAuthorityServiceConfigArgs'] certificate_authority_service_config: Defines a CertificateAuthorityServiceConfig.
        """
        if certificate_authority_service_config is not None:
            pulumi.set(__self__, "certificate_authority_service_config", certificate_authority_service_config)

    @property
    @pulumi.getter(name="certificateAuthorityServiceConfig")
    def certificate_authority_service_config(self) -> Optional[pulumi.Input['CertificateAuthorityServiceConfigArgs']]:
        """
        Defines a CertificateAuthorityServiceConfig.
        """
        return pulumi.get(self, "certificate_authority_service_config")

    @certificate_authority_service_config.setter
    def certificate_authority_service_config(self, value: Optional[pulumi.Input['CertificateAuthorityServiceConfigArgs']]):
        pulumi.set(self, "certificate_authority_service_config", value)


@pulumi.input_type
class CertificateAuthorityServiceConfigArgs:
    def __init__(__self__, *,
                 ca_pool: pulumi.Input[str]):
        """
        Contains information required to contact CA service.
        :param pulumi.Input[str] ca_pool: A CA pool resource used to issue a certificate. The CA pool string has a relative resource path following the form "projects/{project}/locations/{location}/caPools/{ca_pool}".
        """
        pulumi.set(__self__, "ca_pool", ca_pool)

    @property
    @pulumi.getter(name="caPool")
    def ca_pool(self) -> pulumi.Input[str]:
        """
        A CA pool resource used to issue a certificate. The CA pool string has a relative resource path following the form "projects/{project}/locations/{location}/caPools/{ca_pool}".
        """
        return pulumi.get(self, "ca_pool")

    @ca_pool.setter
    def ca_pool(self, value: pulumi.Input[str]):
        pulumi.set(self, "ca_pool", value)


@pulumi.input_type
class ManagedCertificateArgs:
    def __init__(__self__, *,
                 dns_authorizations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 issuance_config: Optional[pulumi.Input[str]] = None):
        """
        Configuration and state of a Managed Certificate. Certificate Manager provisions and renews Managed Certificates automatically, for as long as it's authorized to do so.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_authorizations: Immutable. Authorizations that will be used for performing domain authorization.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] domains: Immutable. The domains for which a managed SSL certificate will be generated. Wildcard domains are only supported with DNS challenge resolution.
        :param pulumi.Input[str] issuance_config: Immutable. The resource name for a CertificateIssuanceConfig used to configure private PKI certificates in the format `projects/*/locations/*/certificateIssuanceConfigs/*`. If this field is not set, the certificates will instead be publicly signed as documented at https://cloud.google.com/load-balancing/docs/ssl-certificates/google-managed-certs#caa.
        """
        if dns_authorizations is not None:
            pulumi.set(__self__, "dns_authorizations", dns_authorizations)
        if domains is not None:
            pulumi.set(__self__, "domains", domains)
        if issuance_config is not None:
            pulumi.set(__self__, "issuance_config", issuance_config)

    @property
    @pulumi.getter(name="dnsAuthorizations")
    def dns_authorizations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Immutable. Authorizations that will be used for performing domain authorization.
        """
        return pulumi.get(self, "dns_authorizations")

    @dns_authorizations.setter
    def dns_authorizations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_authorizations", value)

    @property
    @pulumi.getter
    def domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Immutable. The domains for which a managed SSL certificate will be generated. Wildcard domains are only supported with DNS challenge resolution.
        """
        return pulumi.get(self, "domains")

    @domains.setter
    def domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "domains", value)

    @property
    @pulumi.getter(name="issuanceConfig")
    def issuance_config(self) -> Optional[pulumi.Input[str]]:
        """
        Immutable. The resource name for a CertificateIssuanceConfig used to configure private PKI certificates in the format `projects/*/locations/*/certificateIssuanceConfigs/*`. If this field is not set, the certificates will instead be publicly signed as documented at https://cloud.google.com/load-balancing/docs/ssl-certificates/google-managed-certs#caa.
        """
        return pulumi.get(self, "issuance_config")

    @issuance_config.setter
    def issuance_config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issuance_config", value)


@pulumi.input_type
class SelfManagedCertificateArgs:
    def __init__(__self__, *,
                 pem_certificate: Optional[pulumi.Input[str]] = None,
                 pem_private_key: Optional[pulumi.Input[str]] = None):
        """
        Certificate data for a SelfManaged Certificate. SelfManaged Certificates are uploaded by the user. Updating such certificates before they expire remains the user's responsibility.
        :param pulumi.Input[str] pem_certificate: Input only. The PEM-encoded certificate chain. Leaf certificate comes first, followed by intermediate ones if any.
        :param pulumi.Input[str] pem_private_key: Input only. The PEM-encoded private key of the leaf certificate.
        """
        if pem_certificate is not None:
            pulumi.set(__self__, "pem_certificate", pem_certificate)
        if pem_private_key is not None:
            pulumi.set(__self__, "pem_private_key", pem_private_key)

    @property
    @pulumi.getter(name="pemCertificate")
    def pem_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        Input only. The PEM-encoded certificate chain. Leaf certificate comes first, followed by intermediate ones if any.
        """
        return pulumi.get(self, "pem_certificate")

    @pem_certificate.setter
    def pem_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pem_certificate", value)

    @property
    @pulumi.getter(name="pemPrivateKey")
    def pem_private_key(self) -> Optional[pulumi.Input[str]]:
        """
        Input only. The PEM-encoded private key of the leaf certificate.
        """
        return pulumi.get(self, "pem_private_key")

    @pem_private_key.setter
    def pem_private_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pem_private_key", value)


