# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AutoscaleResponse',
    'StatusResponse',
]

@pulumi.output_type
class AutoscaleResponse(dict):
    """
    Auto scaling settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "currentSlots":
            suggest = "current_slots"
        elif key == "maxSlots":
            suggest = "max_slots"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoscaleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoscaleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoscaleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 current_slots: str,
                 max_slots: str):
        """
        Auto scaling settings.
        :param str current_slots: The slot capacity added to this reservation when autoscale happens. Will be between [0, max_slots].
        :param str max_slots: Number of slots to be scaled when needed.
        """
        pulumi.set(__self__, "current_slots", current_slots)
        pulumi.set(__self__, "max_slots", max_slots)

    @property
    @pulumi.getter(name="currentSlots")
    def current_slots(self) -> str:
        """
        The slot capacity added to this reservation when autoscale happens. Will be between [0, max_slots].
        """
        return pulumi.get(self, "current_slots")

    @property
    @pulumi.getter(name="maxSlots")
    def max_slots(self) -> str:
        """
        Number of slots to be scaled when needed.
        """
        return pulumi.get(self, "max_slots")


@pulumi.output_type
class StatusResponse(dict):
    """
    The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
    """
    def __init__(__self__, *,
                 code: int,
                 details: Sequence[Mapping[str, str]],
                 message: str):
        """
        The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
        :param int code: The status code, which should be an enum value of google.rpc.Code.
        :param Sequence[Mapping[str, str]] details: A list of messages that carry the error details. There is a common set of message types for APIs to use.
        :param str message: A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> int:
        """
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Sequence[Mapping[str, str]]:
        """
        A list of messages that carry the error details. There is a common set of message types for APIs to use.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        return pulumi.get(self, "message")


