# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'GetSubscriptionResult',
    'AwaitableGetSubscriptionResult',
    'get_subscription',
    'get_subscription_output',
]

@pulumi.output_type
class GetSubscriptionResult:
    def __init__(__self__, auto_renew_enabled=None, create_time=None, end_time=None, name=None, seat_count=None, sku=None, start_time=None, state=None, type=None):
        if auto_renew_enabled and not isinstance(auto_renew_enabled, bool):
            raise TypeError("Expected argument 'auto_renew_enabled' to be a bool")
        pulumi.set(__self__, "auto_renew_enabled", auto_renew_enabled)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if end_time and not isinstance(end_time, str):
            raise TypeError("Expected argument 'end_time' to be a str")
        pulumi.set(__self__, "end_time", end_time)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if seat_count and not isinstance(seat_count, str):
            raise TypeError("Expected argument 'seat_count' to be a str")
        pulumi.set(__self__, "seat_count", seat_count)
        if sku and not isinstance(sku, str):
            raise TypeError("Expected argument 'sku' to be a str")
        pulumi.set(__self__, "sku", sku)
        if start_time and not isinstance(start_time, str):
            raise TypeError("Expected argument 'start_time' to be a str")
        pulumi.set(__self__, "start_time", start_time)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="autoRenewEnabled")
    def auto_renew_enabled(self) -> bool:
        """
        Represents that, if subscription will renew or end when the term ends.
        """
        return pulumi.get(self, "auto_renew_enabled")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Create time of the subscription.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        End time of the subscription.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Unique resource name of the Subscription. The name is ignored when creating a subscription.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="seatCount")
    def seat_count(self) -> str:
        """
        Number of seats in the subscription.
        """
        return pulumi.get(self, "seat_count")

    @property
    @pulumi.getter
    def sku(self) -> str:
        """
        SKU of subscription.
        """
        return pulumi.get(self, "sku")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Start time of the subscription.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the subscription.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of subscription.
        """
        return pulumi.get(self, "type")


class AwaitableGetSubscriptionResult(GetSubscriptionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSubscriptionResult(
            auto_renew_enabled=self.auto_renew_enabled,
            create_time=self.create_time,
            end_time=self.end_time,
            name=self.name,
            seat_count=self.seat_count,
            sku=self.sku,
            start_time=self.start_time,
            state=self.state,
            type=self.type)


def get_subscription(location: Optional[str] = None,
                     organization_id: Optional[str] = None,
                     subscription_id: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSubscriptionResult:
    """
    Gets details of a single Subscription.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['organizationId'] = organization_id
    __args__['subscriptionId'] = subscription_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:beyondcorp/v1alpha:getSubscription', __args__, opts=opts, typ=GetSubscriptionResult).value

    return AwaitableGetSubscriptionResult(
        auto_renew_enabled=__ret__.auto_renew_enabled,
        create_time=__ret__.create_time,
        end_time=__ret__.end_time,
        name=__ret__.name,
        seat_count=__ret__.seat_count,
        sku=__ret__.sku,
        start_time=__ret__.start_time,
        state=__ret__.state,
        type=__ret__.type)


@_utilities.lift_output_func(get_subscription)
def get_subscription_output(location: Optional[pulumi.Input[str]] = None,
                            organization_id: Optional[pulumi.Input[str]] = None,
                            subscription_id: Optional[pulumi.Input[str]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSubscriptionResult]:
    """
    Gets details of a single Subscription.
    """
    ...
