# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetJobResult',
    'AwaitableGetJobResult',
    'get_job',
    'get_job_output',
]

@pulumi.output_type
class GetJobResult:
    def __init__(__self__, allocation_policy=None, create_time=None, labels=None, logs_policy=None, name=None, notifications=None, priority=None, status=None, task_groups=None, uid=None, update_time=None):
        if allocation_policy and not isinstance(allocation_policy, dict):
            raise TypeError("Expected argument 'allocation_policy' to be a dict")
        pulumi.set(__self__, "allocation_policy", allocation_policy)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if logs_policy and not isinstance(logs_policy, dict):
            raise TypeError("Expected argument 'logs_policy' to be a dict")
        pulumi.set(__self__, "logs_policy", logs_policy)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if notifications and not isinstance(notifications, list):
            raise TypeError("Expected argument 'notifications' to be a list")
        pulumi.set(__self__, "notifications", notifications)
        if priority and not isinstance(priority, str):
            raise TypeError("Expected argument 'priority' to be a str")
        pulumi.set(__self__, "priority", priority)
        if status and not isinstance(status, dict):
            raise TypeError("Expected argument 'status' to be a dict")
        pulumi.set(__self__, "status", status)
        if task_groups and not isinstance(task_groups, list):
            raise TypeError("Expected argument 'task_groups' to be a list")
        pulumi.set(__self__, "task_groups", task_groups)
        if uid and not isinstance(uid, str):
            raise TypeError("Expected argument 'uid' to be a str")
        pulumi.set(__self__, "uid", uid)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="allocationPolicy")
    def allocation_policy(self) -> 'outputs.AllocationPolicyResponse':
        """
        Compute resource allocation for all TaskGroups in the Job.
        """
        return pulumi.get(self, "allocation_policy")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        When the Job was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Labels for the Job. Labels could be user provided or system generated. For example, "labels": { "department": "finance", "environment": "test" } You can assign up to 64 labels. [Google Compute Engine label restrictions](https://cloud.google.com/compute/docs/labeling-resources#restrictions) apply. Label names that start with "goog-" or "google-" are reserved.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="logsPolicy")
    def logs_policy(self) -> 'outputs.LogsPolicyResponse':
        """
        Log preservation policy for the Job.
        """
        return pulumi.get(self, "logs_policy")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Job name. For example: "projects/123456/locations/us-central1/jobs/job01".
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def notifications(self) -> Sequence['outputs.JobNotificationResponse']:
        """
        Notification configurations.
        """
        return pulumi.get(self, "notifications")

    @property
    @pulumi.getter
    def priority(self) -> str:
        """
        Priority of the Job. The valid value range is [0, 100). A job with higher priority value is more likely to run earlier if all other requirements are satisfied.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def status(self) -> 'outputs.JobStatusResponse':
        """
        Job status. It is read only for users.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="taskGroups")
    def task_groups(self) -> Sequence['outputs.TaskGroupResponse']:
        """
        TaskGroups in the Job. Only one TaskGroup is supported now.
        """
        return pulumi.get(self, "task_groups")

    @property
    @pulumi.getter
    def uid(self) -> str:
        """
        A system generated unique ID (in UUID4 format) for the Job.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The last time the Job was updated.
        """
        return pulumi.get(self, "update_time")


class AwaitableGetJobResult(GetJobResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetJobResult(
            allocation_policy=self.allocation_policy,
            create_time=self.create_time,
            labels=self.labels,
            logs_policy=self.logs_policy,
            name=self.name,
            notifications=self.notifications,
            priority=self.priority,
            status=self.status,
            task_groups=self.task_groups,
            uid=self.uid,
            update_time=self.update_time)


def get_job(job_id: Optional[str] = None,
            location: Optional[str] = None,
            project: Optional[str] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetJobResult:
    """
    Get a Job specified by its resource name.
    """
    __args__ = dict()
    __args__['jobId'] = job_id
    __args__['location'] = location
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:batch/v1:getJob', __args__, opts=opts, typ=GetJobResult).value

    return AwaitableGetJobResult(
        allocation_policy=__ret__.allocation_policy,
        create_time=__ret__.create_time,
        labels=__ret__.labels,
        logs_policy=__ret__.logs_policy,
        name=__ret__.name,
        notifications=__ret__.notifications,
        priority=__ret__.priority,
        status=__ret__.status,
        task_groups=__ret__.task_groups,
        uid=__ret__.uid,
        update_time=__ret__.update_time)


@_utilities.lift_output_func(get_job)
def get_job_output(job_id: Optional[pulumi.Input[str]] = None,
                   location: Optional[pulumi.Input[str]] = None,
                   project: Optional[pulumi.Input[Optional[str]]] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetJobResult]:
    """
    Get a Job specified by its resource name.
    """
    ...
