# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AcceleratorArgs',
    'ActionConditionArgs',
    'AllocationPolicyArgs',
    'AttachedDiskArgs',
    'AuditConfigArgs',
    'AuditLogConfigArgs',
    'BarrierArgs',
    'BindingArgs',
    'ComputeResourceArgs',
    'ContainerArgs',
    'DiskArgs',
    'EnvironmentArgs',
    'ExprArgs',
    'GCSArgs',
    'InstancePolicyOrTemplateArgs',
    'InstancePolicyArgs',
    'JobNotificationArgs',
    'KMSEnvMapArgs',
    'LifecyclePolicyArgs',
    'LocationPolicyArgs',
    'LogsPolicyArgs',
    'MessageArgs',
    'NFSArgs',
    'NetworkInterfaceArgs',
    'NetworkPolicyArgs',
    'RunnableArgs',
    'ScriptArgs',
    'ServiceAccountArgs',
    'TaskGroupArgs',
    'TaskSpecArgs',
    'VolumeArgs',
]

@pulumi.input_type
class AcceleratorArgs:
    def __init__(__self__, *,
                 count: Optional[pulumi.Input[str]] = None,
                 install_gpu_drivers: Optional[pulumi.Input[bool]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Accelerator describes Compute Engine accelerators to be attached to the VM.
        :param pulumi.Input[str] count: The number of accelerators of this type.
        :param pulumi.Input[bool] install_gpu_drivers: Deprecated: please use instances[0].install_gpu_drivers instead.
        :param pulumi.Input[str] type: The accelerator type. For example, "nvidia-tesla-t4". See `gcloud compute accelerator-types list`.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if install_gpu_drivers is not None:
            warnings.warn("""Deprecated: please use instances[0].install_gpu_drivers instead.""", DeprecationWarning)
            pulumi.log.warn("""install_gpu_drivers is deprecated: Deprecated: please use instances[0].install_gpu_drivers instead.""")
        if install_gpu_drivers is not None:
            pulumi.set(__self__, "install_gpu_drivers", install_gpu_drivers)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[str]]:
        """
        The number of accelerators of this type.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter(name="installGpuDrivers")
    def install_gpu_drivers(self) -> Optional[pulumi.Input[bool]]:
        """
        Deprecated: please use instances[0].install_gpu_drivers instead.
        """
        return pulumi.get(self, "install_gpu_drivers")

    @install_gpu_drivers.setter
    def install_gpu_drivers(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "install_gpu_drivers", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The accelerator type. For example, "nvidia-tesla-t4". See `gcloud compute accelerator-types list`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ActionConditionArgs:
    def __init__(__self__, *,
                 exit_codes: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None):
        """
        Conditions for actions to deal with task failures.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] exit_codes: Exit codes of a task execution. If there are more than 1 exit codes, when task executes with any of the exit code in the list, the condition is met and the action will be executed.
        """
        if exit_codes is not None:
            pulumi.set(__self__, "exit_codes", exit_codes)

    @property
    @pulumi.getter(name="exitCodes")
    def exit_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        Exit codes of a task execution. If there are more than 1 exit codes, when task executes with any of the exit code in the list, the condition is met and the action will be executed.
        """
        return pulumi.get(self, "exit_codes")

    @exit_codes.setter
    def exit_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "exit_codes", value)


@pulumi.input_type
class AllocationPolicyArgs:
    def __init__(__self__, *,
                 instances: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePolicyOrTemplateArgs']]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input['LocationPolicyArgs']] = None,
                 network: Optional[pulumi.Input['NetworkPolicyArgs']] = None,
                 service_account: Optional[pulumi.Input['ServiceAccountArgs']] = None):
        """
        A Job's resource allocation policy describes when, where, and how compute resources should be allocated for the Job.
        :param pulumi.Input[Sequence[pulumi.Input['InstancePolicyOrTemplateArgs']]] instances: Describe instances that can be created by this AllocationPolicy. Only instances[0] is supported now.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels applied to all VM instances and other resources created by AllocationPolicy. Labels could be user provided or system generated. You can assign up to 64 labels. [Google Compute Engine label restrictions](https://cloud.google.com/compute/docs/labeling-resources#restrictions) apply. Label names that start with "goog-" or "google-" are reserved.
        :param pulumi.Input['LocationPolicyArgs'] location: Location where compute resources should be allocated for the Job.
        :param pulumi.Input['NetworkPolicyArgs'] network: The network policy.
        :param pulumi.Input['ServiceAccountArgs'] service_account: Service account that VMs will run as.
        """
        if instances is not None:
            pulumi.set(__self__, "instances", instances)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)

    @property
    @pulumi.getter
    def instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstancePolicyOrTemplateArgs']]]]:
        """
        Describe instances that can be created by this AllocationPolicy. Only instances[0] is supported now.
        """
        return pulumi.get(self, "instances")

    @instances.setter
    def instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstancePolicyOrTemplateArgs']]]]):
        pulumi.set(self, "instances", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels applied to all VM instances and other resources created by AllocationPolicy. Labels could be user provided or system generated. You can assign up to 64 labels. [Google Compute Engine label restrictions](https://cloud.google.com/compute/docs/labeling-resources#restrictions) apply. Label names that start with "goog-" or "google-" are reserved.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input['LocationPolicyArgs']]:
        """
        Location where compute resources should be allocated for the Job.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input['LocationPolicyArgs']]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input['NetworkPolicyArgs']]:
        """
        The network policy.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input['NetworkPolicyArgs']]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input['ServiceAccountArgs']]:
        """
        Service account that VMs will run as.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input['ServiceAccountArgs']]):
        pulumi.set(self, "service_account", value)


@pulumi.input_type
class AttachedDiskArgs:
    def __init__(__self__, *,
                 device_name: Optional[pulumi.Input[str]] = None,
                 existing_disk: Optional[pulumi.Input[str]] = None,
                 new_disk: Optional[pulumi.Input['DiskArgs']] = None):
        """
        A new or an existing persistent disk (PD) or a local ssd attached to a VM instance.
        :param pulumi.Input[str] device_name: Device name that the guest operating system will see. It is used by Runnable.volumes field to mount disks. So please specify the device_name if you want Batch to help mount the disk, and it should match the device_name field in volumes.
        :param pulumi.Input[str] existing_disk: Name of an existing PD.
        """
        if device_name is not None:
            pulumi.set(__self__, "device_name", device_name)
        if existing_disk is not None:
            pulumi.set(__self__, "existing_disk", existing_disk)
        if new_disk is not None:
            pulumi.set(__self__, "new_disk", new_disk)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> Optional[pulumi.Input[str]]:
        """
        Device name that the guest operating system will see. It is used by Runnable.volumes field to mount disks. So please specify the device_name if you want Batch to help mount the disk, and it should match the device_name field in volumes.
        """
        return pulumi.get(self, "device_name")

    @device_name.setter
    def device_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_name", value)

    @property
    @pulumi.getter(name="existingDisk")
    def existing_disk(self) -> Optional[pulumi.Input[str]]:
        """
        Name of an existing PD.
        """
        return pulumi.get(self, "existing_disk")

    @existing_disk.setter
    def existing_disk(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "existing_disk", value)

    @property
    @pulumi.getter(name="newDisk")
    def new_disk(self) -> Optional[pulumi.Input['DiskArgs']]:
        return pulumi.get(self, "new_disk")

    @new_disk.setter
    def new_disk(self, value: Optional[pulumi.Input['DiskArgs']]):
        pulumi.set(self, "new_disk", value)


@pulumi.input_type
class AuditConfigArgs:
    def __init__(__self__, *,
                 audit_log_configs: Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]] = None,
                 service: Optional[pulumi.Input[str]] = None):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
        :param pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]] audit_log_configs: The configuration for logging of each type of permission.
        :param pulumi.Input[str] service: Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        if audit_log_configs is not None:
            pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]]:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @audit_log_configs.setter
    def audit_log_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]]):
        pulumi.set(self, "audit_log_configs", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service", value)


@pulumi.input_type
class AuditLogConfigArgs:
    def __init__(__self__, *,
                 exempted_members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 log_type: Optional[pulumi.Input['AuditLogConfigLogType']] = None):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param pulumi.Input['AuditLogConfigLogType'] log_type: The log type that this config enables.
        """
        if exempted_members is not None:
            pulumi.set(__self__, "exempted_members", exempted_members)
        if log_type is not None:
            pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @exempted_members.setter
    def exempted_members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exempted_members", value)

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> Optional[pulumi.Input['AuditLogConfigLogType']]:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")

    @log_type.setter
    def log_type(self, value: Optional[pulumi.Input['AuditLogConfigLogType']]):
        pulumi.set(self, "log_type", value)


@pulumi.input_type
class BarrierArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Barrier runnable blocks until all tasks in a taskgroup reach it.
        :param pulumi.Input[str] name: Barriers are identified by their index in runnable list. Names are not required, but if present should be an identifier.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Barriers are identified by their index in runnable list. Names are not required, but if present should be an identifier.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class BindingArgs:
    def __init__(__self__, *,
                 condition: Optional[pulumi.Input['ExprArgs']] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 role: Optional[pulumi.Input[str]] = None):
        """
        Associates `members`, or principals, with a `role`.
        :param pulumi.Input['ExprArgs'] condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] members: Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. Does not include identities that come from external identity providers (IdPs) through identity federation. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a Google service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An identifier for a [Kubernetes service account](https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts). For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding.
        :param pulumi.Input[str] role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['ExprArgs']]:
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['ExprArgs']]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. Does not include identities that come from external identity providers (IdPs) through identity federation. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a Google service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An identifier for a [Kubernetes service account](https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts). For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding.
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)


@pulumi.input_type
class ComputeResourceArgs:
    def __init__(__self__, *,
                 boot_disk_mib: Optional[pulumi.Input[str]] = None,
                 cpu_milli: Optional[pulumi.Input[str]] = None,
                 memory_mib: Optional[pulumi.Input[str]] = None):
        """
        Compute resource requirements
        :param pulumi.Input[str] boot_disk_mib: Extra boot disk size in MiB for each task.
        :param pulumi.Input[str] cpu_milli: The milliCPU count.
        :param pulumi.Input[str] memory_mib: Memory in MiB.
        """
        if boot_disk_mib is not None:
            pulumi.set(__self__, "boot_disk_mib", boot_disk_mib)
        if cpu_milli is not None:
            pulumi.set(__self__, "cpu_milli", cpu_milli)
        if memory_mib is not None:
            pulumi.set(__self__, "memory_mib", memory_mib)

    @property
    @pulumi.getter(name="bootDiskMib")
    def boot_disk_mib(self) -> Optional[pulumi.Input[str]]:
        """
        Extra boot disk size in MiB for each task.
        """
        return pulumi.get(self, "boot_disk_mib")

    @boot_disk_mib.setter
    def boot_disk_mib(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "boot_disk_mib", value)

    @property
    @pulumi.getter(name="cpuMilli")
    def cpu_milli(self) -> Optional[pulumi.Input[str]]:
        """
        The milliCPU count.
        """
        return pulumi.get(self, "cpu_milli")

    @cpu_milli.setter
    def cpu_milli(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpu_milli", value)

    @property
    @pulumi.getter(name="memoryMib")
    def memory_mib(self) -> Optional[pulumi.Input[str]]:
        """
        Memory in MiB.
        """
        return pulumi.get(self, "memory_mib")

    @memory_mib.setter
    def memory_mib(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "memory_mib", value)


@pulumi.input_type
class ContainerArgs:
    def __init__(__self__, *,
                 block_external_network: Optional[pulumi.Input[bool]] = None,
                 commands: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 entrypoint: Optional[pulumi.Input[str]] = None,
                 image_uri: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Container runnable.
        :param pulumi.Input[bool] block_external_network: If set to true, external network access to and from container will be blocked. The container will use the default internal network 'goog-internal'.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] commands: Overrides the `CMD` specified in the container. If there is an ENTRYPOINT (either in the container image or with the entrypoint field below) then commands are appended as arguments to the ENTRYPOINT.
        :param pulumi.Input[str] entrypoint: Overrides the `ENTRYPOINT` specified in the container.
        :param pulumi.Input[str] image_uri: The URI to pull the container image from.
        :param pulumi.Input[str] options: Arbitrary additional options to include in the "docker run" command when running this container, e.g. "--network host".
        :param pulumi.Input[str] password: Optional password for logging in to a docker registry. If password matches `projects/*/secrets/*/versions/*` then Batch will read the password from the Secret Manager;
        :param pulumi.Input[str] username: Optional username for logging in to a docker registry. If username matches `projects/*/secrets/*/versions/*` then Batch will read the username from the Secret Manager.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] volumes: Volumes to mount (bind mount) from the host machine files or directories into the container, formatted to match docker run's --volume option, e.g. /foo:/bar, or /foo:/bar:ro
        """
        if block_external_network is not None:
            pulumi.set(__self__, "block_external_network", block_external_network)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if entrypoint is not None:
            pulumi.set(__self__, "entrypoint", entrypoint)
        if image_uri is not None:
            pulumi.set(__self__, "image_uri", image_uri)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter(name="blockExternalNetwork")
    def block_external_network(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to true, external network access to and from container will be blocked. The container will use the default internal network 'goog-internal'.
        """
        return pulumi.get(self, "block_external_network")

    @block_external_network.setter
    def block_external_network(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "block_external_network", value)

    @property
    @pulumi.getter
    def commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Overrides the `CMD` specified in the container. If there is an ENTRYPOINT (either in the container image or with the entrypoint field below) then commands are appended as arguments to the ENTRYPOINT.
        """
        return pulumi.get(self, "commands")

    @commands.setter
    def commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "commands", value)

    @property
    @pulumi.getter
    def entrypoint(self) -> Optional[pulumi.Input[str]]:
        """
        Overrides the `ENTRYPOINT` specified in the container.
        """
        return pulumi.get(self, "entrypoint")

    @entrypoint.setter
    def entrypoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entrypoint", value)

    @property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The URI to pull the container image from.
        """
        return pulumi.get(self, "image_uri")

    @image_uri.setter
    def image_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_uri", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[str]]:
        """
        Arbitrary additional options to include in the "docker run" command when running this container, e.g. "--network host".
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Optional password for logging in to a docker registry. If password matches `projects/*/secrets/*/versions/*` then Batch will read the password from the Secret Manager;
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Optional username for logging in to a docker registry. If username matches `projects/*/secrets/*/versions/*` then Batch will read the username from the Secret Manager.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Volumes to mount (bind mount) from the host machine files or directories into the container, formatted to match docker run's --volume option, e.g. /foo:/bar, or /foo:/bar:ro
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "volumes", value)


@pulumi.input_type
class DiskArgs:
    def __init__(__self__, *,
                 disk_interface: Optional[pulumi.Input[str]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 size_gb: Optional[pulumi.Input[str]] = None,
                 snapshot: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        A new persistent disk or a local ssd. A VM can only have one local SSD setting but multiple local SSD partitions. https://cloud.google.com/compute/docs/disks#pdspecs. https://cloud.google.com/compute/docs/disks#localssds.
        :param pulumi.Input[str] disk_interface: Local SSDs are available through both "SCSI" and "NVMe" interfaces. If not indicated, "NVMe" will be the default one for local ssds. We only support "SCSI" for persistent disks now.
        :param pulumi.Input[str] image: Name of a public or custom image used as the data source. For example, the following are all valid URLs: (1) Specify the image by its family name: projects/{project}/global/images/family/{image_family} (2) Specify the image version: projects/{project}/global/images/{image_version} You can also use Batch customized image in short names. The following image values are supported for a boot disk: "batch-debian": use Batch Debian images. "batch-centos": use Batch CentOS images. "batch-cos": use Batch Container-Optimized images.
        :param pulumi.Input[str] size_gb: Disk size in GB. For persistent disk, this field is ignored if `data_source` is `image` or `snapshot`. For local SSD, size_gb should be a multiple of 375GB, otherwise, the final size will be the next greater multiple of 375 GB. For boot disk, Batch will calculate the boot disk size based on source image and task requirements if you do not speicify the size. If both this field and the boot_disk_mib field in task spec's compute_resource are defined, Batch will only honor this field.
        :param pulumi.Input[str] snapshot: Name of a snapshot used as the data source.
        :param pulumi.Input[str] type: Disk type as shown in `gcloud compute disk-types list`. For example, local SSD uses type "local-ssd". Persistent disks and boot disks use "pd-balanced", "pd-extreme", "pd-ssd" or "pd-standard".
        """
        if disk_interface is not None:
            pulumi.set(__self__, "disk_interface", disk_interface)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if size_gb is not None:
            pulumi.set(__self__, "size_gb", size_gb)
        if snapshot is not None:
            pulumi.set(__self__, "snapshot", snapshot)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="diskInterface")
    def disk_interface(self) -> Optional[pulumi.Input[str]]:
        """
        Local SSDs are available through both "SCSI" and "NVMe" interfaces. If not indicated, "NVMe" will be the default one for local ssds. We only support "SCSI" for persistent disks now.
        """
        return pulumi.get(self, "disk_interface")

    @disk_interface.setter
    def disk_interface(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_interface", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[str]]:
        """
        Name of a public or custom image used as the data source. For example, the following are all valid URLs: (1) Specify the image by its family name: projects/{project}/global/images/family/{image_family} (2) Specify the image version: projects/{project}/global/images/{image_version} You can also use Batch customized image in short names. The following image values are supported for a boot disk: "batch-debian": use Batch Debian images. "batch-centos": use Batch CentOS images. "batch-cos": use Batch Container-Optimized images.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="sizeGb")
    def size_gb(self) -> Optional[pulumi.Input[str]]:
        """
        Disk size in GB. For persistent disk, this field is ignored if `data_source` is `image` or `snapshot`. For local SSD, size_gb should be a multiple of 375GB, otherwise, the final size will be the next greater multiple of 375 GB. For boot disk, Batch will calculate the boot disk size based on source image and task requirements if you do not speicify the size. If both this field and the boot_disk_mib field in task spec's compute_resource are defined, Batch will only honor this field.
        """
        return pulumi.get(self, "size_gb")

    @size_gb.setter
    def size_gb(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "size_gb", value)

    @property
    @pulumi.getter
    def snapshot(self) -> Optional[pulumi.Input[str]]:
        """
        Name of a snapshot used as the data source.
        """
        return pulumi.get(self, "snapshot")

    @snapshot.setter
    def snapshot(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Disk type as shown in `gcloud compute disk-types list`. For example, local SSD uses type "local-ssd". Persistent disks and boot disks use "pd-balanced", "pd-extreme", "pd-ssd" or "pd-standard".
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class EnvironmentArgs:
    def __init__(__self__, *,
                 encrypted_variables: Optional[pulumi.Input['KMSEnvMapArgs']] = None,
                 secret_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        An Environment describes a collection of environment variables to set when executing Tasks.
        :param pulumi.Input['KMSEnvMapArgs'] encrypted_variables: An encrypted JSON dictionary where the key/value pairs correspond to environment variable names and their values.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] secret_variables: A map of environment variable names to Secret Manager secret names. The VM will access the named secrets to set the value of each environment variable.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] variables: A map of environment variable names to values.
        """
        if encrypted_variables is not None:
            pulumi.set(__self__, "encrypted_variables", encrypted_variables)
        if secret_variables is not None:
            pulumi.set(__self__, "secret_variables", secret_variables)
        if variables is not None:
            pulumi.set(__self__, "variables", variables)

    @property
    @pulumi.getter(name="encryptedVariables")
    def encrypted_variables(self) -> Optional[pulumi.Input['KMSEnvMapArgs']]:
        """
        An encrypted JSON dictionary where the key/value pairs correspond to environment variable names and their values.
        """
        return pulumi.get(self, "encrypted_variables")

    @encrypted_variables.setter
    def encrypted_variables(self, value: Optional[pulumi.Input['KMSEnvMapArgs']]):
        pulumi.set(self, "encrypted_variables", value)

    @property
    @pulumi.getter(name="secretVariables")
    def secret_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of environment variable names to Secret Manager secret names. The VM will access the named secrets to set the value of each environment variable.
        """
        return pulumi.get(self, "secret_variables")

    @secret_variables.setter
    def secret_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "secret_variables", value)

    @property
    @pulumi.getter
    def variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of environment variable names to values.
        """
        return pulumi.get(self, "variables")

    @variables.setter
    def variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "variables", value)


@pulumi.input_type
class ExprArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param pulumi.Input[str] description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param pulumi.Input[str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[str] location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param pulumi.Input[str] title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class GCSArgs:
    def __init__(__self__, *,
                 remote_path: Optional[pulumi.Input[str]] = None):
        """
        Represents a Google Cloud Storage volume.
        :param pulumi.Input[str] remote_path: Remote path, either a bucket name or a subdirectory of a bucket, e.g.: bucket_name, bucket_name/subdirectory/
        """
        if remote_path is not None:
            pulumi.set(__self__, "remote_path", remote_path)

    @property
    @pulumi.getter(name="remotePath")
    def remote_path(self) -> Optional[pulumi.Input[str]]:
        """
        Remote path, either a bucket name or a subdirectory of a bucket, e.g.: bucket_name, bucket_name/subdirectory/
        """
        return pulumi.get(self, "remote_path")

    @remote_path.setter
    def remote_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_path", value)


@pulumi.input_type
class InstancePolicyOrTemplateArgs:
    def __init__(__self__, *,
                 install_gpu_drivers: Optional[pulumi.Input[bool]] = None,
                 instance_template: Optional[pulumi.Input[str]] = None,
                 policy: Optional[pulumi.Input['InstancePolicyArgs']] = None):
        """
        Either an InstancePolicy or an instance template.
        :param pulumi.Input[bool] install_gpu_drivers: Set this field true if users want Batch to help fetch drivers from a third party location and install them for GPUs specified in policy.accelerators or instance_template on their behalf. Default is false.
        :param pulumi.Input[str] instance_template: Name of an instance template used to create VMs. Named the field as 'instance_template' instead of 'template' to avoid c++ keyword conflict.
        :param pulumi.Input['InstancePolicyArgs'] policy: InstancePolicy.
        """
        if install_gpu_drivers is not None:
            pulumi.set(__self__, "install_gpu_drivers", install_gpu_drivers)
        if instance_template is not None:
            pulumi.set(__self__, "instance_template", instance_template)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)

    @property
    @pulumi.getter(name="installGpuDrivers")
    def install_gpu_drivers(self) -> Optional[pulumi.Input[bool]]:
        """
        Set this field true if users want Batch to help fetch drivers from a third party location and install them for GPUs specified in policy.accelerators or instance_template on their behalf. Default is false.
        """
        return pulumi.get(self, "install_gpu_drivers")

    @install_gpu_drivers.setter
    def install_gpu_drivers(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "install_gpu_drivers", value)

    @property
    @pulumi.getter(name="instanceTemplate")
    def instance_template(self) -> Optional[pulumi.Input[str]]:
        """
        Name of an instance template used to create VMs. Named the field as 'instance_template' instead of 'template' to avoid c++ keyword conflict.
        """
        return pulumi.get(self, "instance_template")

    @instance_template.setter
    def instance_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_template", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input['InstancePolicyArgs']]:
        """
        InstancePolicy.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input['InstancePolicyArgs']]):
        pulumi.set(self, "policy", value)


@pulumi.input_type
class InstancePolicyArgs:
    def __init__(__self__, *,
                 accelerators: Optional[pulumi.Input[Sequence[pulumi.Input['AcceleratorArgs']]]] = None,
                 boot_disk: Optional[pulumi.Input['DiskArgs']] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input['AttachedDiskArgs']]]] = None,
                 machine_type: Optional[pulumi.Input[str]] = None,
                 min_cpu_platform: Optional[pulumi.Input[str]] = None,
                 provisioning_model: Optional[pulumi.Input['InstancePolicyProvisioningModel']] = None):
        """
        InstancePolicy describes an instance type and resources attached to each VM created by this InstancePolicy.
        :param pulumi.Input[Sequence[pulumi.Input['AcceleratorArgs']]] accelerators: The accelerators attached to each VM instance.
        :param pulumi.Input['DiskArgs'] boot_disk: Book disk to be created and attached to each VM by this InstancePolicy. Boot disk will be deleted when the VM is deleted.
        :param pulumi.Input[Sequence[pulumi.Input['AttachedDiskArgs']]] disks: Non-boot disks to be attached for each VM created by this InstancePolicy. New disks will be deleted when the VM is deleted.
        :param pulumi.Input[str] machine_type: The Compute Engine machine type.
        :param pulumi.Input[str] min_cpu_platform: The minimum CPU platform. See `https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform`. Not yet implemented.
        :param pulumi.Input['InstancePolicyProvisioningModel'] provisioning_model: The provisioning model.
        """
        if accelerators is not None:
            pulumi.set(__self__, "accelerators", accelerators)
        if boot_disk is not None:
            pulumi.set(__self__, "boot_disk", boot_disk)
        if disks is not None:
            pulumi.set(__self__, "disks", disks)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if min_cpu_platform is not None:
            pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        if provisioning_model is not None:
            pulumi.set(__self__, "provisioning_model", provisioning_model)

    @property
    @pulumi.getter
    def accelerators(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AcceleratorArgs']]]]:
        """
        The accelerators attached to each VM instance.
        """
        return pulumi.get(self, "accelerators")

    @accelerators.setter
    def accelerators(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AcceleratorArgs']]]]):
        pulumi.set(self, "accelerators", value)

    @property
    @pulumi.getter(name="bootDisk")
    def boot_disk(self) -> Optional[pulumi.Input['DiskArgs']]:
        """
        Book disk to be created and attached to each VM by this InstancePolicy. Boot disk will be deleted when the VM is deleted.
        """
        return pulumi.get(self, "boot_disk")

    @boot_disk.setter
    def boot_disk(self, value: Optional[pulumi.Input['DiskArgs']]):
        pulumi.set(self, "boot_disk", value)

    @property
    @pulumi.getter
    def disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AttachedDiskArgs']]]]:
        """
        Non-boot disks to be attached for each VM created by this InstancePolicy. New disks will be deleted when the VM is deleted.
        """
        return pulumi.get(self, "disks")

    @disks.setter
    def disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AttachedDiskArgs']]]]):
        pulumi.set(self, "disks", value)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[str]]:
        """
        The Compute Engine machine type.
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_type", value)

    @property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> Optional[pulumi.Input[str]]:
        """
        The minimum CPU platform. See `https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform`. Not yet implemented.
        """
        return pulumi.get(self, "min_cpu_platform")

    @min_cpu_platform.setter
    def min_cpu_platform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_cpu_platform", value)

    @property
    @pulumi.getter(name="provisioningModel")
    def provisioning_model(self) -> Optional[pulumi.Input['InstancePolicyProvisioningModel']]:
        """
        The provisioning model.
        """
        return pulumi.get(self, "provisioning_model")

    @provisioning_model.setter
    def provisioning_model(self, value: Optional[pulumi.Input['InstancePolicyProvisioningModel']]):
        pulumi.set(self, "provisioning_model", value)


@pulumi.input_type
class JobNotificationArgs:
    def __init__(__self__, *,
                 message: Optional[pulumi.Input['MessageArgs']] = None,
                 pubsub_topic: Optional[pulumi.Input[str]] = None):
        """
        Notification configurations.
        :param pulumi.Input['MessageArgs'] message: The attribute requirements of messages to be sent to this Pub/Sub topic. Without this field, no message will be sent.
        :param pulumi.Input[str] pubsub_topic: The Pub/Sub topic where notifications like the job state changes will be published. This topic exist in the same project as the job and billings will be charged to this project. If not specified, no Pub/Sub messages will be sent. Topic format: `projects/{project}/topics/{topic}`.
        """
        if message is not None:
            pulumi.set(__self__, "message", message)
        if pubsub_topic is not None:
            pulumi.set(__self__, "pubsub_topic", pubsub_topic)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input['MessageArgs']]:
        """
        The attribute requirements of messages to be sent to this Pub/Sub topic. Without this field, no message will be sent.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input['MessageArgs']]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter(name="pubsubTopic")
    def pubsub_topic(self) -> Optional[pulumi.Input[str]]:
        """
        The Pub/Sub topic where notifications like the job state changes will be published. This topic exist in the same project as the job and billings will be charged to this project. If not specified, no Pub/Sub messages will be sent. Topic format: `projects/{project}/topics/{topic}`.
        """
        return pulumi.get(self, "pubsub_topic")

    @pubsub_topic.setter
    def pubsub_topic(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pubsub_topic", value)


@pulumi.input_type
class KMSEnvMapArgs:
    def __init__(__self__, *,
                 cipher_text: Optional[pulumi.Input[str]] = None,
                 key_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] cipher_text: The value of the cipherText response from the `encrypt` method.
        :param pulumi.Input[str] key_name: The name of the KMS key that will be used to decrypt the cipher text.
        """
        if cipher_text is not None:
            pulumi.set(__self__, "cipher_text", cipher_text)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)

    @property
    @pulumi.getter(name="cipherText")
    def cipher_text(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the cipherText response from the `encrypt` method.
        """
        return pulumi.get(self, "cipher_text")

    @cipher_text.setter
    def cipher_text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cipher_text", value)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the KMS key that will be used to decrypt the cipher text.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_name", value)


@pulumi.input_type
class LifecyclePolicyArgs:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input['LifecyclePolicyAction']] = None,
                 action_condition: Optional[pulumi.Input['ActionConditionArgs']] = None):
        """
        LifecyclePolicy describes how to deal with task failures based on different conditions.
        :param pulumi.Input['LifecyclePolicyAction'] action: Action to execute when ActionCondition is true.
        :param pulumi.Input['ActionConditionArgs'] action_condition: Conditions that decide why a task failure is dealt with a specific action.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if action_condition is not None:
            pulumi.set(__self__, "action_condition", action_condition)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input['LifecyclePolicyAction']]:
        """
        Action to execute when ActionCondition is true.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input['LifecyclePolicyAction']]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="actionCondition")
    def action_condition(self) -> Optional[pulumi.Input['ActionConditionArgs']]:
        """
        Conditions that decide why a task failure is dealt with a specific action.
        """
        return pulumi.get(self, "action_condition")

    @action_condition.setter
    def action_condition(self, value: Optional[pulumi.Input['ActionConditionArgs']]):
        pulumi.set(self, "action_condition", value)


@pulumi.input_type
class LocationPolicyArgs:
    def __init__(__self__, *,
                 allowed_locations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_locations: A list of allowed location names represented by internal URLs. Each location can be a region or a zone. Only one region or multiple zones in one region is supported now. For example, ["regions/us-central1"] allow VMs in any zones in region us-central1. ["zones/us-central1-a", "zones/us-central1-c"] only allow VMs in zones us-central1-a and us-central1-c. All locations end up in different regions would cause errors. For example, ["regions/us-central1", "zones/us-central1-a", "zones/us-central1-b", "zones/us-west1-a"] contains 2 regions "us-central1" and "us-west1". An error is expected in this case.
        """
        if allowed_locations is not None:
            pulumi.set(__self__, "allowed_locations", allowed_locations)

    @property
    @pulumi.getter(name="allowedLocations")
    def allowed_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of allowed location names represented by internal URLs. Each location can be a region or a zone. Only one region or multiple zones in one region is supported now. For example, ["regions/us-central1"] allow VMs in any zones in region us-central1. ["zones/us-central1-a", "zones/us-central1-c"] only allow VMs in zones us-central1-a and us-central1-c. All locations end up in different regions would cause errors. For example, ["regions/us-central1", "zones/us-central1-a", "zones/us-central1-b", "zones/us-west1-a"] contains 2 regions "us-central1" and "us-west1". An error is expected in this case.
        """
        return pulumi.get(self, "allowed_locations")

    @allowed_locations.setter
    def allowed_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_locations", value)


@pulumi.input_type
class LogsPolicyArgs:
    def __init__(__self__, *,
                 destination: Optional[pulumi.Input['LogsPolicyDestination']] = None,
                 logs_path: Optional[pulumi.Input[str]] = None):
        """
        LogsPolicy describes how outputs from a Job's Tasks (stdout/stderr) will be preserved.
        :param pulumi.Input['LogsPolicyDestination'] destination: Where logs should be saved.
        :param pulumi.Input[str] logs_path: The path to which logs are saved when the destination = PATH. This can be a local file path on the VM, or under the mount point of a Persistent Disk or Filestore, or a Cloud Storage path.
        """
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if logs_path is not None:
            pulumi.set(__self__, "logs_path", logs_path)

    @property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input['LogsPolicyDestination']]:
        """
        Where logs should be saved.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input['LogsPolicyDestination']]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter(name="logsPath")
    def logs_path(self) -> Optional[pulumi.Input[str]]:
        """
        The path to which logs are saved when the destination = PATH. This can be a local file path on the VM, or under the mount point of a Persistent Disk or Filestore, or a Cloud Storage path.
        """
        return pulumi.get(self, "logs_path")

    @logs_path.setter
    def logs_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logs_path", value)


@pulumi.input_type
class MessageArgs:
    def __init__(__self__, *,
                 new_job_state: Optional[pulumi.Input['MessageNewJobState']] = None,
                 new_task_state: Optional[pulumi.Input['MessageNewTaskState']] = None,
                 type: Optional[pulumi.Input['MessageType']] = None):
        """
        Message details. Describe the attribute that a message should have. Without specified message attributes, no message will be sent by default.
        :param pulumi.Input['MessageNewJobState'] new_job_state: The new job state.
        :param pulumi.Input['MessageNewTaskState'] new_task_state: The new task state.
        :param pulumi.Input['MessageType'] type: The message type.
        """
        if new_job_state is not None:
            pulumi.set(__self__, "new_job_state", new_job_state)
        if new_task_state is not None:
            pulumi.set(__self__, "new_task_state", new_task_state)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="newJobState")
    def new_job_state(self) -> Optional[pulumi.Input['MessageNewJobState']]:
        """
        The new job state.
        """
        return pulumi.get(self, "new_job_state")

    @new_job_state.setter
    def new_job_state(self, value: Optional[pulumi.Input['MessageNewJobState']]):
        pulumi.set(self, "new_job_state", value)

    @property
    @pulumi.getter(name="newTaskState")
    def new_task_state(self) -> Optional[pulumi.Input['MessageNewTaskState']]:
        """
        The new task state.
        """
        return pulumi.get(self, "new_task_state")

    @new_task_state.setter
    def new_task_state(self, value: Optional[pulumi.Input['MessageNewTaskState']]):
        pulumi.set(self, "new_task_state", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['MessageType']]:
        """
        The message type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['MessageType']]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class NFSArgs:
    def __init__(__self__, *,
                 remote_path: Optional[pulumi.Input[str]] = None,
                 server: Optional[pulumi.Input[str]] = None):
        """
        Represents an NFS volume.
        :param pulumi.Input[str] remote_path: Remote source path exported from the NFS, e.g., "/share".
        :param pulumi.Input[str] server: The IP address of the NFS.
        """
        if remote_path is not None:
            pulumi.set(__self__, "remote_path", remote_path)
        if server is not None:
            pulumi.set(__self__, "server", server)

    @property
    @pulumi.getter(name="remotePath")
    def remote_path(self) -> Optional[pulumi.Input[str]]:
        """
        Remote source path exported from the NFS, e.g., "/share".
        """
        return pulumi.get(self, "remote_path")

    @remote_path.setter
    def remote_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_path", value)

    @property
    @pulumi.getter
    def server(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address of the NFS.
        """
        return pulumi.get(self, "server")

    @server.setter
    def server(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server", value)


@pulumi.input_type
class NetworkInterfaceArgs:
    def __init__(__self__, *,
                 network: Optional[pulumi.Input[str]] = None,
                 no_external_ip_address: Optional[pulumi.Input[bool]] = None,
                 subnetwork: Optional[pulumi.Input[str]] = None):
        """
        A network interface.
        :param pulumi.Input[str] network: The URL of an existing network resource. You can specify the network as a full or partial URL. For example, the following are all valid URLs: https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network} projects/{project}/global/networks/{network} global/networks/{network}
        :param pulumi.Input[bool] no_external_ip_address: Default is false (with an external IP address). Required if no external public IP address is attached to the VM. If no external public IP address, additional configuration is required to allow the VM to access Google Services. See https://cloud.google.com/vpc/docs/configure-private-google-access and https://cloud.google.com/nat/docs/gce-example#create-nat for more information.
        :param pulumi.Input[str] subnetwork: The URL of an existing subnetwork resource in the network. You can specify the subnetwork as a full or partial URL. For example, the following are all valid URLs: https://www.googleapis.com/compute/v1/projects/{project}/regions/{region}/subnetworks/{subnetwork} projects/{project}/regions/{region}/subnetworks/{subnetwork} regions/{region}/subnetworks/{subnetwork}
        """
        if network is not None:
            pulumi.set(__self__, "network", network)
        if no_external_ip_address is not None:
            pulumi.set(__self__, "no_external_ip_address", no_external_ip_address)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of an existing network resource. You can specify the network as a full or partial URL. For example, the following are all valid URLs: https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network} projects/{project}/global/networks/{network} global/networks/{network}
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="noExternalIpAddress")
    def no_external_ip_address(self) -> Optional[pulumi.Input[bool]]:
        """
        Default is false (with an external IP address). Required if no external public IP address is attached to the VM. If no external public IP address, additional configuration is required to allow the VM to access Google Services. See https://cloud.google.com/vpc/docs/configure-private-google-access and https://cloud.google.com/nat/docs/gce-example#create-nat for more information.
        """
        return pulumi.get(self, "no_external_ip_address")

    @no_external_ip_address.setter
    def no_external_ip_address(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "no_external_ip_address", value)

    @property
    @pulumi.getter
    def subnetwork(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of an existing subnetwork resource in the network. You can specify the subnetwork as a full or partial URL. For example, the following are all valid URLs: https://www.googleapis.com/compute/v1/projects/{project}/regions/{region}/subnetworks/{subnetwork} projects/{project}/regions/{region}/subnetworks/{subnetwork} regions/{region}/subnetworks/{subnetwork}
        """
        return pulumi.get(self, "subnetwork")

    @subnetwork.setter
    def subnetwork(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnetwork", value)


@pulumi.input_type
class NetworkPolicyArgs:
    def __init__(__self__, *,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceArgs']]]] = None):
        """
        NetworkPolicy describes VM instance network configurations.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceArgs']]] network_interfaces: Network configurations.
        """
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceArgs']]]]:
        """
        Network configurations.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)


@pulumi.input_type
class RunnableArgs:
    def __init__(__self__, *,
                 always_run: Optional[pulumi.Input[bool]] = None,
                 background: Optional[pulumi.Input[bool]] = None,
                 barrier: Optional[pulumi.Input['BarrierArgs']] = None,
                 container: Optional[pulumi.Input['ContainerArgs']] = None,
                 environment: Optional[pulumi.Input['EnvironmentArgs']] = None,
                 ignore_exit_status: Optional[pulumi.Input[bool]] = None,
                 script: Optional[pulumi.Input['ScriptArgs']] = None,
                 timeout: Optional[pulumi.Input[str]] = None):
        """
        Runnable describes instructions for executing a specific script or container as part of a Task.
        :param pulumi.Input[bool] always_run: By default, after a Runnable fails, no further Runnable are executed. This flag indicates that this Runnable must be run even if the Task has already failed. This is useful for Runnables that copy output files off of the VM or for debugging. The always_run flag does not override the Task's overall max_run_duration. If the max_run_duration has expired then no further Runnables will execute, not even always_run Runnables.
        :param pulumi.Input[bool] background: This flag allows a Runnable to continue running in the background while the Task executes subsequent Runnables. This is useful to provide services to other Runnables (or to provide debugging support tools like SSH servers).
        :param pulumi.Input['BarrierArgs'] barrier: Barrier runnable.
        :param pulumi.Input['ContainerArgs'] container: Container runnable.
        :param pulumi.Input['EnvironmentArgs'] environment: Environment variables for this Runnable (overrides variables set for the whole Task or TaskGroup).
        :param pulumi.Input[bool] ignore_exit_status: Normally, a non-zero exit status causes the Task to fail. This flag allows execution of other Runnables to continue instead.
        :param pulumi.Input['ScriptArgs'] script: Script runnable.
        :param pulumi.Input[str] timeout: Timeout for this Runnable.
        """
        if always_run is not None:
            pulumi.set(__self__, "always_run", always_run)
        if background is not None:
            pulumi.set(__self__, "background", background)
        if barrier is not None:
            pulumi.set(__self__, "barrier", barrier)
        if container is not None:
            pulumi.set(__self__, "container", container)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if ignore_exit_status is not None:
            pulumi.set(__self__, "ignore_exit_status", ignore_exit_status)
        if script is not None:
            pulumi.set(__self__, "script", script)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="alwaysRun")
    def always_run(self) -> Optional[pulumi.Input[bool]]:
        """
        By default, after a Runnable fails, no further Runnable are executed. This flag indicates that this Runnable must be run even if the Task has already failed. This is useful for Runnables that copy output files off of the VM or for debugging. The always_run flag does not override the Task's overall max_run_duration. If the max_run_duration has expired then no further Runnables will execute, not even always_run Runnables.
        """
        return pulumi.get(self, "always_run")

    @always_run.setter
    def always_run(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "always_run", value)

    @property
    @pulumi.getter
    def background(self) -> Optional[pulumi.Input[bool]]:
        """
        This flag allows a Runnable to continue running in the background while the Task executes subsequent Runnables. This is useful to provide services to other Runnables (or to provide debugging support tools like SSH servers).
        """
        return pulumi.get(self, "background")

    @background.setter
    def background(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "background", value)

    @property
    @pulumi.getter
    def barrier(self) -> Optional[pulumi.Input['BarrierArgs']]:
        """
        Barrier runnable.
        """
        return pulumi.get(self, "barrier")

    @barrier.setter
    def barrier(self, value: Optional[pulumi.Input['BarrierArgs']]):
        pulumi.set(self, "barrier", value)

    @property
    @pulumi.getter
    def container(self) -> Optional[pulumi.Input['ContainerArgs']]:
        """
        Container runnable.
        """
        return pulumi.get(self, "container")

    @container.setter
    def container(self, value: Optional[pulumi.Input['ContainerArgs']]):
        pulumi.set(self, "container", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input['EnvironmentArgs']]:
        """
        Environment variables for this Runnable (overrides variables set for the whole Task or TaskGroup).
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input['EnvironmentArgs']]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter(name="ignoreExitStatus")
    def ignore_exit_status(self) -> Optional[pulumi.Input[bool]]:
        """
        Normally, a non-zero exit status causes the Task to fail. This flag allows execution of other Runnables to continue instead.
        """
        return pulumi.get(self, "ignore_exit_status")

    @ignore_exit_status.setter
    def ignore_exit_status(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_exit_status", value)

    @property
    @pulumi.getter
    def script(self) -> Optional[pulumi.Input['ScriptArgs']]:
        """
        Script runnable.
        """
        return pulumi.get(self, "script")

    @script.setter
    def script(self, value: Optional[pulumi.Input['ScriptArgs']]):
        pulumi.set(self, "script", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[str]]:
        """
        Timeout for this Runnable.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class ScriptArgs:
    def __init__(__self__, *,
                 path: Optional[pulumi.Input[str]] = None,
                 text: Optional[pulumi.Input[str]] = None):
        """
        Script runnable.
        :param pulumi.Input[str] path: Script file path on the host VM. To specify an interpreter, please add a `#!`(also known as [shebang line](https://en.wikipedia.org/wiki/Shebang_(Unix))) as the first line of the file.(For example, to execute the script using bash, `#!/bin/bash` should be the first line of the file. To execute the script using`Python3`, `#!/usr/bin/env python3` should be the first line of the file.) Otherwise, the file will by default be excuted by `/bin/sh`.
        :param pulumi.Input[str] text: Shell script text. To specify an interpreter, please add a `#!\\n` at the beginning of the text.(For example, to execute the script using bash, `#!/bin/bash\\n` should be added. To execute the script using`Python3`, `#!/usr/bin/env python3\\n` should be added.) Otherwise, the script will by default be excuted by `/bin/sh`.
        """
        if path is not None:
            pulumi.set(__self__, "path", path)
        if text is not None:
            pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Script file path on the host VM. To specify an interpreter, please add a `#!`(also known as [shebang line](https://en.wikipedia.org/wiki/Shebang_(Unix))) as the first line of the file.(For example, to execute the script using bash, `#!/bin/bash` should be the first line of the file. To execute the script using`Python3`, `#!/usr/bin/env python3` should be the first line of the file.) Otherwise, the file will by default be excuted by `/bin/sh`.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def text(self) -> Optional[pulumi.Input[str]]:
        """
        Shell script text. To specify an interpreter, please add a `#!\\n` at the beginning of the text.(For example, to execute the script using bash, `#!/bin/bash\\n` should be added. To execute the script using`Python3`, `#!/usr/bin/env python3\\n` should be added.) Otherwise, the script will by default be excuted by `/bin/sh`.
        """
        return pulumi.get(self, "text")

    @text.setter
    def text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "text", value)


@pulumi.input_type
class ServiceAccountArgs:
    def __init__(__self__, *,
                 email: Optional[pulumi.Input[str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Carries information about a Google Cloud service account.
        :param pulumi.Input[str] email: Email address of the service account. If not specified, the default Compute Engine service account for the project will be used. If instance template is being used, the service account has to be specified in the instance template and it has to match the email field here.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scopes: List of scopes to be enabled for this service account on the VM, in addition to the cloud-platform API scope that will be added by default.
        """
        if email is not None:
            pulumi.set(__self__, "email", email)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        Email address of the service account. If not specified, the default Compute Engine service account for the project will be used. If instance template is being used, the service account has to be specified in the instance template and it has to match the email field here.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of scopes to be enabled for this service account on the VM, in addition to the cloud-platform API scope that will be added by default.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "scopes", value)


@pulumi.input_type
class TaskGroupArgs:
    def __init__(__self__, *,
                 task_spec: pulumi.Input['TaskSpecArgs'],
                 parallelism: Optional[pulumi.Input[str]] = None,
                 permissive_ssh: Optional[pulumi.Input[bool]] = None,
                 require_hosts_file: Optional[pulumi.Input[bool]] = None,
                 task_count: Optional[pulumi.Input[str]] = None,
                 task_count_per_node: Optional[pulumi.Input[str]] = None,
                 task_environments: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentArgs']]]] = None):
        """
        A TaskGroup contains one or multiple Tasks that share the same Runnable but with different runtime parameters.
        :param pulumi.Input['TaskSpecArgs'] task_spec: Tasks in the group share the same task spec.
        :param pulumi.Input[str] parallelism: Max number of tasks that can run in parallel. Default to min(task_count, 1000).
        :param pulumi.Input[bool] permissive_ssh: When true, Batch will configure SSH to allow passwordless login between VMs running the Batch tasks in the same TaskGroup.
        :param pulumi.Input[bool] require_hosts_file: When true, Batch will populate a file with a list of all VMs assigned to the TaskGroup and set the BATCH_HOSTS_FILE environment variable to the path of that file. Defaults to false.
        :param pulumi.Input[str] task_count: Number of Tasks in the TaskGroup. default is 1
        :param pulumi.Input[str] task_count_per_node: Max number of tasks that can be run on a VM at the same time. If not specified, the system will decide a value based on available compute resources on a VM and task requirements.
        :param pulumi.Input[Sequence[pulumi.Input['EnvironmentArgs']]] task_environments: An array of environment variable mappings, which are passed to Tasks with matching indices. If task_environments is used then task_count should not be specified in the request (and will be ignored). Task count will be the length of task_environments. Tasks get a BATCH_TASK_INDEX and BATCH_TASK_COUNT environment variable, in addition to any environment variables set in task_environments, specifying the number of Tasks in the Task's parent TaskGroup, and the specific Task's index in the TaskGroup (0 through BATCH_TASK_COUNT - 1). task_environments supports up to 200 entries.
        """
        pulumi.set(__self__, "task_spec", task_spec)
        if parallelism is not None:
            pulumi.set(__self__, "parallelism", parallelism)
        if permissive_ssh is not None:
            pulumi.set(__self__, "permissive_ssh", permissive_ssh)
        if require_hosts_file is not None:
            pulumi.set(__self__, "require_hosts_file", require_hosts_file)
        if task_count is not None:
            pulumi.set(__self__, "task_count", task_count)
        if task_count_per_node is not None:
            pulumi.set(__self__, "task_count_per_node", task_count_per_node)
        if task_environments is not None:
            pulumi.set(__self__, "task_environments", task_environments)

    @property
    @pulumi.getter(name="taskSpec")
    def task_spec(self) -> pulumi.Input['TaskSpecArgs']:
        """
        Tasks in the group share the same task spec.
        """
        return pulumi.get(self, "task_spec")

    @task_spec.setter
    def task_spec(self, value: pulumi.Input['TaskSpecArgs']):
        pulumi.set(self, "task_spec", value)

    @property
    @pulumi.getter
    def parallelism(self) -> Optional[pulumi.Input[str]]:
        """
        Max number of tasks that can run in parallel. Default to min(task_count, 1000).
        """
        return pulumi.get(self, "parallelism")

    @parallelism.setter
    def parallelism(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parallelism", value)

    @property
    @pulumi.getter(name="permissiveSsh")
    def permissive_ssh(self) -> Optional[pulumi.Input[bool]]:
        """
        When true, Batch will configure SSH to allow passwordless login between VMs running the Batch tasks in the same TaskGroup.
        """
        return pulumi.get(self, "permissive_ssh")

    @permissive_ssh.setter
    def permissive_ssh(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "permissive_ssh", value)

    @property
    @pulumi.getter(name="requireHostsFile")
    def require_hosts_file(self) -> Optional[pulumi.Input[bool]]:
        """
        When true, Batch will populate a file with a list of all VMs assigned to the TaskGroup and set the BATCH_HOSTS_FILE environment variable to the path of that file. Defaults to false.
        """
        return pulumi.get(self, "require_hosts_file")

    @require_hosts_file.setter
    def require_hosts_file(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_hosts_file", value)

    @property
    @pulumi.getter(name="taskCount")
    def task_count(self) -> Optional[pulumi.Input[str]]:
        """
        Number of Tasks in the TaskGroup. default is 1
        """
        return pulumi.get(self, "task_count")

    @task_count.setter
    def task_count(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "task_count", value)

    @property
    @pulumi.getter(name="taskCountPerNode")
    def task_count_per_node(self) -> Optional[pulumi.Input[str]]:
        """
        Max number of tasks that can be run on a VM at the same time. If not specified, the system will decide a value based on available compute resources on a VM and task requirements.
        """
        return pulumi.get(self, "task_count_per_node")

    @task_count_per_node.setter
    def task_count_per_node(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "task_count_per_node", value)

    @property
    @pulumi.getter(name="taskEnvironments")
    def task_environments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentArgs']]]]:
        """
        An array of environment variable mappings, which are passed to Tasks with matching indices. If task_environments is used then task_count should not be specified in the request (and will be ignored). Task count will be the length of task_environments. Tasks get a BATCH_TASK_INDEX and BATCH_TASK_COUNT environment variable, in addition to any environment variables set in task_environments, specifying the number of Tasks in the Task's parent TaskGroup, and the specific Task's index in the TaskGroup (0 through BATCH_TASK_COUNT - 1). task_environments supports up to 200 entries.
        """
        return pulumi.get(self, "task_environments")

    @task_environments.setter
    def task_environments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentArgs']]]]):
        pulumi.set(self, "task_environments", value)


@pulumi.input_type
class TaskSpecArgs:
    def __init__(__self__, *,
                 compute_resource: Optional[pulumi.Input['ComputeResourceArgs']] = None,
                 environment: Optional[pulumi.Input['EnvironmentArgs']] = None,
                 environments: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 lifecycle_policies: Optional[pulumi.Input[Sequence[pulumi.Input['LifecyclePolicyArgs']]]] = None,
                 max_retry_count: Optional[pulumi.Input[int]] = None,
                 max_run_duration: Optional[pulumi.Input[str]] = None,
                 runnables: Optional[pulumi.Input[Sequence[pulumi.Input['RunnableArgs']]]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeArgs']]]] = None):
        """
        Spec of a task
        :param pulumi.Input['ComputeResourceArgs'] compute_resource: ComputeResource requirements.
        :param pulumi.Input['EnvironmentArgs'] environment: Environment variables to set before running the Task.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environments: Deprecated: please use environment(non-plural) instead.
        :param pulumi.Input[Sequence[pulumi.Input['LifecyclePolicyArgs']]] lifecycle_policies: Lifecycle management schema when any task in a task group is failed. The valid size of lifecycle policies are [0, 10]. For each lifecycle policy, when the condition is met, the action in that policy will execute. If there are multiple policies that the task execution result matches, we use the action from the first matched policy. If task execution result does not meet with any of the defined lifecycle policy, we consider it as the default policy. Default policy means if the exit code is 0, exit task. If task ends with non-zero exit code, retry the task with max_retry_count.
        :param pulumi.Input[int] max_retry_count: Maximum number of retries on failures. The default, 0, which means never retry. The valid value range is [0, 10].
        :param pulumi.Input[str] max_run_duration: Maximum duration the task should run. The task will be killed and marked as FAILED if over this limit.
        :param pulumi.Input[Sequence[pulumi.Input['RunnableArgs']]] runnables: The sequence of scripts or containers to run for this Task. Each Task using this TaskSpec executes its list of runnables in order. The Task succeeds if all of its runnables either exit with a zero status or any that exit with a non-zero status have the ignore_exit_status flag. Background runnables are killed automatically (if they have not already exited) a short time after all foreground runnables have completed. Even though this is likely to result in a non-zero exit status for the background runnable, these automatic kills are not treated as Task failures.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeArgs']]] volumes: Volumes to mount before running Tasks using this TaskSpec.
        """
        if compute_resource is not None:
            pulumi.set(__self__, "compute_resource", compute_resource)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if environments is not None:
            warnings.warn("""Deprecated: please use environment(non-plural) instead.""", DeprecationWarning)
            pulumi.log.warn("""environments is deprecated: Deprecated: please use environment(non-plural) instead.""")
        if environments is not None:
            pulumi.set(__self__, "environments", environments)
        if lifecycle_policies is not None:
            pulumi.set(__self__, "lifecycle_policies", lifecycle_policies)
        if max_retry_count is not None:
            pulumi.set(__self__, "max_retry_count", max_retry_count)
        if max_run_duration is not None:
            pulumi.set(__self__, "max_run_duration", max_run_duration)
        if runnables is not None:
            pulumi.set(__self__, "runnables", runnables)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter(name="computeResource")
    def compute_resource(self) -> Optional[pulumi.Input['ComputeResourceArgs']]:
        """
        ComputeResource requirements.
        """
        return pulumi.get(self, "compute_resource")

    @compute_resource.setter
    def compute_resource(self, value: Optional[pulumi.Input['ComputeResourceArgs']]):
        pulumi.set(self, "compute_resource", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input['EnvironmentArgs']]:
        """
        Environment variables to set before running the Task.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input['EnvironmentArgs']]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter
    def environments(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Deprecated: please use environment(non-plural) instead.
        """
        return pulumi.get(self, "environments")

    @environments.setter
    def environments(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "environments", value)

    @property
    @pulumi.getter(name="lifecyclePolicies")
    def lifecycle_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LifecyclePolicyArgs']]]]:
        """
        Lifecycle management schema when any task in a task group is failed. The valid size of lifecycle policies are [0, 10]. For each lifecycle policy, when the condition is met, the action in that policy will execute. If there are multiple policies that the task execution result matches, we use the action from the first matched policy. If task execution result does not meet with any of the defined lifecycle policy, we consider it as the default policy. Default policy means if the exit code is 0, exit task. If task ends with non-zero exit code, retry the task with max_retry_count.
        """
        return pulumi.get(self, "lifecycle_policies")

    @lifecycle_policies.setter
    def lifecycle_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LifecyclePolicyArgs']]]]):
        pulumi.set(self, "lifecycle_policies", value)

    @property
    @pulumi.getter(name="maxRetryCount")
    def max_retry_count(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of retries on failures. The default, 0, which means never retry. The valid value range is [0, 10].
        """
        return pulumi.get(self, "max_retry_count")

    @max_retry_count.setter
    def max_retry_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_retry_count", value)

    @property
    @pulumi.getter(name="maxRunDuration")
    def max_run_duration(self) -> Optional[pulumi.Input[str]]:
        """
        Maximum duration the task should run. The task will be killed and marked as FAILED if over this limit.
        """
        return pulumi.get(self, "max_run_duration")

    @max_run_duration.setter
    def max_run_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_run_duration", value)

    @property
    @pulumi.getter
    def runnables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RunnableArgs']]]]:
        """
        The sequence of scripts or containers to run for this Task. Each Task using this TaskSpec executes its list of runnables in order. The Task succeeds if all of its runnables either exit with a zero status or any that exit with a non-zero status have the ignore_exit_status flag. Background runnables are killed automatically (if they have not already exited) a short time after all foreground runnables have completed. Even though this is likely to result in a non-zero exit status for the background runnable, these automatic kills are not treated as Task failures.
        """
        return pulumi.get(self, "runnables")

    @runnables.setter
    def runnables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RunnableArgs']]]]):
        pulumi.set(self, "runnables", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeArgs']]]]:
        """
        Volumes to mount before running Tasks using this TaskSpec.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeArgs']]]]):
        pulumi.set(self, "volumes", value)


@pulumi.input_type
class VolumeArgs:
    def __init__(__self__, *,
                 device_name: Optional[pulumi.Input[str]] = None,
                 gcs: Optional[pulumi.Input['GCSArgs']] = None,
                 mount_options: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 mount_path: Optional[pulumi.Input[str]] = None,
                 nfs: Optional[pulumi.Input['NFSArgs']] = None):
        """
        Volume describes a volume and parameters for it to be mounted to a VM.
        :param pulumi.Input[str] device_name: Device name of an attached disk volume, which should align with a device_name specified by job.allocation_policy.instances[0].policy.disks[i].device_name or defined by the given instance template in job.allocation_policy.instances[0].instance_template.
        :param pulumi.Input['GCSArgs'] gcs: A Google Cloud Storage (GCS) volume.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] mount_options: For Google Cloud Storage (GCS), mount options are the options supported by the gcsfuse tool (https://github.com/GoogleCloudPlatform/gcsfuse). For existing persistent disks, mount options provided by the mount command (https://man7.org/linux/man-pages/man8/mount.8.html) except writing are supported. This is due to restrictions of multi-writer mode (https://cloud.google.com/compute/docs/disks/sharing-disks-between-vms). For other attached disks and Network File System (NFS), mount options are these supported by the mount command (https://man7.org/linux/man-pages/man8/mount.8.html).
        :param pulumi.Input[str] mount_path: The mount path for the volume, e.g. /mnt/disks/share.
        :param pulumi.Input['NFSArgs'] nfs: A Network File System (NFS) volume. For example, a Filestore file share.
        """
        if device_name is not None:
            pulumi.set(__self__, "device_name", device_name)
        if gcs is not None:
            pulumi.set(__self__, "gcs", gcs)
        if mount_options is not None:
            pulumi.set(__self__, "mount_options", mount_options)
        if mount_path is not None:
            pulumi.set(__self__, "mount_path", mount_path)
        if nfs is not None:
            pulumi.set(__self__, "nfs", nfs)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> Optional[pulumi.Input[str]]:
        """
        Device name of an attached disk volume, which should align with a device_name specified by job.allocation_policy.instances[0].policy.disks[i].device_name or defined by the given instance template in job.allocation_policy.instances[0].instance_template.
        """
        return pulumi.get(self, "device_name")

    @device_name.setter
    def device_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_name", value)

    @property
    @pulumi.getter
    def gcs(self) -> Optional[pulumi.Input['GCSArgs']]:
        """
        A Google Cloud Storage (GCS) volume.
        """
        return pulumi.get(self, "gcs")

    @gcs.setter
    def gcs(self, value: Optional[pulumi.Input['GCSArgs']]):
        pulumi.set(self, "gcs", value)

    @property
    @pulumi.getter(name="mountOptions")
    def mount_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        For Google Cloud Storage (GCS), mount options are the options supported by the gcsfuse tool (https://github.com/GoogleCloudPlatform/gcsfuse). For existing persistent disks, mount options provided by the mount command (https://man7.org/linux/man-pages/man8/mount.8.html) except writing are supported. This is due to restrictions of multi-writer mode (https://cloud.google.com/compute/docs/disks/sharing-disks-between-vms). For other attached disks and Network File System (NFS), mount options are these supported by the mount command (https://man7.org/linux/man-pages/man8/mount.8.html).
        """
        return pulumi.get(self, "mount_options")

    @mount_options.setter
    def mount_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "mount_options", value)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> Optional[pulumi.Input[str]]:
        """
        The mount path for the volume, e.g. /mnt/disks/share.
        """
        return pulumi.get(self, "mount_path")

    @mount_path.setter
    def mount_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mount_path", value)

    @property
    @pulumi.getter
    def nfs(self) -> Optional[pulumi.Input['NFSArgs']]:
        """
        A Network File System (NFS) volume. For example, a Filestore file share.
        """
        return pulumi.get(self, "nfs")

    @nfs.setter
    def nfs(self, value: Optional[pulumi.Input['NFSArgs']]):
        pulumi.set(self, "nfs", value)


