# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

from enum import Enum

__all__ = [
    'AuditLogConfigLogType',
    'InstancePolicyProvisioningModel',
    'LifecyclePolicyAction',
    'LogsPolicyDestination',
    'MessageNewJobState',
    'MessageNewTaskState',
    'MessageType',
]


class AuditLogConfigLogType(str, Enum):
    """
    The log type that this config enables.
    """
    LOG_TYPE_UNSPECIFIED = "LOG_TYPE_UNSPECIFIED"
    """
    Default case. Should never be this.
    """
    ADMIN_READ = "ADMIN_READ"
    """
    Admin reads. Example: CloudIAM getIamPolicy
    """
    DATA_WRITE = "DATA_WRITE"
    """
    Data writes. Example: CloudSQL Users create
    """
    DATA_READ = "DATA_READ"
    """
    Data reads. Example: CloudSQL Users list
    """


class InstancePolicyProvisioningModel(str, Enum):
    """
    The provisioning model.
    """
    PROVISIONING_MODEL_UNSPECIFIED = "PROVISIONING_MODEL_UNSPECIFIED"
    """
    Unspecified.
    """
    STANDARD = "STANDARD"
    """
    Standard VM.
    """
    SPOT = "SPOT"
    """
    SPOT VM.
    """
    PREEMPTIBLE = "PREEMPTIBLE"
    """
    Preemptible VM (PVM). Above SPOT VM is the preferable model for preemptible VM instances: the old preemptible VM model (indicated by this field) is the older model, and has been migrated to use the SPOT model as the underlying technology. This old model will still be supported.
    """


class LifecyclePolicyAction(str, Enum):
    """
    Action to execute when ActionCondition is true.
    """
    ACTION_UNSPECIFIED = "ACTION_UNSPECIFIED"
    """
    Action unspecified.
    """
    RETRY_TASK = "RETRY_TASK"
    """
    Action that tasks in the group will be scheduled to re-execute.
    """
    FAIL_TASK = "FAIL_TASK"
    """
    Action that tasks in the group will be stopped immediately.
    """


class LogsPolicyDestination(str, Enum):
    """
    Where logs should be saved.
    """
    DESTINATION_UNSPECIFIED = "DESTINATION_UNSPECIFIED"
    """
    Logs are not preserved.
    """
    CLOUD_LOGGING = "CLOUD_LOGGING"
    """
    Logs are streamed to Cloud Logging.
    """
    PATH = "PATH"
    """
    Logs are saved to a file path.
    """


class MessageNewJobState(str, Enum):
    """
    The new job state.
    """
    STATE_UNSPECIFIED = "STATE_UNSPECIFIED"
    QUEUED = "QUEUED"
    """
    Job is admitted (validated and persisted) and waiting for resources.
    """
    SCHEDULED = "SCHEDULED"
    """
    Job is scheduled to run as soon as resource allocation is ready. The resource allocation may happen at a later time but with a high chance to succeed.
    """
    RUNNING = "RUNNING"
    """
    Resource allocation has been successful. At least one Task in the Job is RUNNING.
    """
    SUCCEEDED = "SUCCEEDED"
    """
    All Tasks in the Job have finished successfully.
    """
    FAILED = "FAILED"
    """
    At least one Task in the Job has failed.
    """
    DELETION_IN_PROGRESS = "DELETION_IN_PROGRESS"
    """
    The Job will be deleted, but has not been deleted yet. Typically this is because resources used by the Job are still being cleaned up.
    """


class MessageNewTaskState(str, Enum):
    """
    The new task state.
    """
    STATE_UNSPECIFIED = "STATE_UNSPECIFIED"
    """
    unknown state
    """
    PENDING = "PENDING"
    """
    The Task is created and waiting for resources.
    """
    ASSIGNED = "ASSIGNED"
    """
    The Task is assigned to at least one VM.
    """
    RUNNING = "RUNNING"
    """
    The Task is running.
    """
    FAILED = "FAILED"
    """
    The Task has failed.
    """
    SUCCEEDED = "SUCCEEDED"
    """
    The Task has succeeded.
    """


class MessageType(str, Enum):
    """
    The message type.
    """
    TYPE_UNSPECIFIED = "TYPE_UNSPECIFIED"
    """
    Unspecified.
    """
    JOB_STATE_CHANGED = "JOB_STATE_CHANGED"
    """
    Notify users that the job state has changed.
    """
    TASK_STATE_CHANGED = "TASK_STATE_CHANGED"
    """
    Notify users that the task state has changed.
    """
