# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'GetSnapshotResult',
    'AwaitableGetSnapshotResult',
    'get_snapshot',
    'get_snapshot_output',
]

@pulumi.output_type
class GetSnapshotResult:
    def __init__(__self__, create_time=None, description=None, name=None, storage_volume=None, type=None):
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if storage_volume and not isinstance(storage_volume, str):
            raise TypeError("Expected argument 'storage_volume' to be a str")
        pulumi.set(__self__, "storage_volume", storage_volume)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creation time of the snapshot.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the snapshot.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the snapshot.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="storageVolume")
    def storage_volume(self) -> str:
        """
        The name of the volume which this snapshot belongs to.
        """
        return pulumi.get(self, "storage_volume")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the snapshot which indicates whether it was scheduled or manual/ad-hoc.
        """
        return pulumi.get(self, "type")


class AwaitableGetSnapshotResult(GetSnapshotResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSnapshotResult(
            create_time=self.create_time,
            description=self.description,
            name=self.name,
            storage_volume=self.storage_volume,
            type=self.type)


def get_snapshot(location: Optional[str] = None,
                 project: Optional[str] = None,
                 snapshot_id: Optional[str] = None,
                 volume_id: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSnapshotResult:
    """
    Returns the specified snapshot resource. Returns INVALID_ARGUMENT if called for a non-boot volume.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['project'] = project
    __args__['snapshotId'] = snapshot_id
    __args__['volumeId'] = volume_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:baremetalsolution/v2:getSnapshot', __args__, opts=opts, typ=GetSnapshotResult).value

    return AwaitableGetSnapshotResult(
        create_time=__ret__.create_time,
        description=__ret__.description,
        name=__ret__.name,
        storage_volume=__ret__.storage_volume,
        type=__ret__.type)


@_utilities.lift_output_func(get_snapshot)
def get_snapshot_output(location: Optional[pulumi.Input[str]] = None,
                        project: Optional[pulumi.Input[Optional[str]]] = None,
                        snapshot_id: Optional[pulumi.Input[str]] = None,
                        volume_id: Optional[pulumi.Input[str]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSnapshotResult]:
    """
    Returns the specified snapshot resource. Returns INVALID_ARGUMENT if called for a non-boot volume.
    """
    ...
