# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetNfsShareResult',
    'AwaitableGetNfsShareResult',
    'get_nfs_share',
    'get_nfs_share_output',
]

@pulumi.output_type
class GetNfsShareResult:
    def __init__(__self__, allowed_clients=None, labels=None, name=None, nfs_share_id=None, requested_size_gib=None, state=None, storage_type=None, volume=None):
        if allowed_clients and not isinstance(allowed_clients, list):
            raise TypeError("Expected argument 'allowed_clients' to be a list")
        pulumi.set(__self__, "allowed_clients", allowed_clients)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if nfs_share_id and not isinstance(nfs_share_id, str):
            raise TypeError("Expected argument 'nfs_share_id' to be a str")
        pulumi.set(__self__, "nfs_share_id", nfs_share_id)
        if requested_size_gib and not isinstance(requested_size_gib, str):
            raise TypeError("Expected argument 'requested_size_gib' to be a str")
        pulumi.set(__self__, "requested_size_gib", requested_size_gib)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if storage_type and not isinstance(storage_type, str):
            raise TypeError("Expected argument 'storage_type' to be a str")
        pulumi.set(__self__, "storage_type", storage_type)
        if volume and not isinstance(volume, str):
            raise TypeError("Expected argument 'volume' to be a str")
        pulumi.set(__self__, "volume", volume)

    @property
    @pulumi.getter(name="allowedClients")
    def allowed_clients(self) -> Sequence['outputs.AllowedClientResponse']:
        """
        List of allowed access points.
        """
        return pulumi.get(self, "allowed_clients")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Labels as key value pairs.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Immutable. The name of the NFS share.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nfsShareId")
    def nfs_share_id(self) -> str:
        """
        An identifier for the NFS share, generated by the backend. This field will be deprecated in the future, use `id` instead.
        """
        return pulumi.get(self, "nfs_share_id")

    @property
    @pulumi.getter(name="requestedSizeGib")
    def requested_size_gib(self) -> str:
        """
        The requested size, in GiB.
        """
        return pulumi.get(self, "requested_size_gib")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the NFS share.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> str:
        """
        Immutable. The storage type of the underlying volume.
        """
        return pulumi.get(self, "storage_type")

    @property
    @pulumi.getter
    def volume(self) -> str:
        """
        The underlying volume of the share. Created automatically during provisioning.
        """
        return pulumi.get(self, "volume")


class AwaitableGetNfsShareResult(GetNfsShareResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNfsShareResult(
            allowed_clients=self.allowed_clients,
            labels=self.labels,
            name=self.name,
            nfs_share_id=self.nfs_share_id,
            requested_size_gib=self.requested_size_gib,
            state=self.state,
            storage_type=self.storage_type,
            volume=self.volume)


def get_nfs_share(location: Optional[str] = None,
                  nfs_share_id: Optional[str] = None,
                  project: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNfsShareResult:
    """
    Get details of a single NFS share.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['nfsShareId'] = nfs_share_id
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:baremetalsolution/v2:getNfsShare', __args__, opts=opts, typ=GetNfsShareResult).value

    return AwaitableGetNfsShareResult(
        allowed_clients=__ret__.allowed_clients,
        labels=__ret__.labels,
        name=__ret__.name,
        nfs_share_id=__ret__.nfs_share_id,
        requested_size_gib=__ret__.requested_size_gib,
        state=__ret__.state,
        storage_type=__ret__.storage_type,
        volume=__ret__.volume)


@_utilities.lift_output_func(get_nfs_share)
def get_nfs_share_output(location: Optional[pulumi.Input[str]] = None,
                         nfs_share_id: Optional[pulumi.Input[str]] = None,
                         project: Optional[pulumi.Input[Optional[str]]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetNfsShareResult]:
    """
    Get details of a single NFS share.
    """
    ...
