# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['ListingArgs', 'Listing']

@pulumi.input_type
class ListingArgs:
    def __init__(__self__, *,
                 bigquery_dataset: pulumi.Input['BigQueryDatasetSourceArgs'],
                 data_exchange_id: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 listing_id: pulumi.Input[str],
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input['ListingCategoriesItem']]]] = None,
                 data_provider: Optional[pulumi.Input['DataProviderArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 documentation: Optional[pulumi.Input[str]] = None,
                 icon: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 primary_contact: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 publisher: Optional[pulumi.Input['PublisherArgs']] = None,
                 request_access: Optional[pulumi.Input[str]] = None,
                 restricted_export_config: Optional[pulumi.Input['RestrictedExportConfigArgs']] = None):
        """
        The set of arguments for constructing a Listing resource.
        :param pulumi.Input['BigQueryDatasetSourceArgs'] bigquery_dataset: Shared dataset i.e. BigQuery dataset source.
        :param pulumi.Input[str] display_name: Human-readable display name of the listing. The display name must contain only Unicode letters, numbers (0-9), underscores (_), dashes (-), spaces ( ), ampersands (&) and can't start or end with spaces. Default value is an empty string. Max length: 63 bytes.
        :param pulumi.Input[str] listing_id: Required. The ID of the listing to create. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces. Max length: 100 bytes.
        :param pulumi.Input[Sequence[pulumi.Input['ListingCategoriesItem']]] categories: Optional. Categories of the listing. Up to two categories are allowed.
        :param pulumi.Input['DataProviderArgs'] data_provider: Optional. Details of the data provider who owns the source data.
        :param pulumi.Input[str] description: Optional. Short description of the listing. The description must not contain Unicode non-characters and C0 and C1 control codes except tabs (HT), new lines (LF), carriage returns (CR), and page breaks (FF). Default value is an empty string. Max length: 2000 bytes.
        :param pulumi.Input[str] documentation: Optional. Documentation describing the listing.
        :param pulumi.Input[str] icon: Optional. Base64 encoded image representing the listing. Max Size: 3.0MiB Expected image dimensions are 512x512 pixels, however the API only performs validation on size of the encoded data. Note: For byte fields, the contents of the field are base64-encoded (which increases the size of the data by 33-36%) when using JSON on the wire.
        :param pulumi.Input[str] primary_contact: Optional. Email or URL of the primary point of contact of the listing. Max Length: 1000 bytes.
        :param pulumi.Input['PublisherArgs'] publisher: Optional. Details of the publisher who owns the listing and who can share the source data.
        :param pulumi.Input[str] request_access: Optional. Email or URL of the request access of the listing. Subscribers can use this reference to request access. Max Length: 1000 bytes.
        :param pulumi.Input['RestrictedExportConfigArgs'] restricted_export_config: Optional. If set, restricted export configuration will be propagated and enforced on the linked dataset.
        """
        pulumi.set(__self__, "bigquery_dataset", bigquery_dataset)
        pulumi.set(__self__, "data_exchange_id", data_exchange_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "listing_id", listing_id)
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if data_provider is not None:
            pulumi.set(__self__, "data_provider", data_provider)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if documentation is not None:
            pulumi.set(__self__, "documentation", documentation)
        if icon is not None:
            pulumi.set(__self__, "icon", icon)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if primary_contact is not None:
            pulumi.set(__self__, "primary_contact", primary_contact)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)
        if request_access is not None:
            pulumi.set(__self__, "request_access", request_access)
        if restricted_export_config is not None:
            pulumi.set(__self__, "restricted_export_config", restricted_export_config)

    @property
    @pulumi.getter(name="bigqueryDataset")
    def bigquery_dataset(self) -> pulumi.Input['BigQueryDatasetSourceArgs']:
        """
        Shared dataset i.e. BigQuery dataset source.
        """
        return pulumi.get(self, "bigquery_dataset")

    @bigquery_dataset.setter
    def bigquery_dataset(self, value: pulumi.Input['BigQueryDatasetSourceArgs']):
        pulumi.set(self, "bigquery_dataset", value)

    @property
    @pulumi.getter(name="dataExchangeId")
    def data_exchange_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "data_exchange_id")

    @data_exchange_id.setter
    def data_exchange_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "data_exchange_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        Human-readable display name of the listing. The display name must contain only Unicode letters, numbers (0-9), underscores (_), dashes (-), spaces ( ), ampersands (&) and can't start or end with spaces. Default value is an empty string. Max length: 63 bytes.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="listingId")
    def listing_id(self) -> pulumi.Input[str]:
        """
        Required. The ID of the listing to create. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces. Max length: 100 bytes.
        """
        return pulumi.get(self, "listing_id")

    @listing_id.setter
    def listing_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "listing_id", value)

    @property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ListingCategoriesItem']]]]:
        """
        Optional. Categories of the listing. Up to two categories are allowed.
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ListingCategoriesItem']]]]):
        pulumi.set(self, "categories", value)

    @property
    @pulumi.getter(name="dataProvider")
    def data_provider(self) -> Optional[pulumi.Input['DataProviderArgs']]:
        """
        Optional. Details of the data provider who owns the source data.
        """
        return pulumi.get(self, "data_provider")

    @data_provider.setter
    def data_provider(self, value: Optional[pulumi.Input['DataProviderArgs']]):
        pulumi.set(self, "data_provider", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Short description of the listing. The description must not contain Unicode non-characters and C0 and C1 control codes except tabs (HT), new lines (LF), carriage returns (CR), and page breaks (FF). Default value is an empty string. Max length: 2000 bytes.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def documentation(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Documentation describing the listing.
        """
        return pulumi.get(self, "documentation")

    @documentation.setter
    def documentation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "documentation", value)

    @property
    @pulumi.getter
    def icon(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Base64 encoded image representing the listing. Max Size: 3.0MiB Expected image dimensions are 512x512 pixels, however the API only performs validation on size of the encoded data. Note: For byte fields, the contents of the field are base64-encoded (which increases the size of the data by 33-36%) when using JSON on the wire.
        """
        return pulumi.get(self, "icon")

    @icon.setter
    def icon(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "icon", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="primaryContact")
    def primary_contact(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Email or URL of the primary point of contact of the listing. Max Length: 1000 bytes.
        """
        return pulumi.get(self, "primary_contact")

    @primary_contact.setter
    def primary_contact(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_contact", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def publisher(self) -> Optional[pulumi.Input['PublisherArgs']]:
        """
        Optional. Details of the publisher who owns the listing and who can share the source data.
        """
        return pulumi.get(self, "publisher")

    @publisher.setter
    def publisher(self, value: Optional[pulumi.Input['PublisherArgs']]):
        pulumi.set(self, "publisher", value)

    @property
    @pulumi.getter(name="requestAccess")
    def request_access(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Email or URL of the request access of the listing. Subscribers can use this reference to request access. Max Length: 1000 bytes.
        """
        return pulumi.get(self, "request_access")

    @request_access.setter
    def request_access(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_access", value)

    @property
    @pulumi.getter(name="restrictedExportConfig")
    def restricted_export_config(self) -> Optional[pulumi.Input['RestrictedExportConfigArgs']]:
        """
        Optional. If set, restricted export configuration will be propagated and enforced on the linked dataset.
        """
        return pulumi.get(self, "restricted_export_config")

    @restricted_export_config.setter
    def restricted_export_config(self, value: Optional[pulumi.Input['RestrictedExportConfigArgs']]):
        pulumi.set(self, "restricted_export_config", value)


class Listing(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bigquery_dataset: Optional[pulumi.Input[pulumi.InputType['BigQueryDatasetSourceArgs']]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input['ListingCategoriesItem']]]] = None,
                 data_exchange_id: Optional[pulumi.Input[str]] = None,
                 data_provider: Optional[pulumi.Input[pulumi.InputType['DataProviderArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 documentation: Optional[pulumi.Input[str]] = None,
                 icon: Optional[pulumi.Input[str]] = None,
                 listing_id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 primary_contact: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 publisher: Optional[pulumi.Input[pulumi.InputType['PublisherArgs']]] = None,
                 request_access: Optional[pulumi.Input[str]] = None,
                 restricted_export_config: Optional[pulumi.Input[pulumi.InputType['RestrictedExportConfigArgs']]] = None,
                 __props__=None):
        """
        Creates a new listing.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['BigQueryDatasetSourceArgs']] bigquery_dataset: Shared dataset i.e. BigQuery dataset source.
        :param pulumi.Input[Sequence[pulumi.Input['ListingCategoriesItem']]] categories: Optional. Categories of the listing. Up to two categories are allowed.
        :param pulumi.Input[pulumi.InputType['DataProviderArgs']] data_provider: Optional. Details of the data provider who owns the source data.
        :param pulumi.Input[str] description: Optional. Short description of the listing. The description must not contain Unicode non-characters and C0 and C1 control codes except tabs (HT), new lines (LF), carriage returns (CR), and page breaks (FF). Default value is an empty string. Max length: 2000 bytes.
        :param pulumi.Input[str] display_name: Human-readable display name of the listing. The display name must contain only Unicode letters, numbers (0-9), underscores (_), dashes (-), spaces ( ), ampersands (&) and can't start or end with spaces. Default value is an empty string. Max length: 63 bytes.
        :param pulumi.Input[str] documentation: Optional. Documentation describing the listing.
        :param pulumi.Input[str] icon: Optional. Base64 encoded image representing the listing. Max Size: 3.0MiB Expected image dimensions are 512x512 pixels, however the API only performs validation on size of the encoded data. Note: For byte fields, the contents of the field are base64-encoded (which increases the size of the data by 33-36%) when using JSON on the wire.
        :param pulumi.Input[str] listing_id: Required. The ID of the listing to create. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces. Max length: 100 bytes.
        :param pulumi.Input[str] primary_contact: Optional. Email or URL of the primary point of contact of the listing. Max Length: 1000 bytes.
        :param pulumi.Input[pulumi.InputType['PublisherArgs']] publisher: Optional. Details of the publisher who owns the listing and who can share the source data.
        :param pulumi.Input[str] request_access: Optional. Email or URL of the request access of the listing. Subscribers can use this reference to request access. Max Length: 1000 bytes.
        :param pulumi.Input[pulumi.InputType['RestrictedExportConfigArgs']] restricted_export_config: Optional. If set, restricted export configuration will be propagated and enforced on the linked dataset.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ListingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new listing.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param ListingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ListingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bigquery_dataset: Optional[pulumi.Input[pulumi.InputType['BigQueryDatasetSourceArgs']]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input['ListingCategoriesItem']]]] = None,
                 data_exchange_id: Optional[pulumi.Input[str]] = None,
                 data_provider: Optional[pulumi.Input[pulumi.InputType['DataProviderArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 documentation: Optional[pulumi.Input[str]] = None,
                 icon: Optional[pulumi.Input[str]] = None,
                 listing_id: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 primary_contact: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 publisher: Optional[pulumi.Input[pulumi.InputType['PublisherArgs']]] = None,
                 request_access: Optional[pulumi.Input[str]] = None,
                 restricted_export_config: Optional[pulumi.Input[pulumi.InputType['RestrictedExportConfigArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ListingArgs.__new__(ListingArgs)

            if bigquery_dataset is None and not opts.urn:
                raise TypeError("Missing required property 'bigquery_dataset'")
            __props__.__dict__["bigquery_dataset"] = bigquery_dataset
            __props__.__dict__["categories"] = categories
            if data_exchange_id is None and not opts.urn:
                raise TypeError("Missing required property 'data_exchange_id'")
            __props__.__dict__["data_exchange_id"] = data_exchange_id
            __props__.__dict__["data_provider"] = data_provider
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["documentation"] = documentation
            __props__.__dict__["icon"] = icon
            if listing_id is None and not opts.urn:
                raise TypeError("Missing required property 'listing_id'")
            __props__.__dict__["listing_id"] = listing_id
            __props__.__dict__["location"] = location
            __props__.__dict__["primary_contact"] = primary_contact
            __props__.__dict__["project"] = project
            __props__.__dict__["publisher"] = publisher
            __props__.__dict__["request_access"] = request_access
            __props__.__dict__["restricted_export_config"] = restricted_export_config
            __props__.__dict__["name"] = None
            __props__.__dict__["state"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["data_exchange_id", "listing_id", "location", "project"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Listing, __self__).__init__(
            'google-native:analyticshub/v1beta1:Listing',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Listing':
        """
        Get an existing Listing resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ListingArgs.__new__(ListingArgs)

        __props__.__dict__["bigquery_dataset"] = None
        __props__.__dict__["categories"] = None
        __props__.__dict__["data_exchange_id"] = None
        __props__.__dict__["data_provider"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["display_name"] = None
        __props__.__dict__["documentation"] = None
        __props__.__dict__["icon"] = None
        __props__.__dict__["listing_id"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["primary_contact"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["publisher"] = None
        __props__.__dict__["request_access"] = None
        __props__.__dict__["restricted_export_config"] = None
        __props__.__dict__["state"] = None
        return Listing(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bigqueryDataset")
    def bigquery_dataset(self) -> pulumi.Output['outputs.BigQueryDatasetSourceResponse']:
        """
        Shared dataset i.e. BigQuery dataset source.
        """
        return pulumi.get(self, "bigquery_dataset")

    @property
    @pulumi.getter
    def categories(self) -> pulumi.Output[Sequence[str]]:
        """
        Optional. Categories of the listing. Up to two categories are allowed.
        """
        return pulumi.get(self, "categories")

    @property
    @pulumi.getter(name="dataExchangeId")
    def data_exchange_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "data_exchange_id")

    @property
    @pulumi.getter(name="dataProvider")
    def data_provider(self) -> pulumi.Output['outputs.DataProviderResponse']:
        """
        Optional. Details of the data provider who owns the source data.
        """
        return pulumi.get(self, "data_provider")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Optional. Short description of the listing. The description must not contain Unicode non-characters and C0 and C1 control codes except tabs (HT), new lines (LF), carriage returns (CR), and page breaks (FF). Default value is an empty string. Max length: 2000 bytes.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        Human-readable display name of the listing. The display name must contain only Unicode letters, numbers (0-9), underscores (_), dashes (-), spaces ( ), ampersands (&) and can't start or end with spaces. Default value is an empty string. Max length: 63 bytes.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def documentation(self) -> pulumi.Output[str]:
        """
        Optional. Documentation describing the listing.
        """
        return pulumi.get(self, "documentation")

    @property
    @pulumi.getter
    def icon(self) -> pulumi.Output[str]:
        """
        Optional. Base64 encoded image representing the listing. Max Size: 3.0MiB Expected image dimensions are 512x512 pixels, however the API only performs validation on size of the encoded data. Note: For byte fields, the contents of the field are base64-encoded (which increases the size of the data by 33-36%) when using JSON on the wire.
        """
        return pulumi.get(self, "icon")

    @property
    @pulumi.getter(name="listingId")
    def listing_id(self) -> pulumi.Output[str]:
        """
        Required. The ID of the listing to create. Must contain only Unicode letters, numbers (0-9), underscores (_). Should not use characters that require URL-escaping, or characters outside of ASCII, spaces. Max length: 100 bytes.
        """
        return pulumi.get(self, "listing_id")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The resource name of the listing. e.g. `projects/myproject/locations/US/dataExchanges/123/listings/456`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="primaryContact")
    def primary_contact(self) -> pulumi.Output[str]:
        """
        Optional. Email or URL of the primary point of contact of the listing. Max Length: 1000 bytes.
        """
        return pulumi.get(self, "primary_contact")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def publisher(self) -> pulumi.Output['outputs.PublisherResponse']:
        """
        Optional. Details of the publisher who owns the listing and who can share the source data.
        """
        return pulumi.get(self, "publisher")

    @property
    @pulumi.getter(name="requestAccess")
    def request_access(self) -> pulumi.Output[str]:
        """
        Optional. Email or URL of the request access of the listing. Subscribers can use this reference to request access. Max Length: 1000 bytes.
        """
        return pulumi.get(self, "request_access")

    @property
    @pulumi.getter(name="restrictedExportConfig")
    def restricted_export_config(self) -> pulumi.Output['outputs.RestrictedExportConfigResponse']:
        """
        Optional. If set, restricted export configuration will be propagated and enforced on the linked dataset.
        """
        return pulumi.get(self, "restricted_export_config")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        Current state of the listing.
        """
        return pulumi.get(self, "state")

