# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'GetAuthorizedOrgsDescResult',
    'AwaitableGetAuthorizedOrgsDescResult',
    'get_authorized_orgs_desc',
    'get_authorized_orgs_desc_output',
]

@pulumi.output_type
class GetAuthorizedOrgsDescResult:
    def __init__(__self__, asset_type=None, authorization_direction=None, authorization_type=None, name=None, orgs=None):
        if asset_type and not isinstance(asset_type, str):
            raise TypeError("Expected argument 'asset_type' to be a str")
        pulumi.set(__self__, "asset_type", asset_type)
        if authorization_direction and not isinstance(authorization_direction, str):
            raise TypeError("Expected argument 'authorization_direction' to be a str")
        pulumi.set(__self__, "authorization_direction", authorization_direction)
        if authorization_type and not isinstance(authorization_type, str):
            raise TypeError("Expected argument 'authorization_type' to be a str")
        pulumi.set(__self__, "authorization_type", authorization_type)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if orgs and not isinstance(orgs, list):
            raise TypeError("Expected argument 'orgs' to be a list")
        pulumi.set(__self__, "orgs", orgs)

    @property
    @pulumi.getter(name="assetType")
    def asset_type(self) -> str:
        """
        The asset type of this authorized orgs desc. Valid values are `ASSET_TYPE_DEVICE`, and `ASSET_TYPE_CREDENTIAL_STRENGTH`.
        """
        return pulumi.get(self, "asset_type")

    @property
    @pulumi.getter(name="authorizationDirection")
    def authorization_direction(self) -> str:
        """
        The direction of the authorization relationship between this organization and the organizations listed in the `orgs` field. The valid values for this field include the following: `AUTHORIZATION_DIRECTION_FROM`: Allows this organization to evaluate traffic in the organizations listed in the `orgs` field. `AUTHORIZATION_DIRECTION_TO`: Allows the organizations listed in the `orgs` field to evaluate the traffic in this organization. For the authorization relationship to take effect, all of the organizations must authorize and specify the appropriate relationship direction. For example, if organization A authorized organization B and C to evaluate its traffic, by specifying `AUTHORIZATION_DIRECTION_TO` as the authorization direction, organizations B and C must specify `AUTHORIZATION_DIRECTION_FROM` as the authorization direction in their `AuthorizedOrgsDesc` resource.
        """
        return pulumi.get(self, "authorization_direction")

    @property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> str:
        """
        A granular control type for authorization levels. Valid value is `AUTHORIZATION_TYPE_TRUST`.
        """
        return pulumi.get(self, "authorization_type")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name for the `AuthorizedOrgsDesc`. Format: `accessPolicies/{access_policy}/authorizedOrgsDescs/{authorized_orgs_desc}`. The `authorized_orgs_desc` component must begin with a letter, followed by alphanumeric characters or `_`. After you create an `AuthorizedOrgsDesc`, you cannot change its `name`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def orgs(self) -> Sequence[str]:
        """
        The list of organization ids in this AuthorizedOrgsDesc. Format: `organizations/` Example: `organizations/123456`
        """
        return pulumi.get(self, "orgs")


class AwaitableGetAuthorizedOrgsDescResult(GetAuthorizedOrgsDescResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAuthorizedOrgsDescResult(
            asset_type=self.asset_type,
            authorization_direction=self.authorization_direction,
            authorization_type=self.authorization_type,
            name=self.name,
            orgs=self.orgs)


def get_authorized_orgs_desc(access_policy_id: Optional[str] = None,
                             authorized_orgs_desc_id: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAuthorizedOrgsDescResult:
    """
    Gets an authorized orgs desc based on the resource name.
    """
    __args__ = dict()
    __args__['accessPolicyId'] = access_policy_id
    __args__['authorizedOrgsDescId'] = authorized_orgs_desc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:accesscontextmanager/v1:getAuthorizedOrgsDesc', __args__, opts=opts, typ=GetAuthorizedOrgsDescResult).value

    return AwaitableGetAuthorizedOrgsDescResult(
        asset_type=__ret__.asset_type,
        authorization_direction=__ret__.authorization_direction,
        authorization_type=__ret__.authorization_type,
        name=__ret__.name,
        orgs=__ret__.orgs)


@_utilities.lift_output_func(get_authorized_orgs_desc)
def get_authorized_orgs_desc_output(access_policy_id: Optional[pulumi.Input[str]] = None,
                                    authorized_orgs_desc_id: Optional[pulumi.Input[str]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAuthorizedOrgsDescResult]:
    """
    Gets an authorized orgs desc based on the resource name.
    """
    ...
