# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = ['AuthorizedOrgsDescArgs', 'AuthorizedOrgsDesc']

@pulumi.input_type
class AuthorizedOrgsDescArgs:
    def __init__(__self__, *,
                 access_policy_id: pulumi.Input[str],
                 asset_type: Optional[pulumi.Input['AuthorizedOrgsDescAssetType']] = None,
                 authorization_direction: Optional[pulumi.Input['AuthorizedOrgsDescAuthorizationDirection']] = None,
                 authorization_type: Optional[pulumi.Input['AuthorizedOrgsDescAuthorizationType']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 orgs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a AuthorizedOrgsDesc resource.
        :param pulumi.Input['AuthorizedOrgsDescAssetType'] asset_type: The asset type of this authorized orgs desc. Valid values are `ASSET_TYPE_DEVICE`, and `ASSET_TYPE_CREDENTIAL_STRENGTH`.
        :param pulumi.Input['AuthorizedOrgsDescAuthorizationDirection'] authorization_direction: The direction of the authorization relationship between this organization and the organizations listed in the `orgs` field. The valid values for this field include the following: `AUTHORIZATION_DIRECTION_FROM`: Allows this organization to evaluate traffic in the organizations listed in the `orgs` field. `AUTHORIZATION_DIRECTION_TO`: Allows the organizations listed in the `orgs` field to evaluate the traffic in this organization. For the authorization relationship to take effect, all of the organizations must authorize and specify the appropriate relationship direction. For example, if organization A authorized organization B and C to evaluate its traffic, by specifying `AUTHORIZATION_DIRECTION_TO` as the authorization direction, organizations B and C must specify `AUTHORIZATION_DIRECTION_FROM` as the authorization direction in their `AuthorizedOrgsDesc` resource.
        :param pulumi.Input['AuthorizedOrgsDescAuthorizationType'] authorization_type: A granular control type for authorization levels. Valid value is `AUTHORIZATION_TYPE_TRUST`.
        :param pulumi.Input[str] name: Resource name for the `AuthorizedOrgsDesc`. Format: `accessPolicies/{access_policy}/authorizedOrgsDescs/{authorized_orgs_desc}`. The `authorized_orgs_desc` component must begin with a letter, followed by alphanumeric characters or `_`. After you create an `AuthorizedOrgsDesc`, you cannot change its `name`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] orgs: The list of organization ids in this AuthorizedOrgsDesc. Format: `organizations/` Example: `organizations/123456`
        """
        pulumi.set(__self__, "access_policy_id", access_policy_id)
        if asset_type is not None:
            pulumi.set(__self__, "asset_type", asset_type)
        if authorization_direction is not None:
            pulumi.set(__self__, "authorization_direction", authorization_direction)
        if authorization_type is not None:
            pulumi.set(__self__, "authorization_type", authorization_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if orgs is not None:
            pulumi.set(__self__, "orgs", orgs)

    @property
    @pulumi.getter(name="accessPolicyId")
    def access_policy_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "access_policy_id")

    @access_policy_id.setter
    def access_policy_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "access_policy_id", value)

    @property
    @pulumi.getter(name="assetType")
    def asset_type(self) -> Optional[pulumi.Input['AuthorizedOrgsDescAssetType']]:
        """
        The asset type of this authorized orgs desc. Valid values are `ASSET_TYPE_DEVICE`, and `ASSET_TYPE_CREDENTIAL_STRENGTH`.
        """
        return pulumi.get(self, "asset_type")

    @asset_type.setter
    def asset_type(self, value: Optional[pulumi.Input['AuthorizedOrgsDescAssetType']]):
        pulumi.set(self, "asset_type", value)

    @property
    @pulumi.getter(name="authorizationDirection")
    def authorization_direction(self) -> Optional[pulumi.Input['AuthorizedOrgsDescAuthorizationDirection']]:
        """
        The direction of the authorization relationship between this organization and the organizations listed in the `orgs` field. The valid values for this field include the following: `AUTHORIZATION_DIRECTION_FROM`: Allows this organization to evaluate traffic in the organizations listed in the `orgs` field. `AUTHORIZATION_DIRECTION_TO`: Allows the organizations listed in the `orgs` field to evaluate the traffic in this organization. For the authorization relationship to take effect, all of the organizations must authorize and specify the appropriate relationship direction. For example, if organization A authorized organization B and C to evaluate its traffic, by specifying `AUTHORIZATION_DIRECTION_TO` as the authorization direction, organizations B and C must specify `AUTHORIZATION_DIRECTION_FROM` as the authorization direction in their `AuthorizedOrgsDesc` resource.
        """
        return pulumi.get(self, "authorization_direction")

    @authorization_direction.setter
    def authorization_direction(self, value: Optional[pulumi.Input['AuthorizedOrgsDescAuthorizationDirection']]):
        pulumi.set(self, "authorization_direction", value)

    @property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> Optional[pulumi.Input['AuthorizedOrgsDescAuthorizationType']]:
        """
        A granular control type for authorization levels. Valid value is `AUTHORIZATION_TYPE_TRUST`.
        """
        return pulumi.get(self, "authorization_type")

    @authorization_type.setter
    def authorization_type(self, value: Optional[pulumi.Input['AuthorizedOrgsDescAuthorizationType']]):
        pulumi.set(self, "authorization_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource name for the `AuthorizedOrgsDesc`. Format: `accessPolicies/{access_policy}/authorizedOrgsDescs/{authorized_orgs_desc}`. The `authorized_orgs_desc` component must begin with a letter, followed by alphanumeric characters or `_`. After you create an `AuthorizedOrgsDesc`, you cannot change its `name`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def orgs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of organization ids in this AuthorizedOrgsDesc. Format: `organizations/` Example: `organizations/123456`
        """
        return pulumi.get(self, "orgs")

    @orgs.setter
    def orgs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "orgs", value)


class AuthorizedOrgsDesc(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_policy_id: Optional[pulumi.Input[str]] = None,
                 asset_type: Optional[pulumi.Input['AuthorizedOrgsDescAssetType']] = None,
                 authorization_direction: Optional[pulumi.Input['AuthorizedOrgsDescAuthorizationDirection']] = None,
                 authorization_type: Optional[pulumi.Input['AuthorizedOrgsDescAuthorizationType']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 orgs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Creates an authorized orgs desc. The long-running operation from this RPC has a successful status after the authorized orgs desc propagates to long-lasting storage. If a authorized orgs desc contains errors, an error response is returned for the first error encountered. The name of this `AuthorizedOrgsDesc` will be assigned during creation.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input['AuthorizedOrgsDescAssetType'] asset_type: The asset type of this authorized orgs desc. Valid values are `ASSET_TYPE_DEVICE`, and `ASSET_TYPE_CREDENTIAL_STRENGTH`.
        :param pulumi.Input['AuthorizedOrgsDescAuthorizationDirection'] authorization_direction: The direction of the authorization relationship between this organization and the organizations listed in the `orgs` field. The valid values for this field include the following: `AUTHORIZATION_DIRECTION_FROM`: Allows this organization to evaluate traffic in the organizations listed in the `orgs` field. `AUTHORIZATION_DIRECTION_TO`: Allows the organizations listed in the `orgs` field to evaluate the traffic in this organization. For the authorization relationship to take effect, all of the organizations must authorize and specify the appropriate relationship direction. For example, if organization A authorized organization B and C to evaluate its traffic, by specifying `AUTHORIZATION_DIRECTION_TO` as the authorization direction, organizations B and C must specify `AUTHORIZATION_DIRECTION_FROM` as the authorization direction in their `AuthorizedOrgsDesc` resource.
        :param pulumi.Input['AuthorizedOrgsDescAuthorizationType'] authorization_type: A granular control type for authorization levels. Valid value is `AUTHORIZATION_TYPE_TRUST`.
        :param pulumi.Input[str] name: Resource name for the `AuthorizedOrgsDesc`. Format: `accessPolicies/{access_policy}/authorizedOrgsDescs/{authorized_orgs_desc}`. The `authorized_orgs_desc` component must begin with a letter, followed by alphanumeric characters or `_`. After you create an `AuthorizedOrgsDesc`, you cannot change its `name`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] orgs: The list of organization ids in this AuthorizedOrgsDesc. Format: `organizations/` Example: `organizations/123456`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuthorizedOrgsDescArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates an authorized orgs desc. The long-running operation from this RPC has a successful status after the authorized orgs desc propagates to long-lasting storage. If a authorized orgs desc contains errors, an error response is returned for the first error encountered. The name of this `AuthorizedOrgsDesc` will be assigned during creation.

        :param str resource_name: The name of the resource.
        :param AuthorizedOrgsDescArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthorizedOrgsDescArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_policy_id: Optional[pulumi.Input[str]] = None,
                 asset_type: Optional[pulumi.Input['AuthorizedOrgsDescAssetType']] = None,
                 authorization_direction: Optional[pulumi.Input['AuthorizedOrgsDescAuthorizationDirection']] = None,
                 authorization_type: Optional[pulumi.Input['AuthorizedOrgsDescAuthorizationType']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 orgs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthorizedOrgsDescArgs.__new__(AuthorizedOrgsDescArgs)

            if access_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'access_policy_id'")
            __props__.__dict__["access_policy_id"] = access_policy_id
            __props__.__dict__["asset_type"] = asset_type
            __props__.__dict__["authorization_direction"] = authorization_direction
            __props__.__dict__["authorization_type"] = authorization_type
            __props__.__dict__["name"] = name
            __props__.__dict__["orgs"] = orgs
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["access_policy_id"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(AuthorizedOrgsDesc, __self__).__init__(
            'google-native:accesscontextmanager/v1:AuthorizedOrgsDesc',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'AuthorizedOrgsDesc':
        """
        Get an existing AuthorizedOrgsDesc resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = AuthorizedOrgsDescArgs.__new__(AuthorizedOrgsDescArgs)

        __props__.__dict__["access_policy_id"] = None
        __props__.__dict__["asset_type"] = None
        __props__.__dict__["authorization_direction"] = None
        __props__.__dict__["authorization_type"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["orgs"] = None
        return AuthorizedOrgsDesc(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessPolicyId")
    def access_policy_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "access_policy_id")

    @property
    @pulumi.getter(name="assetType")
    def asset_type(self) -> pulumi.Output[str]:
        """
        The asset type of this authorized orgs desc. Valid values are `ASSET_TYPE_DEVICE`, and `ASSET_TYPE_CREDENTIAL_STRENGTH`.
        """
        return pulumi.get(self, "asset_type")

    @property
    @pulumi.getter(name="authorizationDirection")
    def authorization_direction(self) -> pulumi.Output[str]:
        """
        The direction of the authorization relationship between this organization and the organizations listed in the `orgs` field. The valid values for this field include the following: `AUTHORIZATION_DIRECTION_FROM`: Allows this organization to evaluate traffic in the organizations listed in the `orgs` field. `AUTHORIZATION_DIRECTION_TO`: Allows the organizations listed in the `orgs` field to evaluate the traffic in this organization. For the authorization relationship to take effect, all of the organizations must authorize and specify the appropriate relationship direction. For example, if organization A authorized organization B and C to evaluate its traffic, by specifying `AUTHORIZATION_DIRECTION_TO` as the authorization direction, organizations B and C must specify `AUTHORIZATION_DIRECTION_FROM` as the authorization direction in their `AuthorizedOrgsDesc` resource.
        """
        return pulumi.get(self, "authorization_direction")

    @property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> pulumi.Output[str]:
        """
        A granular control type for authorization levels. Valid value is `AUTHORIZATION_TYPE_TRUST`.
        """
        return pulumi.get(self, "authorization_type")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Resource name for the `AuthorizedOrgsDesc`. Format: `accessPolicies/{access_policy}/authorizedOrgsDescs/{authorized_orgs_desc}`. The `authorized_orgs_desc` component must begin with a letter, followed by alphanumeric characters or `_`. After you create an `AuthorizedOrgsDesc`, you cannot change its `name`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def orgs(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of organization ids in this AuthorizedOrgsDesc. Format: `organizations/` Example: `organizations/123456`
        """
        return pulumi.get(self, "orgs")

