# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/utils.ipynb (unless otherwise specified).

__all__ = ['free_gpu_memory', 'less_random']

# Cell
import torch, random, gc
import numpy as np
from fastai.learner import Learner
from fastai.data.core import DataLoaders
from fastcore.foundation import contextmanager
from fastai.callback.core import set_random_states, get_random_states

# Cell
def free_gpu_memory(learn:Learner, dls:DataLoaders=None):
    "Frees GPU memory using `gc.collect` and `torch.cuda.empty_cache`"
    learn.dls, learn, dls = None, None, None
    gc.collect()
    torch.cuda.empty_cache()

# Cell
@contextmanager
def less_random(seed=42, deterministic=True):
    "Stores and retrieves state of random number generators. Sets random seed for `random`, `torch`, and `numpy`. Does not set `torch.backends.cudnn.benchmark = False`"
    states = get_random_states()

    try: torch.manual_seed(seed)
    except NameError: pass
    try: torch.cuda.manual_seed_all(seed)
    except NameError: pass
    try: np.random.seed(seed%(2**32-1))
    except NameError: pass
    random.seed(seed)
    if deterministic:
        torch.backends.cudnn.deterministic = True
        torch.backends.cudnn.benchmark = True
    try:
        yield #we are managing global variables
    finally:
        set_random_states(**states)