import { SecurityGroup } from "@pepperize/cdk-security-group";
import { CloudFormationInit, IMachineImage, InstanceType, UserData } from "aws-cdk-lib/aws-ec2";
import { IRole } from "aws-cdk-lib/aws-iam";
import { IBucket } from "aws-cdk-lib/aws-s3";
import { Construct } from "constructs";
import { GlobalConfiguration } from "../runner-configuration";
import { GitlabRunnerAutoscalingJobRunner } from "./job-runner";
import { Network } from "./network";
export interface GitlabRunnerAutoscalingManagerBaseProps {
    /**
     * An Amazon Machine Image ID for the Manager EC2 instance. If empty the latest Amazon 2 Image will be looked up.
     *
     * Should be RHEL flavor like Amazon Linux 2 with yum available for instance initialization.
     *
     * @see https://cloudinit.readthedocs.io/en/latest/
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-init.html
     */
    readonly machineImage?: IMachineImage;
    /**
     * Instance type for manager EC2 instance. It's a combination of a class and size.
     * @default InstanceType.of(InstanceClass.T3, InstanceSize.NANO)
     */
    readonly instanceType?: InstanceType;
    /**
     * A set of security credentials that you use to prove your identity when connecting to an Amazon EC2 instance. You won't be able to ssh into an instance without the Key Pair.
     */
    readonly keyPairName?: string;
}
export interface GitlabRunnerAutoscalingManagerProps extends GitlabRunnerAutoscalingManagerBaseProps {
    readonly globalConfiguration?: GlobalConfiguration;
    readonly runners: GitlabRunnerAutoscalingJobRunner[];
    readonly network: Network;
    readonly cacheBucket: IBucket;
    readonly role?: IRole;
    readonly runnersSecurityGroup: SecurityGroup;
}
/**
 * Settings for the manager (coordinator)
 *
 *  Manager coordinates the placement of runner (job executor) instances
 */
export declare class GitlabRunnerAutoscalingManager extends Construct {
    readonly machineImage: IMachineImage;
    readonly instanceType: InstanceType;
    readonly keyPairName?: string;
    readonly runners: GitlabRunnerAutoscalingJobRunner[];
    readonly network: Network;
    readonly runnersSecurityGroupName: string;
    readonly role: IRole;
    readonly initConfig: CloudFormationInit;
    readonly userData: UserData;
    readonly cacheBucket: IBucket;
    readonly globalConfiguration: GlobalConfiguration;
    constructor(scope: Construct, id: string, props: GitlabRunnerAutoscalingManagerProps);
}
