# dagshub-api
The api docs are made with SwaggerUI using the OpenAPI 3 specification. 

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0.1
- Package version: 1.0.1
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/DagsHub/api-clients.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/DagsHub/api-clients.git`)

Then import the package:
```python
import dagshub_api 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import dagshub_api
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import dagshub_api
from dagshub_api.rest import ApiException
from pprint import pprint
# Configure HTTP basic authorization: basicAuth
configuration = dagshub_api.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'
# Configure API key authorization: tokenAuth
configuration = dagshub_api.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = dagshub_api.BranchesApi(dagshub_api.ApiClient(configuration))
owner = 'owner_example' # str | owner of the repository
repo = 'repo_example' # str | name of the repository
branch = 'branch_example' # str | branch of the repository

try:
    # Get Branch
    api_instance.get_branch(owner, repo, branch)
except ApiException as e:
    print("Exception when calling BranchesApi->get_branch: %s\n" % e)
# Configure HTTP basic authorization: basicAuth
configuration = dagshub_api.Configuration()
configuration.username = 'YOUR_USERNAME'
configuration.password = 'YOUR_PASSWORD'
# Configure API key authorization: tokenAuth
configuration = dagshub_api.Configuration()
configuration.api_key['token'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['token'] = 'Bearer'

# create an instance of the API class
api_instance = dagshub_api.BranchesApi(dagshub_api.ApiClient(configuration))
owner = 'owner_example' # str | owner of the repository
repo = 'repo_example' # str | name of the repository

try:
    # List Branches
    api_instance.list_branches(owner, repo)
except ApiException as e:
    print("Exception when calling BranchesApi->list_branches: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://dagshub.com/api/v1/*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*BranchesApi* | [**get_branch**](docs/BranchesApi.md#get_branch) | **GET** /repos/{owner}/{repo}/branches/{branch} | Get Branch
*BranchesApi* | [**list_branches**](docs/BranchesApi.md#list_branches) | **GET** /repos/{owner}/{repo}/branches | List Branches
*CollaboratorsApi* | [**add_collaborator**](docs/CollaboratorsApi.md#add_collaborator) | **PUT** /repos/{username}/{repo}/collaborators/{collaborator} | Add user as a collaborator
*CollaboratorsApi* | [**get_collaborators**](docs/CollaboratorsApi.md#get_collaborators) | **GET** /repos/{username}/{repo}/collaborators | Get collaborators
*CollaboratorsApi* | [**remove_collaborator**](docs/CollaboratorsApi.md#remove_collaborator) | **DELETE** /repos/{username}/{repo}/collaborators/{collaborator} | Delete collaborator
*CommitsApi* | [**get_commit**](docs/CommitsApi.md#get_commit) | **GET** /repos/{owner}/{repo}/commits/{sha} | Get a single commit
*CommitsApi* | [**get_commit_sha1**](docs/CommitsApi.md#get_commit_sha1) | **GET** /repos/{owner}/{repo}/commits/{ref} | Get the SHA-1 of a commit reference
*ContentApi* | [**get_archive**](docs/ContentApi.md#get_archive) | **GET** /repos/{username}/{repo}/archive/{ref}/{format} | Download archive
*ContentApi* | [**get_raw**](docs/ContentApi.md#get_raw) | **GET** /repos/{username}/{repo}/raw/{ref}/{path} | Download raw content
*IssuesApi* | [**create_issue**](docs/IssuesApi.md#create_issue) | **POST** /repos/{owner}/{repo}/issues | Create an issue
*IssuesApi* | [**edit_issue**](docs/IssuesApi.md#edit_issue) | **PATCH** /repos/{owner}/{repo}/issues | Edit an issue
*IssuesApi* | [**get_issue**](docs/IssuesApi.md#get_issue) | **GET** /repos/{owner}/{repo}/issues/{index} | Get a single issue
*IssuesApi* | [**list_repo_issues**](docs/IssuesApi.md#list_repo_issues) | **GET** /repos/{owner}/{repo}/issues | List issues for a repository
*ReleasesApi* | [**list_releases**](docs/ReleasesApi.md#list_releases) | **GET** /repos/{owner}/{repo}/releases | List Releases
*RepositoryApi* | [**create_org_repo**](docs/RepositoryApi.md#create_org_repo) | **POST** /org/{orgname}/repos | Create in organization
*RepositoryApi* | [**create_repo**](docs/RepositoryApi.md#create_repo) | **POST** /user/repos | Create
*RepositoryApi* | [**list_my_repos**](docs/RepositoryApi.md#list_my_repos) | **GET** /user/repos | List your repositories
*RepositoryApi* | [**list_org_repos**](docs/RepositoryApi.md#list_org_repos) | **GET** /orgs/{orgname}/repos | List organization repositories
*RepositoryApi* | [**list_user_repos**](docs/RepositoryApi.md#list_user_repos) | **GET** /users/{username}/repos | List user repositories
*RepositoryApi* | [**migrate_repo**](docs/RepositoryApi.md#migrate_repo) | **POST** /repos/migrate | Migrate repository
*RepositoryApi* | [**search**](docs/RepositoryApi.md#search) | **GET** /repos/search | Search repositories
*WebhooksApi* | [**create_hook**](docs/WebhooksApi.md#create_hook) | **POST** /repos/{owner}/{repo}/hooks | Create a hook
*WebhooksApi* | [**delete_hook**](docs/WebhooksApi.md#delete_hook) | **DELETE** /repos/{owner}/{repo}/hooks/{id} | Delete a hook
*WebhooksApi* | [**edit_hook**](docs/WebhooksApi.md#edit_hook) | **PATCH** /repos/{owner}/{repo}/hooks/{id} | Edit a hook
*WebhooksApi* | [**list_hooks**](docs/WebhooksApi.md#list_hooks) | **GET** /repos/{owner}/{repo}/hooks | List hooks

## Documentation For Models

 - [Assignee](docs/Assignee.md)
 - [Body](docs/Body.md)
 - [Closed](docs/Closed.md)
 - [CollaboratorsCollaboratorBody](docs/CollaboratorsCollaboratorBody.md)
 - [CreateRepo](docs/CreateRepo.md)
 - [HooksIdBody](docs/HooksIdBody.md)
 - [Issue](docs/Issue.md)
 - [IssueAssignee](docs/IssueAssignee.md)
 - [IssueLabels](docs/IssueLabels.md)
 - [IssueMilestone](docs/IssueMilestone.md)
 - [Issues](docs/Issues.md)
 - [Labels](docs/Labels.md)
 - [MigrateRepo](docs/MigrateRepo.md)
 - [Milestone](docs/Milestone.md)
 - [PatchIssue](docs/PatchIssue.md)
 - [PostIssue](docs/PostIssue.md)
 - [RepoHooksBody](docs/RepoHooksBody.md)
 - [State](docs/State.md)
 - [Title](docs/Title.md)
 - [User](docs/User.md)
 - [WebhookConfig](docs/WebhookConfig.md)
 - [WebhookEvents](docs/WebhookEvents.md)

## Documentation For Authorization


## basicAuth

- **Type**: HTTP basic authentication

## tokenAuth

- **Type**: API key
- **API key parameter name**: token
- **Location**: URL query string


## Author


