# coding: utf-8

"""
    FlashBlade REST API

    A lightweight client for FlashBlade REST API 2.3, developed by Pure Storage, Inc. (http://www.purestorage.com/).

    OpenAPI spec version: 2.3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re

import six
import typing

from ....properties import Property
if typing.TYPE_CHECKING:
    from pypureclient.flashblade.FB_2_3 import models

class AdminSetting(object):
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'lockout_duration': 'int',
        'max_login_attempts': 'int',
        'min_password_length': 'int'
    }

    attribute_map = {
        'lockout_duration': 'lockout_duration',
        'max_login_attempts': 'max_login_attempts',
        'min_password_length': 'min_password_length'
    }

    required_args = {
    }

    def __init__(
        self,
        lockout_duration=None,  # type: int
        max_login_attempts=None,  # type: int
        min_password_length=None,  # type: int
    ):
        """
        Keyword args:
            lockout_duration (int): The lockout duration, in milliseconds, if a user has reached the maximum number of login attempts. Ranges from 1 second to 90 days. Default value is `null`. Use 0 to reset the value to `null`.
            max_login_attempts (int): The maximum number of failed login attempts allowed before the user is locked out. Default value is `null`. Use 0 to reset the value to `null`.
            min_password_length (int): The minimum password length. If not specified, defaults to 1 character.
        """
        if lockout_duration is not None:
            self.lockout_duration = lockout_duration
        if max_login_attempts is not None:
            self.max_login_attempts = max_login_attempts
        if min_password_length is not None:
            self.min_password_length = min_password_length

    def __setattr__(self, key, value):
        if key not in self.attribute_map:
            raise KeyError("Invalid key `{}` for `AdminSetting`".format(key))
        if key == "lockout_duration" and value is not None:
            if value > 7776000000:
                raise ValueError("Invalid value for `lockout_duration`, value must be less than or equal to `7776000000`")
            if value < 0:
                raise ValueError("Invalid value for `lockout_duration`, must be a value greater than or equal to `0`")
        if key == "max_login_attempts" and value is not None:
            if value > 100:
                raise ValueError("Invalid value for `max_login_attempts`, value must be less than or equal to `100`")
            if value < 0:
                raise ValueError("Invalid value for `max_login_attempts`, must be a value greater than or equal to `0`")
        if key == "min_password_length" and value is not None:
            if value > 100:
                raise ValueError("Invalid value for `min_password_length`, value must be less than or equal to `100`")
            if value < 1:
                raise ValueError("Invalid value for `min_password_length`, must be a value greater than or equal to `1`")
        self.__dict__[key] = value

    def __getattribute__(self, item):
        value = object.__getattribute__(self, item)
        if isinstance(value, Property):
            return None
        else:
            return value

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            if hasattr(self, attr):
                value = getattr(self, attr)
                if isinstance(value, list):
                    result[attr] = list(map(
                        lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                        value
                    ))
                elif hasattr(value, "to_dict"):
                    result[attr] = value.to_dict()
                elif isinstance(value, dict):
                    result[attr] = dict(map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict") else item,
                        value.items()
                    ))
                else:
                    result[attr] = value
        if issubclass(AdminSetting, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AdminSetting):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
