"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AfterCreate = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const core_1 = require("@aws-cdk/core");
/**
 * @stability stable
 */
class AfterCreate extends core_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        const provider = core_1.CustomResourceProvider.getOrCreateProvider(this, 'AWSCDK.TriggerCustomResourceProvider', {
            runtime: core_1.CustomResourceProviderRuntime.NODEJS_14_X,
            codeDirectory: path_1.join(__dirname, 'handler'),
            policyStatements: [
                {
                    Effect: 'Allow',
                    Action: ['lambda:InvokeFunction'],
                    Resource: ['*'],
                },
            ],
        });
        const resource = new core_1.CustomResource(this, 'Resource', {
            resourceType: 'Custom::Trigger',
            serviceToken: provider.serviceToken,
            properties: {
                HandlerArn: props.handler.functionArn,
            },
        });
        // add a dependency between our resource and the resources we want to invoke
        // after.
        resource.node.addDependency(...(_b = props.resources) !== null && _b !== void 0 ? _b : []);
    }
}
exports.AfterCreate = AfterCreate;
_a = JSII_RTTI_SYMBOL_1;
AfterCreate[_a] = { fqn: "cdk-triggers.AfterCreate", version: "0.0.53" };
//# sourceMappingURL=data:application/json;base64,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