import re


async def load_bios_info(hub):
    biosinfo = await hub.exec.wmi.get("Win32_BIOS", 0)

    # bios name had a bunch of whitespace appended to it in my testing
    # 'PhoenixBIOS 4.0 Release 6.0     '
    hub.corn.CORN.biosversion = await hub.corn.init.clean_value(
        "biosversion", biosinfo.Name.strip()
    )
    hub.corn.CORN.serialnumber = await hub.corn.init.clean_value(
        "serialnumber", biosinfo.SerialNumber
    )
