import sys
import subprocess

def get_version():
    # VERSION.txt gets generated by the CI
    # This is used on pip install
    try:
        with open('VERSION.txt', 'r') as version_file:
            return version_file.read()
    except IOError:
        # Use version from git
        pass

    # Uses latest git tag on local dev branch
    result = subprocess.run(['git', 'describe', '--tags'], stdout=subprocess.PIPE, stderr=subprocess.PIPE)
    if result.returncode != 0:
        print(result.stderr.decode('utf-8'), file=sys.stderr)
        raise RuntimeError('Could not get version from git')
    return result.stdout.decode('utf-8').strip()
