# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator (autorest: 3.0.6320, generator: {generator})
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._simulator_api_enums import *


class EpisodeFinish(msrest.serialization.Model):
    """EpisodeFinish event signalling current episode is finished.

    :param reason: Reason for episodeFinish. Possible values include: "Invalid", "Unspecified",
     "LessonChanged", "Terminal", "Interrupted", "InvalidStateValue", "InternalError",
     "EpisodeComplete", "TrainingComplete".
    :type reason: str or ~microsoft_bonsai_api.simulator.generated.models.EpisodeFinishReason
    """

    _attribute_map = {
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(
        self, *, reason: Optional[Union[str, "EpisodeFinishReason"]] = None, **kwargs
    ):
        super(EpisodeFinish, self).__init__(**kwargs)
        self.reason = reason


class EpisodeStart(msrest.serialization.Model):
    """EpisodeStart event. It's sent when a new episode need to be started.

    :param config: Initial configuration of simulation for starting an episode.
    :type config: object
    """

    _attribute_map = {
        "config": {"key": "config", "type": "object"},
    }

    def __init__(self, *, config: Optional[object] = None, **kwargs):
        super(EpisodeStart, self).__init__(**kwargs)
        self.config = config


class EpisodeStep(msrest.serialization.Model):
    """EpisodeStep event for stepping inthe simulation. this is sent when there is an ongoing active episode.

    :param action: action decided by RL agent.null use this action to advance from current state of
     simulator.
    :type action: object
    """

    _attribute_map = {
        "action": {"key": "action", "type": "object"},
    }

    def __init__(self, *, action: Optional[object] = None, **kwargs):
        super(EpisodeStep, self).__init__(**kwargs)
        self.action = action


class Event(msrest.serialization.Model):
    """RL action returned by bonsai platform when it got new state from simulator session.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of Event as response to advance method. Possible values include:
     "Unspecified", "EpisodeStart", "EpisodeStep", "EpisodeFinish", "Idle", "Unregister".
    :type type: str or ~microsoft_bonsai_api.simulator.generated.models.EventType
    :param session_id: Required. unique session id.
    :type session_id: str
    :param sequence_id: Required. Always startes with 1, and Bonsai platform increment it at each
     Step event in advance operation.static
     Always just return the sequenceId returned by previous advance operation response.
    :type sequence_id: int
    :param episode_start: EpisodeStart event. It's sent when a new episode need to be started.
    :type episode_start: ~microsoft_bonsai_api.simulator.generated.models.EpisodeStart
    :param episode_step: EpisodeStep event for stepping inthe simulation. this is sent when there
     is an ongoing active episode.
    :type episode_step: ~microsoft_bonsai_api.simulator.generated.models.EpisodeStep
    :param episode_finish: EpisodeFinish event signalling current episode is finished.
    :type episode_finish: ~microsoft_bonsai_api.simulator.generated.models.EpisodeFinish
    :param idle: Idle Event.null It means, that no RL action was yet available for this session.
    :type idle: ~microsoft_bonsai_api.simulator.generated.models.Idle
    :param unregister: Event notifying the simulator that its session has been deleted.
     If you want to continue training with this simulator, you must create a new session.
    :type unregister: ~microsoft_bonsai_api.simulator.generated.models.Unregister
    """

    _validation = {
        "type": {"required": True},
        "session_id": {"required": True},
        "sequence_id": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "session_id": {"key": "sessionId", "type": "str"},
        "sequence_id": {"key": "sequenceId", "type": "int"},
        "episode_start": {"key": "episodeStart", "type": "EpisodeStart"},
        "episode_step": {"key": "episodeStep", "type": "EpisodeStep"},
        "episode_finish": {"key": "episodeFinish", "type": "EpisodeFinish"},
        "idle": {"key": "idle", "type": "Idle"},
        "unregister": {"key": "unregister", "type": "Unregister"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "EventType"],
        session_id: str,
        sequence_id: int,
        episode_start: Optional["EpisodeStart"] = None,
        episode_step: Optional["EpisodeStep"] = None,
        episode_finish: Optional["EpisodeFinish"] = None,
        idle: Optional["Idle"] = None,
        unregister: Optional["Unregister"] = None,
        **kwargs
    ):
        super(Event, self).__init__(**kwargs)
        self.type = type
        self.session_id = session_id
        self.sequence_id = sequence_id
        self.episode_start = episode_start
        self.episode_step = episode_step
        self.episode_finish = episode_finish
        self.idle = idle
        self.unregister = unregister


class Idle(msrest.serialization.Model):
    """Idle Event.null It means, that no RL action was yet available for this session.

    :param callback_time: callback time in seconds. this mean,s you should wait for this much time
     before sending a new advance request.
    :type callback_time: float
    """

    _attribute_map = {
        "callback_time": {"key": "callbackTime", "type": "float"},
    }

    def __init__(self, *, callback_time: Optional[float] = None, **kwargs):
        super(Idle, self).__init__(**kwargs)
        self.callback_time = callback_time


class ProblemDetails(msrest.serialization.Model):
    """ProblemDetails.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param type:
    :type type: str
    :param title:
    :type title: str
    :param status:
    :type status: int
    :param detail:
    :type detail: str
    :param instance:
    :type instance: str
    :ivar extensions: Dictionary of :code:`<any>`.
    :vartype extensions: dict[str, object]
    """

    _validation = {
        "extensions": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "title": {"key": "title", "type": "str"},
        "status": {"key": "status", "type": "int"},
        "detail": {"key": "detail", "type": "str"},
        "instance": {"key": "instance", "type": "str"},
        "extensions": {"key": "extensions", "type": "{object}"},
    }

    def __init__(
        self,
        *,
        type: Optional[str] = None,
        title: Optional[str] = None,
        status: Optional[int] = None,
        detail: Optional[str] = None,
        instance: Optional[str] = None,
        **kwargs
    ):
        super(ProblemDetails, self).__init__(**kwargs)
        self.type = type
        self.title = title
        self.status = status
        self.detail = detail
        self.instance = instance
        self.extensions = None


class Purpose(msrest.serialization.Model):
    """The purpose for existing, from the standpoint of a simulator instance or
    brain version.

        :param action:  Possible values include: "Inactive", "Debug", "Train", "Assess".
        :type action: str or ~microsoft_bonsai_api.simulator.generated.models.PurposeTypesAction
        :param target: This structure describes the "target" of the simulator;
         i.e., what trainable construct(s) it exists to service.
        :type target: ~microsoft_bonsai_api.simulator.generated.models.PurposeTarget
    """

    _attribute_map = {
        "action": {"key": "action", "type": "str"},
        "target": {"key": "target", "type": "PurposeTarget"},
    }

    def __init__(
        self,
        *,
        action: Optional[Union[str, "PurposeTypesAction"]] = None,
        target: Optional["PurposeTarget"] = None,
        **kwargs
    ):
        super(Purpose, self).__init__(**kwargs)
        self.action = action
        self.target = target


class PurposeTarget(msrest.serialization.Model):
    """This structure describes the "target" of the simulator;
    i.e., what trainable construct(s) it exists to service.

        :param workspace_name:
        :type workspace_name: str
        :param brain_name: This is the brain *short* name!.
        :type brain_name: str
        :param brain_version:
        :type brain_version: int
        :param concept_name:
        :type concept_name: str
    """

    _attribute_map = {
        "workspace_name": {"key": "workspaceName", "type": "str"},
        "brain_name": {"key": "brainName", "type": "str"},
        "brain_version": {"key": "brainVersion", "type": "int"},
        "concept_name": {"key": "conceptName", "type": "str"},
    }

    def __init__(
        self,
        *,
        workspace_name: Optional[str] = None,
        brain_name: Optional[str] = None,
        brain_version: Optional[int] = None,
        concept_name: Optional[str] = None,
        **kwargs
    ):
        super(PurposeTarget, self).__init__(**kwargs)
        self.workspace_name = workspace_name
        self.brain_name = brain_name
        self.brain_version = brain_version
        self.concept_name = concept_name


class SimulatorContext(msrest.serialization.Model):
    """This structure is passed (as a string) to a simulator running
    when launched by the Socrates backend.

        :param deployment_mode:  Possible values include: "Unspecified", "Hosted", "Testing".
        :type deployment_mode: str or
         ~microsoft_bonsai_api.simulator.generated.models.SimulatorContextTypesDeploymentMode
        :param deployment_details: Where is this simulator deployed.
        :type deployment_details: str
        :param simulator_client_id: A simulator id generated by the client.
        :type simulator_client_id: str
        :param collection: The id of the collection.
        :type collection: str
        :param package: The id of the package.
        :type package: str
        :param purpose: The purpose for existing, from the standpoint of a simulator instance or
         brain version.
        :type purpose: ~microsoft_bonsai_api.simulator.generated.models.Purpose
        :param container_group_name: Azure Container Group Id to be part of simulator. This is required
         for Telescope logging purpose.
        :type container_group_name: str
    """

    _attribute_map = {
        "deployment_mode": {"key": "deploymentMode", "type": "str"},
        "deployment_details": {"key": "deploymentDetails", "type": "str"},
        "simulator_client_id": {"key": "simulatorClientId", "type": "str"},
        "collection": {"key": "collection", "type": "str"},
        "package": {"key": "package", "type": "str"},
        "purpose": {"key": "purpose", "type": "Purpose"},
        "container_group_name": {"key": "containerGroupName", "type": "str"},
    }

    def __init__(
        self,
        *,
        deployment_mode: Optional[
            Union[str, "SimulatorContextTypesDeploymentMode"]
        ] = None,
        deployment_details: Optional[str] = None,
        simulator_client_id: Optional[str] = None,
        collection: Optional[str] = None,
        package: Optional[str] = None,
        purpose: Optional["Purpose"] = None,
        container_group_name: Optional[str] = None,
        **kwargs
    ):
        super(SimulatorContext, self).__init__(**kwargs)
        self.deployment_mode = deployment_mode
        self.deployment_details = deployment_details
        self.simulator_client_id = simulator_client_id
        self.collection = collection
        self.package = package
        self.purpose = purpose
        self.container_group_name = container_group_name


class SimulatorInterface(msrest.serialization.Model):
    """It contains all the registration/creation time properties of a simulator session.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Name of the simulator session.
    :type name: str
    :param timeout: This is the max time in seconds, within which simulator need to send advance
     request, else it will be timed out and unregistered from Bonsai platform.
     Set it to (SimulatorComputeTime + RTT network latency + few seconds)
     Default is 60s.
    :type timeout: float
    :param capabilities: Additional Capabilities for the session.
    :type capabilities: object
    :param simulator_context: Opaque string to the sim authors. It's used to connect simulator
     sessions to right brain.false
     For hosted sims, we automatically take care of setting the right environment variable for
     this.
     For Local sims, set it to empty string, and use Bonsai CLI's, ``bonsai connect`` command.
    :type simulator_context: str
    :param description: Schema descriptions of the simulator. Contains State, Action and Config
     schemas.
    :type description: object
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "timeout": {"key": "timeout", "type": "float"},
        "capabilities": {"key": "capabilities", "type": "object"},
        "simulator_context": {"key": "simulatorContext", "type": "str"},
        "description": {"key": "description", "type": "object"},
    }

    def __init__(
        self,
        *,
        name: str,
        timeout: Optional[float] = None,
        capabilities: Optional[object] = None,
        simulator_context: Optional[str] = None,
        description: Optional[object] = None,
        **kwargs
    ):
        super(SimulatorInterface, self).__init__(**kwargs)
        self.name = name
        self.timeout = timeout
        self.capabilities = capabilities
        self.simulator_context = simulator_context
        self.description = description


class SimulatorSessionMilestone(msrest.serialization.Model):
    """SimulatorSession progress milestone.

    :param first_time: First time, this session made the specified progress.
    :type first_time: ~datetime.datetime
    """

    _attribute_map = {
        "first_time": {"key": "firstTime", "type": "iso-8601"},
    }

    def __init__(self, *, first_time: Optional[datetime.datetime] = None, **kwargs):
        super(SimulatorSessionMilestone, self).__init__(**kwargs)
        self.first_time = first_time


class SimulatorSessionProgress(msrest.serialization.Model):
    """SimulatorSession progress:
    Has the simulator ever attached to a Scholar;
    Has the simulator ever iterated (i.e., sent a state and received an action);
    Has the simulator ever completed an episode (i.e., received an EpisodeFinish message).

      :param attached: SimulatorSession progress milestone.
      :type attached: ~microsoft_bonsai_api.simulator.generated.models.SimulatorSessionMilestone
      :param iterated: SimulatorSession progress milestone.
      :type iterated: ~microsoft_bonsai_api.simulator.generated.models.SimulatorSessionMilestone
      :param finished_episode: SimulatorSession progress milestone.
      :type finished_episode:
       ~microsoft_bonsai_api.simulator.generated.models.SimulatorSessionMilestone
    """

    _attribute_map = {
        "attached": {"key": "attached", "type": "SimulatorSessionMilestone"},
        "iterated": {"key": "iterated", "type": "SimulatorSessionMilestone"},
        "finished_episode": {
            "key": "finishedEpisode",
            "type": "SimulatorSessionMilestone",
        },
    }

    def __init__(
        self,
        *,
        attached: Optional["SimulatorSessionMilestone"] = None,
        iterated: Optional["SimulatorSessionMilestone"] = None,
        finished_episode: Optional["SimulatorSessionMilestone"] = None,
        **kwargs
    ):
        super(SimulatorSessionProgress, self).__init__(**kwargs)
        self.attached = attached
        self.iterated = iterated
        self.finished_episode = finished_episode


class SimulatorSessionResponse(msrest.serialization.Model):
    """SimulatorSession model, having details of one active simulator session.
    When a simulator registers, it creates and starts active simulator session.
    When that simulator deregisters itself, it ends and removes its simulator session.
    If the Bonsai platform deregisters a simulator due to that simulator's "misbehavior,"
    that also ends and removes that simulator's session.

        All required parameters must be populated in order to send to Azure.

        :param session_id: Required. Unique sessionId for this simulator session.
        :type session_id: str
        :param session_status:  Possible values include: "Deregistered", "Attachable", "Attached",
         "Detaching", "Rejected".
        :type session_status: str or
         ~microsoft_bonsai_api.simulator.generated.models.SimulatorSessionTypesStatus
        :param session_progress: SimulatorSession progress:
           Has the simulator ever attached to a Scholar;
           Has the simulator ever iterated (i.e., sent a state and received an action);
           Has the simulator ever completed an episode (i.e., received an EpisodeFinish message).
        :type session_progress:
         ~microsoft_bonsai_api.simulator.generated.models.SimulatorSessionProgress
        :param interface: It contains all the registration/creation time properties of a simulator
         session.
        :type interface: ~microsoft_bonsai_api.simulator.generated.models.SimulatorInterface
        :param simulator_context: This structure is passed (as a string) to a simulator running
         when launched by the Socrates backend.
        :type simulator_context: ~microsoft_bonsai_api.simulator.generated.models.SimulatorContext
        :param registration_time: Required. Time when this session was registered with Bonsai platform.
        :type registration_time: ~datetime.datetime
        :param last_seen_time: Required. A recent time that this simulator communicated with the Bonsai
         platform.
         This value is updated at a regular interval, so it may not be the most recent communication
         time.
        :type last_seen_time: ~datetime.datetime
        :param last_iterated_time: Required. A recent time that this simulator received an EpisodeStep
         from the Scholar.
         This value is updated at a regular interval, so it may not be the most recent communication
         time.
        :type last_iterated_time: ~datetime.datetime
        :param iteration_rate: Current IterationRate, 1 state-action loop is roughly maps to 1
         iteration.
        :type iteration_rate: float
        :param details: Additional Details for this session provided by Bonsai platform.
        :type details: str
    """

    _validation = {
        "session_id": {"required": True},
        "registration_time": {"required": True},
        "last_seen_time": {"required": True},
        "last_iterated_time": {"required": True},
    }

    _attribute_map = {
        "session_id": {"key": "sessionId", "type": "str"},
        "session_status": {"key": "sessionStatus", "type": "str"},
        "session_progress": {
            "key": "sessionProgress",
            "type": "SimulatorSessionProgress",
        },
        "interface": {"key": "interface", "type": "SimulatorInterface"},
        "simulator_context": {"key": "simulatorContext", "type": "SimulatorContext"},
        "registration_time": {"key": "registrationTime", "type": "iso-8601"},
        "last_seen_time": {"key": "lastSeenTime", "type": "iso-8601"},
        "last_iterated_time": {"key": "lastIteratedTime", "type": "iso-8601"},
        "iteration_rate": {"key": "iterationRate", "type": "float"},
        "details": {"key": "details", "type": "str"},
    }

    def __init__(
        self,
        *,
        session_id: str,
        registration_time: datetime.datetime,
        last_seen_time: datetime.datetime,
        last_iterated_time: datetime.datetime,
        session_status: Optional[Union[str, "SimulatorSessionTypesStatus"]] = None,
        session_progress: Optional["SimulatorSessionProgress"] = None,
        interface: Optional["SimulatorInterface"] = None,
        simulator_context: Optional["SimulatorContext"] = None,
        iteration_rate: Optional[float] = None,
        details: Optional[str] = None,
        **kwargs
    ):
        super(SimulatorSessionResponse, self).__init__(**kwargs)
        self.session_id = session_id
        self.session_status = session_status
        self.session_progress = session_progress
        self.interface = interface
        self.simulator_context = simulator_context
        self.registration_time = registration_time
        self.last_seen_time = last_seen_time
        self.last_iterated_time = last_iterated_time
        self.iteration_rate = iteration_rate
        self.details = details


class SimulatorSessionSummary(msrest.serialization.Model):
    """A summary of a SimulatorSession, returned from ListSessions.

    :param session_id:
    :type session_id: str
    :param session_status:  Possible values include: "Deregistered", "Attachable", "Attached",
     "Detaching", "Rejected".
    :type session_status: str or
     ~microsoft_bonsai_api.simulator.generated.models.SimulatorSessionTypesStatus
    :param simulator_name: From the registration's SimulatorInterface.
    :type simulator_name: str
    :param simulator_context: This structure is passed (as a string) to a simulator running
     when launched by the Socrates backend.
    :type simulator_context: ~microsoft_bonsai_api.simulator.generated.models.SimulatorContext
    """

    _attribute_map = {
        "session_id": {"key": "sessionId", "type": "str"},
        "session_status": {"key": "sessionStatus", "type": "str"},
        "simulator_name": {"key": "simulatorName", "type": "str"},
        "simulator_context": {"key": "simulatorContext", "type": "SimulatorContext"},
    }

    def __init__(
        self,
        *,
        session_id: Optional[str] = None,
        session_status: Optional[Union[str, "SimulatorSessionTypesStatus"]] = None,
        simulator_name: Optional[str] = None,
        simulator_context: Optional["SimulatorContext"] = None,
        **kwargs
    ):
        super(SimulatorSessionSummary, self).__init__(**kwargs)
        self.session_id = session_id
        self.session_status = session_status
        self.simulator_name = simulator_name
        self.simulator_context = simulator_context


class SimulatorState(msrest.serialization.Model):
    """It contains simulator state information needed by bonsai platform in response of an action.

    All required parameters must be populated in order to send to Azure.

    :param sequence_id: Required. Always startes with 1, and Bonsai platform increment it at each
     Step event in advance operation.static
     Always just return the sequenceId returned by previous advance operation response.
    :type sequence_id: int
    :param state: State of your simulator model.
    :type state: object
    :param halted: Optional halt parameter to indicate, simulator wants to halt.
     Implicitly false when not present.
    :type halted: bool
    :param error: No error if not defined or empty.
    :type error: str
    """

    _validation = {
        "sequence_id": {"required": True},
    }

    _attribute_map = {
        "sequence_id": {"key": "sequenceId", "type": "int"},
        "state": {"key": "state", "type": "object"},
        "halted": {"key": "halted", "type": "bool"},
        "error": {"key": "error", "type": "str"},
    }

    def __init__(
        self,
        *,
        sequence_id: int,
        state: Optional[object] = None,
        halted: Optional[bool] = None,
        error: Optional[str] = None,
        **kwargs
    ):
        super(SimulatorState, self).__init__(**kwargs)
        self.sequence_id = sequence_id
        self.state = state
        self.halted = halted
        self.error = error


class Unregister(msrest.serialization.Model):
    """Event notifying the simulator that its session has been deleted.
    If you want to continue training with this simulator, you must create a new session.

        :param reason: Reason for unregister event. Possible values include: "Unspecified", "Finished",
         "Error", "NotFound".
        :type reason: str or ~microsoft_bonsai_api.simulator.generated.models.UnregisterReason
        :param details: Detail message for unregister event.
        :type details: str
    """

    _attribute_map = {
        "reason": {"key": "reason", "type": "str"},
        "details": {"key": "details", "type": "str"},
    }

    def __init__(
        self,
        *,
        reason: Optional[Union[str, "UnregisterReason"]] = None,
        details: Optional[str] = None,
        **kwargs
    ):
        super(Unregister, self).__init__(**kwargs)
        self.reason = reason
        self.details = details
