# SPDX-FileCopyrightText: 2006-2021 Istituto Italiano di Tecnologia (IIT)
# SPDX-FileCopyrightText: 2006-2010 RobotCub Consortium
# SPDX-License-Identifier: BSD-3-Clause

#
# Packing stuff
#

set(CPACK_PACKAGE_NAME "YARP")
set(CPACK_PACKAGE_VENDOR "Istituto Italiano di Tecnologia (IIT)")
set(CPACK_PACKAGE_DESCRIPTION_SUMMARY "YARP: A thin middleware for humanoid robots and more")
set(CPACK_PACKAGE_DESCRIPTION_FILE "${CMAKE_CURRENT_SOURCE_DIR}/README.md")
set(CPACK_RESOURCE_FILE_LICENSE "${CMAKE_CURRENT_SOURCE_DIR}/COPYING")

set(CPACK_PACKAGE_VERSION_MAJOR "${YARP_VERSION_MAJOR}")
set(CPACK_PACKAGE_VERSION_MINOR "${YARP_VERSION_MINOR}")
set(CPACK_PACKAGE_VERSION_PATCH "${YARP_VERSION_PATCH}")
if(YARP_VERSION_TWEAK)
  set(CPACK_PACKAGE_VERSION_TWEAK "${YARP_VERSION_TWEAK}")
endif()
set(CPACK_PACKAGE_VERSION "${YARP_VERSION}")

if(WIN32 AND CMAKE_GENERATOR MATCHES "^Visual Studio")
  if(MSVC10)
    set(CPACK_SYSTEM_NAME v10)
  elseif(MSVC11)
    set(CPACK_SYSTEM_NAME v11)
  elseif(MSVC12)
    set(CPACK_SYSTEM_NAME v12)
  elseif(MSVC14)
    set(CPACK_SYSTEM_NAME v14)
  endif()

  if(CMAKE_GENERATOR_PLATFORM MATCHES "x64" OR CMAKE_GENERATOR MATCHES "Win64")
    set(CPACK_SYSTEM_NAME "${CPACK_SYSTEM_NAME}_x86_amd64")
    set(CPACK_NSIS_INSTALL_ROOT "\\$PROGRAMFILES64\\\\robotology")
  elseif(NOT CMAKE_GENERATOR MATCHES "ARM")
    set(CPACK_SYSTEM_NAME "${CPACK_SYSTEM_NAME}_x86")
    set(CPACK_NSIS_INSTALL_ROOT "\\$PROGRAMFILES32\\\\robotology")
  endif()
endif()

set(CPACK_PACKAGE_FILE_NAME "yarp_${CPACK_PACKAGE_VERSION}_${CPACK_SYSTEM_NAME}")
set(CPACK_NSIS_PACKAGE_NAME "YARP ${CPACK_PACKAGE_VERSION}")
set(CPACK_NSIS_DISPLAY_NAME "YARP ${CPACK_PACKAGE_VERSION} ${CPACK_SYSTEM_NAME}")
set(CPACK_PACKAGE_INSTALL_DIRECTORY "yarp-${CPACK_PACKAGE_VERSION}_${CPACK_SYSTEM_NAME}")
set(CPACK_MONOLITHIC_INSTALL 1)

set(CPACK_NSIS_HELP_LINK "http://github.com/robotology/yarp/issues/")
set(CPACK_NSIS_URL_INFO_ABOUT "http://yarp.it/")
set(CPACK_NSIS_CONTACT "yarp0-devel@lists.sourceforge.net")

include(CPack)
