# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, Awaitable, TYPE_CHECKING

from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.mgmt.core import AsyncARMPipelineClient

from .. import models
from .._serialization import Deserializer, Serializer
from ._configuration import DevCenterMgmtClientConfiguration
from .operations import (
    AttachedNetworksOperations,
    CatalogsOperations,
    DevBoxDefinitionsOperations,
    DevCentersOperations,
    EnvironmentTypesOperations,
    GalleriesOperations,
    ImageVersionsOperations,
    ImagesOperations,
    NetworkConnectionsOperations,
    OperationStatusesOperations,
    Operations,
    PoolsOperations,
    ProjectAllowedEnvironmentTypesOperations,
    ProjectEnvironmentTypesOperations,
    ProjectsOperations,
    SchedulesOperations,
    SkusOperations,
    UsagesOperations,
)

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials_async import AsyncTokenCredential


class DevCenterMgmtClient:  # pylint: disable=client-accepts-api-version-keyword,too-many-instance-attributes
    """DevCenter Management API.

    :ivar dev_centers: DevCentersOperations operations
    :vartype dev_centers: azure.mgmt.devcenter.aio.operations.DevCentersOperations
    :ivar projects: ProjectsOperations operations
    :vartype projects: azure.mgmt.devcenter.aio.operations.ProjectsOperations
    :ivar attached_networks: AttachedNetworksOperations operations
    :vartype attached_networks: azure.mgmt.devcenter.aio.operations.AttachedNetworksOperations
    :ivar galleries: GalleriesOperations operations
    :vartype galleries: azure.mgmt.devcenter.aio.operations.GalleriesOperations
    :ivar images: ImagesOperations operations
    :vartype images: azure.mgmt.devcenter.aio.operations.ImagesOperations
    :ivar image_versions: ImageVersionsOperations operations
    :vartype image_versions: azure.mgmt.devcenter.aio.operations.ImageVersionsOperations
    :ivar catalogs: CatalogsOperations operations
    :vartype catalogs: azure.mgmt.devcenter.aio.operations.CatalogsOperations
    :ivar environment_types: EnvironmentTypesOperations operations
    :vartype environment_types: azure.mgmt.devcenter.aio.operations.EnvironmentTypesOperations
    :ivar project_allowed_environment_types: ProjectAllowedEnvironmentTypesOperations operations
    :vartype project_allowed_environment_types:
     azure.mgmt.devcenter.aio.operations.ProjectAllowedEnvironmentTypesOperations
    :ivar project_environment_types: ProjectEnvironmentTypesOperations operations
    :vartype project_environment_types:
     azure.mgmt.devcenter.aio.operations.ProjectEnvironmentTypesOperations
    :ivar dev_box_definitions: DevBoxDefinitionsOperations operations
    :vartype dev_box_definitions: azure.mgmt.devcenter.aio.operations.DevBoxDefinitionsOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.devcenter.aio.operations.Operations
    :ivar operation_statuses: OperationStatusesOperations operations
    :vartype operation_statuses: azure.mgmt.devcenter.aio.operations.OperationStatusesOperations
    :ivar usages: UsagesOperations operations
    :vartype usages: azure.mgmt.devcenter.aio.operations.UsagesOperations
    :ivar skus: SkusOperations operations
    :vartype skus: azure.mgmt.devcenter.aio.operations.SkusOperations
    :ivar pools: PoolsOperations operations
    :vartype pools: azure.mgmt.devcenter.aio.operations.PoolsOperations
    :ivar schedules: SchedulesOperations operations
    :vartype schedules: azure.mgmt.devcenter.aio.operations.SchedulesOperations
    :ivar network_connections: NetworkConnectionsOperations operations
    :vartype network_connections: azure.mgmt.devcenter.aio.operations.NetworkConnectionsOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: The ID of the target subscription. Required.
    :type subscription_id: str
    :param base_url: Service URL. Default value is "https://management.azure.com".
    :type base_url: str
    :keyword api_version: Api Version. Default value is "2022-10-12-preview". Note that overriding
     this default value may result in unsupported behavior.
    :paramtype api_version: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        subscription_id: str,
        base_url: str = "https://management.azure.com",
        **kwargs: Any
    ) -> None:
        self._config = DevCenterMgmtClientConfiguration(
            credential=credential, subscription_id=subscription_id, **kwargs
        )
        self._client = AsyncARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.dev_centers = DevCentersOperations(self._client, self._config, self._serialize, self._deserialize)
        self.projects = ProjectsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.attached_networks = AttachedNetworksOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.galleries = GalleriesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.images = ImagesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.image_versions = ImageVersionsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.catalogs = CatalogsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.environment_types = EnvironmentTypesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.project_allowed_environment_types = ProjectAllowedEnvironmentTypesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.project_environment_types = ProjectEnvironmentTypesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.dev_box_definitions = DevBoxDefinitionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.operations = Operations(self._client, self._config, self._serialize, self._deserialize)
        self.operation_statuses = OperationStatusesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.usages = UsagesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.skus = SkusOperations(self._client, self._config, self._serialize, self._deserialize)
        self.pools = PoolsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.schedules = SchedulesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.network_connections = NetworkConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )

    def _send_request(self, request: HttpRequest, **kwargs: Any) -> Awaitable[AsyncHttpResponse]:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = await client._send_request(request)
        <AsyncHttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.AsyncHttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, **kwargs)

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> "DevCenterMgmtClient":
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details) -> None:
        await self._client.__aexit__(*exc_details)
