import sys
import os
import json
import requests


def post_main():
    color_start = '\033[31m' if sys.stderr.isatty() else ''
    color_end = '\033[0m' if sys.stderr.isatty() else ''
    sys.stderr.write(
        color_start
        + '**********************************************\n'
        + '             DEPRECATION WARNING\n'
        + ' gh-pr-comment on PyPi (pip) is deprecated!\n'
        + ' Please use the new version of gh-pr-comment.\n'
        + ' See https://github.com/at-wat/gh-pr-comment/\n'
        + '**********************************************'
        + color_end + '\n\n')

    argv = sys.argv
    if len(argv) < 3:
        sys.stderr.write(
            'usage: gh-pr-comment title comment\n')
        sys.stderr.write(
            'env:\n')
        sys.stderr.write(
            '  TRAVIS_PULL_REQUEST_SLUG:\n'
            + '    owner/repos (TRAVIS_REPO_SLUG is used if not set)\n')
        sys.stderr.write(
            '  TRAVIS_PULL_REQUEST:\n'
            + '    pull request number\n')
        sys.stderr.write(
            '  TRAVIS_BOT_GITHUB_TOKEN or GITHUB_TOKEN:\n'
            + '    token with comment write permission\n')
        sys.exit(1)

    post(argv[1], argv[2])


def post(title, contents):
    if 'TRAVIS_BOT_GITHUB_TOKEN' not in os.environ \
            and 'GITHUB_TOKEN' not in os.environ:
        sys.stderr.write(
            'gh-pr-comment: '
            + 'neither TRAVIS_BOT_GITHUB_TOKEN nor GITHUB_TOKEN is not set.\n')
        sys.exit(1)
    if 'TRAVIS_PULL_REQUEST_SLUG' not in os.environ:
        if 'TRAVIS_REPO_SLUG' not in os.environ:
            sys.stderr.write(
                'gh-pr-comment: TRAVIS_PULL_REQUEST_SLUG is not set.\n')
            sys.exit(1)
    if 'TRAVIS_PULL_REQUEST' not in os.environ:
        sys.stderr.write(
            'gh-pr-comment: TRAVIS_PULL_REQUEST is not set.\n')
        sys.exit(1)

    if os.environ['TRAVIS_PULL_REQUEST'] == 'false':
        sys.stderr.write(
            'gh-pr-comment: TRAVIS_PULL_REQUEST is false.\n')
        sys.exit(0)

    if 'TRAVIS_PULL_REQUEST_SLUG' in os.environ:
        slug = os.environ['TRAVIS_PULL_REQUEST_SLUG']
    else:
        slug = os.environ['TRAVIS_REPO_SLUG']

    if 'GITHUB_API_URL_BASE' in os.environ:
        url_base = os.environ['GITHUB_API_URL_BASE']
    else:
        url_base = 'https://api.github.com'

    token = (os.environ['TRAVIS_BOT_GITHUB_TOKEN']
             if 'TRAVIS_BOT_GITHUB_TOKEN' in os.environ
             else os.environ['GITHUB_TOKEN'])
    url = url_base + '/repos/' \
        + slug \
        + '/issues/' \
        + os.environ['TRAVIS_PULL_REQUEST'] \
        + '/comments'
    headers = {
        "Content-Type": "application/json",
        "Authorization": "token " + token
    }

    body = {
        "body": '## %s' % title + '\n\n' + contents
    }

    r = requests.post(url, data=json.dumps(body), headers=headers)
    print(r.text.encode('utf-8'))
