# Generated by Django 2.2.5 on 2019-11-18 11:39

from django.conf import settings
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='ModelObjectVersionGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('representation', models.TextField(verbose_name='Описание объекта')),
                ('verbose_name', models.TextField(verbose_name='Наименование объекта')),
                ('object_id', models.PositiveIntegerField()),
                ('relation_tree', django.contrib.postgres.fields.jsonb.JSONField(null=True, verbose_name='Дерево отношений')),
                ('tree_last_update', models.DateTimeField(null=True, verbose_name='Последнее обновление дерева отношений')),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType')),
            ],
            options={
                'verbose_name': 'Группа версий объекта',
                'verbose_name_plural': 'Группы версий объектов',
                'unique_together': {('content_type', 'object_id')},
            },
        ),
        migrations.CreateModel(
            name='ModelObjectVersion',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('change_type', models.CharField(choices=[('object_changed', 'Изменено'), ('object_created', 'Создано'), ('object_deleted', 'Удалено'), ('object_restored', 'Восстановлено'), ('object_state_init', 'Инициализировано состояние')], default='object_changed', max_length=50, verbose_name='Тип изменения объекта')),
                ('change_url', models.TextField(null=True, verbose_name='URL создания версии')),
                ('change_app', models.TextField(null=True, verbose_name='APP создания версии')),
                ('created', models.DateTimeField(verbose_name='Дата и время версии')),
                ('request_key', models.UUIDField(null=True, verbose_name='Уникальный ключ request')),
                ('hash', models.UUIDField(verbose_name='Хэш версии')),
                ('state', django.contrib.postgres.fields.jsonb.JSONField(null=True)),
                ('author', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='model_objects_versions', to=settings.AUTH_USER_MODEL, verbose_name='Автор')),
                ('group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='model_object_versions', to='version_control.ModelObjectVersionGroup', verbose_name='Группа версий')),
            ],
            options={
                'verbose_name': 'Версия объекта',
                'verbose_name_plural': 'Версии объектов',
                'ordering': ('-created',),
            },
        ),
    ]
