"""Implements WellDataset class."""

from ..batchflow import Dataset, FilesIndex
from .well_batch import WellBatch


class WellDataset(Dataset):
    """A dataset, that generates batches of `WellBatch` class. Contains
    indices of wells and a specific `batch_class` to create and process small
    subsets of data.

    Parameters
    ----------
    index : DatasetIndex or None, optional
        Unique identifiers of wells in a dataset. If `index` is not given, it
        is constructed by instantiating `FilesIndex` with passed `kwargs`.
    batch_class : type, optional
        A class of batches, generated by a dataset. Must be inherited from
        `Batch`.
    preloaded : tuple, optional
        Data to put in created batches. Defaults to `None`.
    copy : bool
        Specifies whether to deepcopy preloaded data for each batch. If
        `False`, preloaded data will be updated each time an inplace method of
        a `Well` is called which is usually an undesirable behavior. Defaults
        to `True`.
    kwargs : misc, optional
        Additional keyword arguments to `FilesIndex.__init__`.
    """

    def __init__(self, index=None, batch_class=WellBatch, preloaded=None, copy=True, **kwargs):
        if index is None:
            index = FilesIndex(**kwargs)
        super().__init__(index, batch_class=batch_class, preloaded=preloaded, copy=copy, **kwargs)
