import java.io
import java.net
import java.util
import jpype.protocol
import opennlp.tools.ml.model
import opennlp.tools.util
import opennlp.tools.util.eval
import opennlp.tools.util.model
import typing



class ChunkSample:
    @typing.overload
    def __init__(self, stringArray: typing.List[str], stringArray2: typing.List[str], stringArray3: typing.List[str]): ...
    @typing.overload
    def __init__(self, list: java.util.List[str], list2: java.util.List[str], list3: java.util.List[str]): ...
    def equals(self, object: typing.Any) -> bool: ...
    def getPhrasesAsSpanList(self) -> typing.List[opennlp.tools.util.Span]: ...
    def getPreds(self) -> typing.List[str]: ...
    def getSentence(self) -> typing.List[str]: ...
    def getTags(self) -> typing.List[str]: ...
    def hashCode(self) -> int: ...
    def nicePrint(self) -> str: ...
    @staticmethod
    def phrasesAsSpanList(stringArray: typing.List[str], stringArray2: typing.List[str], stringArray3: typing.List[str]) -> typing.List[opennlp.tools.util.Span]: ...
    def toString(self) -> str: ...

class ChunkSampleSequenceStream(opennlp.tools.ml.model.SequenceStream):
    def __init__(self, objectStream: opennlp.tools.util.ObjectStream[ChunkSample], chunkerContextGenerator: 'ChunkerContextGenerator'): ...
    def close(self) -> None: ...
    def read(self) -> opennlp.tools.ml.model.Sequence: ...
    def reset(self) -> None: ...
    def updateContext(self, sequence: opennlp.tools.ml.model.Sequence, abstractModel: opennlp.tools.ml.model.AbstractModel) -> typing.List[opennlp.tools.ml.model.Event]: ...

class ChunkSampleStream(opennlp.tools.util.FilterObjectStream[str, ChunkSample]):
    def __init__(self, objectStream: opennlp.tools.util.ObjectStream[str]): ...
    def read(self) -> ChunkSample: ...

class Chunker:
    def chunk(self, stringArray: typing.List[str], stringArray2: typing.List[str]) -> typing.List[str]: ...
    def chunkAsSpans(self, stringArray: typing.List[str], stringArray2: typing.List[str]) -> typing.List[opennlp.tools.util.Span]: ...
    @typing.overload
    def topKSequences(self, stringArray: typing.List[str], stringArray2: typing.List[str]) -> typing.List[opennlp.tools.util.Sequence]: ...
    @typing.overload
    def topKSequences(self, stringArray: typing.List[str], stringArray2: typing.List[str], double: float) -> typing.List[opennlp.tools.util.Sequence]: ...

class ChunkerContextGenerator(opennlp.tools.util.BeamSearchContextGenerator['TokenTag']):
    @typing.overload
    def getContext(self, int: int, tArray: typing.List[typing.Any], stringArray: typing.List[str], objectArray: typing.List[typing.Any]) -> typing.List[str]: ...
    @typing.overload
    def getContext(self, int: int, stringArray: typing.List[str], stringArray2: typing.List[str], stringArray3: typing.List[str]) -> typing.List[str]: ...

class ChunkerCrossValidator:
    def __init__(self, string: str, trainingParameters: opennlp.tools.util.TrainingParameters, chunkerFactory: 'ChunkerFactory', chunkerEvaluationMonitorArray: typing.List['ChunkerEvaluationMonitor']): ...
    def evaluate(self, objectStream: opennlp.tools.util.ObjectStream[ChunkSample], int: int) -> None: ...
    def getFMeasure(self) -> opennlp.tools.util.eval.FMeasure: ...

class ChunkerEvaluationMonitor(opennlp.tools.util.eval.EvaluationMonitor[ChunkSample]): ...

class ChunkerEvaluator(opennlp.tools.util.eval.Evaluator[ChunkSample]):
    def __init__(self, chunker: Chunker, chunkerEvaluationMonitorArray: typing.List[ChunkerEvaluationMonitor]): ...
    def getFMeasure(self) -> opennlp.tools.util.eval.FMeasure: ...

class ChunkerEventStream(opennlp.tools.util.AbstractEventStream[ChunkSample]):
    def __init__(self, objectStream: opennlp.tools.util.ObjectStream[ChunkSample], chunkerContextGenerator: ChunkerContextGenerator): ...

class ChunkerFactory(opennlp.tools.util.BaseToolFactory):
    def __init__(self): ...
    @typing.overload
    @staticmethod
    def create(class_: typing.Type[opennlp.tools.util.BaseToolFactory], artifactProvider: opennlp.tools.util.model.ArtifactProvider) -> opennlp.tools.util.BaseToolFactory: ...
    @typing.overload
    @staticmethod
    def create(string: str, artifactProvider: opennlp.tools.util.model.ArtifactProvider) -> opennlp.tools.util.BaseToolFactory: ...
    @typing.overload
    @staticmethod
    def create(string: str) -> 'ChunkerFactory': ...
    def getContextGenerator(self) -> ChunkerContextGenerator: ...
    def getSequenceValidator(self) -> opennlp.tools.util.SequenceValidator['TokenTag']: ...
    def validateArtifactMap(self) -> None: ...

class ChunkerModel(opennlp.tools.util.model.BaseModel):
    @typing.overload
    def __init__(self, file: typing.Union[java.io.File, jpype.protocol.SupportsPath]): ...
    @typing.overload
    def __init__(self, inputStream: java.io.InputStream): ...
    @typing.overload
    def __init__(self, string: str, maxentModel: opennlp.tools.ml.model.MaxentModel, int: int, map: typing.Union[java.util.Map[str, str], typing.Mapping[str, str]], chunkerFactory: ChunkerFactory): ...
    @typing.overload
    def __init__(self, string: str, maxentModel: opennlp.tools.ml.model.MaxentModel, map: typing.Union[java.util.Map[str, str], typing.Mapping[str, str]], chunkerFactory: ChunkerFactory): ...
    @typing.overload
    def __init__(self, string: str, maxentModel: opennlp.tools.ml.model.MaxentModel, chunkerFactory: ChunkerFactory): ...
    @typing.overload
    def __init__(self, string: str, sequenceClassificationModel: opennlp.tools.ml.model.SequenceClassificationModel[str], map: typing.Union[java.util.Map[str, str], typing.Mapping[str, str]], chunkerFactory: ChunkerFactory): ...
    @typing.overload
    def __init__(self, uRL: java.net.URL): ...
    def getChunkerModel(self) -> opennlp.tools.ml.model.MaxentModel: ...
    def getChunkerSequenceModel(self) -> opennlp.tools.ml.model.SequenceClassificationModel['TokenTag']: ...
    def getFactory(self) -> ChunkerFactory: ...

class DefaultChunkerSequenceValidator(opennlp.tools.util.SequenceValidator['TokenTag']):
    def __init__(self): ...
    def validSequence(self, int: int, tokenTagArray: typing.List['TokenTag'], stringArray: typing.List[str], string2: str) -> bool: ...

class TokenTag:
    def __init__(self, string: str, string2: str, stringArray: typing.List[str]): ...
    @staticmethod
    def create(stringArray: typing.List[str], stringArray2: typing.List[str]) -> typing.List['TokenTag']: ...
    def equals(self, object: typing.Any) -> bool: ...
    @typing.overload
    @staticmethod
    def extract(tokenTagArray: typing.List['TokenTag'], stringArray: typing.List[str], stringArray2: typing.List[str]) -> None: ...
    @typing.overload
    @staticmethod
    def extract(tokenTagArray: typing.List['TokenTag'], stringArray: typing.List[str], stringArray2: typing.List[str], stringArray3: typing.List[str]) -> None: ...
    @staticmethod
    def extractTags(tokenTagArray: typing.List['TokenTag']) -> typing.List[str]: ...
    @staticmethod
    def extractTokens(tokenTagArray: typing.List['TokenTag']) -> typing.List[str]: ...
    def getAddtionalData(self) -> typing.List[str]: ...
    def getTag(self) -> str: ...
    def getToken(self) -> str: ...
    def hashCode(self) -> int: ...
    def toString(self) -> str: ...

class ChunkerME(Chunker):
    DEFAULT_BEAM_SIZE: typing.ClassVar[int] = ...
    @typing.overload
    def __init__(self, chunkerModel: ChunkerModel): ...
    @typing.overload
    def __init__(self, chunkerModel: ChunkerModel, int: int): ...
    @typing.overload
    def chunk(self, stringArray: typing.List[str], stringArray2: typing.List[str]) -> typing.List[str]: ...
    @typing.overload
    def chunk(self, tokenTagArray: typing.List[TokenTag]) -> typing.List[str]: ...
    @typing.overload
    def chunkAsSpans(self, stringArray: typing.List[str], stringArray2: typing.List[str]) -> typing.List[opennlp.tools.util.Span]: ...
    @typing.overload
    def chunkAsSpans(self, tokenTagArray: typing.List[TokenTag]) -> typing.List[opennlp.tools.util.Span]: ...
    @typing.overload
    def probs(self) -> typing.List[float]: ...
    @typing.overload
    def probs(self, doubleArray: typing.List[float]) -> None: ...
    @typing.overload
    def topKSequences(self, stringArray: typing.List[str], stringArray2: typing.List[str]) -> typing.List[opennlp.tools.util.Sequence]: ...
    @typing.overload
    def topKSequences(self, stringArray: typing.List[str], stringArray2: typing.List[str], double: float) -> typing.List[opennlp.tools.util.Sequence]: ...
    @typing.overload
    def topKSequences(self, tokenTagArray: typing.List[TokenTag]) -> typing.List[opennlp.tools.util.Sequence]: ...
    @typing.overload
    def topKSequences(self, tokenTagArray: typing.List[TokenTag], double: float) -> typing.List[opennlp.tools.util.Sequence]: ...
    @staticmethod
    def train(string: str, objectStream: opennlp.tools.util.ObjectStream[ChunkSample], trainingParameters: opennlp.tools.util.TrainingParameters, chunkerFactory: ChunkerFactory) -> ChunkerModel: ...

class DefaultChunkerContextGenerator(ChunkerContextGenerator):
    def __init__(self): ...
    @typing.overload
    def getContext(self, int: int, stringArray: typing.List[str], stringArray2: typing.List[str], stringArray3: typing.List[str]) -> typing.List[str]: ...
    @typing.overload
    def getContext(self, int: int, stringArray: typing.List[str], stringArray2: typing.List[str], stringArray3: typing.List[str], objectArray: typing.List[typing.Any]) -> typing.List[str]: ...
    @typing.overload
    def getContext(self, int: int, tokenTagArray: typing.List[TokenTag], stringArray: typing.List[str], objectArray: typing.List[typing.Any]) -> typing.List[str]: ...


class __module_protocol__(typing.Protocol):
    # A module protocol which reflects the result of ``jp.JPackage("org.cogroo.tools.chunker2")``.

    ChunkSample: typing.Type[ChunkSample]
    ChunkSampleSequenceStream: typing.Type[ChunkSampleSequenceStream]
    ChunkSampleStream: typing.Type[ChunkSampleStream]
    Chunker: typing.Type[Chunker]
    ChunkerContextGenerator: typing.Type[ChunkerContextGenerator]
    ChunkerCrossValidator: typing.Type[ChunkerCrossValidator]
    ChunkerEvaluationMonitor: typing.Type[ChunkerEvaluationMonitor]
    ChunkerEvaluator: typing.Type[ChunkerEvaluator]
    ChunkerEventStream: typing.Type[ChunkerEventStream]
    ChunkerFactory: typing.Type[ChunkerFactory]
    ChunkerME: typing.Type[ChunkerME]
    ChunkerModel: typing.Type[ChunkerModel]
    DefaultChunkerContextGenerator: typing.Type[DefaultChunkerContextGenerator]
    DefaultChunkerSequenceValidator: typing.Type[DefaultChunkerSequenceValidator]
    TokenTag: typing.Type[TokenTag]
