/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.util;

import java.util.Arrays;
import java.util.List;
import org.cogroo.config.Analyzers;
import org.cogroo.text.Document;
import org.cogroo.text.Sentence;
import org.cogroo.text.Token;
import org.cogroo.util.StringsUtil;

public class TextUtils {
    public static String[] tokensToString(List<Token> tokens) {
        String[] tokensString = new String[tokens.size()];
        for (int i = 0; i < tokens.size(); ++i) {
            tokensString[i] = tokens.get(i).getLexeme();
        }
        return tokensString;
    }

    public static String[][] additionalContext(List<Token> tokens, List<Analyzers> analyzers) {
        String[][] additionalContext = new String[analyzers.size()][tokens.size()];
        for (int i = 0; i < analyzers.size(); ++i) {
            for (int j = 0; j < tokens.size(); ++j) {
                Object object = tokens.get(j).getAdditionalContext(analyzers.get(i));
                additionalContext[i][j] = object == null ? null : (String)object;
            }
        }
        return additionalContext;
    }

    public static String nicePrint(Document document) {
        boolean printAdditionalContext = false;
        StringBuilder output = new StringBuilder();
        output.append("Document text: ").append(document.getText()).append("\n\n");
        if (document.getSentences() != null) {
            int cont = 0;
            for (Sentence sentence : document.getSentences()) {
                output.append("{Sentence ").append(++cont).append(": ").append(sentence.getText()).append("\n");
                List<Token> tokens = sentence.getTokens();
                if (tokens != null) {
                    int i;
                    String[] lexemes = new String[tokens.size()];
                    String[] posTags = new String[tokens.size()];
                    String[] features = new String[tokens.size()];
                    String[] lemmas = new String[tokens.size()];
                    String[] chunks = new String[tokens.size()];
                    String[] schunks = new String[tokens.size()];
                    output.append("   (token, class tag, feature tag, lexeme, chunks, function)\n");
                    for (i = 0; i < tokens.size(); ++i) {
                        Token t = tokens.get(i);
                        lexemes[i] = StringsUtil.nullToEmpty(t.getLexeme());
                        posTags[i] = StringsUtil.nullToEmpty(t.getPOSTag());
                        features[i] = StringsUtil.nullToEmpty(t.getFeatures());
                        lemmas[i] = t.getLemmas() != null ? StringsUtil.join(t.getLemmas(), ", ") : "";
                        String head = "";
                        if (t.isChunkHead()) {
                            head = "*";
                        }
                        chunks[i] = t.getChunkTag() + head;
                        schunks[i] = t.getSyntacticTag();
                    }
                    String format = "   | %-" + TextUtils.maxSize(lexemes) + "s | %-" + TextUtils.maxSize(posTags) + "s | %-" + TextUtils.maxSize(features) + "s | %-" + TextUtils.maxSize(lemmas) + "s | %-" + TextUtils.maxSize(chunks) + "s | %-" + TextUtils.maxSize(schunks) + "s |\n";
                    for (i = 0; i < tokens.size(); ++i) {
                        output.append(String.format(format, lexemes[i], posTags[i], features[i], lemmas[i], chunks[i], schunks[i]));
                    }
                    output.append("\n");
                    if (printAdditionalContext) {
                        String[][] addcontext;
                        String[][] stringArray = addcontext = TextUtils.additionalContext(tokens, Arrays.asList(Analyzers.CONTRACTION_FINDER, Analyzers.NAME_FINDER));
                        int n = stringArray.length;
                        for (int j = 0; j < n; ++j) {
                            String[] line;
                            for (String col : line = stringArray[j]) {
                                output.append("[");
                                if (col == null) {
                                    output.append("-");
                                } else {
                                    output.append(col);
                                }
                                output.append("]");
                            }
                            output.append("\n");
                        }
                    }
                }
                output.append("   Syntax tree: \n   ");
                output.append(sentence.asTree().toSyntaxTree());
                output.append("\n}\n");
            }
        }
        return output.toString();
    }

    private static int maxSize(String[] string) {
        int size = 1;
        for (String string2 : string) {
            if (size >= string2.length()) continue;
            size = string2.length();
        }
        return size;
    }
}

