/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.featurizer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import opennlp.tools.ml.model.Event;
import opennlp.tools.util.AbstractEventStream;
import opennlp.tools.util.ObjectStream;
import org.cogroo.tools.featurizer.FeatureSample;
import org.cogroo.tools.featurizer.FeaturizerContextGenerator;

public class FeaturizerEventStream
extends AbstractEventStream<FeatureSample> {
    private FeaturizerContextGenerator cg;

    public FeaturizerEventStream(ObjectStream<FeatureSample> d, FeaturizerContextGenerator cg) {
        super(d);
        this.cg = cg;
    }

    @Override
    protected Iterator<Event> createEvents(FeatureSample sample) {
        if (sample != null) {
            ArrayList<Event> events = new ArrayList<Event>();
            String[] toksArray = sample.getSentence();
            String[] tagsArray = sample.getTags();
            String[] predsArray = sample.getFeatures();
            int el = sample.getSentence().length;
            for (int ei = 0; ei < el; ++ei) {
                events.add(new Event(predsArray[ei], this.cg.getContext(ei, toksArray, tagsArray, predsArray)));
            }
            return events.iterator();
        }
        return Collections.emptyListIterator();
    }
}

