/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.chunker2;

import opennlp.tools.util.eval.Evaluator;
import opennlp.tools.util.eval.FMeasure;
import org.cogroo.tools.chunker2.ChunkSample;
import org.cogroo.tools.chunker2.Chunker;
import org.cogroo.tools.chunker2.ChunkerEvaluationMonitor;

public class ChunkerEvaluator
extends Evaluator<ChunkSample> {
    private FMeasure fmeasure = new FMeasure();
    private Chunker chunker;

    public ChunkerEvaluator(Chunker chunker, ChunkerEvaluationMonitor ... listeners) {
        super(listeners);
        this.chunker = chunker;
    }

    @Override
    protected ChunkSample processSample(ChunkSample reference) {
        String[] preds = this.chunker.chunk(reference.getSentence(), reference.getTags());
        ChunkSample result = new ChunkSample(reference.getSentence(), reference.getTags(), preds);
        this.fmeasure.updateScores(reference.getPhrasesAsSpanList(), result.getPhrasesAsSpanList());
        return result;
    }

    public FMeasure getFMeasure() {
        return this.fmeasure;
    }
}

