/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.checker;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.cogroo.tools.checker.GenericChecker;
import org.cogroo.tools.checker.RuleDefinition;

public abstract class GenericCheckerComposite<T>
implements GenericChecker<T> {
    private static final String ID_PREFIX = "";
    protected SortedSet<GenericChecker<T>> mChildCheckers;
    private boolean mAllowOverlaps;
    protected static final Logger LOGGER = Logger.getLogger(GenericCheckerComposite.class);

    public GenericCheckerComposite(List<GenericChecker<T>> aChildCheckers) {
        this(aChildCheckers, false);
    }

    public GenericCheckerComposite(List<GenericChecker<T>> aChildCheckers, boolean aAllowOverlaps) {
        TreeSet<GenericChecker<T>> children = new TreeSet<GenericChecker<T>>(new Comparator<GenericChecker<T>>(){

            @Override
            public int compare(GenericChecker<T> o1, GenericChecker<T> o2) {
                if (o1.equals(o2)) {
                    return 0;
                }
                if (o2.getPriority() - o1.getPriority() == 0) {
                    return 1;
                }
                return o2.getPriority() - o1.getPriority();
            }
        });
        children.addAll(aChildCheckers);
        this.mChildCheckers = Collections.unmodifiableSortedSet(children);
        this.mAllowOverlaps = aAllowOverlaps;
    }

    @Override
    public String getIdPrefix() {
        return ID_PREFIX;
    }

    @Override
    public void ignore(String id) {
        for (GenericChecker genericChecker : this.mChildCheckers) {
            if (!id.startsWith(genericChecker.getIdPrefix())) continue;
            genericChecker.ignore(id);
            break;
        }
    }

    @Override
    public void resetIgnored() {
        for (GenericChecker genericChecker : this.mChildCheckers) {
            genericChecker.resetIgnored();
        }
    }

    @Override
    public int getPriority() {
        return 0;
    }

    public List<RuleDefinition> getRulesDefinition() {
        LinkedList<RuleDefinition> definitions = new LinkedList<RuleDefinition>();
        for (GenericChecker genericChecker : this.mChildCheckers) {
            definitions.addAll(genericChecker.getRulesDefinition());
        }
        return definitions;
    }
}

