/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.analyzer;

import java.util.List;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.util.Span;
import org.cogroo.analyzer.Analyzer;
import org.cogroo.config.Analyzers;
import org.cogroo.text.Document;
import org.cogroo.text.Sentence;
import org.cogroo.text.Token;
import org.cogroo.text.impl.TokenImpl;
import org.cogroo.util.TextUtils;

public class NameFinder
implements Analyzer {
    private NameFinderME nameFinder;

    public NameFinder(NameFinderME nameFinder) {
        this.nameFinder = nameFinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void analyze(Document document) {
        List<Sentence> sentences = document.getSentences();
        for (Sentence sentence : sentences) {
            Span[] namesSpan;
            NameFinderME nameFinderME = this.nameFinder;
            synchronized (nameFinderME) {
                namesSpan = this.nameFinder.find(TextUtils.tokensToString(sentence.getTokens()));
            }
            List<Token> newTokens = sentence.getTokens();
            for (int i = namesSpan.length - 1; i >= 0; --i) {
                int start = namesSpan[i].getStart();
                int end = namesSpan[i].getEnd();
                int chStart = newTokens.get(start).getStart();
                int chEnd = newTokens.get(end - 1).getEnd();
                String name = sentence.getText().substring(chStart, chEnd).replace(" ", "_");
                newTokens.remove(end - 1);
                for (int j = end - 2; j >= start; --j) {
                    newTokens.remove(j);
                }
                TokenImpl token = new TokenImpl(chStart, chEnd, name);
                newTokens.add(start, token);
                token.addContext(Analyzers.NAME_FINDER, "P");
            }
            sentence.setTokens(newTokens);
        }
    }
}

