/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import opennlp.tools.postag.ExtendedPOSDictionary;
import opennlp.tools.postag.POSDictionary;
import opennlp.tools.postag.Triple;
import org.cogroo.entities.impl.MorphologicalTag;
import org.cogroo.interpreters.TagInterpreter;

public class MyPOSDictionary
extends POSDictionary {
    private Set<String> knwonTags = new HashSet<String>();

    public static ExtendedPOSDictionary parseOneEntryPerLine(Reader in, TagInterpreter tago, TagInterpreter tagd, Set<String> knownFeats, Set<String> knownPostags, boolean allowInvalidFeats) throws IOException {
        String line;
        knownFeats = new TreeSet<String>(knownFeats);
        BufferedReader lineReader = new BufferedReader(in);
        ExtendedPOSDictionary dictionary = new ExtendedPOSDictionary();
        TreeSet<String> unknownTags = new TreeSet<String>();
        while ((line = lineReader.readLine()) != null) {
            StringTokenizer whiteSpaceTokenizer = new StringTokenizer(line, " ");
            String word = whiteSpaceTokenizer.nextToken();
            while (whiteSpaceTokenizer.hasMoreTokens()) {
                MorphologicalTag completeTag;
                String data = whiteSpaceTokenizer.nextToken();
                String[] lemmaTag = data.split(">");
                if (lemmaTag.length != 2 || (completeTag = tago.parseMorphologicalTag(lemmaTag[1])) == null || completeTag.getClazzE() == null) continue;
                MorphologicalTag classMT = new MorphologicalTag();
                classMT.setClazz(completeTag.getClazzE());
                String classString = tagd.serialize(classMT);
                MorphologicalTag featsMT = completeTag.clone();
                featsMT.setClazz(null);
                String featsString = null;
                if (!featsMT.isEmpty()) {
                    featsString = tagd.serialize(featsMT);
                }
                if (featsString == null || featsString.length() == 0) {
                    featsString = "-";
                }
                if ("pron".equals(classString)) {
                    if (knownFeats.contains(featsString) || allowInvalidFeats) {
                        dictionary.addTriple(word, new Triple("pron-det", lemmaTag[0], featsString));
                    }
                    if (!knownFeats.contains(featsString) && !allowInvalidFeats) continue;
                    dictionary.addTriple(word, new Triple("pron-indp", lemmaTag[0], featsString));
                    continue;
                }
                if (classString != null && knownPostags.contains(classString) && (knownFeats.contains(featsString) || allowInvalidFeats)) {
                    dictionary.addTriple(word, new Triple(classString, lemmaTag[0], featsString));
                    continue;
                }
                if (!classString.startsWith("v-")) {
                    System.err.println("unknown - " + word + " -> " + new Triple(classString, lemmaTag[0], classString + "_" + featsString));
                }
                unknownTags.add(classString + "_" + featsString);
            }
        }
        if (knownFeats.size() > 0) {
            System.err.print("Known tags:");
            for (String tag : knownFeats) {
                System.err.print(" " + tag);
            }
            System.err.println();
        }
        if (unknownTags.size() > 0) {
            System.err.print("Found unknown tags:");
            for (String tag : unknownTags) {
                System.err.print(" " + tag);
            }
            System.err.println();
        }
        return dictionary;
    }

    @Override
    void addTags(String word, String ... tags) {
        super.addTags(word, tags);
        for (String t : tags) {
            this.knwonTags.add(t);
        }
    }

    public void addTag(String word, String tag) {
        String[] tags = this.getTags(word);
        if (tag.startsWith("B-") || tag.startsWith("I-")) {
            tag = tag.substring(2);
        }
        if (tags != null && !this.arrayContains(tag, tags) && this.knwonTags.contains(tag)) {
            System.err.println("-- tag not found " + word + ":" + tag);
            String[] newTags = Arrays.copyOf(tags, tags.length + 1);
            newTags[tags.length] = tag;
            this.addTags(word, newTags);
        }
    }

    private boolean arrayContains(String tag, String[] tags) {
        for (String t : tags) {
            if (!tag.equals(t)) continue;
            return true;
        }
        return false;
    }

    public static MyPOSDictionary createCopy(POSDictionary original) {
        MyPOSDictionary newDict = new MyPOSDictionary();
        for (String word : original) {
            newDict.addTags(word, original.getTags(word));
        }
        return newDict;
    }
}

