/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.checker.rules.util;

import java.io.File;
import org.apache.log4j.Logger;
import org.cogroo.tools.checker.rules.applier.RulesProvider;
import org.cogroo.tools.checker.rules.applier.RulesTreesBuilder;
import org.cogroo.tools.checker.rules.applier.RulesTreesFromScratchAccess;
import org.cogroo.tools.checker.rules.applier.RulesTreesSerializedAccess;
import org.cogroo.tools.checker.rules.applier.RulesXmlAccess;
import org.cogroo.tools.checker.rules.util.RulesProperties;

public class RulesTreesSerializer {
    protected static final Logger LOGGER = Logger.getLogger(RulesTreesSerializer.class);

    public static void serialize() {
        RulesProvider xmlProvider = new RulesProvider(RulesXmlAccess.getInstance(), false);
        RulesTreesFromScratchAccess IN = new RulesTreesFromScratchAccess(new RulesTreesBuilder(xmlProvider));
        RulesTreesSerializedAccess OUT = new RulesTreesSerializedAccess("rules.serialized");
        OUT.persist(IN.getTrees());
    }

    public static void serializeIfAbsent() {
        if (!RulesProperties.isReadFromSerialized()) {
            LOGGER.info("Will not create serialized rules file because will use the XML version only.");
            return;
        }
        File xml = new File(RulesProperties.getRulesFile());
        File bin = new File(RulesProperties.getSerializedTreesFile());
        if (xml.exists()) {
            if (!bin.exists() || RulesProperties.REREAD_FROM_SERIALIZED) {
                RulesTreesSerializer.serialize();
            }
        } else {
            LOGGER.warn("Failed to create binary rules file because the xml file is missing.");
        }
        if (!bin.exists()) {
            LOGGER.warn("Failed to create binary rules file.");
        }
    }

    public static void main(String[] args) {
        RulesTreesSerializer.serialize();
    }
}

