/*
 * Decompiled with CFR 0.152.
 */
package org.cogroo.tools.checker.checkers;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.util.StringList;
import org.cogroo.entities.Mistake;
import org.cogroo.entities.Sentence;
import org.cogroo.tools.checker.AbstractTypedChecker;
import org.cogroo.tools.checker.JavaRuleDefinition;
import org.cogroo.tools.checker.RuleDefinition;
import org.cogroo.tools.checker.rules.model.Example;

public class SpaceChecker
extends AbstractTypedChecker {
    private static final String ID_PREFIX = "space:";
    private static final String[] SUGGESTION_ONE_SPACE = new String[]{" "};
    private static final String[] SUGGESTION_NO_SPACE = new String[]{""};
    private static final String CATEGORY = "Erros mec\u00e2nicos";
    private static final String GROUP = "Uso do espa\u00e7o";
    static final String EXTRA_BETWEEN_WORDS_ID = "space:EXTRA_BETWEEN_WORDS";
    private static final Pattern EXTRA_BETWEEN_WORDS = Pattern.compile("\\S(\\s{2,})\\S");
    static final String EXTRA_BEFORE_RIGHT_PUNCT_ID = "space:EXTRA_BEFORE_RIGHT_PUNCT";
    private static final Pattern EXTRA_BEFORE_RIGHT_PUNCT = Pattern.compile("\\S(\\s{1,})[.?!;,:\u201d)}\\]]");
    static final String EXTRA_AFTER_LEFT_PUNCT_ID = "space:EXTRA_AFTER_LEFT_PUNCT";
    private static final Pattern EXTRA_AFTER_LEFT_PUNCT = Pattern.compile("[\\[{(](\\s{1,})");
    static final String MISSING_SPACE_AFTER_PUNCT_ID = "space:MISSING_SPACE_AFTER_PUNCT";
    private static final Pattern MISSING_SPACE_AFTER_PUNCT = Pattern.compile("([.\u201d?!;,:)}\\]]+)[^\\s.\u201d'\",;:!?)}\\]]");
    private static final Pattern EMAIL = Pattern.compile("([\\S]+@([\\w]+\\.)+[\\w]+)");
    private static final Pattern NUMBER = Pattern.compile("((\\d+[,.])+\\d+)");
    private static final Pattern INITIALS = Pattern.compile("((\\p{L}\\.){2,})(?!\\p{L})");
    private static final Pattern URL = Pattern.compile("(^(http|www)[\\S]+)");
    private Dictionary dic;

    public SpaceChecker(Dictionary dic) {
        this.dic = dic;
        this.add(this.createRuleDefinition(EXTRA_BETWEEN_WORDS_ID, EXTRA_BETWEEN_WORDS, "Excesso de espa\u00e7os entre as palavras. Entre palavras deve haver apenas um espa\u00e7o.", "Excesso de espa\u00e7os entre as palavras.", SpaceChecker.createExample("Este programa \u00e9  bom.", "Este programa \u00e9 bom."))).add(this.createRuleDefinition(EXTRA_BEFORE_RIGHT_PUNCT_ID, EXTRA_BEFORE_RIGHT_PUNCT, "Excesso de espa\u00e7o antes de s\u00edmbolo. O s\u00edmbolo deve ser mantido junto \u00e0 palavra que o precede.", "Excesso de espa\u00e7o antes de s\u00edmbolo.", SpaceChecker.createExample("Este programa \u00e9 bom .", "Este programa \u00e9 bom."))).add(this.createRuleDefinition(EXTRA_AFTER_LEFT_PUNCT_ID, EXTRA_AFTER_LEFT_PUNCT, "Excesso de espa\u00e7o depois de s\u00edmbolo. O s\u00edmbolo deve ser mantido junto \u00e0 palavra que o sucede.", "Excesso de espa\u00e7o depois de s\u00edmbolo.", SpaceChecker.createExample("Este programa \u00e9 ( era) bom.", "Este programa \u00e9 (era) bom."))).add(this.createRuleDefinition(MISSING_SPACE_AFTER_PUNCT_ID, MISSING_SPACE_AFTER_PUNCT, "Falta espa\u00e7o entre s\u00edmbolo e palavra \u00e0 direita. Deve haver um espa\u00e7o entre o s\u00edmbolo e a palavra que o sucede.", "Falta espa\u00e7o entre s\u00edmbolo e palavra \u00e0 direita.", SpaceChecker.createExample("Este programa \u00e9 era bom.Mas agora \u00e9 melhor.", "Este programa \u00e9 era bom. Mas agora \u00e9 melhor.")));
    }

    private RuleDefinition createRuleDefinition(String id, Pattern regex, String message, String shortMessage, Example example) {
        String description = "Aplica a express\u00e3o regular " + regex.pattern() + " na senten\u00e7a.";
        LinkedList<Example> examples = new LinkedList<Example>();
        examples.add(example);
        return new JavaRuleDefinition(id, CATEGORY, GROUP, description, message, shortMessage, examples);
    }

    @Override
    public String getIdPrefix() {
        return ID_PREFIX;
    }

    @Override
    public List<Mistake> check(Sentence sentence) {
        int end;
        int start;
        Matcher m;
        String text = sentence.getSentence();
        LinkedList<Mistake> mistakes = new LinkedList<Mistake>();
        int offset = sentence.getSpan().getStart();
        if (this.isCheckRule(EXTRA_BETWEEN_WORDS_ID)) {
            m = EXTRA_BETWEEN_WORDS.matcher(text);
            while (m.find()) {
                start = m.start(1) + offset;
                end = m.end(1) + offset;
                mistakes.add(this.createMistake(EXTRA_BETWEEN_WORDS_ID, SUGGESTION_ONE_SPACE, start, end, sentence.getSentence()));
            }
        }
        if (this.isCheckRule(EXTRA_BEFORE_RIGHT_PUNCT_ID)) {
            m = EXTRA_BEFORE_RIGHT_PUNCT.matcher(text);
            while (m.find()) {
                start = m.start(1) + offset;
                end = m.end(1) + offset;
                mistakes.add(this.createMistake(EXTRA_BEFORE_RIGHT_PUNCT_ID, SUGGESTION_NO_SPACE, start, end, sentence.getSentence()));
            }
        }
        if (this.isCheckRule(EXTRA_AFTER_LEFT_PUNCT_ID)) {
            m = EXTRA_AFTER_LEFT_PUNCT.matcher(text);
            while (m.find()) {
                start = m.start(1) + offset;
                end = m.end(1) + offset;
                mistakes.add(this.createMistake(EXTRA_AFTER_LEFT_PUNCT_ID, SUGGESTION_NO_SPACE, start, end, sentence.getSentence()));
            }
        }
        if (this.isCheckRule(MISSING_SPACE_AFTER_PUNCT_ID)) {
            m = MISSING_SPACE_AFTER_PUNCT.matcher(text);
            while (m.find()) {
                String error = this.getsSupposedError(text, m.start(1));
                boolean initials = this.getsSupposedAbbreviation(text, m.start(1));
                if (this.isEmail(error) || this.isNumber(error) || this.isURL(error) || initials) continue;
                int start2 = m.start(1) + offset;
                int end2 = m.end(1) + offset;
                String[] suggestion = new String[]{m.group(1) + " "};
                mistakes.add(this.createMistake(MISSING_SPACE_AFTER_PUNCT_ID, suggestion, start2, end2, sentence.getSentence()));
            }
        }
        return mistakes;
    }

    private boolean isOpenBracket(char c) {
        switch (c) {
            case '(': 
            case '[': 
            case '{': 
            case '\u201c': {
                return true;
            }
        }
        return false;
    }

    private boolean isEnding(char c) {
        switch (c) {
            case '!': 
            case ')': 
            case ',': 
            case '.': 
            case ';': 
            case '?': 
            case ']': 
            case '}': 
            case '\u201d': {
                return true;
            }
        }
        return false;
    }

    private String getsSupposedError(String text, int position) {
        int ini;
        boolean end = false;
        String word = text;
        for (ini = position; ini >= 0 && !Character.isWhitespace(text.charAt(ini)) && !this.isOpenBracket(text.charAt(ini)); --ini) {
        }
        block5: for (int i = position + 1; i < text.length() && !end; ++i) {
            switch (text.charAt(i)) {
                case '\n': 
                case ' ': 
                case '!': 
                case ')': 
                case ',': 
                case ';': 
                case '?': 
                case ']': 
                case '}': 
                case '\u201d': {
                    word = word.substring(ini + 1, i);
                    end = true;
                    continue block5;
                }
                case '.': {
                    if (!Character.isWhitespace(text.charAt(i + 1))) continue block5;
                    word = word.substring(ini + 1, i);
                    end = true;
                    continue block5;
                }
            }
        }
        return word;
    }

    private boolean getsSupposedAbbreviation(String text, int position) {
        int ini;
        boolean end = false;
        String word = text;
        for (ini = position; ini >= 0 && !Character.isWhitespace(text.charAt(ini)) && !this.isOpenBracket(text.charAt(ini)); --ini) {
        }
        block4: for (int i = position + 1; i < text.length() - 1 && !end; ++i) {
            switch (text.charAt(i)) {
                case '.': {
                    if (!Character.isWhitespace(text.charAt(i + 1)) && !this.isEnding(text.charAt(i + 1))) continue block4;
                    word = word.substring(ini + 1, i + 1);
                    end = true;
                    continue block4;
                }
            }
        }
        if (end) {
            if (INITIALS.matcher(word).find()) {
                return true;
            }
            if (this.dic.contains(new StringList(word))) {
                return true;
            }
        }
        return false;
    }

    private boolean isEmail(String email) {
        return EMAIL.matcher(email).find();
    }

    private boolean isNumber(String number) {
        return NUMBER.matcher(number).find();
    }

    private boolean isURL(String url) {
        return URL.matcher(url).find();
    }

    @Override
    public int getPriority() {
        return 2000;
    }
}

